/*
 * Decompiled with CFR 0.152.
 */
package norman.nplg;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class NStackedLayout
implements LayoutManager {
    int vgap;
    boolean alignBottom;
    Dimension layoutSize;

    NStackedLayout(int gap, boolean bottom) {
        this.vgap = gap;
        this.alignBottom = bottom;
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    public Dimension preferredLayoutSize(Container parent) {
        int components = parent.getComponentCount();
        Insets insets = parent.getInsets();
        int cx = 0;
        int cy = 0;
        int i = 0;
        while (i < components) {
            Dimension compSize = parent.getComponent(i).getPreferredSize();
            if (cx < compSize.width) {
                cx = compSize.width;
            }
            cy += compSize.height + this.vgap;
            ++i;
        }
        this.layoutSize = new Dimension(cx + insets.left + insets.right, cy + insets.top + insets.bottom);
        return this.layoutSize;
    }

    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    public void layoutContainer(Container parent) {
        int y;
        int components = parent.getComponentCount();
        Insets insets = parent.getInsets();
        if (this.alignBottom) {
            Dimension parentDim = parent.getSize();
            y = parentDim.height - this.layoutSize.height - insets.top;
        } else {
            y = insets.top;
        }
        int cx = this.layoutSize.width;
        int i = components - 1;
        while (i >= 0) {
            Component comp = parent.getComponent(i);
            Dimension compSize = comp.getPreferredSize();
            comp.setBounds(insets.left, y, cx - insets.right, compSize.height);
            y += compSize.height + this.vgap;
            --i;
        }
    }
}

