/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lexington.prt;

import com.ibm.lexington.prt.BlueMetalTheme;
import com.ibm.lexington.prt.HttpService;
import com.ibm.lexington.prt.Language;
import com.ibm.lexington.prt.SystemProductInfo;
import com.ibm.lexington.prt.Utility;
import com.ibm.lexington.prt.res.Bounds;
import com.ibm.lexington.prt.res.StrBounds;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class AIXConnectionDialog
extends JDialog
implements ActionListener {
    private JPanel ivjJDialogContentPane;
    private JPanel ivjAIXConnectionButtonJPanel;
    private FlowLayout ivjAIXConnectionButtonJPanelFlowLayout;
    private JPanel ivjAIXConnectionRadioButtonJPanel = null;
    private JTextPane ivjAIXConnectionJTextPane = null;
    private ButtonGroup ivjRadioButtonGroup = new ButtonGroup();
    private JRadioButton ivjRadioButtonDirect = null;
    private JRadioButton ivjRadioButtonSocks = null;
    private JRadioButton ivjRadioButtonHttp = null;
    private JRadioButton ivjRadioButtonAutoproxy = null;
    private JLabel ivjAIXConnectionServerLabel = null;
    private JTextField ivjAIXConnectionServerJTextField = null;
    private JButton ivjAIXConnectionOKJButton = null;
    private JButton ivjAIXConnectionCancelJButton = null;
    private String serverPort = null;
    private String serverPortProxy = "80";
    private String serverPortSocks = "1080";
    private String serverName = null;
    private int connectType;
    private int buttonPressed = -1;

    public AIXConnectionDialog(JFrame jFrame) {
        super(jFrame, SystemProductInfo.title, true);
        this.initialize();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        ((Component)this).setCursor(new Cursor(3));
        if (actionEvent.getSource() == this.ivjAIXConnectionOKJButton) {
            this.onOK();
        } else if (actionEvent.getSource() == this.ivjAIXConnectionCancelJButton) {
            this.onCancel();
        }
        ((Component)this).setCursor(new Cursor(0));
    }

    private static String copyright() {
        return "\n\nLicensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1999, 2000. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    }

    public int getConnectType() {
        return this.connectType;
    }

    public String getPortNumber() {
        return this.serverPort;
    }

    public String getServer() {
        return this.serverName;
    }

    public int getUserInput() {
        return this.buttonPressed;
    }

    private void initialize() {
        try {
            try {
                MetalLookAndFeel metalLookAndFeel = new MetalLookAndFeel();
                MetalLookAndFeel.setCurrentTheme(new BlueMetalTheme());
                UIManager.setLookAndFeel(metalLookAndFeel);
                UIManager.put("ToolTip.background", new Color(95, 127, 191));
            }
            catch (Exception exception) {
                System.out.println("Problem in BusyDlg.initialize() setting the Look and Feel!");
                exception.printStackTrace();
            }
            this.setName("ErrorConnectAIXDialog");
            this.setResizable(false);
            ((Component)this).setBackground(Color.lightGray);
            Bounds bounds = (Bounds)Language.rb_aix.getObject(Integer.toString(2500));
            Dimension dimension = bounds.returnDimension();
            int n = Utility.determineTextDimensions((Component)this, (String)SystemProductInfo.title).width + 90;
            if (n > dimension.width) {
                dimension.width = n;
            }
            Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
            int n2 = dimension2.width / 2 - dimension.width / 2;
            int n3 = dimension2.height / 2 - dimension.height / 2;
            if (Locale.getDefault().toString().equals("ja_JP") || Locale.getDefault().toString().equals("ko_KR") || Locale.getDefault().toString().equals("zh_CN") || Locale.getDefault().toString().equals("zh_TW")) {
                ((Component)this).setBounds(n2, n3, dimension.width, dimension.height + 100);
            } else {
                ((Component)this).setBounds(n2, n3, dimension.width, dimension.height);
            }
            StrBounds strBounds = (StrBounds)Language.rb_aix.getObject(Integer.toString(2502));
            StrBounds strBounds2 = (StrBounds)Language.rb_aix.getObject(Integer.toString(2503));
            StrBounds strBounds3 = (StrBounds)Language.rb_aix.getObject(Integer.toString(2504));
            StrBounds strBounds4 = (StrBounds)Language.rb_aix.getObject(Integer.toString(2505));
            StrBounds strBounds5 = (StrBounds)Language.rb_aix.getObject(Integer.toString(2506));
            StrBounds strBounds6 = (StrBounds)Language.rb_aix.getObject(Integer.toString(2507));
            StrBounds strBounds7 = (StrBounds)Language.rb_aix.getObject(Integer.toString(2509));
            StrBounds strBounds8 = (StrBounds)Language.rb_aix.getObject(Integer.toString(2510));
            this.ivjAIXConnectionRadioButtonJPanel = new JPanel();
            this.ivjAIXConnectionRadioButtonJPanel.setName("AIXConnectionRadioButtonJPanel");
            this.ivjAIXConnectionRadioButtonJPanel.setLayout(new GridBagLayout());
            this.ivjAIXConnectionRadioButtonJPanel.setBackground(Color.lightGray);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(0, 8, 10, 4);
            this.ivjAIXConnectionJTextPane = new JTextPane();
            this.ivjAIXConnectionJTextPane.setName("AIXConnectionDialogJTextPane");
            this.ivjAIXConnectionJTextPane.setAutoscrolls(false);
            this.ivjAIXConnectionJTextPane.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.ivjAIXConnectionJTextPane.setEditable(false);
            this.ivjAIXConnectionJTextPane.setEnabled(false);
            this.ivjAIXConnectionJTextPane.setRequestFocusEnabled(false);
            this.ivjAIXConnectionJTextPane.setSelectionColor(SystemColor.control);
            this.ivjAIXConnectionJTextPane.setBackground(Color.lightGray);
            this.ivjAIXConnectionJTextPane.setDisabledTextColor(Color.black);
            this.ivjAIXConnectionRadioButtonJPanel.add((Component)this.ivjAIXConnectionJTextPane, gridBagConstraints);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.insets = new Insets(4, 20, 4, 4);
            this.ivjRadioButtonDirect = new JRadioButton(strBounds2.returnString());
            this.ivjRadioButtonDirect.setName("RadioButtonDirect");
            this.ivjRadioButtonDirect.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.ivjRadioButtonDirect.setBackground(Color.lightGray);
            this.ivjRadioButtonDirect.setHorizontalAlignment(2);
            this.ivjAIXConnectionRadioButtonJPanel.add((Component)this.ivjRadioButtonDirect, gridBagConstraints2);
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 2;
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.insets = new Insets(4, 20, 4, 4);
            this.ivjRadioButtonSocks = new JRadioButton(strBounds3.returnString());
            this.ivjRadioButtonSocks.setName("RadioButtonSocks");
            this.ivjRadioButtonSocks.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.ivjRadioButtonSocks.setBackground(Color.lightGray);
            this.ivjRadioButtonSocks.setHorizontalAlignment(2);
            this.ivjAIXConnectionRadioButtonJPanel.add((Component)this.ivjRadioButtonSocks, gridBagConstraints3);
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.gridy = 3;
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.insets = new Insets(4, 20, 4, 4);
            this.ivjRadioButtonHttp = new JRadioButton(strBounds4.returnString());
            this.ivjRadioButtonHttp.setName("RadioButtonHttp");
            this.ivjRadioButtonHttp.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.ivjRadioButtonHttp.setBackground(Color.lightGray);
            this.ivjRadioButtonHttp.setHorizontalAlignment(2);
            this.ivjAIXConnectionRadioButtonJPanel.add((Component)this.ivjRadioButtonHttp, gridBagConstraints4);
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.gridy = 4;
            gridBagConstraints5.fill = 2;
            gridBagConstraints5.anchor = 17;
            gridBagConstraints5.insets = new Insets(4, 20, 10, 4);
            this.ivjRadioButtonAutoproxy = new JRadioButton(strBounds5.returnString());
            this.ivjRadioButtonAutoproxy.setName("RadioButtonAutoproxy");
            this.ivjRadioButtonAutoproxy.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.ivjRadioButtonAutoproxy.setBackground(Color.lightGray);
            this.ivjRadioButtonAutoproxy.setHorizontalAlignment(2);
            this.ivjAIXConnectionRadioButtonJPanel.add((Component)this.ivjRadioButtonAutoproxy, gridBagConstraints5);
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.gridy = 5;
            gridBagConstraints6.fill = 2;
            gridBagConstraints6.anchor = 17;
            gridBagConstraints6.insets = new Insets(4, 20, 4, 4);
            this.ivjAIXConnectionServerLabel = new JLabel(strBounds6.returnString());
            this.ivjAIXConnectionServerLabel.setName("ServerLabel");
            this.ivjAIXConnectionServerLabel.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.ivjAIXConnectionServerLabel.setForeground(Color.black);
            this.ivjAIXConnectionServerLabel.setBackground(Color.lightGray);
            this.ivjAIXConnectionRadioButtonJPanel.add((Component)this.ivjAIXConnectionServerLabel, gridBagConstraints6);
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.gridy = 6;
            gridBagConstraints7.fill = 2;
            gridBagConstraints7.anchor = 17;
            gridBagConstraints7.weightx = 1.0;
            gridBagConstraints7.insets = new Insets(4, 20, 4, 4);
            this.ivjAIXConnectionServerJTextField = new JTextField();
            this.ivjAIXConnectionServerJTextField.setName("ServerJTextField");
            this.ivjAIXConnectionServerJTextField.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.ivjAIXConnectionServerJTextField.setBackground(Color.white);
            this.ivjAIXConnectionRadioButtonJPanel.add((Component)this.ivjAIXConnectionServerJTextField, gridBagConstraints7);
            this.ivjAIXConnectionOKJButton = new JButton(strBounds7.returnString());
            this.ivjAIXConnectionOKJButton.setName("AIXConnectionOKJButton");
            this.ivjAIXConnectionOKJButton.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.ivjAIXConnectionOKJButton.setBackground(Color.lightGray);
            this.ivjAIXConnectionCancelJButton = new JButton(strBounds8.returnString());
            this.ivjAIXConnectionCancelJButton.setName("AIXConnectionCancelJButton");
            this.ivjAIXConnectionCancelJButton.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.ivjAIXConnectionCancelJButton.setBackground(Color.lightGray);
            this.ivjAIXConnectionButtonJPanelFlowLayout = new FlowLayout();
            this.ivjAIXConnectionButtonJPanelFlowLayout.setVgap(10);
            this.ivjAIXConnectionButtonJPanelFlowLayout.setHgap(20);
            this.ivjAIXConnectionButtonJPanel = new JPanel();
            this.ivjAIXConnectionButtonJPanel.setName("AIXConnectionButtonJPanel");
            this.ivjAIXConnectionButtonJPanel.setLayout(this.ivjAIXConnectionButtonJPanelFlowLayout);
            this.ivjAIXConnectionButtonJPanel.setBackground(Color.lightGray);
            this.ivjAIXConnectionButtonJPanel.add((Component)this.ivjAIXConnectionOKJButton, this.ivjAIXConnectionOKJButton.getName());
            this.ivjAIXConnectionButtonJPanel.add((Component)this.ivjAIXConnectionCancelJButton, this.ivjAIXConnectionCancelJButton.getName());
            this.ivjJDialogContentPane = new JPanel();
            this.ivjJDialogContentPane.setName("JDialogContentPane");
            this.ivjJDialogContentPane.setLayout(new BorderLayout());
            this.ivjJDialogContentPane.setBackground(Color.lightGray);
            if (Locale.getDefault().toString().equals("ja_JP") || Locale.getDefault().toString().equals("ko_KR") || Locale.getDefault().toString().equals("zh_CN") || Locale.getDefault().toString().equals("zh_TW")) {
                ((Component)this).setSize(dimension.width, dimension.height + 100);
            } else {
                ((Component)this).setSize(dimension.width, dimension.height);
            }
            this.ivjJDialogContentPane.add((Component)this.ivjAIXConnectionRadioButtonJPanel, "Center");
            this.ivjJDialogContentPane.add((Component)this.ivjAIXConnectionButtonJPanel, "South");
            this.setContentPane(this.ivjJDialogContentPane);
            this.ivjAIXConnectionJTextPane.setText(strBounds.returnString());
            this.ivjAIXConnectionOKJButton.addActionListener(this);
            this.ivjAIXConnectionCancelJButton.addActionListener(this);
            this.getRootPane().setDefaultButton(this.ivjAIXConnectionOKJButton);
            this.ivjRadioButtonGroup.add(this.ivjRadioButtonDirect);
            this.ivjRadioButtonGroup.add(this.ivjRadioButtonSocks);
            this.ivjRadioButtonGroup.add(this.ivjRadioButtonHttp);
            this.ivjRadioButtonGroup.add(this.ivjRadioButtonAutoproxy);
            this.ivjRadioButtonGroup.setSelected(this.ivjRadioButtonDirect.getModel(), true);
        }
        catch (Exception exception) {
            System.out.println("Problem in AIXConnectionDialog.initialize()!");
            exception.printStackTrace();
        }
    }

    private void onCancel() {
        this.buttonPressed = 2;
        ((Component)this).setVisible(false);
    }

    private void onOK() {
        try {
            if (this.ivjRadioButtonDirect.isSelected()) {
                this.connectType = 1;
            } else {
                String string = this.ivjAIXConnectionServerJTextField.getText();
                int n = (string = HttpService.stripHttp(string)).lastIndexOf(":");
                if (n != -1) {
                    this.serverName = string.substring(0, n);
                    this.serverPort = Integer.toString(Integer.parseInt(string.substring(n + 1)));
                } else {
                    this.serverName = string;
                }
                if (this.ivjRadioButtonSocks.isSelected()) {
                    this.connectType = 3;
                    this.serverPort = this.serverPortSocks;
                } else if (this.ivjRadioButtonHttp.isSelected()) {
                    this.connectType = 4;
                    this.serverPort = this.serverPortProxy;
                } else if (this.ivjRadioButtonAutoproxy.isSelected()) {
                    this.connectType = 2;
                }
            }
            System.out.println("Server Name: " + this.serverName);
            System.out.println("Server Port: " + this.serverPort);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Invalid port #: " + numberFormatException);
            numberFormatException.printStackTrace();
        }
        catch (Exception exception) {
            System.out.println("Problem in AIXConnectionDialog.onOK(). " + exception);
            exception.printStackTrace();
        }
        this.buttonPressed = 0;
        ((Component)this).setVisible(false);
    }
}

