/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lexington.prt;

import com.ibm.lexington.prt.BiosInfo;
import com.ibm.lexington.prt.BlueMetalTheme;
import com.ibm.lexington.prt.Brand;
import com.ibm.lexington.prt.ConsumerQuestions;
import com.ibm.lexington.prt.CustInfo;
import com.ibm.lexington.prt.CustName;
import com.ibm.lexington.prt.HomeBusinessQuestions;
import com.ibm.lexington.prt.HttpService;
import com.ibm.lexington.prt.Language;
import com.ibm.lexington.prt.Questions;
import com.ibm.lexington.prt.RegCommandLine;
import com.ibm.lexington.prt.RegException;
import com.ibm.lexington.prt.RegWriter;
import com.ibm.lexington.prt.SSGInfo;
import com.ibm.lexington.prt.SysInfo;
import com.ibm.lexington.prt.SystemProductInfo;
import com.ibm.lexington.prt.TextBreaker;
import com.ibm.lexington.prt.ThankYou;
import com.ibm.lexington.prt.URLEncoder;
import com.ibm.lexington.prt.URLs;
import com.ibm.lexington.prt.Utility;
import com.ibm.lexington.prt.res.Bounds;
import com.ibm.lexington.prt.res.StrBounds;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class AddInfo
extends JFrame
implements ActionListener,
ItemListener,
WindowListener {
    private BiosInfo biosInfo;
    private JLabel ivjLabelAdditionalInfo;
    private JLabel ivjLabelPlease;
    private JTextPane ivjJTextPaneProviding;
    private JLabel ivjLabelHomeBusiness;
    ButtonGroup bgHomeBusinessGroup = new ButtonGroup();
    JRadioButton rbJRadioButtonHome;
    JRadioButton rbJRadioButtonBusiness;
    JRadioButton rbJRadioButtonHomeBus;
    private JLabel ivjLabelCome;
    private JTextPane ivjJTextPaneURLS;
    private JLabel brandImageLabel;
    private JLabel globeImageLabel;
    private JButton ivjButtonExit;
    JButton ivjButtonSubmit;
    private JButton ivjButtonBack;
    boolean m_closedFromRegException;
    private Questions m_Questions;
    private URLs m_URLs;
    private boolean m_fixed = false;

    public AddInfo(BiosInfo biosInfo) {
        this.biosInfo = biosInfo;
        this.initialize();
        this.m_Questions = Brand.getBrand().isConsumer() ? new ConsumerQuestions(this) : new HomeBusinessQuestions(this, 1);
        this.m_URLs = new URLs(this, 1);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        ((Component)this).setCursor(new Cursor(3));
        if (actionEvent.getSource() == this.ivjButtonExit) {
            this.onAppExit();
        }
        if (actionEvent.getSource() == this.ivjButtonBack) {
            this.onAddInfoBack();
        }
        if (actionEvent.getSource() == this.ivjButtonSubmit) {
            this.onSubmit();
        }
        ((Component)this).setCursor(new Cursor(0));
    }

    private void addBoldLabels() {
        try {
            int n = 0;
            this.ivjLabelAdditionalInfo = new JLabel();
            this.ivjLabelAdditionalInfo.setName("LabelAdditionalInfo");
            this.ivjLabelAdditionalInfo.setForeground(Color.black);
            this.ivjLabelAdditionalInfo.setBackground(Color.lightGray);
            this.ivjLabelPlease = new JLabel();
            this.ivjLabelPlease.setName("LabelPlease");
            this.ivjLabelPlease.setForeground(Color.black);
            this.ivjLabelPlease.setBackground(Color.lightGray);
            if (Language.getDefaultLanguage().supportsBold()) {
                n = 1;
            }
            this.ivjLabelAdditionalInfo.setFont(new Font(SystemProductInfo.type, n, SystemProductInfo.size));
            this.ivjLabelPlease.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            StrBounds strBounds = (StrBounds)Language.rb_24.getObject(Integer.toString(2291));
            String string = strBounds.returnString();
            StrBounds strBounds2 = (StrBounds)Language.rb_24.getObject(Integer.toString(2322));
            String string2 = strBounds2.returnString();
            Dimension dimension = Utility.determineTextDimensions(this.ivjLabelAdditionalInfo, string);
            Dimension dimension2 = Utility.determineTextDimensions(this.ivjLabelPlease, string2);
            int n2 = dimension.width;
            int n3 = dimension2.width;
            int n4 = dimension.height;
            int n5 = dimension2.height;
            int n6 = 10;
            int n7 = 10;
            int n8 = 10;
            this.ivjLabelAdditionalInfo.setBounds(n6, n7, n2, n4);
            this.ivjLabelPlease.setBounds(n6 + n2 + n8, n7, n3, n5);
            if (SysInfo.getOSPlatform().equals("AIX") && Locale.getDefault().toString().equals("ko_KR")) {
                this.ivjLabelAdditionalInfo.setBounds(n6, n7, n2, n4 + 5);
                this.ivjLabelPlease.setBounds(n6 + n2 + n8, n7, n3, n5 + 5);
            }
            this.ivjLabelAdditionalInfo.setText(string);
            this.ivjLabelPlease.setText(string2);
            this.getContentPane().add((Component)this.ivjLabelAdditionalInfo, this.ivjLabelAdditionalInfo.getName());
            this.getContentPane().add((Component)this.ivjLabelPlease, this.ivjLabelPlease.getName());
        }
        catch (Throwable throwable) {
            System.out.println("Problem in AddInfo.addboldLabels()!");
            throwable.printStackTrace();
        }
    }

    private void addButtons() {
        try {
            Rectangle rectangle = this.getBounds();
            this.ivjButtonExit = new JButton();
            this.ivjButtonExit.setName("ButtonExit");
            this.ivjButtonExit.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.ivjButtonExit.setBackground(Color.lightGray);
            this.ivjButtonExit.setMargin(new Insets(2, 9, 2, 9));
            this.ivjButtonSubmit = new JButton();
            this.ivjButtonSubmit.setName("ButtonSubmit");
            this.ivjButtonSubmit.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.ivjButtonSubmit.setBackground(Color.lightGray);
            this.ivjButtonSubmit.setMargin(new Insets(2, 9, 2, 9));
            this.ivjButtonBack = new JButton();
            this.ivjButtonBack.setName("ButtonBack");
            this.ivjButtonBack.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.ivjButtonBack.setBackground(Color.lightGray);
            this.ivjButtonBack.setMargin(new Insets(2, 9, 2, 9));
            StrBounds strBounds = (StrBounds)Language.rb_24.getObject(Integer.toString(2312));
            String string = strBounds.returnString();
            StrBounds strBounds2 = (StrBounds)Language.rb_24.getObject(Integer.toString(2202));
            String string2 = strBounds2.returnString();
            StrBounds strBounds3 = (StrBounds)Language.rb_24.getObject(Integer.toString(2206));
            String string3 = strBounds3.returnString();
            Insets insets = this.ivjButtonExit.getInsets();
            Insets insets2 = this.ivjButtonSubmit.getInsets();
            Insets insets3 = this.ivjButtonBack.getInsets();
            Dimension dimension = Utility.determineTextDimensions(this.ivjButtonExit, string);
            Dimension dimension2 = Utility.determineTextDimensions(this.ivjButtonSubmit, string2);
            Dimension dimension3 = Utility.determineTextDimensions(this.ivjButtonBack, string3);
            int n = dimension.width + insets.left + insets.right;
            int n2 = dimension2.width + insets2.left + insets2.right;
            int n3 = dimension3.width + insets3.left + insets3.right;
            int n4 = Math.max(n, n2);
            n4 = Math.max(n3, n4);
            if (n4 < 60) {
                n4 = 60;
            }
            int n5 = dimension.height + insets.top + insets.bottom;
            int n6 = dimension2.height + insets2.top + insets2.bottom;
            int n7 = dimension3.height + insets3.top + insets3.bottom;
            int n8 = rectangle.height;
            if (SysInfo.getOSPlatform().equals("AIX") && Locale.getDefault().toString().equals("zh_CN")) {
                n8 = rectangle.height - 10;
            }
            n8 -= 20;
            int n9 = rectangle.width - 20;
            this.ivjButtonExit.setBounds(n9 -= n4, n8 -= n5, n4, n5);
            n9 -= 20;
            this.ivjButtonSubmit.setBounds(n9 -= n4, n8, n4, n6);
            this.ivjButtonBack.setBounds(n9 -= n4, n8, n4, n7);
            this.ivjButtonExit.setText(string);
            this.ivjButtonSubmit.setText(string2);
            this.ivjButtonBack.setText(string3);
            this.getContentPane().add((Component)this.ivjButtonExit, this.ivjButtonExit.getName());
            this.getContentPane().add((Component)this.ivjButtonSubmit, this.ivjButtonSubmit.getName());
            this.getContentPane().add((Component)this.ivjButtonBack, this.ivjButtonBack.getName());
        }
        catch (Throwable throwable) {
            System.out.println("Problem in AddInfo.addButtons()!");
            throwable.printStackTrace();
        }
    }

    private void addRadioButtons() {
        try {
            this.rbJRadioButtonHome = new JRadioButton();
            this.rbJRadioButtonHome.setName("CheckboxHome");
            this.rbJRadioButtonHome.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.rbJRadioButtonHome.setBackground(Color.lightGray);
            this.rbJRadioButtonHome.setSelected(false);
            this.rbJRadioButtonBusiness = new JRadioButton();
            this.rbJRadioButtonBusiness.setName("CheckboxBusiness");
            this.rbJRadioButtonBusiness.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.rbJRadioButtonBusiness.setBackground(Color.lightGray);
            this.rbJRadioButtonBusiness.setSelected(false);
            this.rbJRadioButtonHomeBus = new JRadioButton();
            this.rbJRadioButtonHomeBus.setName("CheckboxHomeBus");
            this.rbJRadioButtonHomeBus.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.rbJRadioButtonHomeBus.setBackground(Color.lightGray);
            this.rbJRadioButtonHomeBus.setSelected(false);
            StrBounds strBounds = (StrBounds)Language.rb_24.getObject(Integer.toString(2335));
            String string = strBounds.returnString();
            StrBounds strBounds2 = (StrBounds)Language.rb_24.getObject(Integer.toString(2336));
            String string2 = strBounds2.returnString();
            StrBounds strBounds3 = (StrBounds)Language.rb_24.getObject(Integer.toString(2337));
            String string3 = strBounds3.returnString();
            Insets insets = this.rbJRadioButtonHome.getInsets();
            Insets insets2 = this.rbJRadioButtonBusiness.getInsets();
            Insets insets3 = this.rbJRadioButtonHomeBus.getInsets();
            Dimension dimension = Utility.determineTextDimensions(this.rbJRadioButtonHome, string);
            Dimension dimension2 = Utility.determineTextDimensions(this.rbJRadioButtonBusiness, string2);
            Dimension dimension3 = Utility.determineTextDimensions(this.rbJRadioButtonHomeBus, string3);
            int n = dimension.width + insets.left + insets.right + 15;
            int n2 = dimension2.width + insets2.left + insets2.right + 15;
            int n3 = dimension3.width + insets3.left + insets3.right + 15;
            int n4 = dimension.height + insets.top + insets.bottom;
            int n5 = dimension2.height + insets2.top + insets2.bottom;
            int n6 = dimension3.height + insets3.top + insets3.bottom;
            Point point = strBounds.returnPoint();
            int n7 = point.x;
            int n8 = point.y;
            this.rbJRadioButtonHome.setBounds(n7 - SystemProductInfo.AddInfo_xvalue, n8 - (20 + SystemProductInfo.AddInfo_yvalue), n, n4);
            n7 = n7 + dimension.width + 25;
            this.rbJRadioButtonBusiness.setBounds(n7 - SystemProductInfo.AddInfo_xvalue, n8 - (20 + SystemProductInfo.AddInfo_yvalue), n2, n5);
            n7 = n7 + dimension2.width + 25;
            this.rbJRadioButtonHomeBus.setBounds(n7 - SystemProductInfo.AddInfo_xvalue, n8 - (20 + SystemProductInfo.AddInfo_yvalue), n3, n6);
            this.rbJRadioButtonHome.setText(string);
            this.rbJRadioButtonBusiness.setText(string2);
            this.rbJRadioButtonHomeBus.setText(string3);
            this.getContentPane().add((Component)this.rbJRadioButtonHome, this.rbJRadioButtonHome.getName());
            this.getContentPane().add((Component)this.rbJRadioButtonBusiness, this.rbJRadioButtonBusiness.getName());
            this.getContentPane().add((Component)this.rbJRadioButtonHomeBus, this.rbJRadioButtonHomeBus.getName());
        }
        catch (Throwable throwable) {
            System.out.println("Problem in AddInfo.addRadioButtons()!");
            throwable.printStackTrace();
        }
    }

    private void addUnAnsweredQuestions(String string) {
        Vector<Integer> vector = new Vector<Integer>(30);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "&");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.charAt(0) != 'q') continue;
            int n = string2.indexOf("=");
            String string3 = string2.substring(0, n);
            vector.addElement(new Integer(string3.substring(1)));
        }
        String string4 = " ";
        URLEncoder.encode(string4);
        String string5 = Language.rb_comall.getString(Integer.toString(1054));
        int n = Integer.parseInt(string5);
        int n2 = 1;
        while (n2 <= n) {
            if (!vector.contains(new Integer(n2))) {
                String string6 = Integer.toString(n2);
                string = String.valueOf(string) + "&q" + string6 + "=" + string4;
            }
            ++n2;
        }
    }

    private void addUnAnsweredQuestions(StringBuffer stringBuffer) {
        Vector<Integer> vector = new Vector<Integer>(30);
        StringTokenizer stringTokenizer = new StringTokenizer(stringBuffer.toString(), "&");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (string.charAt(0) != 'q') continue;
            int n = string.indexOf("=");
            String string2 = string.substring(0, n);
            vector.addElement(new Integer(string2.substring(1)));
        }
        String string = " ";
        URLEncoder.encode(string);
        String string3 = Language.rb_comall.getString(Integer.toString(1054));
        int n = Integer.parseInt(string3);
        int n2 = 1;
        while (n2 <= n) {
            if (!vector.contains(new Integer(n2))) {
                String string4 = Integer.toString(n2);
                stringBuffer.append("&q" + string4 + "=" + string);
            }
            ++n2;
        }
    }

    private static String copyright() {
        return "\n\nLicensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1999, 2000. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    }

    private void doDataExchange() {
        if (Brand.getBrand().isConsumer()) {
            this.ivjLabelHomeBusiness.setVisible(false);
            this.rbJRadioButtonHome.setVisible(false);
            this.rbJRadioButtonBusiness.setVisible(false);
            this.rbJRadioButtonHomeBus.setVisible(false);
        }
        this.m_Questions.doDataExchange();
        this.m_URLs.doDataExchange();
    }

    private void initialize() {
        try {
            Object object;
            Serializable serializable;
            this.setName("AddInfoView");
            this.setResizable(false);
            this.getContentPane().setLayout(null);
            this.getContentPane().setBackground(Color.lightGray);
            this.setTitle(SystemProductInfo.title);
            this.setDefaultCloseOperation(0);
            try {
                serializable = new MetalLookAndFeel();
                MetalLookAndFeel.setCurrentTheme(new BlueMetalTheme());
                UIManager.setLookAndFeel(serializable);
                UIManager.put("ToolTip.background", new Color(95, 127, 191));
            }
            catch (Exception exception) {
                System.out.println("Problem in setting Look and Feel in AddInfo!");
                exception.printStackTrace();
            }
            Bounds bounds = (Bounds)Language.rb_24.getObject(Integer.toString(2404));
            Dimension dimension = bounds.returnDimension();
            Point point = bounds.returnPoint();
            SystemProductInfo.AddInfo_xvalue = point.x;
            SystemProductInfo.AddInfo_yvalue = point.y;
            ((Component)this).setSize(dimension.width, dimension.height);
            this.getContentPane().setSize(dimension.width, dimension.height);
            this.brandImageLabel = new JLabel();
            this.brandImageLabel.setName("BrandGIF");
            this.globeImageLabel = new JLabel();
            this.globeImageLabel.setName("GlobeGIF");
            this.ivjJTextPaneProviding = new JTextPane();
            this.ivjJTextPaneProviding.setName("JTextPaneProviding");
            this.ivjJTextPaneProviding.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.ivjJTextPaneProviding.setEditable(false);
            this.ivjJTextPaneProviding.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 15));
            this.ivjJTextPaneProviding.setSelectionColor(SystemColor.control);
            this.ivjJTextPaneProviding.setBackground(Color.lightGray);
            this.ivjJTextPaneProviding.setDisabledTextColor(Color.black);
            this.ivjJTextPaneProviding.setEnabled(false);
            this.ivjLabelHomeBusiness = new JLabel();
            this.ivjLabelHomeBusiness.setName("LabelHomeBusiness");
            this.ivjLabelHomeBusiness.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.ivjLabelHomeBusiness.setBackground(Color.lightGray);
            this.ivjLabelHomeBusiness.setForeground(Color.black);
            this.ivjLabelCome = new JLabel();
            this.ivjLabelCome.setName("LabelCome");
            this.ivjLabelCome.setBackground(Color.lightGray);
            this.ivjLabelCome.setForeground(Color.black);
            if (Language.getDefaultLanguage().supportsBold()) {
                this.ivjLabelCome.setFont(new Font(SystemProductInfo.type, 1, SystemProductInfo.size));
            } else {
                this.ivjLabelCome.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            }
            this.ivjJTextPaneURLS = new JTextPane();
            this.ivjJTextPaneURLS.setName("JTextPaneURLS");
            this.ivjJTextPaneURLS.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.ivjJTextPaneURLS.setEditable(false);
            this.ivjJTextPaneURLS.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 15));
            this.ivjJTextPaneURLS.setSelectionColor(SystemColor.control);
            this.ivjJTextPaneURLS.setBackground(Color.lightGray);
            this.ivjJTextPaneURLS.setDisabledTextColor(Color.black);
            this.ivjJTextPaneURLS.setEnabled(false);
            serializable = this.getSize();
            ImageIcon imageIcon = null;
            try {
                object = Brand.getBrand().getBrandStringLow();
                String string = String.valueOf(object) + "brand.gif";
                imageIcon = new ImageIcon(this.getClass().getResource("/com/ibm/lexington/prt/res/" + string));
                this.brandImageLabel.setIcon(imageIcon);
                this.brandImageLabel.setBounds(0, ((Dimension)serializable).height - 80, imageIcon.getIconWidth(), imageIcon.getIconHeight());
                imageIcon = new ImageIcon(this.getClass().getResource("/com/ibm/lexington/prt/res/globe.gif"));
                this.globeImageLabel.setIcon(imageIcon);
                this.globeImageLabel.setBounds(((Dimension)serializable).width - imageIcon.getIconWidth() - 20, 46, imageIcon.getIconWidth(), imageIcon.getIconHeight());
            }
            catch (Exception exception) {
                System.out.println("AddInfo.initialize(): Could not load GIFs.");
            }
            StrBounds strBounds = (StrBounds)Language.rb_24.getObject(Integer.toString(2314));
            StrBounds strBounds2 = (StrBounds)Language.rb_24.getObject(Integer.toString(2338));
            StrBounds strBounds3 = (StrBounds)Language.rb_24.getObject(Integer.toString(2292));
            StrBounds strBounds4 = (StrBounds)Language.rb_24.getObject(Integer.toString(2231));
            Point point2 = strBounds.returnPoint();
            Point point3 = strBounds2.returnPoint();
            Point point4 = strBounds3.returnPoint();
            Point point5 = strBounds4.returnPoint();
            strBounds.returnDimension();
            Dimension dimension2 = strBounds2.returnDimension();
            Dimension dimension3 = strBounds3.returnDimension();
            Dimension dimension4 = strBounds4.returnDimension();
            this.ivjJTextPaneProviding.setBounds(point2.x - SystemProductInfo.AddInfo_xvalue, point2.y - (20 + SystemProductInfo.AddInfo_yvalue + 5), this.globeImageLabel.getX() - 30, 30);
            this.ivjLabelHomeBusiness.setBounds(point3.x - SystemProductInfo.AddInfo_xvalue, point3.y - (20 + SystemProductInfo.AddInfo_yvalue), dimension2.width + 20, dimension2.height);
            this.ivjLabelCome.setBounds(point4.x - SystemProductInfo.AddInfo_xvalue, point4.y - (20 + SystemProductInfo.AddInfo_yvalue + 5), dimension3.width, dimension3.height);
            this.ivjJTextPaneURLS.setBounds(point5.x - SystemProductInfo.AddInfo_xvalue, point5.y - (20 + SystemProductInfo.AddInfo_yvalue + 5), dimension4.width + 40, dimension4.height + 10);
            if (SysInfo.getOSPlatform().equals("AIX")) {
                this.ivjLabelCome.setVisible(false);
                this.ivjJTextPaneURLS.setVisible(false);
                if (Locale.getDefault().toString().equals("zh_CN")) {
                    this.ivjLabelHomeBusiness.setBounds(point3.x - SystemProductInfo.AddInfo_xvalue, point3.y - (20 + SystemProductInfo.AddInfo_yvalue + 2), dimension2.width + 50, dimension2.height + 2);
                } else if (Locale.getDefault().toString().equals("ko_KR")) {
                    this.ivjLabelHomeBusiness.setBounds(point3.x - SystemProductInfo.AddInfo_xvalue, point3.y - (20 + SystemProductInfo.AddInfo_yvalue), dimension2.width + 50, dimension2.height);
                }
            }
            this.ivjJTextPaneProviding.setText(strBounds.returnString());
            this.ivjLabelHomeBusiness.setText(strBounds2.returnString());
            this.ivjLabelCome.setText(strBounds3.returnString());
            this.ivjJTextPaneURLS.setText(strBounds4.returnString());
            if (Locale.getDefault().toString().equals("ru_RU")) {
                int n = 0;
                FontMetrics fontMetrics = null;
                Locale locale = null;
                String string = strBounds4.returnString();
                TextBreaker textBreaker = new TextBreaker(fontMetrics, locale, n);
                String[] stringArray = textBreaker.getTextLines(string, 80);
                int n2 = stringArray.length;
                string = "";
                int n3 = 0;
                while (n3 < n2) {
                    string = String.valueOf(string) + stringArray[n3] + "\n";
                    ++n3;
                }
                this.ivjJTextPaneURLS.setText(string);
            }
            this.addBoldLabels();
            this.getContentPane().add((Component)this.ivjJTextPaneProviding, this.ivjJTextPaneProviding.getName());
            this.getContentPane().add((Component)this.ivjLabelHomeBusiness, this.ivjLabelHomeBusiness.getName());
            this.addRadioButtons();
            this.getContentPane().add((Component)this.globeImageLabel, this.globeImageLabel.getName());
            this.getContentPane().add((Component)this.ivjLabelCome, this.ivjLabelCome.getName());
            this.getContentPane().add((Component)this.ivjJTextPaneURLS, this.ivjJTextPaneURLS.getName());
            this.getContentPane().add((Component)this.brandImageLabel, this.brandImageLabel.getName());
            this.addButtons();
            this.addWindowListener(this);
            this.ivjButtonExit.addActionListener(this);
            this.ivjButtonBack.addActionListener(this);
            this.ivjButtonSubmit.addActionListener(this);
            this.rbJRadioButtonHome.addItemListener(this);
            this.rbJRadioButtonBusiness.addItemListener(this);
            this.rbJRadioButtonHomeBus.addItemListener(this);
            this.getRootPane().setDefaultButton(this.ivjButtonSubmit);
            this.bgHomeBusinessGroup.add(this.rbJRadioButtonHome);
            this.bgHomeBusinessGroup.add(this.rbJRadioButtonBusiness);
            this.bgHomeBusinessGroup.add(this.rbJRadioButtonHomeBus);
            object = Toolkit.getDefaultToolkit().getScreenSize();
            int n = ((Dimension)object).height / 2 - ((Dimension)serializable).height / 2;
            int n4 = ((Dimension)object).width / 2 - ((Dimension)serializable).width / 2;
            ((Component)this).setLocation(n4, n);
        }
        catch (Throwable throwable) {
            System.out.println("Problem in AddInfo.initialize()!");
            throwable.printStackTrace();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.rbJRadioButtonHome) {
            this.onHome();
        }
        if (itemEvent.getSource() == this.rbJRadioButtonBusiness) {
            this.onBusiness();
        }
        if (itemEvent.getSource() == this.rbJRadioButtonHomeBus) {
            this.onHomeBusiness();
        }
    }

    private void onAddInfoBack() {
        this.saveInfo();
        ((Component)this).setVisible(false);
        ((Component)this.biosInfo).setVisible(true);
    }

    public void onAppExit() {
        if (!this.m_closedFromRegException) {
            RegException regException = new RegException(2243);
            int n = regException.showMessage();
            if (n == 0) {
                System.exit(0);
            }
        } else {
            System.exit(0);
        }
    }

    protected void onBusiness() {
        if (this.isVisible()) {
            ((HomeBusinessQuestions)this.m_Questions).setHomeBusiness(1);
        }
    }

    protected void onHome() {
        if (this.isVisible()) {
            ((HomeBusinessQuestions)this.m_Questions).setHomeBusiness(0);
        }
    }

    protected void onHomeBusiness() {
        if (this.isVisible()) {
            ((HomeBusinessQuestions)this.m_Questions).setHomeBusiness(3);
        }
    }

    public int onPrint() {
        String[] stringArray;
        String string = " " + Language.rb_brand.getString(Integer.toString(313));
        Locale locale = Locale.getDefault();
        Frame frame = new Frame();
        frame.addNotify();
        Font font = frame.getFont();
        RegWriter regWriter = new RegWriter();
        Vector vector = new Vector();
        regWriter.getStringList(vector);
        vector.trimToSize();
        int n = vector.size();
        Vector<String> vector2 = new Vector<String>(n);
        int n2 = 0;
        while (n2 < n) {
            stringArray = (String[])vector.elementAt(n2);
            String string2 = stringArray.getValue();
            string2 = string2.trim();
            if (stringArray.getBlank() || string2.length() > 0) {
                vector2.addElement(String.valueOf(stringArray.getToken()) + stringArray.getValue());
            }
            ++n2;
        }
        vector2.trimToSize();
        Object[] objectArray = new String[vector2.size()];
        vector2.copyInto(objectArray);
        if (SysInfo.getOSPlatform().equalsIgnoreCase("AIX") && (locale.toString().equals("ja_JP") || locale.toString().equals("ko_KR") || locale.toString().equals("zh_CN") || locale.toString().equals("zh_TW"))) {
            Graphics graphics = ((Component)this).getGraphics();
            if (graphics == null) {
                System.out.println("No graphics found.");
                return -1;
            }
            graphics.setFont(font);
            FontMetrics fontMetrics = graphics.getFontMetrics(font);
            stringArray = new TextBreaker(fontMetrics, locale, 504).getTextLines((String[])objectArray);
            int n3 = stringArray.length;
            String string3 = String.valueOf(System.getProperty("user.dir")) + "/print.txt";
            PrintWriter printWriter = null;
            try {
                printWriter = new PrintWriter(new FileOutputStream(string3), true);
            }
            catch (IOException iOException) {
                System.out.println("File not opened properly\n" + iOException.toString());
            }
            int n4 = 0;
            while (n4 < n3) {
                printWriter.println(stringArray[n4]);
                ++n4;
            }
            printWriter.close();
            System.out.println("Printing DBCS file.");
            try {
                Runtime.getRuntime().exec("lp " + string3);
            }
            catch (IOException iOException) {
                System.out.println("Could not create the \"lp\" printing process!");
                iOException.printStackTrace();
            }
        } else {
            int n5;
            PrintJob printJob = frame.getToolkit().getPrintJob(frame, string, null);
            if (printJob == null) {
                System.out.println("No PrintJob.");
                return -2;
            }
            Graphics graphics = printJob.getGraphics();
            if (graphics == null) {
                System.out.println("No graphics found.");
                return -1;
            }
            graphics.setFont(font);
            FontMetrics fontMetrics = graphics.getFontMetrics(font);
            int n6 = fontMetrics.getHeight();
            Dimension dimension = printJob.getPageDimension();
            double d = (double)dimension.width / 8.5;
            int n7 = dimension.width - (int)(1.5 * d);
            int n8 = dimension.height - (int)(1.5 * d);
            int n9 = (int)((double)n8 / ((double)n6 * 1.0));
            String[] stringArray2 = new TextBreaker(fontMetrics, locale, n7).getTextLines((String[])objectArray);
            int n10 = stringArray2.length;
            int n11 = (int)(0.5 * d);
            int n12 = n5 = (int)(0.5 * d);
            int n13 = 0;
            while (n13 < n10) {
                graphics.drawString(stringArray2[n13], n11, n12 += n6);
                if ((n13 + 1) % n9 == 0) {
                    graphics.dispose();
                    graphics = printJob.getGraphics();
                    if (graphics == null) {
                        System.out.println("No graphics found.");
                        return -1;
                    }
                    graphics.setFont(font);
                    n12 = n5;
                }
                n12 += (int)((double)n6 * 0.0);
                ++n13;
            }
            graphics.dispose();
            printJob.end();
        }
        return 0;
    }

    private void onSubmit() {
        CustInfo custInfo = CustInfo.getInstance();
        try {
            Object object;
            CharSequence charSequence;
            Object object2;
            this.m_Questions.validate();
            this.saveInfo();
            if (custInfo.getRegistrationCode().equals("")) {
                object2 = custInfo.getName();
                charSequence = ((CustName)object2).getFirstName();
                object = ((CustName)object2).getLastName();
                custInfo.setRegistrationCode(Utility.generateRegistrationCode((String)charSequence, (String)object));
            }
            charSequence = new StringBuffer(custInfo.format());
            object = SystemProductInfo.getInstance();
            ((StringBuffer)charSequence).append("&");
            ((StringBuffer)charSequence).append(((SystemProductInfo)object).format());
            object2 = SSGInfo.getInstance();
            ((SSGInfo)object2).setSSGCampaignID(Language.rb_comall.getString(Integer.toString(1050)));
            ((SSGInfo)object2).setSSGService(Language.rb_comall.getString(Integer.toString(1051)));
            ((SSGInfo)object2).setSSGMethod(Language.rb_comall.getString(Integer.toString(1052)));
            ((SSGInfo)object2).setSSGSurveyID(Language.rb_comall.getString(Integer.toString(1053)));
            ((SSGInfo)object2).setSSGNumOfQuestions(Language.rb_comall.getString(Integer.toString(1054)));
            ((StringBuffer)charSequence).append("&");
            ((StringBuffer)charSequence).append(((SSGInfo)object2).format());
            ((StringBuffer)charSequence).append(this.m_Questions.format());
            this.addUnAnsweredQuestions((StringBuffer)charSequence);
            this.writeRegistry();
            SysInfo.getInstance().saveRegistryKeys();
            this.m_URLs.addBookmarks();
            if (RegCommandLine.getConnect().equalsIgnoreCase("no")) {
                System.out.println(charSequence);
                if (RegCommandLine.getRegressionTest().equalsIgnoreCase("yes")) {
                    System.out.println("OS: Windows Regression OS");
                    System.out.println("Version: Windows Regression Version");
                } else {
                    System.out.println("OS: " + SysInfo.getOSPlatform());
                    System.out.println("Version: " + SysInfo.getOSVersion());
                }
                String string = Language.rb_comall.getString(Integer.toString(1547));
                throw new RegException(219, string);
            }
            HttpService httpService = HttpService.getInstance(this);
            httpService.setMsgToPost(((StringBuffer)charSequence).toString());
            httpService.postTheMsg();
            this.requestFocus();
            ((Component)new ThankYou(this)).setVisible(true);
        }
        catch (RegException regException) {
            regException.showMessage();
        }
    }

    private void saveInfo() {
        this.m_Questions.saveInfo();
        this.m_URLs.saveInfo();
    }

    public void windowActivated(WindowEvent windowEvent) {
        RegException.setCurrentWindow(this);
        if (!this.m_fixed) {
            Insets insets = this.getInsets();
            if (SysInfo.getOSPlatform().equals("LINUX")) {
                System.out.println("Fixing LINUX AddInfo screen");
                Dimension dimension = this.getSize();
                dimension.height += insets.top;
                ((Component)this).setSize(dimension);
                this.getContentPane().setSize(dimension);
                dimension = this.getSize();
                Rectangle rectangle = this.brandImageLabel.getBounds();
                rectangle.y = this.getSize().height - 57 - insets.top;
                this.brandImageLabel.setBounds(rectangle);
                ((Component)this).setVisible(false);
                ((Component)this).setVisible(true);
            } else {
                System.out.println("Fixing non-LINUX AddInfo screen");
                Rectangle rectangle = this.ivjButtonSubmit.getBounds();
                rectangle.y -= insets.top;
                this.ivjButtonSubmit.setBounds(rectangle);
                rectangle = this.ivjButtonBack.getBounds();
                rectangle.y -= insets.top;
                this.ivjButtonBack.setBounds(rectangle);
                rectangle = this.ivjButtonExit.getBounds();
                rectangle.y -= insets.top;
                this.ivjButtonExit.setBounds(rectangle);
            }
            this.m_fixed = true;
        }
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    private void writeRegistry() {
        CustInfo custInfo = CustInfo.getInstance();
        custInfo.writeRegistry();
        this.m_Questions.writeRegistry();
    }
}

