/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lexington.prt;

import com.ibm.lexington.prt.Address;
import com.ibm.lexington.prt.Brand;
import com.ibm.lexington.prt.Country;
import com.ibm.lexington.prt.CustAddr;
import com.ibm.lexington.prt.CustInfo;
import com.ibm.lexington.prt.Language;
import com.ibm.lexington.prt.RegException;
import com.ibm.lexington.prt.SysInfo;
import com.ibm.lexington.prt.SystemProductInfo;
import com.ibm.lexington.prt.Utility;
import com.ibm.lexington.prt.res.Bounds;
import com.ibm.lexington.prt.res.StrBounds;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.CollationKey;
import java.text.Collator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class AddrControl
extends Address
implements ItemListener,
KeyListener {
    private static Hashtable hashCountry = new Hashtable();
    private static Hashtable hashSortedCountry = new Hashtable();
    private static Hashtable hashState = new Hashtable();
    private boolean doingDataExchange = false;
    private JFrame parentFrame;
    private Language m_refLanguage;
    private Brand m_refBrand;
    private JCheckBox m_ContactCheckFrenchControl;
    private boolean m_bContactCheckFrench;
    private boolean ZipValidationIsOK;
    private JLabel ivjLabelPOBox;
    private JTextField m_ContactPOBoxControl;
    private String m_strContactPOBox;
    private JLabel ivjLabelStreet;
    private JTextField m_ContactStreetControl;
    private String m_strContactStreet;
    private JLabel ivjLabelCity;
    private JTextField m_ContactCityControl;
    private String m_strContactCity;
    private JLabel ivjLabelState;
    private JComboBox m_ContactStateControl;
    private String m_strContactState;
    private JLabel ivjLabelZip;
    private JTextField m_ContactZipControl;
    private String m_strContactZip;
    private JLabel ivjLabelCountry;
    private JComboBox m_ContactCountryControl;
    private String m_strContactCountry;

    public AddrControl(JFrame jFrame) {
        this.parentFrame = jFrame;
        this.m_refLanguage = Language.getDefaultLanguage();
        this.m_refBrand = Brand.getBrand();
        CustInfo custInfo = CustInfo.getInstance();
        CustAddr custAddr = custInfo.getAddr();
        this.m_strContactPOBox = custAddr.getPOBox();
        this.m_strContactStreet = custAddr.getStreet();
        this.m_strContactZip = custAddr.getZip();
        this.m_strContactCity = custAddr.getCity();
        this.m_strContactCountry = custAddr.getCountry();
        this.m_strContactState = custAddr.getState();
        this.m_bContactCheckFrench = custAddr.getCheckFrench();
        this.initialize();
    }

    private static String copyright() {
        return "\n\nLicensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1999, 2000. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    }

    public void doDataExchange() {
        this.doingDataExchange = true;
        this.m_ContactPOBoxControl.setText(this.m_strContactPOBox);
        this.m_ContactStreetControl.setText(this.m_strContactStreet);
        this.m_ContactCityControl.setText(this.m_strContactCity);
        this.m_ContactStateControl.setSelectedItem(this.m_strContactState);
        this.m_ContactZipControl.setText(this.m_strContactZip);
        this.m_ContactCheckFrenchControl.setSelected(this.m_bContactCheckFrench);
        CustInfo custInfo = CustInfo.getInstance();
        CustAddr custAddr = custInfo.getAddr();
        custAddr.getCheckFrenchState();
        boolean bl = custAddr.getCheckFrench();
        this.m_ContactCheckFrenchControl.setSelected(bl);
        this.doingDataExchange = false;
    }

    public String getCity() {
        this.m_strContactCity = this.m_ContactCityControl.getText();
        return this.m_strContactCity;
    }

    public Component getCityEditControl() {
        return this.m_ContactCityControl;
    }

    public String getCountry() {
        this.m_strContactCountry = (String)this.m_ContactCountryControl.getSelectedItem();
        return this.m_strContactCountry;
    }

    public Component getCountryComboControl() {
        return this.m_ContactCountryControl;
    }

    public int getCountryIdx() {
        Object v = hashCountry.get(this.m_ContactCountryControl.getSelectedItem());
        String string = v != null ? v.toString() : "-1";
        return Integer.parseInt(string);
    }

    public String getPOBox() {
        this.m_strContactPOBox = this.m_ContactPOBoxControl.getText();
        return this.m_strContactPOBox;
    }

    public Component getPOBoxEditControl() {
        return this.m_ContactPOBoxControl;
    }

    public String getState() {
        this.m_strContactState = (String)this.m_ContactStateControl.getSelectedItem();
        return this.m_strContactState;
    }

    public int getStateIdx() {
        return this.m_ContactStateControl.getSelectedIndex();
    }

    public String getStreet() {
        this.m_strContactStreet = this.m_ContactStreetControl.getText();
        return this.m_strContactStreet;
    }

    public Component getStreetEditControl() {
        return this.m_ContactStreetControl;
    }

    public String getZip() {
        this.m_strContactZip = this.m_ContactZipControl.getText();
        return this.m_strContactZip;
    }

    public Component getZipEditControl() {
        return this.m_ContactZipControl;
    }

    public boolean getZipValidationIsOK() {
        return this.ZipValidationIsOK;
    }

    private Vector initCountry() {
        Vector<String> vector = new Vector<String>(170);
        Vector<String> vector2 = null;
        try {
            int n;
            int n2 = 0;
            while (n2 < 169) {
                n = Country.getCountryCode(n2);
                String string = Language.rb.getString(Integer.toString(n));
                if (string != "" && string != " ") {
                    vector.addElement(string);
                    hashCountry.put(string, new Integer(n2));
                }
                ++n2;
            }
            Locale locale = Locale.getDefault();
            Collator collator = Collator.getInstance(locale);
            int n3 = vector.size();
            CollationKey[] collationKeyArray = new CollationKey[n3];
            n2 = 0;
            while (n2 < n3) {
                collationKeyArray[n2] = collator.getCollationKey((String)vector.elementAt(n2));
                ++n2;
            }
            CollationKey collationKey = null;
            n2 = 0;
            while (n2 < n3 - 1) {
                n = n2 + 1;
                while (n < n3) {
                    if (collationKeyArray[n2].compareTo(collationKeyArray[n]) > 0) {
                        collationKey = collationKeyArray[n2];
                        collationKeyArray[n2] = collationKeyArray[n];
                        collationKeyArray[n] = collationKey;
                    }
                    ++n;
                }
                ++n2;
            }
            vector2 = new Vector<String>(n3);
            n2 = 0;
            while (n2 < n3) {
                vector2.addElement(collationKeyArray[n2].getSourceString());
                hashSortedCountry.put(collationKeyArray[n2].getSourceString(), new Integer(n2 + 1));
                ++n2;
            }
            vector2.insertElementAt(new String(""), 0);
        }
        catch (Throwable throwable) {
            System.out.println("Problem in AddrControl.initCountry()!");
            throwable.printStackTrace();
        }
        return vector2;
    }

    private void initialize() {
        try {
            Locale locale = Locale.getDefault();
            this.ivjLabelPOBox = new JLabel();
            this.ivjLabelPOBox.setName("POBoxLabel");
            this.ivjLabelPOBox.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.ivjLabelPOBox.setBackground(Color.lightGray);
            this.ivjLabelPOBox.setForeground(Color.black);
            this.m_ContactPOBoxControl = new JTextField();
            this.m_ContactPOBoxControl.setName("POBoxTextField");
            this.m_ContactPOBoxControl.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.m_ContactPOBoxControl.setColumns(50);
            this.ivjLabelStreet = new JLabel();
            this.ivjLabelStreet.setName("StreetLabel");
            this.ivjLabelStreet.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.ivjLabelStreet.setBackground(Color.lightGray);
            this.ivjLabelStreet.setForeground(Color.black);
            this.m_ContactStreetControl = new JTextField();
            this.m_ContactStreetControl.setName("StreetTextField");
            this.m_ContactStreetControl.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.m_ContactStreetControl.setColumns(50);
            this.ivjLabelCity = new JLabel();
            this.ivjLabelCity.setName("CityLabel");
            this.ivjLabelCity.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.ivjLabelCity.setBackground(Color.lightGray);
            this.ivjLabelCity.setForeground(Color.black);
            this.m_ContactCityControl = new JTextField();
            this.m_ContactCityControl.setName("CityTextField");
            this.m_ContactCityControl.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.m_ContactCityControl.setColumns(40);
            this.ivjLabelZip = new JLabel();
            this.ivjLabelZip.setName("ZipLabel");
            this.ivjLabelZip.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.ivjLabelZip.setBackground(Color.lightGray);
            this.ivjLabelZip.setForeground(Color.black);
            this.m_ContactZipControl = new JTextField();
            this.m_ContactZipControl.setName("ZipTextField");
            this.m_ContactZipControl.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.m_ContactZipControl.setColumns(10);
            this.ivjLabelCountry = new JLabel();
            this.ivjLabelCountry.setName("CountryLabel");
            this.ivjLabelCountry.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.ivjLabelCountry.setBackground(Color.lightGray);
            this.ivjLabelCountry.setForeground(Color.black);
            this.m_ContactCountryControl = new JComboBox(this.initCountry());
            this.m_ContactCountryControl.setName("CountryCombobox");
            this.m_ContactCountryControl.setBackground(Color.white);
            this.m_ContactCountryControl.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.m_ContactCheckFrenchControl = new JCheckBox();
            this.m_ContactCheckFrenchControl.setName("FrenchCheckbox");
            this.m_ContactCheckFrenchControl.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.m_ContactCheckFrenchControl.setBackground(Color.lightGray);
            int n = -1;
            boolean bl = false;
            CustInfo custInfo = CustInfo.getInstance();
            CustAddr custAddr = custInfo.getAddr();
            Country country = null;
            String string = custAddr.getCountry();
            if (string.length() > 0 && Utility.validateIsWhiteSpace(string) != 1) {
                this.m_ContactCountryControl.setSelectedItem(string);
                if (((String)this.m_ContactCountryControl.getSelectedItem()).equals(string)) {
                    bl = true;
                    country = Country.getCountry(new Integer(hashCountry.get(string).toString()));
                    n = country.countryId();
                }
            }
            if (!bl) {
                country = Country.getDefaultCountry();
                Enumeration enumeration = hashCountry.keys();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    n = new Integer(hashCountry.get(string2).toString());
                    if (n != country.countryId()) continue;
                    this.m_ContactCountryControl.setSelectedIndex((Integer)hashSortedCountry.get(string2));
                    break;
                }
            }
            this.ivjLabelState = new JLabel();
            this.ivjLabelState.setName("StateLabel");
            this.ivjLabelState.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.ivjLabelState.setBackground(Color.lightGray);
            this.ivjLabelState.setForeground(Color.black);
            this.m_ContactStateControl = new JComboBox(this.initState(country));
            this.m_ContactStateControl.setName("StateComboBox");
            this.m_ContactStateControl.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.m_ContactStateControl.setBackground(Color.white);
            StrBounds strBounds = (StrBounds)Language.rb.getObject(Integer.toString(2263));
            Bounds bounds = (Bounds)Language.rb.getObject(Integer.toString(2218));
            StrBounds strBounds2 = (StrBounds)Language.rb.getObject(Integer.toString(2258));
            Bounds bounds2 = (Bounds)Language.rb.getObject(Integer.toString(2217));
            StrBounds strBounds3 = (StrBounds)Language.rb.getObject(Integer.toString(2259));
            Bounds bounds3 = (Bounds)Language.rb.getObject(Integer.toString(2216));
            StrBounds strBounds4 = (StrBounds)Language.rb.getObject(Integer.toString(2260));
            Bounds bounds4 = (Bounds)Language.rb.getObject(Integer.toString(2321));
            StrBounds strBounds5 = (StrBounds)Language.rb.getObject(Integer.toString(2261));
            Bounds bounds5 = (Bounds)Language.rb.getObject(Integer.toString(2214));
            StrBounds strBounds6 = (StrBounds)Language.rb.getObject(Integer.toString(2262));
            Bounds bounds6 = (Bounds)Language.rb.getObject(Integer.toString(2239));
            StrBounds strBounds7 = (StrBounds)Language.rb.getObject(Integer.toString(2241));
            this.ivjLabelPOBox.setText(strBounds.returnString());
            this.ivjLabelStreet.setText(strBounds2.returnString());
            this.ivjLabelCity.setText(strBounds3.returnString());
            this.ivjLabelState.setText(strBounds4.returnString());
            this.ivjLabelZip.setText(strBounds5.returnString());
            this.ivjLabelCountry.setText(strBounds6.returnString());
            this.m_ContactCheckFrenchControl.setText(strBounds7.returnString());
            Point point = strBounds.returnPoint();
            Point point2 = bounds.returnPoint();
            Point point3 = strBounds2.returnPoint();
            Point point4 = bounds2.returnPoint();
            Point point5 = strBounds3.returnPoint();
            Point point6 = bounds3.returnPoint();
            Point point7 = strBounds4.returnPoint();
            Point point8 = bounds4.returnPoint();
            Point point9 = strBounds5.returnPoint();
            Point point10 = bounds5.returnPoint();
            Point point11 = strBounds6.returnPoint();
            Point point12 = bounds6.returnPoint();
            Point point13 = strBounds7.returnPoint();
            Dimension dimension = strBounds.returnDimension();
            Dimension dimension2 = bounds.returnDimension();
            Dimension dimension3 = strBounds2.returnDimension();
            Dimension dimension4 = bounds2.returnDimension();
            Dimension dimension5 = strBounds3.returnDimension();
            Dimension dimension6 = bounds3.returnDimension();
            Dimension dimension7 = strBounds4.returnDimension();
            Dimension dimension8 = bounds4.returnDimension();
            Dimension dimension9 = strBounds5.returnDimension();
            Dimension dimension10 = bounds5.returnDimension();
            Dimension dimension11 = strBounds6.returnDimension();
            Dimension dimension12 = bounds6.returnDimension();
            Dimension dimension13 = strBounds7.returnDimension();
            this.ivjLabelPOBox.setBounds(point.x - SystemProductInfo.Contact_xvalue, point.y - (20 + SystemProductInfo.Contact_yvalue), dimension.width, dimension.height);
            this.m_ContactPOBoxControl.setBounds(point2.x - SystemProductInfo.Contact_xvalue, point2.y - (20 + SystemProductInfo.Contact_yvalue), dimension2.width, dimension2.height);
            this.ivjLabelStreet.setBounds(point3.x - SystemProductInfo.Contact_xvalue, point3.y - (20 + SystemProductInfo.Contact_yvalue), dimension3.width, dimension3.height);
            this.m_ContactStreetControl.setBounds(point4.x - SystemProductInfo.Contact_xvalue, point4.y - (20 + SystemProductInfo.Contact_yvalue), dimension4.width, dimension4.height);
            this.ivjLabelCity.setBounds(point5.x - SystemProductInfo.Contact_xvalue, point5.y - (20 + SystemProductInfo.Contact_yvalue), dimension5.width, dimension5.height);
            this.m_ContactCityControl.setBounds(point6.x - SystemProductInfo.Contact_xvalue, point6.y - (20 + SystemProductInfo.Contact_yvalue), dimension6.width, dimension6.height);
            this.ivjLabelState.setBounds(point7.x - SystemProductInfo.Contact_xvalue, point7.y - (20 + SystemProductInfo.Contact_yvalue), dimension7.width, dimension7.height);
            this.m_ContactStateControl.setBounds(point8.x - SystemProductInfo.Contact_xvalue, point8.y - (20 + SystemProductInfo.Contact_yvalue), dimension8.width + 10, dimension8.height);
            this.ivjLabelZip.setBounds(point9.x - SystemProductInfo.Contact_xvalue, point9.y - (20 + SystemProductInfo.Contact_yvalue), dimension9.width + 10, dimension9.height);
            this.m_ContactZipControl.setBounds(point10.x - SystemProductInfo.Contact_xvalue, point10.y - (20 + SystemProductInfo.Contact_yvalue), dimension10.width, dimension10.height);
            this.ivjLabelCountry.setBounds(point11.x - SystemProductInfo.Contact_xvalue, point11.y - (20 + SystemProductInfo.Contact_yvalue), dimension11.width, dimension11.height);
            this.m_ContactCountryControl.setBounds(point12.x - SystemProductInfo.Contact_xvalue, point12.y - (20 + SystemProductInfo.Contact_yvalue), dimension12.width, dimension12.height);
            this.m_ContactCheckFrenchControl.setBounds(point13.x - SystemProductInfo.Contact_xvalue, point13.y - (20 + SystemProductInfo.Contact_yvalue), dimension13.width + 20, dimension13.height + 10);
            if (SysInfo.getOSPlatform().equals("AIX")) {
                if (locale.toString().equals("ko_KR")) {
                    this.ivjLabelPOBox.setBounds(point.x - SystemProductInfo.Contact_xvalue, point.y - (20 + SystemProductInfo.Contact_yvalue), dimension.width + 30, dimension.height);
                } else if (locale.toString().equals("zh_CN")) {
                    this.ivjLabelPOBox.setBounds(point.x - (SystemProductInfo.Contact_xvalue + 2), point.y - (20 + SystemProductInfo.Contact_yvalue), dimension.width, dimension.height + 2);
                    this.m_ContactPOBoxControl.setBounds(point2.x - SystemProductInfo.Contact_xvalue, point2.y - (20 + SystemProductInfo.Contact_yvalue), dimension2.width, dimension2.height + 5);
                    this.ivjLabelStreet.setBounds(point3.x - (SystemProductInfo.Contact_xvalue + 2), point3.y - (20 + SystemProductInfo.Contact_yvalue), dimension3.width, dimension3.height + 2);
                    this.m_ContactStreetControl.setBounds(point4.x - SystemProductInfo.Contact_xvalue, point4.y - (20 + SystemProductInfo.Contact_yvalue), dimension4.width, dimension4.height + 5);
                    this.ivjLabelCity.setBounds(point5.x - (SystemProductInfo.Contact_xvalue + 2), point5.y - (20 + SystemProductInfo.Contact_yvalue), dimension5.width, dimension5.height + 2);
                    this.m_ContactCityControl.setBounds(point6.x - SystemProductInfo.Contact_xvalue, point6.y - (20 + SystemProductInfo.Contact_yvalue), dimension6.width, dimension6.height + 5);
                    this.ivjLabelState.setBounds(point7.x - (SystemProductInfo.Contact_xvalue + 2), point7.y - (20 + SystemProductInfo.Contact_yvalue), dimension7.width, dimension7.height + 2);
                    this.m_ContactStateControl.setBounds(point8.x - SystemProductInfo.Contact_xvalue, point8.y - (20 + SystemProductInfo.Contact_yvalue), dimension8.width + 10, dimension8.height + 5);
                    this.ivjLabelZip.setBounds(point9.x - (SystemProductInfo.Contact_xvalue + 2), point9.y - (20 + SystemProductInfo.Contact_yvalue), dimension9.width + 10, dimension9.height + 2);
                    this.m_ContactZipControl.setBounds(point10.x - SystemProductInfo.Contact_xvalue, point10.y - (20 + SystemProductInfo.Contact_yvalue), dimension10.width, dimension10.height + 5);
                    this.ivjLabelCountry.setBounds(point11.x - (SystemProductInfo.Contact_xvalue + 2), point11.y - (20 + SystemProductInfo.Contact_yvalue), dimension11.width, dimension11.height + 2);
                    this.m_ContactCountryControl.setBounds(point12.x - SystemProductInfo.Contact_xvalue, point12.y - (20 + SystemProductInfo.Contact_yvalue), dimension12.width, dimension12.height + 5);
                }
            }
            if (n == 27 && this.m_refLanguage.isFrenchCheckSupported() && this.m_refBrand.showAlternateLanguageQuestion()) {
                this.m_ContactCheckFrenchControl.setVisible(true);
            } else {
                this.m_ContactCheckFrenchControl.setVisible(false);
            }
            if (!this.m_refLanguage.isStateSupported(country)) {
                this.ivjLabelState.setVisible(false);
                this.m_ContactStateControl.setVisible(false);
            } else {
                this.m_ContactStateControl.setSelectedItem(custAddr.getState());
            }
            if (this.m_refLanguage.isPOBoxSupported()) {
                this.parentFrame.getContentPane().add((Component)this.ivjLabelPOBox, this.ivjLabelPOBox.getName());
                this.parentFrame.getContentPane().add((Component)this.m_ContactPOBoxControl, this.m_ContactPOBoxControl.getName());
            }
            if (this.m_refLanguage.isStreetAddressSupported()) {
                this.parentFrame.getContentPane().add((Component)this.ivjLabelStreet, this.ivjLabelStreet.getName());
                this.parentFrame.getContentPane().add((Component)this.m_ContactStreetControl, this.m_ContactStreetControl.getName());
            }
            if (this.m_refLanguage.isCitySupported()) {
                this.parentFrame.getContentPane().add((Component)this.ivjLabelCity, this.ivjLabelCity.getName());
                this.parentFrame.getContentPane().add((Component)this.m_ContactCityControl, this.m_ContactCityControl.getName());
            }
            this.parentFrame.getContentPane().add((Component)this.ivjLabelState, this.ivjLabelState.getName());
            this.parentFrame.getContentPane().add((Component)this.m_ContactStateControl, this.m_ContactStateControl.getName());
            if (this.m_refLanguage.isZipSupported()) {
                this.parentFrame.getContentPane().add((Component)this.ivjLabelZip, this.ivjLabelZip.getName());
                this.parentFrame.getContentPane().add((Component)this.m_ContactZipControl, this.m_ContactZipControl.getName());
            }
            if (this.m_refLanguage.isCountrySupported()) {
                this.parentFrame.getContentPane().add((Component)this.ivjLabelCountry, this.ivjLabelCountry.getName());
                this.parentFrame.getContentPane().add((Component)this.m_ContactCountryControl, this.m_ContactCountryControl.getName());
            }
            if (this.m_refLanguage.isFrenchCheckSupported()) {
                this.parentFrame.getContentPane().add((Component)this.m_ContactCheckFrenchControl, this.m_ContactCheckFrenchControl.getName());
            }
            this.m_ContactCountryControl.addItemListener(this);
            this.m_ContactPOBoxControl.addKeyListener(this);
            this.m_ContactStreetControl.addKeyListener(this);
            this.m_ContactCityControl.addKeyListener(this);
            this.m_ContactZipControl.addKeyListener(this);
        }
        catch (Throwable throwable) {
            System.out.println("Error in AddrControl.initialize()! " + throwable);
            throwable.printStackTrace();
        }
    }

    private Vector initState(Country country) {
        if (country != null && this.m_refLanguage.isStateSupported(country)) {
            String string = null;
            Vector<String> vector = new Vector<String>(country.numberOfStateOrProvs());
            int n = 0;
            while (n < country.numberOfStateOrProvs()) {
                string = country.getStateProv(n);
                if (Utility.validateIsWhiteSpace(string) == -1) {
                    vector.addElement(string);
                    hashState.put(string, new Integer(n));
                }
                ++n;
            }
            Locale locale = Locale.getDefault();
            Collator collator = Collator.getInstance(locale);
            int n2 = vector.size();
            CollationKey[] collationKeyArray = new CollationKey[n2];
            n = 0;
            while (n < n2) {
                collationKeyArray[n] = collator.getCollationKey((String)vector.elementAt(n));
                ++n;
            }
            CollationKey collationKey = null;
            n = 0;
            while (n < n2 - 1) {
                int n3 = n + 1;
                while (n3 < n2) {
                    if (collationKeyArray[n].compareTo(collationKeyArray[n3]) > 0) {
                        collationKey = collationKeyArray[n];
                        collationKeyArray[n] = collationKeyArray[n3];
                        collationKeyArray[n3] = collationKey;
                    }
                    ++n3;
                }
                ++n;
            }
            Vector<String> vector2 = new Vector<String>(n2);
            n = 0;
            while (n < n2) {
                vector2.addElement(collationKeyArray[n].getSourceString());
                ++n;
            }
            vector2.insertElementAt(new String(""), 0);
            return vector2;
        }
        return new Vector();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.m_ContactCountryControl && itemEvent.getStateChange() == 1) {
            this.onSelchangeCOMBOCountry();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 16) {
            return;
        }
        if (keyEvent.getSource() == this.m_ContactPOBoxControl) {
            this.onChangeEDITPOBox();
        } else if (keyEvent.getSource() == this.m_ContactStreetControl) {
            this.onChangeEDITStreet();
        } else if (keyEvent.getSource() == this.m_ContactCityControl) {
            this.onChangeEDITCity();
        } else if (keyEvent.getSource() == this.m_ContactZipControl) {
            this.onChangeEDITZip();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    private void loadStateComboBox(Country country) {
        if (country != null && this.m_refLanguage.isStateSupported(country)) {
            String string = null;
            String[] stringArray = new String[country.numberOfStateOrProvs()];
            int n = 0;
            while (n < country.numberOfStateOrProvs()) {
                string = country.getStateProv(n);
                if (Utility.validateIsWhiteSpace(string) == -1) {
                    stringArray[n] = string;
                    hashState.put(string, new Integer(n));
                }
                ++n;
            }
            Locale locale = Locale.getDefault();
            Collator collator = Collator.getInstance(locale);
            int n2 = stringArray.length;
            CollationKey[] collationKeyArray = new CollationKey[n2];
            n = 0;
            while (n < n2) {
                collationKeyArray[n] = collator.getCollationKey(stringArray[n]);
                ++n;
            }
            CollationKey collationKey = null;
            int n3 = 0;
            while (n3 < n2 - 1) {
                int n4 = n3 + 1;
                while (n4 < n2) {
                    if (collationKeyArray[n3].compareTo(collationKeyArray[n4]) > 0) {
                        collationKey = collationKeyArray[n3];
                        collationKeyArray[n3] = collationKeyArray[n4];
                        collationKeyArray[n4] = collationKey;
                    }
                    ++n4;
                }
                ++n3;
            }
            this.m_ContactStateControl.removeAllItems();
            n = 0;
            while (n < n2) {
                this.m_ContactStateControl.addItem(collationKeyArray[n].getSourceString());
                ++n;
            }
        }
    }

    public void onChangeEDITCity() {
        String string = this.getCity();
        if (Utility.validateString(string) != -1) {
            RegException regException = new RegException(217);
            regException.showMessage();
            if (this.m_ContactCityControl.isVisible()) {
                this.m_ContactCityControl.requestFocus();
            }
        }
    }

    public void onChangeEDITPOBox() {
        String string = this.getPOBox();
        if (Utility.validateString(string) != -1) {
            RegException regException = new RegException(217);
            regException.showMessage();
            if (this.m_ContactPOBoxControl.isVisible()) {
                this.m_ContactPOBoxControl.requestFocus();
            }
        }
    }

    public void onChangeEDITStreet() {
        String string = this.getStreet();
        if (Utility.validateString(string) != -1) {
            RegException regException = new RegException(217);
            regException.showMessage();
            if (this.m_ContactStreetControl.isVisible()) {
                this.m_ContactStreetControl.requestFocus();
            }
        }
    }

    public void onChangeEDITZip() {
        block3: {
            String string = this.getZip();
            try {
                if (Utility.validateString(string) != -1) {
                    throw new RegException(217);
                }
                Country.getCountry(this.getCountryIdx()).validateZipString(string);
            }
            catch (RegException regException) {
                if (regException.getMessageID() != 217 && regException.getMessageID() != 246) break block3;
                regException.showMessage();
                if (!this.m_ContactZipControl.isVisible()) break block3;
                this.m_ContactZipControl.requestFocus();
            }
        }
        this.ZipValidationIsOK = false;
    }

    public void onSelchangeCOMBOCountry() {
        if (!this.doingDataExchange) {
            CustInfo custInfo = CustInfo.getInstance();
            CustAddr custAddr = custInfo.getAddr();
            String string = (String)this.m_ContactCountryControl.getSelectedItem();
            if (string.length() > 0) {
                Country country;
                int n = (Integer)hashCountry.get(string);
                Language language = Language.getDefaultLanguage();
                if (!language.isStateSupported(country = Country.getCountry(n))) {
                    this.ivjLabelState.setVisible(false);
                    this.m_ContactStateControl.setVisible(false);
                } else {
                    Rectangle rectangle = this.m_ContactStateControl.getBounds();
                    this.parentFrame.getContentPane().remove(this.m_ContactStateControl);
                    this.m_ContactStateControl = new JComboBox(this.initState(country));
                    this.m_ContactStateControl.setName("StateComboBox");
                    this.m_ContactStateControl.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
                    this.m_ContactStateControl.setBackground(Color.white);
                    this.m_ContactStateControl.setBounds(rectangle);
                    this.parentFrame.getContentPane().add((Component)this.m_ContactStateControl, this.m_ContactStateControl.getName());
                    this.ivjLabelState.setVisible(true);
                    this.parentFrame.getContentPane().invalidate();
                    this.parentFrame.getContentPane().validate();
                    this.parentFrame.getContentPane().repaint();
                }
                if (n == 27 && this.m_refLanguage.isFrenchCheckSupported() && this.m_refBrand.showAlternateLanguageQuestion()) {
                    this.m_ContactCheckFrenchControl.setVisible(true);
                    this.m_ContactCheckFrenchControl.setEnabled(true);
                    custAddr.setCheckFrenchState(true);
                } else {
                    this.m_ContactCheckFrenchControl.setVisible(false);
                    this.m_ContactCheckFrenchControl.setSelected(false);
                    custAddr.setCheckFrenchState(false);
                }
            }
        }
    }

    public void saveInfo() {
        int n;
        CustInfo custInfo = CustInfo.getInstance();
        CustAddr custAddr = custInfo.getAddr();
        Language.getDefaultLanguage();
        custAddr.setPOBox(this.m_ContactPOBoxControl.getText());
        custAddr.setStreet(this.m_ContactStreetControl.getText());
        custAddr.setCity(this.m_ContactCityControl.getText());
        custAddr.setZip(this.m_ContactZipControl.getText());
        String string = (String)this.m_ContactCountryControl.getSelectedItem();
        int n2 = (Integer)hashCountry.get(string);
        custAddr.setCountryIdx(string, n2);
        boolean bl = this.m_ContactCheckFrenchControl.isSelected();
        custAddr.setCheckFrench(bl);
        String string2 = this.m_refLanguage.getLanguageString();
        custInfo.setLanguage(string2);
        Country country = Country.getCountry(n2);
        String string3 = (String)this.m_ContactStateControl.getSelectedItem();
        if (string3 == null || string3.length() == 0) {
            string3 = "";
            n = -1;
        } else {
            n = (Integer)hashState.get(string3);
        }
        String string4 = "";
        string4 = country.getStatePostString(n);
        custAddr.setStateIdx(string3, string4);
    }

    public void setCity(String string) {
        this.m_strContactCity = string;
        this.m_ContactCityControl.setText(this.m_strContactCity);
    }

    public void setCountry(String string) {
        this.m_strContactCountry = string;
        this.m_ContactCountryControl.setSelectedItem(this.m_strContactCountry);
    }

    public void setCountryIdx(String string, int n) {
        this.m_strContactCountry = string;
    }

    public boolean setFieldFocus(int n, int n2) {
        boolean bl = false;
        switch (n) {
            case 247: {
                if (!this.m_ContactPOBoxControl.isVisible()) break;
                this.m_ContactPOBoxControl.requestFocus();
                break;
            }
            case 203: 
            case 222: {
                if (!this.m_ContactStreetControl.isVisible()) break;
                this.m_ContactStreetControl.requestFocus();
                break;
            }
            case 204: {
                if (!this.m_ContactCityControl.isVisible()) break;
                this.m_ContactCityControl.requestFocus();
                break;
            }
            case 205: {
                if (!this.m_ContactStateControl.isVisible()) break;
                this.m_ContactStateControl.requestFocus();
                break;
            }
            case 206: {
                if (!this.m_ContactZipControl.isVisible()) break;
                this.m_ContactZipControl.requestFocus();
                break;
            }
            case 1516: 
            case 1517: {
                if (n2 == 1) {
                    this.ZipValidationIsOK = true;
                    bl = true;
                    break;
                }
                if (!this.m_ContactZipControl.isVisible()) break;
                this.m_ContactZipControl.requestFocus();
                break;
            }
            case 207: {
                if (!this.m_ContactCountryControl.isVisible()) break;
                this.m_ContactCountryControl.requestFocus();
                break;
            }
            case 224: 
            case 225: {
                if (n2 == 1) {
                    this.ZipValidationIsOK = true;
                    bl = true;
                    break;
                }
                if (!this.m_ContactZipControl.isVisible()) break;
                this.m_ContactZipControl.requestFocus();
            }
        }
        return bl;
    }

    public void setPOBox(String string) {
        this.m_strContactPOBox = string;
        this.m_ContactPOBoxControl.setText(this.m_strContactPOBox);
    }

    public void setState(String string) {
        this.m_strContactState = string;
        this.m_ContactStateControl.setSelectedItem(this.m_strContactState);
    }

    public void setStateIdx(String string, int n) {
        this.m_strContactState = string;
    }

    public void setStreet(String string) {
        this.m_strContactStreet = string;
        this.m_ContactStreetControl.setText(this.m_strContactStreet);
    }

    public void setZip(String string) {
        this.m_strContactZip = string;
        this.m_ContactZipControl.setText(this.m_strContactZip);
    }
}

