/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lexington.prt;

import com.ibm.lexington.prt.AddInfo;
import com.ibm.lexington.prt.BlueMetalTheme;
import com.ibm.lexington.prt.Brand;
import com.ibm.lexington.prt.Contact;
import com.ibm.lexington.prt.Language;
import com.ibm.lexington.prt.RegException;
import com.ibm.lexington.prt.SysInfo;
import com.ibm.lexington.prt.SystemProductInfo;
import com.ibm.lexington.prt.Utility;
import com.ibm.lexington.prt.res.Bounds;
import com.ibm.lexington.prt.res.StrBounds;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class BiosInfo
extends JFrame
implements ActionListener,
WindowListener {
    private Contact contact;
    private AddInfo addInfo;
    private JLabel ivjLabelBiosInfo;
    private JTextPane ivjLabelBiosInfoFound;
    private JLabel ivjGlobeGraphicLabel;
    private JLabel ivjLabelSTATICManufacturer;
    private JLabel ivjLabelManufacturer;
    private JLabel ivjLabelSTATICMachineTypeAndModel;
    private JLabel ivjLabelMachineTypeAndModel;
    private JLabel ivjLabelSTATICSerialNumber;
    private JLabel ivjLabelSerialNumber;
    private JLabel ivjLabelSTATICOS;
    private JLabel ivjLabelOS;
    private JLabel ivjLabelSendBiosInfoQ;
    private ButtonGroup bgBiosInfoQ = new ButtonGroup();
    private JRadioButton rbYes;
    private JRadioButton rbNo;
    private JLabel ivjBrandGraphicLabel;
    private JButton ivjButtonBack;
    private JButton ivjButtonNext;
    private JButton ivjButtonExit;
    boolean m_closedFromRegException;
    private boolean m_sendBiosInfo;
    private static boolean m_biosFound = false;
    private static boolean m_biosInit = false;
    private static String m_manufacturer = "";
    private static String m_machineModel = "";
    private static String m_serial = "";
    private static boolean m_fixed = false;

    public BiosInfo(Contact contact) {
        Dimension dimension = null;
        try {
            this.setName("BiosInfo");
            this.setResizable(false);
            this.setDefaultCloseOperation(0);
            this.getContentPane().setLayout(null);
            this.getContentPane().setBackground(Color.lightGray);
            this.setTitle(SystemProductInfo.title);
            try {
                MetalLookAndFeel metalLookAndFeel = new MetalLookAndFeel();
                MetalLookAndFeel.setCurrentTheme(new BlueMetalTheme());
                UIManager.setLookAndFeel(metalLookAndFeel);
                UIManager.put("ToolTip.background", new Color(95, 127, 191));
            }
            catch (Exception exception) {
                System.out.println("Problem setting the Look and Feel!");
                exception.printStackTrace();
            }
            Bounds bounds = (Bounds)Language.rb_241.getObject(Integer.toString(2100));
            Point point = bounds.returnPoint();
            SystemProductInfo.BiosInfo_xvalue = point.x;
            SystemProductInfo.BiosInfo_yvalue = point.y;
            dimension = bounds.returnDimension();
            ((Component)this).setSize(dimension.width, dimension.height);
            this.getContentPane().setSize(dimension.width, dimension.height);
        }
        catch (Throwable throwable) {
            System.out.println("Problem setting up the BiosInfo screen!");
            throwable.printStackTrace();
        }
        this.contact = contact;
        this.m_sendBiosInfo = true;
        if (!m_biosInit) {
            m_biosInit = true;
            m_biosFound = SystemProductInfo.getInstance().doBiosProcessing();
            if (m_biosFound) {
                SystemProductInfo.getInstance().getBiosInfo(m_manufacturer, m_machineModel, m_serial);
            }
        }
        this.initialize();
        this.doDataExchange();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        ((Component)this).setCursor(new Cursor(3));
        if (actionEvent.getSource() == this.ivjButtonExit) {
            this.onAppExit();
        } else if (actionEvent.getSource() == this.ivjButtonBack) {
            this.onBiosInfoBack();
        } else if (actionEvent.getSource() == this.ivjButtonNext) {
            this.onBiosInfoNext();
        } else if (actionEvent.getSource() == this.rbYes) {
            this.onBiosYes();
        } else if (actionEvent.getSource() == this.rbNo) {
            this.onBiosNo();
        }
        ((Component)this).setCursor(new Cursor(0));
    }

    private void addButtons() {
        try {
            Rectangle rectangle = this.getBounds();
            this.ivjButtonExit = new JButton();
            this.ivjButtonExit.setName("ButtonExit");
            this.ivjButtonExit.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.ivjButtonExit.setBackground(Color.lightGray);
            this.ivjButtonExit.setMargin(new Insets(2, 9, 2, 9));
            this.ivjButtonNext = new JButton();
            this.ivjButtonNext.setName("ButtonNext");
            this.ivjButtonNext.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.ivjButtonNext.setBackground(Color.lightGray);
            this.ivjButtonNext.setMargin(new Insets(2, 9, 2, 9));
            this.ivjButtonBack = new JButton();
            this.ivjButtonBack.setName("ButtonBack");
            this.ivjButtonBack.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.ivjButtonBack.setBackground(Color.lightGray);
            this.ivjButtonBack.setMargin(new Insets(2, 9, 2, 9));
            StrBounds strBounds = (StrBounds)Language.rb_241.getObject(Integer.toString(2105));
            String string = strBounds.returnString();
            StrBounds strBounds2 = (StrBounds)Language.rb_241.getObject(Integer.toString(2104));
            String string2 = strBounds2.returnString();
            StrBounds strBounds3 = (StrBounds)Language.rb_241.getObject(Integer.toString(2103));
            String string3 = strBounds3.returnString();
            Insets insets = this.ivjButtonExit.getInsets();
            Insets insets2 = this.ivjButtonNext.getInsets();
            Insets insets3 = this.ivjButtonBack.getInsets();
            Dimension dimension = Utility.determineTextDimensions(this.ivjButtonExit, string);
            Dimension dimension2 = Utility.determineTextDimensions(this.ivjButtonNext, string2);
            Dimension dimension3 = Utility.determineTextDimensions(this.ivjButtonBack, string3);
            int n = dimension.width + insets.left + insets.right;
            int n2 = dimension2.width + insets2.left + insets2.right;
            int n3 = dimension3.width + insets3.left + insets3.right;
            int n4 = Math.max(n, n2);
            n4 = Math.max(n3, n4);
            if (n4 < 60) {
                n4 = 60;
            }
            int n5 = dimension.height + insets.top + insets.bottom;
            int n6 = dimension2.height + insets2.top + insets2.bottom;
            int n7 = dimension3.height + insets3.top + insets3.bottom;
            int n8 = rectangle.height;
            if (SysInfo.getOSPlatform().equals("AIX") && Locale.getDefault().toString().equals("zh_CN")) {
                n8 = rectangle.height - 10;
            }
            n8 -= 20;
            int n9 = rectangle.width - 20;
            this.ivjButtonExit.setBounds(n9 -= n4, n8 -= n5, n4, n5);
            n9 -= 20;
            this.ivjButtonNext.setBounds(n9 -= n4, n8, n4, n6);
            this.ivjButtonBack.setBounds(n9 -= n4, n8, n4, n7);
            this.ivjButtonExit.setText(string);
            this.ivjButtonNext.setText(string2);
            this.ivjButtonBack.setText(string3);
            this.getContentPane().add((Component)this.ivjButtonExit, this.ivjButtonExit.getName());
            this.getContentPane().add((Component)this.ivjButtonNext, this.ivjButtonNext.getName());
            this.getContentPane().add((Component)this.ivjButtonBack, this.ivjButtonBack.getName());
        }
        catch (Throwable throwable) {
            System.out.println("Problem in BiosInfo.addButtons()!");
            throwable.printStackTrace();
        }
    }

    private static String copyright() {
        return "\n\nLicensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1999, 2000. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    }

    private void doDataExchange() {
        if (SystemProductInfo.getInstance().getBiosSend()) {
            this.bgBiosInfoQ.setSelected(this.rbYes.getModel(), true);
        } else {
            this.bgBiosInfoQ.setSelected(this.rbNo.getModel(), true);
        }
        if (m_manufacturer.length() > 0) {
            this.ivjLabelManufacturer.setText(m_manufacturer);
        } else {
            this.ivjLabelSTATICManufacturer.setEnabled(false);
        }
        if (m_machineModel.length() > 0) {
            this.ivjLabelMachineTypeAndModel.setText(m_machineModel);
        } else {
            this.ivjLabelSTATICMachineTypeAndModel.setEnabled(false);
        }
        if (m_serial.length() > 0) {
            this.ivjLabelSerialNumber.setText(m_serial);
        } else {
            this.ivjLabelSTATICSerialNumber.setEnabled(false);
        }
        this.ivjLabelOS.setText(String.valueOf(SysInfo.getOSPlatform()) + " " + SysInfo.getOSVersion());
    }

    private void initialize() {
        int n = 0;
        try {
            Object object;
            String string;
            this.ivjLabelBiosInfo = new JLabel();
            this.ivjLabelBiosInfo.setName("SystemInformationLabel");
            if (Language.getDefaultLanguage().supportsBold()) {
                n = 1;
            }
            this.ivjLabelBiosInfo.setFont(new Font(SystemProductInfo.type, n, SystemProductInfo.size));
            this.ivjLabelBiosInfo.setBackground(Color.lightGray);
            this.ivjLabelBiosInfo.setForeground(Color.black);
            this.ivjLabelBiosInfoFound = new JTextPane();
            this.ivjLabelBiosInfoFound.setName("JTextPaneBiosInfoFound");
            this.ivjLabelBiosInfoFound.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.ivjLabelBiosInfoFound.setBackground(Color.lightGray);
            this.ivjLabelBiosInfoFound.setSelectionColor(SystemColor.control);
            this.ivjLabelBiosInfoFound.setDisabledTextColor(Color.black);
            this.ivjLabelBiosInfoFound.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 10));
            this.ivjLabelBiosInfoFound.setEditable(false);
            this.ivjLabelBiosInfoFound.setEnabled(false);
            this.ivjLabelBiosInfoFound.setAutoscrolls(true);
            this.ivjGlobeGraphicLabel = new JLabel();
            this.ivjGlobeGraphicLabel.setName("GlobeGraphicLabel");
            this.ivjLabelSTATICManufacturer = new JLabel();
            this.ivjLabelSTATICManufacturer.setName("STATICManufacturerLabel");
            this.ivjLabelSTATICManufacturer.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.ivjLabelSTATICManufacturer.setBackground(Color.lightGray);
            this.ivjLabelSTATICManufacturer.setForeground(Color.black);
            this.ivjLabelManufacturer = new JLabel();
            this.ivjLabelManufacturer.setName("ManufacturerLabel");
            this.ivjLabelManufacturer.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.ivjLabelManufacturer.setBackground(Color.lightGray);
            this.ivjLabelManufacturer.setForeground(Color.black);
            this.ivjLabelSTATICMachineTypeAndModel = new JLabel();
            this.ivjLabelSTATICMachineTypeAndModel.setName("STATICMachineTypeAndModelLabel");
            this.ivjLabelSTATICMachineTypeAndModel.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.ivjLabelSTATICMachineTypeAndModel.setBackground(Color.lightGray);
            this.ivjLabelSTATICMachineTypeAndModel.setForeground(Color.black);
            this.ivjLabelMachineTypeAndModel = new JLabel();
            this.ivjLabelMachineTypeAndModel.setName("MachineTypeAndModelLabel");
            this.ivjLabelMachineTypeAndModel.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.ivjLabelMachineTypeAndModel.setBackground(Color.lightGray);
            this.ivjLabelMachineTypeAndModel.setForeground(Color.black);
            this.ivjLabelSTATICSerialNumber = new JLabel();
            this.ivjLabelSTATICSerialNumber.setName("STATICSerialNumberLabel");
            this.ivjLabelSTATICSerialNumber.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.ivjLabelSTATICSerialNumber.setBackground(Color.lightGray);
            this.ivjLabelSTATICSerialNumber.setForeground(Color.black);
            this.ivjLabelSerialNumber = new JLabel();
            this.ivjLabelSerialNumber.setName("SerialNumberLabel");
            this.ivjLabelSerialNumber.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.ivjLabelSerialNumber.setBackground(Color.lightGray);
            this.ivjLabelSerialNumber.setForeground(Color.black);
            this.ivjLabelSTATICOS = new JLabel();
            this.ivjLabelSTATICOS.setName("STATICOSLabel");
            this.ivjLabelSTATICOS.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.ivjLabelSTATICOS.setBackground(Color.lightGray);
            this.ivjLabelSTATICOS.setForeground(Color.black);
            this.ivjLabelOS = new JLabel();
            this.ivjLabelOS.setName("OSLabel");
            this.ivjLabelOS.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.ivjLabelOS.setBackground(Color.lightGray);
            this.ivjLabelOS.setForeground(Color.black);
            this.ivjLabelSendBiosInfoQ = new JLabel();
            this.ivjLabelSendBiosInfoQ.setName("SendBiosInfoQLabel");
            this.ivjLabelSendBiosInfoQ.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.ivjLabelSendBiosInfoQ.setBackground(Color.lightGray);
            this.ivjLabelSendBiosInfoQ.setForeground(Color.black);
            this.rbYes = new JRadioButton();
            this.rbYes.setName("BiosYesRadioButton");
            this.rbYes.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.rbYes.setBackground(Color.lightGray);
            this.rbYes.setHorizontalTextPosition(2);
            this.rbNo = new JRadioButton();
            this.rbNo.setName("BiosYesRadioButton");
            this.rbNo.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.rbNo.setBackground(Color.lightGray);
            this.rbNo.setHorizontalTextPosition(2);
            this.bgBiosInfoQ.add(this.rbYes);
            this.bgBiosInfoQ.add(this.rbNo);
            this.ivjBrandGraphicLabel = new JLabel();
            this.ivjBrandGraphicLabel.setName("BrandGraphicLabel");
            StrBounds strBounds = (StrBounds)Language.rb_241.getObject(Integer.toString(2106));
            StrBounds strBounds2 = (StrBounds)Language.rb_241.getObject(Integer.toString(2107));
            StrBounds strBounds3 = (StrBounds)Language.rb_241.getObject(Integer.toString(2110));
            StrBounds strBounds4 = (StrBounds)Language.rb_241.getObject(Integer.toString(2114));
            StrBounds strBounds5 = (StrBounds)Language.rb_241.getObject(Integer.toString(2111));
            StrBounds strBounds6 = (StrBounds)Language.rb_241.getObject(Integer.toString(2115));
            StrBounds strBounds7 = (StrBounds)Language.rb_241.getObject(Integer.toString(2112));
            StrBounds strBounds8 = (StrBounds)Language.rb_241.getObject(Integer.toString(2116));
            StrBounds strBounds9 = (StrBounds)Language.rb_241.getObject(Integer.toString(2113));
            StrBounds strBounds10 = (StrBounds)Language.rb_241.getObject(Integer.toString(2117));
            StrBounds strBounds11 = (StrBounds)Language.rb_241.getObject(Integer.toString(2109));
            StrBounds strBounds12 = (StrBounds)Language.rb_241.getObject(Integer.toString(2101));
            StrBounds strBounds13 = (StrBounds)Language.rb_241.getObject(Integer.toString(2102));
            Point point = strBounds.returnPoint();
            Point point2 = strBounds2.returnPoint();
            Point point3 = strBounds3.returnPoint();
            Point point4 = strBounds4.returnPoint();
            Point point5 = strBounds5.returnPoint();
            Point point6 = strBounds6.returnPoint();
            Point point7 = strBounds7.returnPoint();
            Point point8 = strBounds8.returnPoint();
            Point point9 = strBounds9.returnPoint();
            Point point10 = strBounds10.returnPoint();
            Point point11 = strBounds11.returnPoint();
            strBounds12.returnPoint();
            strBounds13.returnPoint();
            Dimension dimension = strBounds.returnDimension();
            Dimension dimension2 = strBounds2.returnDimension();
            Dimension dimension3 = strBounds3.returnDimension();
            Dimension dimension4 = strBounds4.returnDimension();
            Dimension dimension5 = strBounds5.returnDimension();
            Dimension dimension6 = strBounds6.returnDimension();
            Dimension dimension7 = strBounds7.returnDimension();
            Dimension dimension8 = strBounds8.returnDimension();
            Dimension dimension9 = strBounds9.returnDimension();
            Dimension dimension10 = strBounds10.returnDimension();
            strBounds11.returnDimension();
            Dimension dimension11 = strBounds12.returnDimension();
            strBounds13.returnDimension();
            Dimension dimension12 = this.getSize();
            ImageIcon imageIcon = null;
            try {
                imageIcon = new ImageIcon(this.getClass().getResource("/com/ibm/lexington/prt/res/globe.gif"));
                this.ivjGlobeGraphicLabel.setIcon(imageIcon);
                this.ivjGlobeGraphicLabel.setBounds(dimension12.width - imageIcon.getIconWidth() - 20, 46, imageIcon.getIconWidth(), imageIcon.getIconHeight());
                string = Brand.getBrand().getBrandStringLow();
                object = String.valueOf(string) + "brand.gif";
                imageIcon = new ImageIcon(this.getClass().getResource("/com/ibm/lexington/prt/res/" + (String)object));
                this.ivjBrandGraphicLabel.setIcon(imageIcon);
                this.ivjBrandGraphicLabel.setBounds(0, dimension12.height - 80, imageIcon.getIconWidth(), imageIcon.getIconHeight());
            }
            catch (Exception exception) {
                System.out.println("BiosInfo.initialize(): Could not load GIFs.");
            }
            string = strBounds11.returnString();
            object = Utility.determineTextDimensions(this.ivjLabelSendBiosInfoQ, string);
            String string2 = strBounds12.returnString();
            Dimension dimension13 = Utility.determineTextDimensions(this.rbYes, string2);
            String string3 = strBounds13.returnString();
            Dimension dimension14 = Utility.determineTextDimensions(this.rbNo, string3);
            int n2 = 15;
            this.ivjLabelBiosInfo.setBounds(point.x - SystemProductInfo.BiosInfo_xvalue, point.y - (20 + SystemProductInfo.BiosInfo_yvalue), dimension.width, dimension.height);
            this.ivjLabelBiosInfoFound.setBounds(point2.x - SystemProductInfo.BiosInfo_xvalue, point2.y - (20 + SystemProductInfo.BiosInfo_yvalue), dimension2.width, dimension2.height);
            this.ivjLabelSTATICManufacturer.setBounds(point3.x - SystemProductInfo.BiosInfo_xvalue, point3.y - (20 + SystemProductInfo.BiosInfo_yvalue), dimension3.width, dimension3.height);
            this.ivjLabelManufacturer.setBounds(point4.x - SystemProductInfo.BiosInfo_xvalue, point4.y - (20 + SystemProductInfo.BiosInfo_yvalue), dimension4.width, dimension4.height);
            this.ivjLabelSTATICMachineTypeAndModel.setBounds(point5.x - SystemProductInfo.BiosInfo_xvalue, point5.y - (20 + SystemProductInfo.BiosInfo_yvalue), dimension5.width + n2, dimension5.height);
            this.ivjLabelMachineTypeAndModel.setBounds(point6.x - SystemProductInfo.BiosInfo_xvalue + n2, point6.y - (20 + SystemProductInfo.BiosInfo_yvalue), dimension6.width, dimension6.height);
            this.ivjLabelSTATICSerialNumber.setBounds(point7.x - SystemProductInfo.BiosInfo_xvalue, point7.y - (20 + SystemProductInfo.BiosInfo_yvalue), dimension7.width, dimension7.height);
            this.ivjLabelSerialNumber.setBounds(point8.x - SystemProductInfo.BiosInfo_xvalue, point8.y - (20 + SystemProductInfo.BiosInfo_yvalue), dimension8.width, dimension8.height);
            this.ivjLabelSTATICOS.setBounds(point9.x - SystemProductInfo.BiosInfo_xvalue, point9.y - (20 + SystemProductInfo.BiosInfo_yvalue), dimension9.width, dimension9.height);
            this.ivjLabelOS.setBounds(point10.x - SystemProductInfo.BiosInfo_xvalue, point10.y - (20 + SystemProductInfo.BiosInfo_yvalue), dimension10.width, dimension10.height);
            this.ivjLabelSendBiosInfoQ.setBounds(point11.x - SystemProductInfo.BiosInfo_xvalue, point11.y - (20 + SystemProductInfo.BiosInfo_yvalue), ((Dimension)object).width, dimension11.height + 1);
            int n3 = 20;
            int n4 = this.ivjLabelSendBiosInfoQ.getX() + ((Dimension)object).width + 15;
            this.rbYes.setBounds(n4, point11.y - (20 + SystemProductInfo.BiosInfo_yvalue), dimension13.width + n3, dimension11.height + 1);
            int n5 = n4 + dimension13.width + n3 + 10;
            this.rbNo.setBounds(n5, point11.y - (20 + SystemProductInfo.BiosInfo_yvalue), dimension14.width + n3, dimension11.height + 1);
            this.ivjLabelBiosInfo.setText(strBounds.returnString());
            this.ivjLabelBiosInfoFound.setText(strBounds2.returnString());
            this.ivjLabelSTATICManufacturer.setText(strBounds3.returnString());
            this.ivjLabelSTATICMachineTypeAndModel.setText(strBounds5.returnString());
            this.ivjLabelSTATICSerialNumber.setText(strBounds7.returnString());
            this.ivjLabelSTATICOS.setText(strBounds9.returnString());
            this.ivjLabelSendBiosInfoQ.setText(strBounds11.returnString());
            this.ivjLabelSendBiosInfoQ.setText(string);
            this.rbYes.setText(string2);
            this.rbNo.setText(string3);
            this.getContentPane().add((Component)this.ivjLabelBiosInfo, this.ivjLabelBiosInfo.getName());
            this.getContentPane().add((Component)this.ivjLabelBiosInfoFound, this.ivjLabelBiosInfoFound.getName());
            this.getContentPane().add((Component)this.ivjGlobeGraphicLabel, this.ivjGlobeGraphicLabel.getName());
            this.getContentPane().add((Component)this.ivjLabelSTATICManufacturer, this.ivjLabelSTATICManufacturer.getName());
            this.getContentPane().add((Component)this.ivjLabelManufacturer, this.ivjLabelManufacturer.getName());
            this.getContentPane().add((Component)this.ivjLabelSTATICMachineTypeAndModel, this.ivjLabelSTATICMachineTypeAndModel.getName());
            this.getContentPane().add((Component)this.ivjLabelMachineTypeAndModel, this.ivjLabelMachineTypeAndModel.getName());
            this.getContentPane().add((Component)this.ivjLabelSTATICSerialNumber, this.ivjLabelSTATICSerialNumber.getName());
            this.getContentPane().add((Component)this.ivjLabelSerialNumber, this.ivjLabelSerialNumber.getName());
            this.getContentPane().add((Component)this.ivjLabelSTATICOS, this.ivjLabelSTATICOS.getName());
            this.getContentPane().add((Component)this.ivjLabelOS, this.ivjLabelOS.getName());
            this.getContentPane().add((Component)this.ivjLabelSendBiosInfoQ, this.ivjLabelSendBiosInfoQ.getName());
            this.getContentPane().add((Component)this.rbYes, this.rbYes.getName());
            this.getContentPane().add((Component)this.rbNo, this.rbNo.getName());
            this.getContentPane().add((Component)this.ivjBrandGraphicLabel, this.ivjBrandGraphicLabel.getName());
            this.addButtons();
            this.addWindowListener(this);
            this.ivjButtonBack.addActionListener(this);
            this.ivjButtonNext.addActionListener(this);
            this.ivjButtonExit.addActionListener(this);
            this.rbYes.addActionListener(this);
            this.rbNo.addActionListener(this);
            this.getRootPane().setDefaultButton(this.ivjButtonNext);
            Dimension dimension15 = Toolkit.getDefaultToolkit().getScreenSize();
            int n6 = dimension15.height / 2 - dimension12.height / 2 - 5;
            int n7 = dimension15.width / 2 - dimension12.width / 2 - 5;
            ((Component)this).setLocation(n7, n6);
        }
        catch (Throwable throwable) {
            System.out.println("Problem in BiosInfo.initialize()!");
            throwable.printStackTrace();
        }
    }

    protected void onAppExit() {
        if (!this.m_closedFromRegException) {
            RegException regException = new RegException(2243);
            int n = regException.showMessage();
            if (n == 0) {
                System.exit(0);
            }
        } else {
            System.exit(0);
        }
    }

    protected void onBiosInfoBack() {
        this.saveInfo();
        ((Component)this).setVisible(false);
        ((Component)this.contact).setVisible(true);
    }

    protected void onBiosInfoNext() {
        this.saveInfo();
        if (this.addInfo == null) {
            this.addInfo = new AddInfo(this);
        }
        ((Component)this).setVisible(false);
        ((Component)this.addInfo).setVisible(true);
    }

    protected void onBiosNo() {
        this.m_sendBiosInfo = false;
    }

    protected void onBiosYes() {
        this.m_sendBiosInfo = true;
    }

    protected void saveInfo() {
        SystemProductInfo systemProductInfo = SystemProductInfo.getInstance();
        systemProductInfo.setBiosSend(this.m_sendBiosInfo);
        if (this.m_sendBiosInfo) {
            systemProductInfo.setOSVersion(SysInfo.getOSVersion());
            systemProductInfo.setOSPlatform(SysInfo.getOSPlatform());
        } else {
            systemProductInfo.setOSVersion("");
            systemProductInfo.setOSPlatform("");
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
        RegException.setCurrentWindow(this);
        if (!m_fixed) {
            Insets insets = this.getInsets();
            if (SysInfo.getOSPlatform().equals("LINUX")) {
                System.out.println("Fixing LINUX BiosInfo screen");
                this.ivjLabelBiosInfoFound.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 10));
                Dimension dimension = this.getSize();
                dimension.height += insets.top;
                ((Component)this).setSize(dimension);
                this.getContentPane().setSize(dimension);
                dimension = this.getSize();
                Rectangle rectangle = this.ivjBrandGraphicLabel.getBounds();
                rectangle.y = this.getSize().height - 57 - insets.top;
                this.ivjBrandGraphicLabel.setBounds(rectangle);
                ((Component)this).setVisible(false);
                ((Component)this).setVisible(true);
            } else {
                System.out.println("Fixing non-LINUX BiosInfo screen");
                Rectangle rectangle = this.ivjButtonNext.getBounds();
                rectangle.y -= insets.top;
                this.ivjButtonNext.setBounds(rectangle);
                rectangle = this.ivjButtonBack.getBounds();
                rectangle.y -= insets.top;
                this.ivjButtonBack.setBounds(rectangle);
                rectangle = this.ivjButtonExit.getBounds();
                rectangle.y -= insets.top;
                this.ivjButtonExit.setBounds(rectangle);
            }
            m_fixed = true;
            this.invalidate();
        }
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    protected void writeRegistry() {
    }
}

