/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lexington.prt;

import com.ibm.lexington.prt.AddrControl;
import com.ibm.lexington.prt.BiosInfo;
import com.ibm.lexington.prt.BlueMetalTheme;
import com.ibm.lexington.prt.Brand;
import com.ibm.lexington.prt.Country;
import com.ibm.lexington.prt.CustInfo;
import com.ibm.lexington.prt.Language;
import com.ibm.lexington.prt.NameControl;
import com.ibm.lexington.prt.PhoneControl;
import com.ibm.lexington.prt.PrivacyDialog;
import com.ibm.lexington.prt.RegException;
import com.ibm.lexington.prt.SysInfo;
import com.ibm.lexington.prt.SystemProductInfo;
import com.ibm.lexington.prt.Utility;
import com.ibm.lexington.prt.res.Bounds;
import com.ibm.lexington.prt.res.StrBounds;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class Contact
extends JFrame
implements ActionListener,
KeyListener,
WindowListener {
    private BiosInfo biosInfo;
    private JButton ivjButtonPrivacy;
    private JButton ivjButtonBack;
    private JButton ivjButtonNext;
    private JButton ivjButtonExit;
    private JLabel ivjBrandingGraphicLabel;
    private JLabel ivjLabelContactInfo;
    private JLabel ivjLabelPlease;
    private JLabel ivjLabelPlease2;
    private CustInfo m_pCust;
    private NameControl m_pNameControl;
    private AddrControl m_pAddrControl;
    private PhoneControl m_pPhoneControl;
    private JLabel ivjLabelJobTitle;
    private JTextField m_contactJobTitleControl;
    private JLabel ivjLabelCompany;
    private JTextField m_contactCompanyControl;
    private JLabel ivjLabelEmail;
    private JTextField m_contactEmailControl;
    private boolean NoEmailCheck;
    private JCheckBox m_contactCheckDataAuthControl;
    private JTextPane ivjJTextPaneDataAuthText;
    private boolean m_contactCheckDataAuth;
    private String m_contactJobTitle;
    private String m_contactEmail;
    private String m_contactCompany;
    protected Language m_hLanguage;
    protected boolean m_fixed = false;

    public Contact() {
        Object object;
        Dimension dimension = null;
        try {
            this.setName("Contact");
            this.setResizable(false);
            this.setDefaultCloseOperation(0);
            this.getContentPane().setLayout(null);
            this.getContentPane().setBackground(Color.lightGray);
            this.setTitle(SystemProductInfo.title);
            try {
                object = new MetalLookAndFeel();
                MetalLookAndFeel.setCurrentTheme(new BlueMetalTheme());
                UIManager.setLookAndFeel((LookAndFeel)object);
                UIManager.put("ToolTip.background", new Color(95, 127, 191));
            }
            catch (Exception exception) {
                System.out.println("Problem setting the Look and Feel!");
                exception.printStackTrace();
            }
            Bounds bounds = (Bounds)Language.rb.getObject(Integer.toString(2403));
            Point point = bounds.returnPoint();
            SystemProductInfo.Contact_xvalue = point.x;
            SystemProductInfo.Contact_yvalue = point.y;
            dimension = bounds.returnDimension();
            ((Component)this).setSize(dimension.width, dimension.height);
            this.getContentPane().setSize(dimension.width, dimension.height);
            if (SysInfo.getOSPlatform().equals("AIX") && Locale.getDefault().toString().equals("ko_KR")) {
                ((Component)this).setSize(dimension.width + 10, dimension.height);
                this.getContentPane().setSize(dimension.width + 10, dimension.height);
            }
        }
        catch (Throwable throwable) {
            System.out.println("Problem setting up the Contact screen!");
            throwable.printStackTrace();
        }
        this.m_hLanguage = Language.getDefaultLanguage();
        this.NoEmailCheck = false;
        object = CustInfo.getInstance();
        this.m_pCust = CustInfo.getInstance();
        this.m_pNameControl = new NameControl(this);
        this.m_pAddrControl = new AddrControl(this);
        this.m_pPhoneControl = new PhoneControl(this);
        if (Brand.getBrand().isConsumer()) {
            this.m_contactJobTitle = ((CustInfo)object).getSchoolLibrary();
            this.m_contactCompany = "";
        } else {
            this.m_contactJobTitle = ((CustInfo)object).getJobTitle();
            this.m_contactCompany = ((CustInfo)object).getCompany();
        }
        this.m_contactEmail = ((CustInfo)object).getEmail();
        this.m_contactCheckDataAuth = ((CustInfo)object).getCheckDataAuth();
        this.initialize(dimension);
        this.doDataExchange();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        ((Component)this).setCursor(new Cursor(3));
        if (actionEvent.getSource() == this.ivjButtonNext) {
            this.onContactNext();
        } else if (actionEvent.getSource() == this.ivjButtonExit) {
            this.onContactExit();
        } else if (actionEvent.getSource() == this.ivjButtonPrivacy) {
            this.onContactPrivacy();
        }
        ((Component)this).setCursor(new Cursor(0));
    }

    private void addButtons() {
        try {
            Rectangle rectangle = this.getBounds();
            this.ivjButtonExit = new JButton();
            this.ivjButtonExit.setName("ButtonExit");
            this.ivjButtonExit.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.ivjButtonExit.setBackground(Color.lightGray);
            this.ivjButtonExit.setMargin(new Insets(2, 9, 2, 9));
            this.ivjButtonNext = new JButton();
            this.ivjButtonNext.setName("ButtonNext");
            this.ivjButtonNext.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.ivjButtonNext.setBackground(Color.lightGray);
            this.ivjButtonNext.setMargin(new Insets(2, 9, 2, 9));
            this.ivjButtonBack = new JButton();
            this.ivjButtonBack.setName("ButtonBack");
            this.ivjButtonBack.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.ivjButtonBack.setBackground(Color.lightGray);
            this.ivjButtonBack.setEnabled(false);
            this.ivjButtonBack.setMargin(new Insets(2, 9, 2, 9));
            StrBounds strBounds = (StrBounds)Language.rb.getObject(Integer.toString(2242));
            String string = strBounds.returnString();
            StrBounds strBounds2 = (StrBounds)Language.rb.getObject(Integer.toString(2226));
            String string2 = strBounds2.returnString();
            StrBounds strBounds3 = (StrBounds)Language.rb.getObject(Integer.toString(2207));
            String string3 = strBounds3.returnString();
            Insets insets = this.ivjButtonExit.getInsets();
            Insets insets2 = this.ivjButtonNext.getInsets();
            Insets insets3 = this.ivjButtonBack.getInsets();
            Dimension dimension = Utility.determineTextDimensions(this.ivjButtonExit, string);
            Dimension dimension2 = Utility.determineTextDimensions(this.ivjButtonNext, string2);
            Dimension dimension3 = Utility.determineTextDimensions(this.ivjButtonBack, string3);
            int n = dimension.width + insets.left + insets.right;
            int n2 = dimension2.width + insets2.left + insets2.right;
            int n3 = dimension3.width + insets3.left + insets3.right;
            int n4 = Math.max(n, n2);
            n4 = Math.max(n3, n4);
            if (n4 < 60) {
                n4 = 60;
            }
            int n5 = dimension.height + insets.top + insets.bottom;
            int n6 = dimension2.height + insets2.top + insets2.bottom;
            int n7 = dimension3.height + insets3.top + insets3.bottom;
            int n8 = rectangle.height;
            n8 -= 20;
            int n9 = rectangle.width - 20;
            this.ivjButtonExit.setBounds(n9 -= n4, n8 -= n5, n4, n5);
            n9 -= 20;
            this.ivjButtonNext.setBounds(n9 -= n4, n8, n4, n6);
            this.ivjButtonBack.setBounds(n9 -= n4, n8, n4, n7);
            this.ivjButtonExit.setText(string);
            this.ivjButtonNext.setText(string2);
            this.ivjButtonBack.setText(string3);
            this.getContentPane().add((Component)this.ivjButtonExit, this.ivjButtonExit.getName());
            this.getContentPane().add((Component)this.ivjButtonNext, this.ivjButtonNext.getName());
            this.getContentPane().add((Component)this.ivjButtonBack, this.ivjButtonBack.getName());
        }
        catch (Throwable throwable) {
            System.out.println("Problem in Contact.addButtons()!");
            throwable.printStackTrace();
        }
    }

    private static String copyright() {
        return "\n\nLicensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1999, 2000. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    }

    private void doDataExchange() {
        this.m_pNameControl.doDataExchange();
        this.m_pAddrControl.doDataExchange();
        this.m_pPhoneControl.doDataExchange();
        this.m_contactJobTitleControl.setText(this.m_contactJobTitle);
        this.m_contactCompanyControl.setText(this.m_contactCompany);
        this.m_contactEmailControl.setText(this.m_contactEmail);
        boolean bl = this.m_pCust.getCheckDataAuth();
        this.m_contactCheckDataAuthControl.setSelected(bl);
        if (Brand.getBrand().isConsumer()) {
            this.m_contactCompanyControl.setVisible(false);
            this.ivjLabelCompany.setVisible(false);
            this.ivjLabelJobTitle.setText(Language.rb.getString(Integer.toString(322)));
            Rectangle rectangle = this.m_contactJobTitleControl.getBounds();
            Rectangle rectangle2 = this.m_contactCompanyControl.getBounds();
            int n = rectangle2.x - (rectangle.x + rectangle.width);
            this.m_contactJobTitleControl.setSize(rectangle.width + n + rectangle2.width, rectangle.height);
        }
    }

    private void initialize(Dimension dimension) {
        int n = 0;
        try {
            Object object;
            int n2;
            Dimension dimension2 = this.getSize();
            this.ivjLabelContactInfo = new JLabel();
            this.ivjLabelContactInfo.setName("ContactInfoLabel");
            if (Language.getDefaultLanguage().supportsBold()) {
                n = 1;
            }
            this.ivjLabelContactInfo.setFont(new Font(SystemProductInfo.type, n, SystemProductInfo.size));
            this.ivjLabelContactInfo.setBackground(Color.lightGray);
            this.ivjLabelContactInfo.setForeground(Color.black);
            this.ivjLabelPlease = new JLabel();
            this.ivjLabelPlease.setName("PleaseLabel");
            this.ivjLabelPlease.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.ivjLabelPlease.setBackground(Color.lightGray);
            this.ivjLabelPlease.setForeground(Color.black);
            this.ivjLabelPlease2 = new JLabel();
            this.ivjLabelPlease2.setName("Please2Label");
            this.ivjLabelPlease2.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.ivjLabelPlease2.setBackground(Color.lightGray);
            this.ivjLabelPlease2.setForeground(Color.black);
            this.ivjLabelCompany = new JLabel();
            this.ivjLabelCompany.setName("CompanyLabel");
            this.ivjLabelCompany.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.ivjLabelCompany.setBackground(Color.lightGray);
            this.ivjLabelCompany.setForeground(Color.black);
            this.m_contactCompanyControl = new JTextField();
            this.m_contactCompanyControl.setName("CompanyTextField");
            this.m_contactCompanyControl.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.m_contactCompanyControl.setColumns(50);
            this.ivjLabelJobTitle = new JLabel();
            this.ivjLabelJobTitle.setName("JobTitleLabel");
            this.ivjLabelJobTitle.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.ivjLabelJobTitle.setBackground(Color.lightGray);
            this.ivjLabelJobTitle.setForeground(Color.black);
            this.m_contactJobTitleControl = new JTextField();
            this.m_contactJobTitleControl.setName("JobTitleTextField");
            this.m_contactJobTitleControl.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.m_contactJobTitleControl.setColumns(30);
            this.ivjLabelEmail = new JLabel();
            this.ivjLabelEmail.setName("EmailLabel");
            this.ivjLabelEmail.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.ivjLabelEmail.setBackground(Color.lightGray);
            this.ivjLabelEmail.setForeground(Color.black);
            this.m_contactEmailControl = new JTextField();
            this.m_contactEmailControl.setName("EmailTextField");
            this.m_contactEmailControl.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.m_contactEmailControl.setColumns(60);
            this.m_contactCheckDataAuthControl = new JCheckBox();
            this.m_contactCheckDataAuthControl.setName("DataAuthCheckbox");
            this.m_contactCheckDataAuthControl.setSelected(true);
            this.ivjJTextPaneDataAuthText = new JTextPane();
            this.ivjJTextPaneDataAuthText.setName("DataAuthJTextPane");
            this.ivjJTextPaneDataAuthText.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.ivjJTextPaneDataAuthText.setBackground(Color.lightGray);
            this.ivjJTextPaneDataAuthText.setSelectionColor(SystemColor.control);
            this.ivjJTextPaneDataAuthText.setDisabledTextColor(Color.black);
            this.ivjJTextPaneDataAuthText.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 15));
            this.ivjJTextPaneDataAuthText.setEditable(false);
            this.ivjJTextPaneDataAuthText.setEnabled(false);
            this.ivjJTextPaneDataAuthText.setAutoscrolls(true);
            this.ivjButtonPrivacy = new JButton();
            this.ivjButtonPrivacy.setName("PrivacyButton");
            this.ivjButtonPrivacy.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.ivjButtonPrivacy.setBackground(Color.lightGray);
            this.ivjBrandingGraphicLabel = new JLabel();
            this.ivjBrandingGraphicLabel.setName("BrandGraphicLabel");
            StrBounds strBounds = (StrBounds)Language.rb.getObject(Integer.toString(2289));
            StrBounds strBounds2 = (StrBounds)Language.rb.getObject(Integer.toString(2290));
            StrBounds strBounds3 = (StrBounds)Language.rb.getObject(Integer.toString(2256));
            Bounds bounds = (Bounds)Language.rb.getObject(Integer.toString(2219));
            StrBounds strBounds4 = (StrBounds)Language.rb.getObject(Integer.toString(2255));
            Bounds bounds2 = (Bounds)Language.rb.getObject(Integer.toString(2220));
            StrBounds strBounds5 = (StrBounds)Language.rb.getObject(Integer.toString(2270));
            Bounds bounds3 = (Bounds)Language.rb.getObject(Integer.toString(2211));
            StrBounds strBounds6 = (StrBounds)Language.rb.getObject(Integer.toString(2334));
            StrBounds strBounds7 = (StrBounds)Language.rb.getObject(Integer.toString(2320));
            StrBounds strBounds8 = (StrBounds)Language.rb.getObject(Integer.toString(2334));
            String string = strBounds.returnString();
            String string2 = strBounds2.returnString();
            Insets insets = this.ivjButtonPrivacy.getInsets();
            Point point = strBounds3.returnPoint();
            Point point2 = bounds.returnPoint();
            Point point3 = strBounds4.returnPoint();
            Point point4 = bounds2.returnPoint();
            Point point5 = strBounds5.returnPoint();
            Point point6 = bounds3.returnPoint();
            Point point7 = strBounds7.returnPoint();
            Point point8 = strBounds6.returnPoint();
            Point point9 = strBounds8.returnPoint();
            Dimension dimension3 = Utility.determineTextDimensions(this.ivjLabelContactInfo, string);
            Dimension dimension4 = Utility.determineTextDimensions(this.ivjLabelPlease, string2);
            Dimension dimension5 = strBounds3.returnDimension();
            Dimension dimension6 = bounds.returnDimension();
            Dimension dimension7 = strBounds4.returnDimension();
            Dimension dimension8 = bounds2.returnDimension();
            Dimension dimension9 = strBounds5.returnDimension();
            Dimension dimension10 = bounds3.returnDimension();
            Dimension dimension11 = Utility.determineTextDimensions(this.ivjButtonPrivacy, strBounds7.returnString());
            int n3 = dimension3.width;
            int n4 = dimension4.width;
            int n5 = dimension.width - dimension3.width - 30;
            if (dimension4.width > n5) {
                n4 = n5;
            }
            if ((n2 = dimension11.width + insets.left + insets.right) < 60) {
                n2 = 60;
            }
            int n6 = dimension3.height;
            int n7 = dimension4.height;
            int n8 = dimension11.height + insets.top + insets.bottom;
            int n9 = 20;
            int n10 = 10;
            int n11 = 10;
            this.ivjLabelContactInfo.setBounds(n9, n10, n3, n6);
            this.ivjLabelPlease.setBounds(n9 + n3 + n11, n10, n4, n7);
            this.ivjLabelCompany.setBounds(point.x - SystemProductInfo.Contact_xvalue, point.y - (20 + SystemProductInfo.Contact_yvalue), dimension5.width, dimension5.height);
            this.m_contactCompanyControl.setBounds(point2.x - SystemProductInfo.Contact_xvalue, point2.y - (20 + SystemProductInfo.Contact_yvalue), dimension6.width, dimension6.height);
            this.ivjLabelJobTitle.setBounds(point3.x - SystemProductInfo.Contact_xvalue, point3.y - (20 + SystemProductInfo.Contact_yvalue), dimension7.width, dimension7.height);
            this.m_contactJobTitleControl.setBounds(point4.x - SystemProductInfo.Contact_xvalue, point4.y - (20 + SystemProductInfo.Contact_yvalue), dimension8.width, dimension8.height);
            this.ivjLabelEmail.setBounds(point5.x - SystemProductInfo.Contact_xvalue, point5.y - (20 + SystemProductInfo.Contact_yvalue), dimension9.width + 60, dimension9.height);
            this.m_contactEmailControl.setBounds(point6.x - SystemProductInfo.Contact_xvalue, point6.y - (20 + SystemProductInfo.Contact_yvalue), dimension10.width, dimension10.height);
            this.ivjButtonPrivacy.setBounds(this.getBounds().width - n2 - 20, point7.y - (20 + SystemProductInfo.Contact_yvalue), n2, n8);
            this.m_contactCheckDataAuthControl.setBounds(point8.x - SystemProductInfo.Contact_xvalue, point8.y - (20 + SystemProductInfo.Contact_yvalue), 15, 15);
            int n12 = point9.x - SystemProductInfo.Contact_xvalue + 20;
            int n13 = point9.y - (20 + SystemProductInfo.Contact_yvalue);
            int n14 = this.ivjButtonPrivacy.getX() - n12 - 20;
            int n15 = 40;
            this.ivjJTextPaneDataAuthText.setBounds(n12, n13, n14, n15);
            if (SysInfo.getOSPlatform().equals("AIX")) {
                if (Locale.getDefault().toString().equals("ko_KR")) {
                    n10 = 15;
                    this.ivjLabelContactInfo.setBounds(n9, n10, n3, n6 + 5);
                    this.ivjLabelPlease.setBounds(n9 + n3 + n11, n10, n4 + 10, n7 + 5);
                } else if (Locale.getDefault().toString().equals("zh_CN")) {
                    this.ivjLabelCompany.setBounds(point.x - SystemProductInfo.Contact_xvalue, point.y - (20 + SystemProductInfo.Contact_yvalue + 2), dimension5.width, dimension5.height + 2);
                    this.m_contactCompanyControl.setBounds(point2.x - SystemProductInfo.Contact_xvalue, point2.y - (20 + SystemProductInfo.Contact_yvalue), dimension6.width, dimension6.height + 5);
                    this.ivjLabelJobTitle.setBounds(point3.x - SystemProductInfo.Contact_xvalue, point3.y - (20 + SystemProductInfo.Contact_yvalue + 2), dimension7.width, dimension7.height + 2);
                    this.m_contactJobTitleControl.setBounds(point4.x - SystemProductInfo.Contact_xvalue, point4.y - (20 + SystemProductInfo.Contact_yvalue), dimension8.width, dimension8.height + 5);
                    this.ivjLabelEmail.setBounds(point5.x - SystemProductInfo.Contact_xvalue, point5.y - (20 + SystemProductInfo.Contact_yvalue + 2), dimension9.width + 60, dimension9.height + 2);
                    this.m_contactEmailControl.setBounds(point6.x - SystemProductInfo.Contact_xvalue, point6.y - (20 + SystemProductInfo.Contact_yvalue), dimension10.width, dimension10.height + 5);
                    this.ivjJTextPaneDataAuthText.setBounds(n12, n13, n14, n15 + 15);
                }
            }
            this.ivjLabelContactInfo.setText(string);
            this.ivjLabelPlease.setText(string2);
            this.ivjLabelCompany.setText(strBounds3.returnString());
            this.ivjLabelJobTitle.setText(strBounds4.returnString());
            this.ivjLabelEmail.setText(strBounds5.returnString());
            this.ivjButtonPrivacy.setText(strBounds7.returnString());
            this.ivjJTextPaneDataAuthText.setText(strBounds8.returnString());
            try {
                object = Brand.getBrand().getBrandStringLow();
                String string3 = String.valueOf(object) + "brand.gif";
                ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/com/ibm/lexington/prt/res/" + string3));
                this.ivjBrandingGraphicLabel.setIcon(imageIcon);
                this.ivjBrandingGraphicLabel.setBounds(0, dimension2.height - 80, imageIcon.getIconWidth(), imageIcon.getIconHeight());
            }
            catch (Exception exception) {
                System.out.println("Contact.initialize(): Could not load brand GIF.");
            }
            this.getContentPane().add((Component)this.ivjLabelContactInfo, this.ivjLabelContactInfo.getName());
            this.getContentPane().add((Component)this.ivjLabelPlease, this.ivjLabelPlease.getName());
            if (this.m_hLanguage.isJobTitleSupported()) {
                this.getContentPane().add((Component)this.ivjLabelJobTitle, this.ivjLabelJobTitle.getName());
                this.getContentPane().add((Component)this.m_contactJobTitleControl, this.m_contactJobTitleControl.getName());
            }
            if (this.m_hLanguage.isCompanySupported()) {
                this.getContentPane().add((Component)this.ivjLabelCompany, this.ivjLabelCompany.getName());
                this.getContentPane().add((Component)this.m_contactCompanyControl, this.m_contactCompanyControl.getName());
            }
            if (this.m_hLanguage.isEmailAddressSupported()) {
                this.getContentPane().add((Component)this.ivjLabelEmail, this.ivjLabelEmail.getName());
                this.getContentPane().add((Component)this.m_contactEmailControl, this.m_contactEmailControl.getName());
            }
            if (Brand.getBrand().isPrivacySupported()) {
                this.getContentPane().add((Component)this.ivjButtonPrivacy, this.ivjButtonPrivacy.getName());
                this.getContentPane().add((Component)this.m_contactCheckDataAuthControl, this.m_contactCheckDataAuthControl.getName());
                this.getContentPane().add((Component)this.ivjJTextPaneDataAuthText, this.ivjJTextPaneDataAuthText.getName());
            }
            this.getContentPane().add((Component)this.ivjBrandingGraphicLabel, this.ivjBrandingGraphicLabel.getName());
            this.addButtons();
            this.addWindowListener(this);
            this.ivjButtonNext.addActionListener(this);
            this.ivjButtonExit.addActionListener(this);
            this.ivjButtonPrivacy.addActionListener(this);
            this.m_contactCompanyControl.addKeyListener(this);
            this.m_contactJobTitleControl.addKeyListener(this);
            this.m_contactEmailControl.addKeyListener(this);
            this.getRootPane().setDefaultButton(this.ivjButtonNext);
            object = Toolkit.getDefaultToolkit().getScreenSize();
            int n16 = ((Dimension)object).height / 2 - dimension2.height / 2 - 5;
            int n17 = ((Dimension)object).width / 2 - dimension2.width / 2 - 5;
            ((Component)this).setLocation(n17, n16);
        }
        catch (Throwable throwable) {
            System.out.println("Problem in Contact.initialize()!");
            throwable.printStackTrace();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 16) {
            return;
        }
        if (keyEvent.getSource() == this.m_contactJobTitleControl) {
            this.onChangeEDITJobTitle();
        } else if (keyEvent.getSource() == this.m_contactCompanyControl) {
            this.onChangeEDITCompany();
        } else if (keyEvent.getSource() == this.m_contactEmailControl) {
            this.onChangeEDITEmail();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    protected void onChangeEDITCompany() {
        String string = this.m_contactCompanyControl.getText();
        if (Utility.validateString(string) != -1) {
            RegException regException = new RegException(217);
            regException.showMessage();
            if (this.m_contactCompanyControl.isVisible()) {
                this.m_contactCompanyControl.requestFocus();
            }
        }
    }

    protected void onChangeEDITEmail() {
        String string = this.m_contactEmailControl.getText();
        if (Utility.validateString(string) != -1) {
            RegException regException = new RegException(217);
            regException.showMessage();
            if (this.m_contactEmailControl.isVisible()) {
                this.m_contactEmailControl.requestFocus();
            }
        }
        this.NoEmailCheck = false;
    }

    protected void onChangeEDITJobTitle() {
        String string = this.m_contactJobTitleControl.getText();
        if (Utility.validateString(string) != -1) {
            RegException regException = new RegException(217);
            regException.showMessage();
            if (this.m_contactJobTitleControl.isVisible()) {
                this.m_contactJobTitleControl.requestFocus();
            }
        }
    }

    protected void onClose() {
        RegException regException = new RegException(2243);
        int n = regException.showMessage();
    }

    protected void onContactExit() {
        RegException regException = new RegException(2243);
        int n = regException.showMessage();
        if (n == 0) {
            System.exit(0);
        }
    }

    protected void onContactNext() {
        boolean bl = true;
        boolean bl2 = true;
        while (bl2) {
            bl2 = false;
            try {
                int n = this.m_pAddrControl.getCountryIdx();
                if (n == -1) {
                    throw new RegException(207, this.m_pAddrControl.getCountryComboControl());
                }
                Country country = Country.getCountry(n);
                country.validate(this.m_pNameControl);
                country.validate(this.m_pAddrControl);
                country.validate(this.m_pPhoneControl);
                String string = this.m_contactJobTitleControl.getText();
                if (Utility.validateString(string) != -1) {
                    throw new RegException(217, this.m_contactJobTitleControl);
                }
                String string2 = this.m_contactCompanyControl.getText();
                if (Utility.validateString(string2) != -1) {
                    throw new RegException(217, this.m_contactCompanyControl);
                }
                String string3 = this.m_contactEmailControl.getText();
                if (this.NoEmailCheck) continue;
                if (Utility.validateString(string3) != -1) {
                    throw new RegException(217, this.m_contactEmailControl);
                }
                if (Utility.validateIsWhiteSpace(string3) == 1) {
                    throw new RegException(213);
                }
                if (Utility.validateEmailString(string3)) continue;
                throw new RegException(216);
            }
            catch (RegException regException) {
                int n = regException.showMessage();
                bl2 = bl = this.setFieldFocus(regException.getMessageID(), n, regException.getBadControl());
            }
        }
        if (bl) {
            this.saveInfo();
            if (this.biosInfo == null) {
                this.biosInfo = new BiosInfo(this);
            }
            ((Component)this).setVisible(false);
            ((Component)this.biosInfo).setVisible(true);
        }
    }

    protected void onContactPrivacy() {
        PrivacyDialog privacyDialog = new PrivacyDialog(this);
        privacyDialog.show();
    }

    protected void saveInfo() {
        CustInfo custInfo = CustInfo.getInstance();
        this.m_pNameControl.saveInfo();
        this.m_pAddrControl.saveInfo();
        this.m_pPhoneControl.saveInfo();
        if (!Brand.getBrand().isConsumer()) {
            custInfo.setJobTitle(this.m_contactJobTitleControl.getText());
            custInfo.setCompany(this.m_contactCompanyControl.getText());
        } else {
            custInfo.setSchoolLibrary(this.m_contactJobTitleControl.getText());
            custInfo.setJobTitle("");
            custInfo.setCompany("");
        }
        custInfo.setEmail(this.m_contactEmailControl.getText());
        custInfo.setPurchaseLocation(Language.rb_comall.getString(Integer.toString(1057)));
        custInfo.setCheckDataAuth(this.m_contactCheckDataAuthControl.isSelected());
        custInfo.setBenefitsPreference(Language.rb_comall.getString(Integer.toString(1056)));
        custInfo.setResponseMedia(Language.rb_comall.getString(Integer.toString(1058)));
    }

    protected boolean setFieldFocus(int n, int n2, Component component) {
        boolean bl = false;
        switch (n) {
            case 1519: {
                this.m_pNameControl.setFieldFocus(n, n2);
                break;
            }
            case 201: {
                this.m_pNameControl.setFieldFocus(n, n2);
                break;
            }
            case 202: {
                this.m_pNameControl.setFieldFocus(n, n2);
                break;
            }
            case 1520: {
                this.m_pNameControl.setFieldFocus(n, n2);
                break;
            }
            case 208: {
                this.m_pPhoneControl.setFieldFocus(n, n2);
                break;
            }
            case 223: {
                if (n2 == 0) {
                    this.m_pPhoneControl.setFieldFocus(n, n2);
                    break;
                }
                bl = true;
                break;
            }
            case 1515: {
                bl = this.m_pPhoneControl.setFieldFocus(n, n2);
                break;
            }
            case 1517: {
                bl = this.m_pAddrControl.setFieldFocus(n, n2);
                break;
            }
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 222: 
            case 247: {
                bl = this.m_pAddrControl.setFieldFocus(n, n2);
                break;
            }
            case 1516: {
                bl = this.m_pAddrControl.setFieldFocus(n, n2);
                break;
            }
            case 224: 
            case 225: {
                bl = this.m_pAddrControl.setFieldFocus(n, n2);
                break;
            }
            case 217: 
            case 221: 
            case 246: {
                if (component == null || !component.isVisible()) break;
                component.requestFocus();
                break;
            }
            case 213: 
            case 216: {
                if (n2 == 0) {
                    if (!this.m_contactEmailControl.isVisible()) break;
                    this.m_contactEmailControl.requestFocus();
                    break;
                }
                bl = true;
                this.NoEmailCheck = true;
            }
        }
        return bl;
    }

    public void windowActivated(WindowEvent windowEvent) {
        RegException.setCurrentWindow(this);
        if (!this.m_fixed) {
            Insets insets = this.getInsets();
            if (SysInfo.getOSPlatform().equals("LINUX")) {
                System.out.println("Fixing LINUX Contact screen");
                Dimension dimension = this.getSize();
                dimension.height += insets.top;
                ((Component)this).setSize(dimension);
                this.getContentPane().setSize(dimension);
                dimension = this.getSize();
                Rectangle rectangle = this.ivjBrandingGraphicLabel.getBounds();
                rectangle.y = this.getSize().height - 57 - insets.top;
                this.ivjBrandingGraphicLabel.setBounds(rectangle);
                ((Component)this).setVisible(false);
                ((Component)this).setVisible(true);
            } else {
                System.out.println("Fixing non-LINUX Contact screen");
                Rectangle rectangle = this.ivjButtonNext.getBounds();
                rectangle.y -= insets.top;
                this.ivjButtonNext.setBounds(rectangle);
                rectangle = this.ivjButtonBack.getBounds();
                rectangle.y -= insets.top;
                this.ivjButtonBack.setBounds(rectangle);
                rectangle = this.ivjButtonExit.getBounds();
                rectangle.y -= insets.top;
                this.ivjButtonExit.setBounds(rectangle);
            }
            this.m_fixed = true;
        }
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

