/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lexington.prt;

import com.ibm.lexington.prt.AddrControl;
import com.ibm.lexington.prt.Belgium;
import com.ibm.lexington.prt.Brand;
import com.ibm.lexington.prt.Brazil;
import com.ibm.lexington.prt.Canada;
import com.ibm.lexington.prt.DualPhone;
import com.ibm.lexington.prt.Japan;
import com.ibm.lexington.prt.Language;
import com.ibm.lexington.prt.Name;
import com.ibm.lexington.prt.PhoneControl;
import com.ibm.lexington.prt.RegException;
import com.ibm.lexington.prt.Switzerland;
import com.ibm.lexington.prt.USA;
import com.ibm.lexington.prt.Utility;
import java.util.Locale;

public class Country {
    protected static final int _AL_ = 0;
    protected static final int _DZ_ = 1;
    protected static final int _AD_ = 2;
    protected static final int _AO_ = 3;
    protected static final int _AG_ = 4;
    protected static final int _AR_ = 5;
    protected static final int _AU_ = 6;
    protected static final int _AT_ = 7;
    protected static final int _AZ_ = 8;
    protected static final int _BS_ = 9;
    protected static final int _BH_ = 10;
    protected static final int _BD_ = 11;
    protected static final int _BB_ = 12;
    protected static final int _BY_ = 13;
    protected static final int _BE_ = 14;
    protected static final int _BZ_ = 15;
    protected static final int _BJ_ = 16;
    protected static final int _BM_ = 17;
    protected static final int _BO_ = 18;
    protected static final int _BA_ = 19;
    protected static final int _BW_ = 20;
    protected static final int _BR_ = 21;
    protected static final int _BN_ = 22;
    protected static final int _BG_ = 23;
    protected static final int _BF_ = 24;
    protected static final int _BI_ = 25;
    protected static final int _CM_ = 26;
    protected static final int _CA_ = 27;
    protected static final int _CV_ = 28;
    protected static final int _KY_ = 29;
    protected static final int _CF_ = 30;
    protected static final int _CD_ = 31;
    protected static final int _CL_ = 32;
    protected static final int _CN_ = 33;
    protected static final int _CO_ = 34;
    protected static final int _KM_ = 35;
    protected static final int _CG_ = 36;
    protected static final int _CR_ = 37;
    protected static final int _HR_ = 38;
    protected static final int _CY_ = 39;
    protected static final int _CZ_ = 40;
    protected static final int _DK_ = 41;
    protected static final int _DO_ = 42;
    protected static final int _EC_ = 43;
    protected static final int _EG_ = 44;
    protected static final int _SV_ = 45;
    protected static final int _GQ_ = 46;
    protected static final int _EE_ = 47;
    protected static final int _ET_ = 48;
    protected static final int _FJ_ = 49;
    protected static final int _FI_ = 50;
    protected static final int _FR_ = 51;
    protected static final int _GF_ = 52;
    protected static final int _PF_ = 53;
    protected static final int _GA_ = 54;
    protected static final int _GM_ = 55;
    protected static final int _GE_ = 56;
    protected static final int _GH_ = 57;
    protected static final int _GI_ = 58;
    protected static final int _GR_ = 59;
    protected static final int _GP_ = 60;
    protected static final int _GT_ = 61;
    protected static final int _GN_ = 62;
    protected static final int _GY_ = 63;
    protected static final int _HT_ = 64;
    protected static final int _HN_ = 65;
    protected static final int _HK_ = 66;
    protected static final int _HU_ = 67;
    protected static final int _IS_ = 68;
    protected static final int _IN_ = 69;
    protected static final int _ID_ = 70;
    protected static final int _IR_ = 71;
    protected static final int _IE_ = 72;
    protected static final int _IL_ = 73;
    protected static final int _IT_ = 74;
    protected static final int _JM_ = 75;
    protected static final int _JP_ = 76;
    protected static final int _JO_ = 77;
    protected static final int _KZ_ = 78;
    protected static final int _KE_ = 79;
    protected static final int _KW_ = 80;
    protected static final int _LV_ = 81;
    protected static final int _LB_ = 82;
    protected static final int _LS_ = 83;
    protected static final int _LR_ = 84;
    protected static final int _LI_ = 85;
    protected static final int _LT_ = 86;
    protected static final int _LU_ = 87;
    protected static final int _MO_ = 88;
    protected static final int _MK_ = 89;
    protected static final int _MG_ = 90;
    protected static final int _MW_ = 91;
    protected static final int _MY_ = 92;
    protected static final int _MV_ = 93;
    protected static final int _ML_ = 94;
    protected static final int _MT_ = 95;
    protected static final int _MQ_ = 96;
    protected static final int _MR_ = 97;
    protected static final int _MU_ = 98;
    protected static final int _YT_ = 99;
    protected static final int _MX_ = 100;
    protected static final int _MC_ = 101;
    protected static final int _MA_ = 102;
    protected static final int _MZ_ = 103;
    protected static final int _MN_ = 104;
    protected static final int _NL_ = 105;
    protected static final int _AN_ = 106;
    protected static final int _NC_ = 107;
    protected static final int _NZ_ = 108;
    protected static final int _NI_ = 109;
    protected static final int _NE_ = 110;
    protected static final int _NG_ = 111;
    protected static final int _NO_ = 112;
    protected static final int _OM_ = 113;
    protected static final int _PK_ = 114;
    protected static final int _PA_ = 115;
    protected static final int _PG_ = 116;
    protected static final int _PY_ = 117;
    protected static final int _PE_ = 118;
    protected static final int _PH_ = 119;
    protected static final int _PL_ = 120;
    protected static final int _PT_ = 121;
    protected static final int _QA_ = 122;
    protected static final int _RE_ = 123;
    protected static final int _RO_ = 124;
    protected static final int _RU_ = 125;
    protected static final int _RW_ = 126;
    protected static final int _ST_ = 127;
    protected static final int _SA_ = 128;
    protected static final int _SN_ = 129;
    protected static final int _SP_ = 130;
    protected static final int _SC_ = 131;
    protected static final int _SG_ = 132;
    protected static final int _SK_ = 133;
    protected static final int _SI_ = 134;
    protected static final int _ZA_ = 135;
    protected static final int _KR_ = 136;
    protected static final int _ES_ = 137;
    protected static final int _LK_ = 138;
    protected static final int _SD_ = 139;
    protected static final int _SR_ = 140;
    protected static final int _SZ_ = 141;
    protected static final int _SE_ = 142;
    protected static final int _CH_ = 143;
    protected static final int _SY_ = 144;
    protected static final int _TW_ = 145;
    protected static final int _TJ_ = 146;
    protected static final int _TZ_ = 147;
    protected static final int _TH_ = 148;
    protected static final int _TG_ = 149;
    protected static final int _TT_ = 150;
    protected static final int _TN_ = 151;
    protected static final int _TR_ = 152;
    protected static final int _TM_ = 153;
    protected static final int _UG_ = 154;
    protected static final int _UA_ = 155;
    protected static final int _AE_ = 156;
    protected static final int _GB_ = 157;
    protected static final int _US_ = 158;
    protected static final int _UY_ = 159;
    protected static final int _UZ_ = 160;
    protected static final int _VU_ = 161;
    protected static final int _VE_ = 162;
    protected static final int _VN_ = 163;
    protected static final int _WF_ = 164;
    protected static final int _YE_ = 165;
    protected static final int _ZR_ = 166;
    protected static final int _ZM_ = 167;
    protected static final int _ZW_ = 168;
    static final int NumberOfCountries = 169;
    private static Country m_defaultCountry;
    private int m_iCountryId;
    static final String BASE_ADDRESS_RESOURCE = "com.ibm.lexington.prt.res.reg_address";
    private static final int maxAddressLines = 7;
    private static final int DEFAULT = 1;
    private static final int COUNTRY = 0;
    private static final int MIN_PHONE = 1;
    protected static final int MIN_ZIP = 2;
    private static final int PHONE = 3;
    private static final int MODEM = 4;
    private static final int FAX = 5;
    private static final int FAX_SUPPORTED = 6;
    protected static final Object[][] validationArray;
    private static final int COUNTRY_CONST = 0;
    private static final int ADDRESS1 = 1;
    private static final int ADDRESS7 = 7;
    private static final int[][] addressArray;

    /*
     * Opcode count of 13359 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    static {
        validationArray = new Object[][]{{"AL", new Integer(1), new Integer(1), " 45 48101805", " 45 48101998", " 45 48101999", new Integer(0)}, {"DZ", new Integer(1), new Integer(1), " 00 45 48101805", " 00 45 48101998", " 00 45 48101999", new Integer(0)}, {"AD", new Integer(1), new Integer(1), " 45 48101805", " 45 48101998", " 45 48101999", new Integer(0)}, {"AO", new Integer(1), new Integer(1), " 45 48101805", " 45 48101998", " 45 48101999", new Integer(0)}, {"AG", new Integer(1), new Integer(1), "            ", "            ", "            ", new Integer(0)}, {"AR", new Integer(1), new Integer(1), "            ", " 17168715890", " 17168715866", new Integer(0)}, {"AU", new Integer(1), new Integer(1), "            ", "            ", "            ", new Integer(0)}, {"AT", new Integer(1), new Integer(-4), " (0660) 8711", " (0660) 8720", "(0800) 298712", new Integer(1)}, {"AZ", new Integer(1), new Integer(1), " 45 48101805", " 45 48101998", " 45 48101999", new Integer(0)}, {"BS", new Integer(1), new Integer(1), "            ", "            ", "            ", new Integer(0)}, {"BH", new Integer(1), new Integer(1), " 0 45 48101805", " 0 45 48101998", " 0 45 48101999", new Integer(0)}, {"BD", new Integer(1), new Integer(1), "            ", "            ", "            ", new Integer(0)}, {"BB", new Integer(1), new Integer(1), "            ", "            ", "            ", new Integer(0)}, {"BY", new Integer(1), new Integer(1), " 45 48101805", " 45 48101998", " 45 48101999", new Integer(0)}, {"BE", new Integer(1), new Integer(1), "   080071531", "   080071534", "0800-71 533", new Integer(1)}, {"BZ", new Integer(1), new Integer(1), "            ", " 17168715890", " 17168715866", new Integer(0)}, {"BJ", new Integer(1), new Integer(1), " 45 48101805", " 45 48101998", " 45 48101999", new Integer(0)}, {"BM", new Integer(1), new Integer(1), "            ", "            ", "            ", new Integer(0)}, {"BO", new Integer(1), new Integer(1), "            ", " 17168715890", " 17168715866", new Integer(0)}, {"BA", new Integer(1), new Integer(1), " 99 45 48101805", " 99 45 48101998", " 99 45 48101999", new Integer(0)}, {"BW", new Integer(1), new Integer(1), " 45 48101805", " 45 48101998", " 45 48101999", new Integer(0)}, {"BR", new Integer(10), new Integer(8), "            ", "  8145502680", "  8145502679", new Integer(0)}, {"BN", new Integer(1), new Integer(1), "            ", "            ", "            ", new Integer(0)}, {"BG", new Integer(1), new Integer(1), " 45 48101805", " 45 48101998", " 45 48101999", new Integer(0)}, {"BF", new Integer(1), new Integer(1), " 45 48101805", " 45 48101998", " 45 48101999", new Integer(0)}, {"BI", new Integer(1), new Integer(1), " 45 48101805", " 45 48101998", " 45 48101999", new Integer(0)}, {"CM", new Integer(1), new Integer(1), " 45 48101805", " 45 48101998", " 45 48101999", new Integer(0)}, {"CA", new Integer(10), new Integer(6), " 1-800-376-5120", " 1-800-469-9891", " 1-800-593-7316", new Integer(0)}, {"CV", new Integer(1), new Integer(1), " 45 48101805", " 45 48101998", " 45 48101999", new Integer(0)}, {"KY", new Integer(1), new Integer(1), "            ", "            ", "            ", new Integer(0)}, {"CF", new Integer(1), new Integer(1), " 45 48101805", " 45 48101998", " 45 48101999", new Integer(0)}, {"CD", new Integer(1), new Integer(1), " 45 48101805", " 45 48101998", " 45 48101999", new Integer(0)}, {"CL", new Integer(1), new Integer(1), "            ", " 17168715890", " 17168715866", new Integer(0)}, {"CN", new Integer(8), new Integer(-6), "            ", "            ", "            ", new Integer(0)}, {"CO", new Integer(1), new Integer(1), "            ", "   980153962", "   980153961", new Integer(0)}, {"KM", new Integer(1), new Integer(1), "            ", "            ", "            ", new Integer(0)}, {"CG", new Integer(1), new Integer(1), " 45 48101805", " 45 48101998", " 45 48101999", new Integer(0)}, {"CR", new Integer(1), new Integer(1), "            ", "  8000120506", "  8000120505", new Integer(0)}, {"HR", new Integer(1), new Integer(1), " 99 45 48101805", " 99 45 48101998", " 99 45 48101999", new Integer(0)}, {"CY", new Integer(1), new Integer(1), " 45 48101805", " 45 48101998", " 45 48101999", new Integer(0)}, {"CZ", new Integer(8), new Integer(5), " 00 45 48101805", " 00 45 48101998", " 00 45 48101999", new Integer(0)}, {"DK", new Integer(8), new Integer(4), "    80361010", "    80361212", "    80361111", new Integer(0)}, {"DO", new Integer(1), new Integer(1), "            ", " 18001560978", " 18001560977", new Integer(0)}, {"EC", new Integer(1), new Integer(1), "            ", " 17168715890", " 17168715866", new Integer(0)}, {"EG", new Integer(1), new Integer(1), " 00 45 48101805", " 00 45 48101998", " 00 45 48101999", new Integer(0)}, {"SV", new Integer(1), new Integer(1), "            ", "            ", "            ", new Integer(0)}, {"GQ", new Integer(1), new Integer(1), "            ", "            ", "            ", new Integer(0)}, {"EE", new Integer(1), new Integer(1), " 45 48101805", " 45 48101998", " 45 48101999", new Integer(0)}, {"ET", new Integer(1), new Integer(1), " 45 48101805", " 45 48101998", " 45 48101999", new Integer(0)}, {"FJ", new Integer(1), new Integer(1), "            ", "            ", "            ", new Integer(0)}, {"FI", new Integer(6), new Integer(-5), " 0800 114 560", " 0800 114 567", " 0800 114 562", new Integer(0)}, {"FR", new Integer(10), new Integer(-5), " (08) 00.90.52.68", " (08) 00.90.52.70", "08.00.90.52.69", new Integer(1)}, {"GF", new Integer(1), new Integer(1), "            ", "            ", "            ", new Integer(0)}, {"PF", new Integer(1), new Integer(1), "            ", "            ", "            ", new Integer(0)}, {"GA", new Integer(1), new Integer(1), " 45 48101805", " 45 48101998", " 45 48101999", new Integer(0)}, {"GM", new Integer(1), new Integer(1), " 45 48101805", " 45 48101998", " 45 48101999", new Integer(0)}, {"DE", new Integer(8), new Integer(5), " (0130) 82 44 57", " (0130) 82 44 59", "(0130) 82 44 58", new Integer(1)}, {"GH", new Integer(1), new Integer(1), " 45 48101805", " 45 48101998", " 45 48101999", new Integer(0)}, {"GI", new Integer(1), new Integer(1), " 45 48101805", " 45 48101998", " 45 48101999", new Integer(0)}, {"GR", new Integer(9), new Integer(-5), " 00 45 48101805", " 00 45 48101998", " 00 45 48101999", new Integer(0)}, {"GP", new Integer(1), new Integer(1), "            ", "            ", "            ", new Integer(0)}, {"GT", new Integer(1), new Integer(1), "            ", " 17168715890", " 17168715866", new Integer(0)}, {"GN", new Integer(1), new Integer(1), " 45 48101805", " 45 48101998", " 45 48101999", new Integer(0)}, {"GY", new Integer(1), new Integer(1), "            ", "            ", "            ", new Integer(0)}, {"HT", new Integer(1), new Integer(1), "            ", "            ", "            ", new Integer(0)}, {"HN", new Integer(1), new Integer(1), "            ", "            ", "            ", new Integer(0)}, {"HK", new Integer(1), new Integer(1), "            ", "            ", "            ", new Integer(0)}, {"HU", new Integer(10), new Integer(4), " 00-45-48-101-805", " 00-45-48-101-998", " 00-45-48-101-999", new Integer(0)}, {"IS", new Integer(1), new Integer(1), " 90 45 48101805", " 90 45 48101998", " 90 45 48101999", new Integer(0)}, {"IN", new Integer(1), new Integer(1), "            ", "            ", "            ", new Integer(0)}, {"ID", new Integer(1), new Integer(1), "            ", "            ", "            ", new Integer(0)}, {"IR", new Integer(1), new Integer(1), " 00 45 48101805", " 00 45 48101998", " 00 45 48101999", new Integer(0)}, {"IE", new Integer(1), new Integer(1), "  1800554504", "  1800554506", "  1800554505", new Integer(0)}, {"IL", new Integer(1), new Integer(1), " 00 45 48101805", " 00 45 48101998", " 00 45 48101999", new Integer(0)}, {"IT", new Integer(7), new Integer(5), " 800-876378", " 800-876398", "800-876388", new Integer(1)}, {"JM", new Integer(1), new Integer(1), "            ", "            ", "            ", new Integer(0)}, {"JP", new Integer(10), new Integer(7), " 0120-770376", " 0120-770393", " 0120-770397", new Integer(0)}, {"JO", new Integer(1), new Integer(1), " 45 48101805", " 45 48101998", " 45 48101999", new Integer(0)}, {"KZ", new Integer(1), new Integer(1), " 45 48101805", " 45 48101998", " 45 48101999", new Integer(0)}, {"KE", new Integer(1), new Integer(1), " 45 48101805", " 45 48101998", " 45 48101999", new Integer(0)}, {"KW", new Integer(1), new Integer(1), " 45 48101805", " 45 48101998", " 45 48101999", new Integer(0)}, {"LV", new Integer(1), new Integer(1), " 45 48101805", " 45 48101998", " 45 48101999", new Integer(0)}, {"LB", new Integer(1), new Integer(1), " 45 48101805", " 45 48101998", " 45 48101999", new Integer(0)}, {"LS", new Integer(1), new Integer(1), " 45 48101805", " 45 48101998", " 45 48101999", new Integer(0)}, {"LR", new Integer(1), new Integer(1), " 45 48101805", " 45 48101998", " 45 48101999", new Integer(0)}, {"LI", new Integer(1), new Integer(1), " 00 45 48101805", " 00 45 48101998", " 00 45 48101999", new Integer(0)}, {"LT", new Integer(1), new Integer(1), " 45 48101805", " 45 48101998", " 45 48101999", new Integer(0)}, {"LU", new Integer(1), new Integer(1), " 00 45 48101805", " 00 45 48101998", " 00 45 48101999", new Integer(0)}, {"MO", new Integer(1), new Integer(1), "            ", "            ", "            ", new Integer(0)}, {"MK", new Integer(1), new Integer(1), " 99 45 48101805", " 99 45 48101998", " 99 45 48101999", new Integer(0)}, {"MG", new Integer(1), new Integer(1), " 45 48101805", " 45 48101998", " 45 48101999", new Integer(0)}, {"MW", new Integer(1), new Integer(1), " 45 48101805", " 45 48101998", " 45 48101999", new Integer(0)}, {"MY", new Integer(1), new Integer(1), "            ", "            ", "            ", new Integer(0)}, {"MV", new Integer(1), new Integer(1), "            ", "            ", "            ", new Integer(0)}, {"ML", new Integer(1), new Integer(1), " 45 48101805", " 45 48101998", " 45 48101999", new Integer(0)}, {"MT", new Integer(1), new Integer(1), " 45 48101805", " 45 48101998", " 45 48101999", new Integer(0)}, {"MQ", new Integer(1), new Integer(1), "            ", "            ", "            ", new Integer(0)}, {"MR", new Integer(1), new Integer(1), " 45 48101805", " 45 48101998", " 45 48101999", new Integer(0)}, {"MU", new Integer(1), new Integer(1), " 45 48101805", " 45 48101998", " 45 48101999", new Integer(0)}, {"YT", new Integer(1), new Integer(1), "            ", "            ", "            ", new Integer(0)}, {"MX", new Integer(1), new Integer(1), "            ", "958005628652", "958005628587", new Integer(0)}, {"MC", new Integer(1), new Integer(1), "   800905268", "   800905270", "   800905269", new Integer(0)}, {"MA", new Integer(1), new Integer(1), " 00 45 48101805", " 00 45 48101998", " 00 45 48101999", new Integer(0)}, {"MZ", new Integer(1), new Integer(1), " 45 48101805", " 45 48101998", " 45 48101999", new Integer(0)}, {"MN", new Integer(1), new Integer(1), "            ", "            ", "            ", new Integer(0)}, {"NL", new Integer(10), new Integer(6), " 0800-0223167", " 0800-0223016", " 0800-0222984", new Integer(0)}, {"AN", new Integer(1), new Integer(1), "            ", "            ", "            ", new Integer(0)}, {"NC", new Integer(1), new Integer(1), "            ", "            ", "            ", new Integer(0)}, {"NZ", new Integer(1), new Integer(1), "            ", "            ", "            ", new Integer(0)}, {"NI", new Integer(1), new Integer(1), "            ", " 18002201001", " 18002201000", new Integer(0)}, {"NE", new Integer(1), new Integer(1), " 45 48101805", " 45 48101998", " 45 48101999", new Integer(0)}, {"NG", new Integer(1), new Integer(1), " 45 48101805", " 45 48101998", " 45 48101999", new Integer(0)}, {"NO", new Integer(8), new Integer(4), "  800 10 081", "  800 10 083", "  800 10 082", new Integer(0)}, {"OM", new Integer(1), new Integer(1), " 45 48101805", " 45 48101998", " 45 48101999", new Integer(0)}, {"PK", new Integer(1), new Integer(1), " 45 48101805", " 45 48101998", " 45 48101999", new Integer(0)}, {"PA", new Integer(1), new Integer(1), "            ", "            ", "            ", new Integer(0)}, {"PG", new Integer(1), new Integer(1), "            ", "            ", "            ", new Integer(0)}, {"PY", new Integer(1), new Integer(1), "            ", "            ", "            ", new Integer(0)}, {"PE", new Integer(1), new Integer(1), "            ", " 17168715890", " 17168715866", new Integer(0)}, {"PH", new Integer(1), new Integer(1), "            ", "            ", "            ", new Integer(0)}, {"PL", new Integer(9), new Integer(-5), " 00 45 48 101 805", " 00 45 48 101 998", " 00 45 48 101 999", new Integer(0)}, {"PT", new Integer(8), new Integer(4), "  0800 845937", "  0800 845939", "  505 459938", new Integer(0)}, {"QA", new Integer(1), new Integer(1), " 45 48101805", " 45 48101998", " 45 48101999", new Integer(0)}, {"RE", new Integer(1), new Integer(1), " 45 48101805", " 45 48101998", " 45 48101999", new Integer(0)}, {"RO", new Integer(1), new Integer(1), " 00 45 48101805", " 00 45 48101998", " 00 45 48101999", new Integer(0)}, {"RU", new Integer(6), new Integer(6), " 8-10 45 48101805", " 8-10 45 48101998", " 8-10 45 48101999", new Integer(0)}, {"RW", new Integer(1), new Integer(1), " 45 48101805", " 45 48101998", " 45 48101999", new Integer(0)}, {"ST", new Integer(1), new Integer(1), " 45 48101805", " 45 48101998", " 45 48101999", new Integer(0)}, {"SA", new Integer(1), new Integer(1), " 45 48101805", " 45 48101998", " 45 48101999", new Integer(0)}, {"SN", new Integer(1), new Integer(1), "            ", "            ", "            ", new Integer(0)}, {"SP", new Integer(1), new Integer(1), " 99 45 48101805", " 99 45 48101998", " 99 45 48101999", new Integer(0)}, {"SC", new Integer(1), new Integer(1), " 45 48101805", " 45 48101998", " 45 48101999", new Integer(0)}, {"SG", new Integer(1), new Integer(1), "            ", "            ", "            ", new Integer(0)}, {"SK", new Integer(1), new Integer(1), " 00 45 48101805", " 00 45 48101998", " 00 45 48101999", new Integer(0)}, {"SI", new Integer(1), new Integer(1), " 99 45 48101805", " 99 45 48101998", " 99 45 48101999", new Integer(0)}, {"ZA", new Integer(1), new Integer(1), " 45 48101805", " 45 48101999", " 45 48101999", new Integer(0)}, {"KR", new Integer(9), new Integer(6), "            ", "            ", "            ", new Integer(0)}, {"ES", new Integer(9), new Integer(5), " 900 994 545", " 900 994 565", "900 994 550", new Integer(1)}, {"LK", new Integer(1), new Integer(1), "            ", "            ", "            ", new Integer(0)}, {"SD", new Integer(1), new Integer(1), " 45 48101805", " 45 48101998", " 45 48101999", new Integer(0)}, {"SR", new Integer(1), new Integer(1), " 45 48101805", " 45 48101998", " 45 48101999", new Integer(0)}, {"SZ", new Integer(1), new Integer(1), " 45 48101805", " 45 48101998", " 45 48101999", new Integer(0)}, {"SE", new Integer(7), new Integer(5), " 020-79 58 10", " 020-79 58 12", " 020-79 58 11", new Integer(0)}, {"CH", new Integer(1), new Integer(-4), " (0800) 55 59 05", " (0800) 55 59 01", "0800 55 59 02", new Integer(1)}, {"SY", new Integer(1), new Integer(1), " 45 48101805", " 45 48101998", " 45 48101999", new Integer(0)}, {"TW", new Integer(9), new Integer(3), "            ", "            ", "            ", new Integer(0)}, {"TJ", new Integer(1), new Integer(1), " 45 48101805", " 45 48101998", " 45 48101999", new Integer(0)}, {"TZ", new Integer(1), new Integer(1), " 45 48101805", " 45 48101998", " 45 48101999", new Integer(0)}, {"TH", new Integer(9), new Integer(5), "            ", "            ", "            ", new Integer(0)}, {"TG", new Integer(1), new Integer(1), " 45 48101805", " 45 48101998", " 45 48101999", new Integer(0)}, {"TT", new Integer(1), new Integer(1), "            ", "            ", "            ", new Integer(0)}, {"TN", new Integer(1), new Integer(1), " 45 48101805", " 45 48101998", " 45 48101999", new Integer(0)}, {"TR", new Integer(10), new Integer(5), " (00 45) 4810 1805", " (99 45) 4810 1998", " (99 45) 4810 1999", new Integer(0)}, {"TM", new Integer(1), new Integer(1), " 45 48101805", " 45 48101998", " 45 48101999", new Integer(0)}, {"UG", new Integer(1), new Integer(1), " 45 48101805", " 45 48101998", " 45 48101999", new Integer(0)}, {"UA", new Integer(1), new Integer(1), " 45 48101805", " 45 48101998", " 45 48101999", new Integer(0)}, {"AE", new Integer(1), new Integer(1), " 00 45 48101805", " 00 45 48101998", " 00 45 48101999", new Integer(0)}, {"GB", new Integer(1), new Integer(1), "  0800893771", "  0800893588", "0800-893693", new Integer(1)}, {"US", new Integer(10), new Integer(1), " 1-800-376-5120", " 1-800-469-9891", " 1-800-346-6410", new Integer(0)}, {"UY", new Integer(1), new Integer(1), "            ", "  4135982086", "   4135982085", new Integer(0)}, {"UZ", new Integer(1), new Integer(1), " 45 48101805", " 45 48101998", " 45 48101999", new Integer(0)}, {"VU", new Integer(1), new Integer(1), "            ", "            ", "            ", new Integer(0)}, {"VE", new Integer(1), new Integer(1), "            ", "    80012872", "  4135982085", new Integer(0)}, {"VN", new Integer(1), new Integer(1), "            ", "            ", "            ", new Integer(0)}, {"WF", new Integer(1), new Integer(1), "            ", "            ", "            ", new Integer(0)}, {"YE", new Integer(1), new Integer(1), " 45 48101805", " 45 48101999", " 45 48101999", new Integer(0)}, {"ZR", new Integer(1), new Integer(1), " 45 48101805", " 45 48101999", " 45 48101999", new Integer(0)}, {"ZM", new Integer(1), new Integer(1), " 45 48101805", " 45 48101999", " 45 48101999", new Integer(0)}, {"ZW", new Integer(1), new Integer(1), " 45 48101805", " 45 48101999", " 45 48101999", new Integer(0)}};
        addressArray = new int[][]{{1200, 1605, 1606, 1607, 1608, 0, 0, 0}, {1201, 1605, 1606, 1607, 1608, 0, 0, 0}, {1202, 1605, 1606, 1607, 1608, 0, 0, 0}, {1203, 1605, 1606, 1607, 1608, 0, 0, 0}, {1204, 1600, 1601, 1602, 1603, 0, 0, 0}, {1205, 1615, 1616, 1617, 1618, 1619, 1620, 0}, {1206, 1622, 1623, 1624, 1625, 0, 0, 0}, {1207, 1605, 1606, 1607, 1608, 0, 0, 0}, {1208, 1605, 1606, 1607, 1608, 0, 0, 0}, {1209, 1600, 1601, 1602, 1603, 1604, 0, 0}, {1210, 1605, 1606, 1607, 1608, 0, 0, 0}, {1211, 1610, 1611, 1612, 1613, 1614, 0, 0}, {1212, 1600, 1601, 1602, 1603, 1604, 0, 0}, {1213, 1605, 1606, 1607, 1608, 0, 0, 0}, {1214, 1605, 1606, 1607, 1608, 0, 0, 0}, {1215, 1643, 1644, 1645, 1646, 1647, 1648, 0}, {1216, 1605, 1606, 1607, 1608, 0, 0, 0}, {1217, 1600, 1601, 1602, 1603, 1604, 0, 0}, {1218, 1629, 1630, 1631, 1632, 1633, 0, 0}, {1219, 1605, 1606, 1607, 1608, 0, 0, 0}, {1220, 1605, 1606, 1607, 1608, 0, 0, 0}, {1221, 1636, 1637, 1638, 1639, 1640, 1641, 0}, {1222, 1610, 1611, 1612, 1613, 1614, 0, 0}, {1223, 1605, 1606, 1607, 1608, 0, 0, 0}, {1224, 1605, 1606, 1607, 1608, 0, 0, 0}, {1225, 1605, 1606, 1607, 1608, 0, 0, 0}, {1226, 1605, 1606, 1607, 1608, 0, 0, 0}, {1227, 1600, 1601, 1602, 1603, 1604, 0, 0}, {1228, 1605, 1606, 1607, 1608, 0, 0, 0}, {1229, 1600, 1601, 1602, 1603, 1604, 0, 0}, {1230, 1605, 1606, 1607, 1608, 0, 0, 0}, {1231, 1605, 1606, 1607, 1608, 0, 0, 0}, {1232, 1650, 1651, 1652, 1653, 1654, 1655, 0}, {1233, 1657, 1658, 1659, 1660, 1661, 0, 0}, {1234, 1664, 1665, 1666, 1667, 1668, 0, 0}, {1235, 1605, 1606, 1607, 1608, 0, 0, 0}, {1236, 1605, 1606, 1607, 1608, 0, 0, 0}, {1237, 1671, 1672, 1673, 1674, 1675, 0, 0}, {1238, 1605, 1606, 1607, 1608, 0, 0, 0}, {1239, 1605, 1606, 1607, 1608, 0, 0, 0}, {1240, 1605, 1606, 1607, 1608, 0, 0, 0}, {1241, 1605, 1606, 1607, 1608, 0, 0, 0}, {1242, 1678, 1679, 1680, 1681, 1682, 1683, 0}, {1243, 1685, 1686, 1687, 1688, 1689, 1690, 0}, {1244, 1605, 1606, 1607, 1608, 0, 0, 0}, {1245, 1811, 1812, 1813, 1814, 1815, 1816, 0}, {1246, 1605, 1606, 1607, 1608, 0, 0, 0}, {1247, 1605, 1606, 1607, 1608, 0, 0, 0}, {1248, 1605, 1606, 1607, 1608, 0, 0, 0}, {1249, 1692, 1693, 1694, 1695, 1696, 0, 0}, {1250, 1605, 1606, 1607, 1608, 0, 0, 0}, {1251, 1605, 1606, 1607, 1608, 0, 0, 0}, {1252, 1605, 1606, 1607, 1608, 0, 0, 0}, {1253, 1605, 1606, 1607, 1608, 0, 0, 0}, {1254, 1605, 1606, 1607, 1608, 0, 0, 0}, {1255, 1605, 1606, 1607, 1608, 0, 0, 0}, {1256, 1605, 1606, 1607, 1608, 0, 0, 0}, {1257, 1605, 1606, 1607, 1608, 0, 0, 0}, {1258, 1605, 1606, 1607, 1608, 0, 0, 0}, {1259, 1605, 1606, 1607, 1608, 0, 0, 0}, {1260, 1605, 1606, 1607, 1608, 0, 0, 0}, {1261, 1699, 1700, 1701, 1702, 1703, 1704, 0}, {1262, 1605, 1606, 1607, 1608, 0, 0, 0}, {1263, 1600, 1601, 1602, 1603, 1604, 0, 0}, {1264, 1720, 1721, 1722, 1723, 1724, 1725, 0}, {1265, 1713, 1714, 1715, 1716, 1717, 1718, 0}, {1266, 1706, 1707, 1708, 1709, 1710, 1711, 0}, {1267, 1605, 1606, 1607, 1608, 0, 0, 0}, {1268, 1605, 1606, 1607, 1608, 0, 0, 0}, {1269, 1610, 1611, 1612, 1613, 1614, 0, 0}, {1270, 1727, 1728, 1729, 1730, 1731, 1732, 0}, {1271, 1605, 1606, 1607, 1608, 0, 0, 0}, {1272, 1605, 1606, 1607, 1608, 0, 0, 0}, {1273, 1605, 1606, 1607, 1608, 0, 0, 0}, {1274, 1605, 1606, 1607, 1608, 0, 0, 0}, {1275, 1600, 1601, 1602, 1603, 1604, 0, 0}, {1276, 1734, 1735, 1736, 1737, 1738, 0, 0}, {1277, 1605, 1606, 1607, 1608, 0, 0, 0}, {1278, 1605, 1606, 1607, 1608, 0, 0, 0}, {1279, 1605, 1606, 1607, 1608, 0, 0, 0}, {1280, 1605, 1606, 1607, 1608, 0, 0, 0}, {1281, 1605, 1606, 1607, 1608, 0, 0, 0}, {1282, 1605, 1606, 1607, 1608, 0, 0, 0}, {1283, 1605, 1606, 1607, 1608, 0, 0, 0}, {1284, 1605, 1606, 1607, 1608, 0, 0, 0}, {1285, 1605, 1606, 1607, 1608, 0, 0, 0}, {1286, 1605, 1606, 1607, 1608, 0, 0, 0}, {1287, 1605, 1606, 1607, 1608, 0, 0, 0}, {1288, 1610, 1611, 1612, 1613, 1614, 0, 0}, {1289, 1605, 1606, 1607, 1608, 0, 0, 0}, {1290, 1605, 1606, 1607, 1608, 0, 0, 0}, {1291, 1605, 1606, 1607, 1608, 0, 0, 0}, {1292, 1755, 1756, 1757, 1758, 1759, 1760, 0}, {1293, 1610, 1611, 1612, 1613, 1614, 0, 0}, {1294, 1605, 1606, 1607, 1608, 0, 0, 0}, {1295, 1605, 1606, 1607, 1608, 0, 0, 0}, {1296, 1605, 1606, 1607, 1608, 0, 0, 0}, {1297, 1605, 1606, 1607, 1608, 0, 0, 0}, {1298, 1605, 1606, 1607, 1608, 0, 0, 0}, {1299, 1605, 1606, 1607, 1608, 0, 0, 0}, {1300, 1748, 1749, 1750, 1751, 1752, 1753, 0}, {1301, 1605, 1606, 1607, 1608, 0, 0, 0}, {1302, 1605, 1606, 1607, 1608, 0, 0, 0}, {1303, 1605, 1606, 1607, 1608, 0, 0, 0}, {1304, 1610, 1611, 1612, 1613, 1614, 0, 0}, {1305, 1605, 1606, 1607, 1608, 0, 0, 0}, {1306, 1600, 1601, 1602, 1603, 1604, 0, 0}, {1307, 1605, 1606, 1607, 1608, 0, 0, 0}, {1308, 1769, 1770, 1771, 1772, 1773, 0, 0}, {1309, 1762, 1763, 1764, 1765, 1766, 1767, 0}, {1310, 1605, 1606, 1607, 1608, 0, 0, 0}, {1311, 1605, 1606, 1607, 1608, 0, 0, 0}, {1312, 1605, 1606, 1607, 1608, 0, 0, 0}, {1313, 1605, 1606, 1607, 1608, 0, 0, 0}, {1314, 1605, 1606, 1607, 1608, 0, 0, 0}, {1315, 1776, 1777, 1778, 1779, 1780, 0, 0}, {1316, 1610, 1611, 1612, 1613, 1614, 0, 0}, {1317, 1797, 1798, 1799, 1800, 1801, 1802, 0}, {1318, 1783, 1784, 1785, 1786, 1787, 0, 0}, {1319, 1790, 1791, 1792, 1793, 1794, 1795, 0}, {1320, 1605, 1606, 1607, 1608, 0, 0, 0}, {1321, 1605, 1606, 1607, 1608, 0, 0, 0}, {1322, 1605, 1606, 1607, 1608, 0, 0, 0}, {1323, 1605, 1606, 1607, 1608, 0, 0, 0}, {1324, 1605, 1606, 1607, 1608, 0, 0, 0}, {1325, 1605, 1606, 1607, 1608, 0, 0, 0}, {1326, 1605, 1606, 1607, 1608, 0, 0, 0}, {1327, 1605, 1606, 1607, 1608, 0, 0, 0}, {1328, 1605, 1606, 1607, 1608, 0, 0, 0}, {1329, 1605, 1606, 1607, 1608, 0, 0, 0}, {1330, 1605, 1606, 1607, 1608, 0, 0, 0}, {1331, 1605, 1606, 1607, 1608, 0, 0, 0}, {1332, 1804, 1805, 1806, 1807, 1808, 0, 0}, {1333, 1605, 1606, 1607, 1608, 0, 0, 0}, {1334, 1605, 1606, 1607, 1608, 0, 0, 0}, {1335, 1605, 1606, 1607, 1608, 0, 0, 0}, {1336, 1741, 1742, 1743, 1744, 1745, 1746, 0}, {1337, 1605, 1606, 1607, 1608, 0, 0, 0}, {1338, 1610, 1611, 1612, 1613, 1614, 0, 0}, {1339, 1605, 1606, 1607, 1608, 0, 0, 0}, {1340, 1600, 1601, 1602, 1603, 1604, 0, 0}, {1341, 1605, 1606, 1607, 1608, 0, 0, 0}, {1342, 1605, 1606, 1607, 1608, 0, 0, 0}, {1343, 1605, 1606, 1607, 1608, 0, 0, 0}, {1344, 1605, 1606, 1607, 1608, 0, 0, 0}, {1345, 1818, 1819, 1820, 1821, 0, 0, 0}, {1346, 1605, 1606, 1607, 1608, 0, 0, 0}, {1347, 1605, 1606, 1607, 1608, 0, 0, 0}, {1348, 1610, 1611, 1612, 1613, 1614, 0, 0}, {1349, 1605, 1606, 1607, 1608, 0, 0, 0}, {1350, 1600, 1601, 1602, 1603, 1604, 0, 0}, {1351, 1605, 1606, 1607, 1608, 0, 0, 0}, {1352, 1605, 1606, 1607, 1608, 0, 0, 0}, {1353, 1605, 1606, 1607, 1608, 0, 0, 0}, {1354, 1605, 1606, 1607, 1608, 0, 0, 0}, {1355, 1605, 1606, 1607, 1608, 0, 0, 0}, {1356, 1605, 1606, 1607, 1608, 0, 0, 0}, {1357, 1605, 1606, 1607, 1608, 0, 0, 0}, {1358, 1825, 1826, 1827, 1828, 1829, 0, 0}, {1359, 1600, 1601, 1602, 1603, 1604, 0, 0}, {1360, 1605, 1606, 1607, 1608, 0, 0, 0}, {1361, 1605, 1606, 1607, 1608, 0, 0, 0}, {1362, 1832, 1833, 1834, 1835, 1836, 1837, 0}, {1363, 1610, 1611, 1612, 1613, 1614, 0, 0}, {1364, 1605, 1606, 1607, 1608, 0, 0, 0}, {1365, 1605, 1606, 1607, 1608, 0, 0, 0}, {1366, 1605, 1606, 1607, 1608, 0, 0, 0}, {1367, 1605, 1606, 1607, 1608, 0, 0, 0}, {1368, 1605, 1606, 1607, 1608, 0, 0, 0}};
    }

    public Country(int n) {
        this.m_iCountryId = n;
    }

    private static String copyright() {
        return "\n\nLicensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1999, 2000. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    }

    public int countryId() {
        return this.m_iCountryId;
    }

    public int getAddressLength() {
        int n = 0;
        int n2 = 1;
        while (n2 <= 7) {
            if (addressArray[this.m_iCountryId][n2] != 0) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public static Country getCountry(int n) {
        Country country;
        if (m_defaultCountry != null && m_defaultCountry.countryId() == n) {
            return m_defaultCountry;
        }
        switch (n) {
            case 7: 
            case 41: 
            case 50: 
            case 51: 
            case 56: 
            case 72: 
            case 74: 
            case 112: 
            case 121: 
            case 137: 
            case 142: 
            case 157: {
                country = new DualPhone(n);
                break;
            }
            case 158: {
                country = new USA();
                break;
            }
            case 143: {
                country = new Switzerland();
                break;
            }
            case 14: {
                country = new Belgium();
                break;
            }
            case 27: {
                country = new Canada();
                break;
            }
            case 76: {
                country = new Japan();
                break;
            }
            case 21: {
                country = new Brazil();
                break;
            }
            default: {
                country = new Country(n);
            }
        }
        return country;
    }

    public static int getCountryCode(int n) {
        return addressArray[n][0];
    }

    public static Country getDefaultCountry() {
        if (m_defaultCountry == null) {
            int n = -1;
            String string = Locale.getDefault().getCountry();
            int n2 = 0;
            while (n2 < 169) {
                if (validationArray[n2][0].equals(string)) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            if (n == -1) {
                n = 158;
            }
            m_defaultCountry = Country.getCountry(n);
        }
        return m_defaultCountry;
    }

    public String getFaxPhone() {
        return (String)validationArray[this.m_iCountryId][5];
    }

    public String getModemPhone() {
        return (String)validationArray[this.m_iCountryId][4];
    }

    public static String getPostString(int n) {
        return (String)validationArray[n][0];
    }

    public String getStatePostString(int n) {
        return "XX";
    }

    public String getStateProv(int n) {
        return "";
    }

    public String getStringFromId(int n) {
        return Language.rb.getString(Integer.toString(addressArray[n][0]));
    }

    public String getVoicePhone() {
        return (String)validationArray[this.m_iCountryId][3];
    }

    public int isFaxSupported() {
        return (Integer)validationArray[this.m_iCountryId][6];
    }

    public String loadAddressString(int n) {
        return Language.rb_address.getString(Integer.toString(addressArray[this.m_iCountryId][n + 1]));
    }

    public int numberOfStateOrProvs() {
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void validate(AddrControl addrControl) throws RegException {
        String string;
        Language language = Language.getDefaultLanguage();
        Brand brand = Brand.getBrand();
        if (language.isPOBoxSupported()) {
            string = addrControl.getPOBox();
            if (Utility.validateIsWhiteSpace(string) == 1) {
                if (!language.isStreetAddressSupported()) throw new RegException(203);
                string = addrControl.getStreet();
                if (Utility.validateIsWhiteSpace(string) == 1 && brand.isPOBoxOrStreetRequired()) {
                    throw new RegException(203);
                }
                if (!Utility.validateHasCharsString(string)) {
                    throw new RegException(222);
                }
                if (Utility.validateString(string) != -1) {
                    throw new RegException(217, addrControl.getStreetEditControl());
                }
            } else {
                if (!Utility.validateHasCharsString(string)) {
                    throw new RegException(247);
                }
                if (Utility.validateString(string) != -1) {
                    throw new RegException(217, addrControl.getPOBoxEditControl());
                }
                if (language.isStreetAddressSupported() && Utility.validateIsWhiteSpace(string = addrControl.getStreet()) == -1) {
                    if (!Utility.validateHasCharsString(string)) {
                        throw new RegException(222);
                    }
                    if (Utility.validateString(string) != -1) {
                        throw new RegException(217, addrControl.getStreetEditControl());
                    }
                }
            }
        } else if (language.isStreetAddressSupported()) {
            string = addrControl.getStreet();
            if (Utility.validateIsWhiteSpace(string) == 1 && brand.isPOBoxOrStreetRequired()) {
                throw new RegException(203);
            }
            if (!Utility.validateHasCharsString(string)) {
                throw new RegException(222);
            }
            if (Utility.validateString(string) != -1) {
                throw new RegException(217, addrControl.getStreetEditControl());
            }
        }
        if (language.isCitySupported()) {
            string = addrControl.getCity();
            if (Utility.validateIsWhiteSpace(string) == 1 && brand.isCityRequired()) {
                throw new RegException(204);
            }
            if (Utility.validateString(string) != -1) {
                throw new RegException(217, addrControl.getCityEditControl());
            }
        }
        if (language.isStateSupported(this) && Utility.validateIsWhiteSpace(string = addrControl.getState()) == 1 && brand.isStateRequired()) {
            throw new RegException(205);
        }
        if (language.isZipSupported() && !addrControl.getZipValidationIsOK()) {
            string = addrControl.getZip();
            if (Utility.validateIsWhiteSpace(string) == 1 && brand.isZipRequired()) {
                throw new RegException(206, addrControl.getZipEditControl());
            }
            if (Utility.validateString(string) != -1) {
                throw new RegException(217, addrControl.getZipEditControl());
            }
            try {
                this.validateZipString(string);
            }
            catch (RegException regException) {
                if (regException.getMessageID() != 246) throw regException;
                throw new RegException(246, addrControl.getZipEditControl());
            }
        }
        if (!language.isCountrySupported() || addrControl.getCountryIdx() != -1 || !brand.isCountryRequired()) return;
        throw new RegException(207);
    }

    public void validate(Name name) throws RegException {
        Language language = Language.getDefaultLanguage();
        Brand brand = Brand.getBrand();
        if (language.getLanguageString().compareTo("zh_CN") != 0) {
            String string;
            if (language.isFirstNameSupported()) {
                string = name.getFirstName();
                if (Utility.validateIsWhiteSpace(string) == 1) {
                    if (brand.isFirstNameRequired()) {
                        throw new RegException(201);
                    }
                } else {
                    if (Utility.validateNoNumericsString(string) != -1) {
                        throw new RegException(221, name.getFirstNameEditControl());
                    }
                    if (Utility.validateString(string) != -1) {
                        throw new RegException(217, name.getFirstNameEditControl());
                    }
                }
            }
            if (language.isLastNameSupported()) {
                string = name.getLastName();
                if (Utility.validateIsWhiteSpace(string) == 1) {
                    if (brand.isLastNameRequired()) {
                        throw new RegException(202);
                    }
                } else {
                    if (Utility.validateNoNumericsString(string) != -1) {
                        throw new RegException(221, name.getLastNameEditControl());
                    }
                    if (Utility.validateString(string) != -1) {
                        throw new RegException(217, name.getLastNameEditControl());
                    }
                }
            }
            if (language.isMiddleInitialSupported()) {
                string = name.getInitial();
                if (Utility.validateIsWhiteSpace(string) == 1) {
                    if (brand.isMiddleInitialRequired()) {
                        throw new RegException(201);
                    }
                } else if (Utility.validateString(string) != -1) {
                    throw new RegException(217, name.getInitialEditControl());
                }
            }
            if (language.isPrefixSupported()) {
                string = name.getPrefix();
                if (Utility.validateIsWhiteSpace(string) == 1) {
                    if (brand.isPrefixRequired() || language.getLanguageString().compareTo("ja_JP") == 0) {
                        throw new RegException(1519);
                    }
                } else if (Utility.validateString(string) != -1) {
                    throw new RegException(217);
                }
            }
            if (language.isSuffixSupported()) {
                string = name.getSuffix();
                if (Utility.validateIsWhiteSpace(string) == 1) {
                    if (brand.isSuffixRequired() || language.getLanguageString().compareTo("ja_JP") == 0) {
                        throw new RegException(1520);
                    }
                } else if (Utility.validateString(string) != -1) {
                    throw new RegException(217);
                }
            }
        } else {
            String string;
            if (language.isLastNameSupported()) {
                string = name.getLastName();
                if (Utility.validateIsWhiteSpace(string) == 1) {
                    if (brand.isLastNameRequired()) {
                        throw new RegException(202);
                    }
                } else {
                    if (Utility.validateNoNumericsString(string) != -1) {
                        throw new RegException(221, name.getLastNameEditControl());
                    }
                    if (Utility.validateString(string) != -1) {
                        throw new RegException(217, name.getLastNameEditControl());
                    }
                }
            }
            if (language.isFirstNameSupported()) {
                string = name.getFirstName();
                if (Utility.validateIsWhiteSpace(string) == 1) {
                    if (brand.isFirstNameRequired()) {
                        throw new RegException(201);
                    }
                } else {
                    if (Utility.validateNoNumericsString(string) != -1) {
                        throw new RegException(221, name.getFirstNameEditControl());
                    }
                    if (Utility.validateString(string) != -1) {
                        throw new RegException(217, name.getFirstNameEditControl());
                    }
                }
            }
            if (language.isMiddleInitialSupported()) {
                string = name.getInitial();
                if (Utility.validateIsWhiteSpace(string) == 1) {
                    if (brand.isMiddleInitialRequired()) {
                        throw new RegException(201);
                    }
                } else if (Utility.validateString(string) != -1) {
                    throw new RegException(217, name.getInitialEditControl());
                }
            }
            if (language.isPrefixSupported()) {
                string = name.getPrefix();
                if (Utility.validateIsWhiteSpace(string) == 1) {
                    if (brand.isPrefixRequired() || language.getLanguageString().compareTo("ja_JP") == 0) {
                        throw new RegException(1519);
                    }
                } else if (Utility.validateString(string) != -1) {
                    throw new RegException(217);
                }
            }
            if (language.isSuffixSupported()) {
                string = name.getSuffix();
                if (Utility.validateIsWhiteSpace(string) == 1) {
                    if (brand.isSuffixRequired() || language.getLanguageString().compareTo("ja_JP") == 0) {
                        throw new RegException(1520);
                    }
                } else if (Utility.validateString(string) != -1) {
                    throw new RegException(217);
                }
            }
        }
    }

    public void validate(PhoneControl phoneControl) throws RegException {
        this.validatePhoneField(phoneControl);
        this.validatePhoneExtField(phoneControl);
    }

    public void validatePhoneExtField(PhoneControl phoneControl) throws RegException {
        Language language = Language.getDefaultLanguage();
        Brand brand = Brand.getBrand();
        if (language.isPhoneSupported()) {
            String string = phoneControl.getExt();
            if (Utility.validateString(string) != -1) {
                throw new RegException(217, phoneControl.getExtControl());
            }
            if (Utility.validateIsWhiteSpace(string) == 1 && brand.isPhoneRequired()) {
                throw new RegException(208);
            }
            if (Utility.validateIsWhiteSpace(string) != 1) {
                String string2 = "0123456789- .()+";
                String string3 = "0123456789";
                int n = -1;
                int n2 = 0;
                int n3 = 0;
                while (n3 < string.length() && n == -1) {
                    String string4 = string.substring(n3, n3 + 1);
                    if (string2.indexOf(string4) == -1) {
                        n = n3;
                    } else if (string3.indexOf(string4) != -1) {
                        ++n2;
                    }
                    ++n3;
                }
                if (n != -1) {
                    throw new RegException(246, phoneControl.getExtControl());
                }
            }
        }
    }

    public void validatePhoneField(PhoneControl phoneControl) throws RegException {
        Language language = Language.getDefaultLanguage();
        Brand brand = Brand.getBrand();
        if (language.isPhoneSupported() && !phoneControl.getPhoneValidationIsOK()) {
            int n = (Integer)validationArray[this.m_iCountryId][1];
            String string = phoneControl.getPhone();
            if (Utility.validateString(string) != -1) {
                throw new RegException(217, phoneControl.getPhoneControl());
            }
            if (Utility.validateIsWhiteSpace(string) == 1 && brand.isPhoneRequired()) {
                throw new RegException(208);
            }
            if (Utility.validateIsWhiteSpace(string) != 1) {
                String string2 = "0123456789- .()+";
                String string3 = "0123456789";
                int n2 = -1;
                int n3 = 0;
                int n4 = 0;
                while (n4 < string.length() && n2 == -1) {
                    String string4 = string.substring(n4, n4 + 1);
                    if (string2.indexOf(string4) == -1) {
                        n2 = n4;
                    } else if (string3.indexOf(string4) != -1) {
                        ++n3;
                    }
                    ++n4;
                }
                if (n2 != -1) {
                    throw new RegException(246, phoneControl.getPhoneControl());
                }
                if (n3 < n) {
                    throw new RegException(1515);
                }
            }
        }
    }

    public void validateZipString(String string) throws RegException {
        Language language = Language.getDefaultLanguage();
        Brand brand = Brand.getBrand();
        String string2 = string;
        if (language.isZipSupported()) {
            if (Utility.validateIsWhiteSpace(string2) == 1 && brand.isZipRequired()) {
                throw new RegException(206);
            }
            if (Utility.validateIsWhiteSpace(string2) != 1) {
                int n = (Integer)validationArray[this.m_iCountryId][2];
                boolean bl = false;
                if (n < 0) {
                    bl = true;
                    n = Math.abs(n);
                }
                int n2 = 0;
                int n3 = -1;
                int n4 = 0;
                while (n4 < string2.length() && n3 == -1) {
                    char c = string2.charAt(n4);
                    if (!Character.isDigit(c)) {
                        if (bl && c != '-' && c != ' ') {
                            n3 = n4;
                        } else if (!Character.isLetter(c) && c != '-' && c != ' ') {
                            n3 = n4;
                        } else if (c != '-' && c != ' ') {
                            ++n2;
                        }
                    } else {
                        ++n2;
                    }
                    ++n4;
                }
                if (n3 != -1) {
                    throw new RegException(246);
                }
                if (n2 < n) {
                    if (bl) {
                        throw new RegException(1517);
                    }
                    throw new RegException(1516);
                }
            }
        }
    }
}

