/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lexington.prt;

import com.ibm.lexington.prt.Address;
import com.ibm.lexington.prt.Country;
import com.ibm.lexington.prt.SysInfo;
import com.ibm.lexington.prt.Utility;
import java.util.Hashtable;

public class CustAddr
extends Address {
    private static final String NotSpecified = "";
    private static final String POBox = "addr2";
    private static final String Street = "addr1";
    private static final String City = "city";
    private static final String State = "stateProv";
    private static final String Zip = "zip";
    private static final String COUNTRY = "country";
    private static final String CheckFrench = "q6";
    private static final String CheckFrenchKey = "fr_CA";
    private static final String CheckFrenchState = "frenchState";
    private static final int NumState = 63;
    private static final String[] StateCode = new String[]{"AL", "AK", "AB", "AZ", "AR", "BC", "CA", "CO", "CT", "DE", "DC", "FL", "GA", "HI", "ID", "IL", "IN", "IA", "KS", "KY", "LA", "ME", "MB", "MD", "MA", "MI", "MN", "MS", "MO", "MT", "NE", "NV", "NB", "NH", "NJ", "NM", "NY", "NF", "NC", "ND", "NT", "NS", "OH", "OK", "ON", "OR", "PA", "PE", "QC", "RI", "SK", "SC", "SD", "TN", "TX", "UT", "VT", "VA", "WA", "WV", "WI", "WY", "YT"};
    private boolean m_bCheckFrench;
    private boolean m_bCheckFrenchState;
    private int m_iCountryIdx;
    private String m_strCountry;
    private String m_iStateIdx;
    private String m_strState;
    private String m_strZip;
    private String m_strCity;
    private String m_strPOBox;
    private Hashtable m_hash;

    public CustAddr(Hashtable hashtable) {
        this.m_hash = hashtable;
    }

    private static String copyright() {
        return "\n\nLicensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1999, 2000. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    }

    public boolean getCheckFrench() {
        return this.m_bCheckFrench;
    }

    public boolean getCheckFrenchState() {
        return this.m_bCheckFrenchState;
    }

    public String getCheckFrenchValue() {
        return (String)this.m_hash.get(CheckFrench);
    }

    public String getCity() {
        return (String)this.m_hash.get(City);
    }

    public String getCountry() {
        return this.m_strCountry;
    }

    public int getCountryIdx() {
        return this.m_iCountryIdx;
    }

    public String getCountryValue() {
        String string = this.m_iCountryIdx >= 0 && this.m_iCountryIdx < 169 ? Country.getPostString(this.m_iCountryIdx) : NotSpecified;
        return string;
    }

    public String getPOBox() {
        return (String)this.m_hash.get(POBox);
    }

    public String getState() {
        return this.m_strState;
    }

    public String getStateIdx() {
        return this.m_iStateIdx;
    }

    public String getStateValue() {
        return this.m_iStateIdx;
    }

    public String getStreet() {
        return (String)this.m_hash.get(Street);
    }

    public String getZip() {
        return (String)this.m_hash.get(Zip);
    }

    public void readRegistry() {
        SysInfo sysInfo = SysInfo.getInstance();
        String string = sysInfo.readRegistryString("General", POBox);
        this.setPOBox(string);
        string = sysInfo.readRegistryString("General", Street);
        this.setStreet(string);
        string = sysInfo.readRegistryString("General", City);
        this.setCity(string);
        string = sysInfo.readRegistryString("General", State);
        this.setState(string);
        string = sysInfo.readRegistryString("General", Zip);
        this.setZip(string);
        string = sysInfo.readRegistryString("General", COUNTRY);
        this.setCountry(string);
        int n = sysInfo.readRegistryInt("General", CheckFrench);
        if (n != -1) {
            this.setCheckFrench(n == 1);
        }
    }

    public void setCheckFrench(boolean bl) {
        this.m_bCheckFrench = bl;
        String string = bl ? CheckFrenchKey : NotSpecified;
        this.m_hash.put(CheckFrench, string);
    }

    public void setCheckFrenchState(boolean bl) {
        this.m_bCheckFrenchState = bl;
    }

    public void setCity(String string) {
        this.m_hash.put(City, string);
    }

    public void setCountry(String string) {
        this.m_strCountry = string;
    }

    public void setCountryIdx(String string, int n) {
        String string2;
        this.m_iCountryIdx = n;
        if (n >= 0 && n < 169) {
            string2 = Country.getPostString(n);
            this.m_strCountry = string;
        } else {
            string2 = NotSpecified;
            this.m_strCountry = NotSpecified;
        }
        this.m_hash.put(COUNTRY, string2);
    }

    public void setPOBox(String string) {
        String string2 = string == NotSpecified ? NotSpecified : string;
        this.m_hash.put(POBox, string2);
    }

    public void setState(String string) {
        this.m_strState = string;
    }

    public void setStateIdx(String string, String string2) {
        String string3;
        this.m_iStateIdx = string2;
        if (Utility.validateIsWhiteSpace(string2) == -1) {
            string3 = string2;
            this.m_strState = string;
        } else {
            string3 = NotSpecified;
            this.m_strState = NotSpecified;
        }
        this.m_hash.put(State, string3);
    }

    public void setStreet(String string) {
        String string2 = string == NotSpecified ? NotSpecified : string;
        this.m_hash.put(Street, string2);
    }

    public void setZip(String string) {
        this.m_hash.put(Zip, string);
    }

    public void writeRegistry() {
        SysInfo sysInfo = SysInfo.getInstance();
        sysInfo.writeRegistryString("General", POBox, this.getPOBox());
        sysInfo.writeRegistryString("General", Street, this.getStreet());
        sysInfo.writeRegistryString("General", City, this.getCity());
        String string = this.getState();
        if (!string.equalsIgnoreCase("XX")) {
            sysInfo.writeRegistryString("General", State, this.getState());
        }
        sysInfo.writeRegistryString("General", COUNTRY, this.getCountry());
        sysInfo.writeRegistryString("General", Zip, this.getZip());
        sysInfo.writeRegistryInt("General", CheckFrench, this.getCheckFrench() ? 1 : 0);
    }
}

