/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lexington.prt;

import com.ibm.lexington.prt.Brand;
import com.ibm.lexington.prt.CustAddr;
import com.ibm.lexington.prt.CustName;
import com.ibm.lexington.prt.CustPhone;
import com.ibm.lexington.prt.Language;
import com.ibm.lexington.prt.RegCommandLine;
import com.ibm.lexington.prt.SysInfo;
import com.ibm.lexington.prt.SystemProductInfo;
import com.ibm.lexington.prt.URLEncoder;
import com.ibm.lexington.prt.Utility;
import java.util.Enumeration;
import java.util.Hashtable;

public class CustInfo {
    private static final int RadioRegisterValue = 0;
    private static final int RadioStartISPValue = -1;
    private static final int RadioPrintValue = -2;
    private static final String NotSpecified = "";
    private static final String LANGUAGE = "q1";
    private static final String RegistrationNum = "regNum";
    private static final String ResponseMedia = "q4";
    private static final String JobTitle = "jobTitle";
    private static final String Company = "company";
    private static final String Email = "email";
    private static final String CheckDataAuth = "q26";
    private static final String PurchaseLocation = "q10";
    private static final String BenefitsPreference = "q11";
    private static final String RegistrationCode = "q13";
    private static final String SRTVersion = "q14";
    private static final String SchoolLibrary = "q22";
    private static String AddInfoQ1;
    private static int NumQ1Choices;
    private static String[][] AddInfoQ1Code;
    private static int NumIndustry;
    private static String[][] IndustryCode;
    private static int NumNumEmployees;
    private static String[][] NumEmployeesCode;
    private int m_addInfoQ1Idx;
    private String m_addInfoQ1;
    private int m_industryIdx;
    private String m_industry;
    private int m_numEmployeesIdx;
    private String m_numEmployees;
    private boolean m_checkDataAuth = true;
    private boolean m_checkURL1;
    private boolean m_checkURL2;
    private boolean m_checkURL3;
    private boolean m_checkRegisterLater = true;
    private int m_radioRegisterPrint = 0;
    private String m_message;
    private Hashtable m_hash = new Hashtable();
    private Hashtable m_hashQuestions = new Hashtable();
    private Hashtable m_hashPrint = new Hashtable();
    private CustName m_CustName = new CustName(this.m_hash);
    private CustAddr m_CustAddr = new CustAddr(this.m_hash);
    private CustPhone m_hCustPhone = new CustPhone(this.m_hash);
    private Language m_refLanguage = Language.getDefaultLanguage();
    private static CustInfo m_instance;

    static {
        m_instance = null;
    }

    protected CustInfo() {
        Brand brand = Brand.getBrand();
        if (brand.getBrandString().equalsIgnoreCase("lot")) {
            AddInfoQ1 = "q7";
            NumQ1Choices = 29;
            AddInfoQ1Code = new String[][]{{"ACCT", "1"}, {"ADMI", "2"}, {"ANLY", "3"}, {"ATTY", "4"}, {"CEO", "6"}, {"CIO", "7"}, {"CONS", "8"}, {"DIRE", "9"}, {"DOCT", "10"}, {"EDUC", "11"}, {"ENGI", "12"}, {"MANA", "13"}, {"NETM", "14"}, {"OFFM", "15"}, {"PRES", "16"}, {"PROG", "17"}, {"PROJ", "18"}, {"BUYR", "5"}, {"SREP", "21"}, {"SCNT", "19"}, {"SPEC", "20"}, {"STAF", "22"}, {"STUD", "23"}, {"SUPE", "24"}, {"SYAD", "25"}, {"TREA", "26"}, {"VICE", "27"}, {"WEBM", "28"}, {"OTHR", "29"}};
        } else if (brand.getBrandString().equalsIgnoreCase("ibm")) {
            AddInfoQ1 = "q12";
            NumQ1Choices = 11;
            AddInfoQ1Code = new String[][]{{"PREV", "6"}, {"RECM", "8"}, {"ADVR", "1"}, {"EVAL", "3"}, {"AOTH", "2"}, {"SREP", "9"}, {"VADD", "11"}, {"IBP", "4"}, {"DEMO", "10"}, {"STND", "5"}, {"PRCE", "7"}};
        } else if (brand.getBrandString().equalsIgnoreCase("tiv")) {
            AddInfoQ1 = "q12";
            NumQ1Choices = 11;
            AddInfoQ1Code = new String[][]{{"PREV", "6"}, {"RECM", "8"}, {"ADVR", "1"}, {"EVAL", "3"}, {"AOTH", "2"}, {"SREP", "9"}, {"VADD", "11"}, {"IBP", "4"}, {"DEMO", "10"}, {"STND", "5"}, {"PRCE", "7"}};
        }
        NumIndustry = 25;
        IndustryCode = new String[][]{{"AGRC", "1"}, {"BANK", "2"}, {"CSTR", "5"}, {"CONS", "3"}, {"CPRD", "4"}, {"EDUC", "6"}, {"GOVF", "9"}, {"FINL", "7"}, {"GOIL", "8"}, {"GOVT", "10"}, {"HCAR", "11"}, {"HTEC", "12"}, {"INDP", "13"}, {"INSU", "14"}, {"MANF", "15"}, {"MKTG", "16"}, {"NONP", "17"}, {"PROF", "18"}, {"PUBL", "19"}, {"REAL", "20"}, {"RETL", "21"}, {"TELE", "22"}, {"TRAN", "23"}, {"TRAV", "24"}, {"OTHR", "25"}};
        NumNumEmployees = 13;
        NumEmployeesCode = new String[][]{{"1-9", "1"}, {"10-24", "2"}, {"25-49", "5"}, {"50-99", "10"}, {"100-249", "3"}, {"250-499", "6"}, {"500-999", "11"}, {"1K-1999", "4"}, {"2K-2999", "7"}, {"3K-3999", "8"}, {"4K-4999", "9"}, {"5000+", "12"}, {"UNKN", "13"}};
    }

    private static String copyright() {
        return "\n\nLicensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1999, 2000. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    }

    public String format() {
        Enumeration enumeration = this.m_hash.keys();
        Enumeration enumeration2 = this.m_hash.elements();
        boolean bl = true;
        this.m_message = NotSpecified;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)enumeration2.nextElement();
            if (!bl) {
                this.m_message = String.valueOf(this.m_message) + "&";
            } else {
                bl = false;
            }
            this.m_message = String.valueOf(this.m_message) + string;
            this.m_message = String.valueOf(this.m_message) + "=";
            if (string2 == NotSpecified) {
                string2 = " ";
            }
            URLEncoder.encode(string2);
            this.m_message = String.valueOf(this.m_message) + string2;
        }
        String string = SystemProductInfo.getInstance().getSRTVersion();
        this.m_message = String.valueOf(this.m_message) + "&";
        this.m_message = String.valueOf(this.m_message) + "q14=";
        if (RegCommandLine.getRegressionTest().equalsIgnoreCase("yes")) {
            this.m_message = String.valueOf(this.m_message) + "PRT Regression Test Version";
        } else {
            URLEncoder.encode(string);
            this.m_message = String.valueOf(this.m_message) + string;
        }
        return this.m_message;
    }

    public CustAddr getAddr() {
        return this.m_CustAddr;
    }

    public String getBenefitsPreference() {
        return (String)this.m_hash.get(BenefitsPreference);
    }

    public boolean getCheckDataAuth() {
        return this.m_checkDataAuth;
    }

    public String getCheckDataAuthValue() {
        return (String)this.m_hash.get(CheckDataAuth);
    }

    public boolean getCheckRegisterLater() {
        return this.m_checkRegisterLater;
    }

    public boolean getCheckURL1() {
        return this.m_checkURL1;
    }

    public boolean getCheckURL2() {
        return this.m_checkURL2;
    }

    public boolean getCheckURL3() {
        return this.m_checkURL3;
    }

    public String getCompany() {
        return (String)this.m_hash.get(Company);
    }

    public String getEmail() {
        return (String)this.m_hash.get(Email);
    }

    public static CustInfo getInstance() {
        if (m_instance == null) {
            m_instance = new CustInfo();
        }
        return m_instance;
    }

    public String getJobTitle() {
        return (String)this.m_hash.get(JobTitle);
    }

    public String getLanguage() {
        return (String)this.m_hash.get(LANGUAGE);
    }

    public CustName getName() {
        return this.m_CustName;
    }

    public CustPhone getPhone() {
        return this.m_hCustPhone;
    }

    public String getPrintValue(String string) {
        String string2 = (String)this.m_hashPrint.get(string);
        if (string2 == null || string2 == "null") {
            string2 = NotSpecified;
        }
        return string2;
    }

    public String getPurchaseLocation() {
        return (String)this.m_hash.get(PurchaseLocation);
    }

    public String getQuestionValue(String string) {
        String string2 = (String)this.m_hashQuestions.get(string);
        if (string2 == null || string2 == "null") {
            string2 = NotSpecified;
        }
        return string2;
    }

    public int getRadioRegisterPrint() {
        return this.m_radioRegisterPrint;
    }

    public String getRegistrationCode() {
        return (String)this.m_hash.get(RegistrationCode);
    }

    public String getRegistrationNum() {
        return (String)this.m_hash.get(RegistrationNum);
    }

    public String getResponseMedia() {
        return (String)this.m_hash.get(ResponseMedia);
    }

    public String getSchoolLibrary() {
        return (String)this.m_hash.get(SchoolLibrary);
    }

    public boolean isRadioPrint() {
        return this.m_radioRegisterPrint == -2;
    }

    public boolean isRadioRegister() {
        return this.m_radioRegisterPrint == 0;
    }

    public boolean isRadioStartISP() {
        return this.m_radioRegisterPrint == -1;
    }

    public void readRegistry() {
        String string;
        Brand brand = Brand.getBrand();
        SysInfo sysInfo = SysInfo.getInstance();
        this.m_CustName.readRegistry();
        this.m_CustAddr.readRegistry();
        this.m_hCustPhone.readRegistry();
        if (brand.isConsumer()) {
            string = sysInfo.readRegistryString(brand.getBrandSection(), SchoolLibrary);
            this.setSchoolLibrary(string);
        } else {
            string = sysInfo.readRegistryString("General", JobTitle);
            this.setJobTitle(string);
            string = sysInfo.readRegistryString("General", Company);
            this.setCompany(string);
        }
        string = sysInfo.readRegistryString("General", Email);
        this.setEmail(string);
        this.setCheckDataAuth(true);
        string = sysInfo.readRegistryString(brand.getBrandSection(), BenefitsPreference);
        this.setBenefitsPreference(string);
        string = sysInfo.readRegistryString(brand.getBrandSection(), PurchaseLocation);
        this.setPurchaseLocation(string);
        string = sysInfo.readRegistryString("General", RegistrationCode);
        this.setRegistrationCode(string);
    }

    public void setBenefitsPreference(String string) {
        this.m_hash.put(BenefitsPreference, string);
    }

    public void setCheckDataAuth(boolean bl) {
        this.m_checkDataAuth = bl;
        String string = bl ? Language.rb_comall.getString(Integer.toString(1055)) : Language.rb_comall.getString(Integer.toString(1056));
        this.m_hash.put(CheckDataAuth, string);
    }

    public void setCheckRegisterLater(boolean bl) {
        this.m_checkRegisterLater = bl;
    }

    public void setCheckURL1(boolean bl) {
        this.m_checkURL1 = bl;
    }

    public void setCheckURL2(boolean bl) {
        this.m_checkURL2 = bl;
    }

    public void setCheckURL3(boolean bl) {
        this.m_checkURL3 = bl;
    }

    public void setCompany(String string) {
        String string2 = string == NotSpecified ? NotSpecified : string;
        this.m_hash.put(Company, string2);
    }

    public void setEmail(String string) {
        String string2 = string == NotSpecified ? NotSpecified : string;
        this.m_hash.put(Email, string2);
    }

    public void setJobTitle(String string) {
        String string2 = string == NotSpecified ? NotSpecified : string;
        this.m_hash.put(JobTitle, string2);
    }

    public void setLanguage(String string) {
        String string2 = Utility.getThreeCharISOCode(string);
        this.m_hash.put(LANGUAGE, string2);
    }

    public void setPrintValue(String string, String string2) {
        this.m_hashPrint.put(string, string2);
    }

    public void setPurchaseLocation(String string) {
        this.m_hash.put(PurchaseLocation, string);
    }

    public void setQuestionValue(String string, String string2) {
        this.m_hashQuestions.put(string, string2);
    }

    public void setRadioPrint() {
        this.m_radioRegisterPrint = -2;
    }

    public void setRadioRegister() {
        this.m_radioRegisterPrint = 0;
    }

    public void setRadioStartISP() {
        this.m_radioRegisterPrint = -1;
    }

    public void setRegistrationCode(String string) {
        if (string == NotSpecified) {
            string = NotSpecified;
        }
        if (RegCommandLine.getRegressionTest().equalsIgnoreCase("yes")) {
            this.m_hash.put(RegistrationCode, "00629B380864C61");
        } else {
            this.m_hash.put(RegistrationCode, string);
        }
    }

    public void setRegistrationNum(String string) {
        this.m_hash.put(RegistrationNum, string);
    }

    public void setResponseMedia(String string) {
        this.m_hash.put(ResponseMedia, string);
    }

    public void setSchoolLibrary(String string) {
        this.m_hash.put(SchoolLibrary, string);
    }

    public void writeRegistry() {
        Brand brand = Brand.getBrand();
        SysInfo sysInfo = SysInfo.getInstance();
        this.m_CustName.writeRegistry();
        this.m_CustAddr.writeRegistry();
        this.m_hCustPhone.writeRegistry();
        if (brand.isConsumer()) {
            sysInfo.writeRegistryString(brand.getBrandSection(), SchoolLibrary, this.getSchoolLibrary());
        } else {
            sysInfo.writeRegistryString("General", JobTitle, this.getJobTitle());
            sysInfo.writeRegistryString("General", Company, this.getCompany());
        }
        sysInfo.writeRegistryString("General", LANGUAGE, this.getLanguage());
        sysInfo.writeRegistryString("General", Email, this.getEmail());
        sysInfo.writeRegistryString(brand.getBrandSection(), PurchaseLocation, this.getPurchaseLocation());
        sysInfo.writeRegistryString(brand.getBrandSection(), BenefitsPreference, this.getBenefitsPreference());
        sysInfo.writeRegistryString("General", RegistrationCode, this.getRegistrationCode());
    }
}

