/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lexington.prt;

import com.ibm.lexington.prt.Name;
import com.ibm.lexington.prt.SysInfo;
import java.util.Hashtable;

public class CustName
extends Name {
    private static final String NotSpecified = "";
    private static final String FirstName = "firstName";
    private static final String Initial = "initial";
    private static final String LastName = "lastName";
    private static final String Suffix = "suffix";
    private static final String Prefix = "prefix";
    private static final int NumPrefix = 5;
    private static final int NumSuffix = 10;
    private static final String[] PrefixCode = new String[]{"MR", "MS", "MRS", "MISS", "DR"};
    private static final String[] SuffixCode = new String[]{"", "CPA", "ESQ", "JR", "PH.D", "SR", "II", "III", "IV", "V"};
    private static CustName m_pInstance;
    private Hashtable m_hash;
    private String m_strFirstName;
    private String m_strInitial;
    private String m_strLastName;
    private String m_strPrefix;
    private String m_strSuffix;
    private int m_iSuffixIdx;
    private int m_iPrefixIdx;

    public CustName(Hashtable hashtable) {
        this.m_hash = hashtable;
    }

    private static String copyright() {
        return "\n\nLicensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1999, 2000. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    }

    public String getFirstName() {
        return (String)this.m_hash.get(FirstName);
    }

    public String getInitial() {
        return (String)this.m_hash.get(Initial);
    }

    public String getLastName() {
        return (String)this.m_hash.get(LastName);
    }

    public String getPrefix() {
        return this.m_strPrefix;
    }

    public String getPrefixValue() {
        String string = this.m_iPrefixIdx >= 0 && this.m_iPrefixIdx < 5 ? PrefixCode[this.m_iPrefixIdx] : NotSpecified;
        return string;
    }

    public String getSuffix() {
        return this.m_strSuffix;
    }

    public String getSuffixValue() {
        String string = this.m_iSuffixIdx >= 0 && this.m_iSuffixIdx < 10 ? SuffixCode[this.m_iSuffixIdx] : NotSpecified;
        return string;
    }

    public void readRegistry() {
        SysInfo sysInfo = SysInfo.getInstance();
        String string = sysInfo.readRegistryString("General", FirstName);
        this.setFirstName(string);
        string = sysInfo.readRegistryString("General", Initial);
        this.setInitial(string);
        string = sysInfo.readRegistryString("General", LastName);
        this.setLastName(string);
        string = sysInfo.readRegistryString("General", Suffix);
        this.setSuffix(string);
        string = sysInfo.readRegistryString("General", Prefix);
        this.setPrefix(string);
    }

    public void setFirstName(String string) {
        this.m_hash.put(FirstName, string);
    }

    public void setInitial(String string) {
        String string2 = string == NotSpecified ? NotSpecified : string;
        this.m_hash.put(Initial, string2);
    }

    public void setLastName(String string) {
        this.m_hash.put(LastName, string);
    }

    public void setPrefix(String string) {
        this.m_strPrefix = string;
    }

    public void setPrefixIdx(String string, int n) {
        String string2;
        this.m_iPrefixIdx = n;
        if (n >= 0 && n < 5) {
            string2 = string;
            this.m_strPrefix = string;
        } else {
            string2 = NotSpecified;
            this.m_strPrefix = NotSpecified;
        }
        this.m_hash.put(Prefix, string2);
    }

    public void setSuffix(String string) {
        this.m_strSuffix = string;
    }

    public void setSuffixIdx(String string, int n) {
        String string2;
        this.m_iSuffixIdx = n;
        if (n >= 0 && n < 10) {
            string2 = string;
            this.m_strSuffix = string;
        } else {
            string2 = NotSpecified;
            this.m_strSuffix = NotSpecified;
        }
        this.m_hash.put(Suffix, string2);
    }

    public void writeRegistry() {
        SysInfo sysInfo = SysInfo.getInstance();
        sysInfo.writeRegistryString("General", FirstName, this.getFirstName());
        sysInfo.writeRegistryString("General", Initial, this.getInitial());
        sysInfo.writeRegistryString("General", LastName, this.getLastName());
        sysInfo.writeRegistryString("General", Suffix, this.getSuffix());
        sysInfo.writeRegistryString("General", Prefix, this.getPrefix());
    }
}

