/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lexington.prt;

import com.ibm.lexington.prt.Brand;
import com.ibm.lexington.prt.EmbeddedPartFileLine;
import com.ibm.lexington.prt.EmbeddedPartFileLineFactory;
import com.ibm.lexington.prt.EncryptedFile;
import com.ibm.lexington.prt.PartFileLanguage;
import java.io.FileNotFoundException;
import java.util.Enumeration;
import java.util.Hashtable;

public class EmbeddedPartFile
extends EncryptedFile {
    private static final String embeddedPartFileName = "pr" + Brand.getBrand().getBrandStringLow() + "reg.dat";
    private static EmbeddedPartFile m_instance = null;
    boolean m_populated = false;
    private String m_firstPartNumber;
    private String m_usaPartNumber;
    private String m_productVersion;
    private String m_dateOfCreation;
    private String m_productName;
    private String m_productType;
    private String m_defaultPartNumber;
    private Hashtable m_languages = new Hashtable();

    private EmbeddedPartFile() throws FileNotFoundException {
        super(embeddedPartFileName);
    }

    public boolean addPartNumber(int n, String string) {
        PartFileLanguage partFileLanguage;
        if (this.m_defaultPartNumber.equals("")) {
            if (this.m_firstPartNumber.equals("") && !string.equals("#default")) {
                this.m_firstPartNumber = string;
            } else if (this.m_usaPartNumber.equals("") && n == 18 && !string.equals("#default")) {
                this.m_usaPartNumber = string;
            }
        }
        if ((partFileLanguage = (PartFileLanguage)this.m_languages.get(new Integer(n))) == null) {
            partFileLanguage = new PartFileLanguage(n);
            this.m_languages.put(new Integer(n), partFileLanguage);
        }
        partFileLanguage.add(string);
        return true;
    }

    private static String copyright() {
        return "\n\nLicensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1999, 2000. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    }

    public String dateOfCreation() {
        this.guaranteePopulation();
        return this.m_dateOfCreation;
    }

    public String defaultPartNumber() {
        this.guaranteePopulation();
        return this.m_defaultPartNumber;
    }

    public static EmbeddedPartFile getInstance() {
        try {
            if (m_instance == null) {
                m_instance = new EmbeddedPartFile();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Could not find the part number side file!  Using defaults.");
        }
        return m_instance;
    }

    public void guaranteePopulation() {
        if (!this.m_populated) {
            Object object;
            StringBuffer stringBuffer = new StringBuffer();
            while (this.readString(stringBuffer)) {
                object = EmbeddedPartFileLineFactory.create(stringBuffer.toString());
                if (object != null) {
                    ((EmbeddedPartFileLine)object).parse();
                }
                stringBuffer = new StringBuffer("");
                object = null;
            }
            if (this.m_defaultPartNumber.equals("")) {
                if (this.m_usaPartNumber != "") {
                    this.setDefaultPartNumber(this.m_usaPartNumber);
                } else if (this.m_firstPartNumber != "") {
                    this.setDefaultPartNumber(this.m_firstPartNumber);
                }
            }
            Enumeration enumeration = this.m_languages.keys();
            Enumeration enumeration2 = this.m_languages.elements();
            while (enumeration.hasMoreElements()) {
                int n = (Integer)enumeration.nextElement();
                object = (PartFileLanguage)enumeration2.nextElement();
                if (!((PartFileLanguage)object).getPartNumber(0).equals("#default")) continue;
                if (this.m_defaultPartNumber.equals("")) {
                    this.m_languages.remove(new Integer(n));
                    continue;
                }
                ((PartFileLanguage)object).change(0, this.m_defaultPartNumber);
            }
            this.m_populated = true;
        }
    }

    public int numParts(int n) {
        PartFileLanguage partFileLanguage = (PartFileLanguage)this.m_languages.get(new Integer(n));
        if (partFileLanguage != null) {
            return partFileLanguage.numParts();
        }
        return 0;
    }

    public String partNumber(int n, int n2) {
        int n3 = 0;
        PartFileLanguage partFileLanguage = (PartFileLanguage)this.m_languages.get(new Integer(n));
        if (partFileLanguage != null) {
            return partFileLanguage.getPartNumber(n3);
        }
        return this.m_defaultPartNumber;
    }

    public String productName() {
        this.guaranteePopulation();
        return this.m_productName;
    }

    public String productType() {
        this.guaranteePopulation();
        return this.m_productType;
    }

    public String productVersion() {
        this.guaranteePopulation();
        return this.m_productVersion;
    }

    public void setDateOfCreation(String string) {
        this.m_dateOfCreation = string;
    }

    public void setDefaultPartNumber(String string) {
        this.m_defaultPartNumber = string;
    }

    public void setProductName(String string) {
        this.m_productName = string;
    }

    public void setProductType(String string) {
        this.m_productType = string;
    }

    public void setProductVersion(String string) {
        this.m_productVersion = string;
    }
}

