/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lexington.prt;

import com.ibm.lexington.prt.BlueMetalTheme;
import com.ibm.lexington.prt.Country;
import com.ibm.lexington.prt.CustInfo;
import com.ibm.lexington.prt.Language;
import com.ibm.lexington.prt.RegCommandLine;
import com.ibm.lexington.prt.SysInfo;
import com.ibm.lexington.prt.SystemProductInfo;
import com.ibm.lexington.prt.TextBreaker;
import com.ibm.lexington.prt.Utility;
import com.ibm.lexington.prt.res.Bounds;
import com.ibm.lexington.prt.res.StrBounds;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class ErrorConnect
extends JDialog
implements ActionListener {
    private JTextPane ivjJTextPaneError;
    private JTextPane ivjJTextPaneMessage;
    private ButtonGroup bgErrorConnectGroup = new ButtonGroup();
    private JLabel ivjLabelLater;
    private JRadioButton ivjCheckboxLater;
    private JRadioButton ivjCheckboxStartISP;
    private JRadioButton ivjCheckboxPrint;
    private JButton ivjButtonOK;
    private JButton ivjButtonCancel;
    private int buttonPressed;
    String m_message;
    int m_regLater;
    private CustInfo m_custInfo = CustInfo.getInstance();

    public ErrorConnect(String string, JFrame jFrame) {
        super((Frame)jFrame, true);
        this.m_custInfo.setRadioRegister();
        this.m_regLater = this.m_custInfo.getRadioRegisterPrint();
        this.m_message = string;
        this.initialize();
        this.doDataExchange();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        ((Component)this).setCursor(new Cursor(3));
        if (actionEvent.getSource() == this.ivjButtonOK) {
            this.onOK();
        } else if (actionEvent.getSource() == this.ivjButtonCancel) {
            this.onCancel();
        } else if (actionEvent.getSource() == this.ivjCheckboxLater) {
            this.onRADIORegisterLater();
        } else if (actionEvent.getSource() == this.ivjCheckboxStartISP) {
            this.onRADIOStartISP();
        } else if (actionEvent.getSource() == this.ivjCheckboxPrint) {
            this.onRADIOPrint();
        }
        ((Component)this).setCursor(new Cursor(0));
    }

    private void addButtons() {
        try {
            StrBounds strBounds = (StrBounds)Language.rb_24.getObject(Integer.toString(2326));
            StrBounds strBounds2 = (StrBounds)Language.rb_24.getObject(Integer.toString(2325));
            this.ivjButtonCancel = new JButton();
            this.ivjButtonCancel.setName("ButtonCancel");
            this.ivjButtonCancel.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.ivjButtonCancel.setBackground(Color.lightGray);
            this.ivjButtonOK = new JButton();
            this.ivjButtonOK.setName("ButtonOK");
            this.ivjButtonOK.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.ivjButtonOK.setBackground(Color.lightGray);
            Insets insets = this.ivjButtonCancel.getInsets();
            Insets insets2 = this.ivjButtonOK.getInsets();
            Dimension dimension = Utility.determineTextDimensions(this.ivjButtonCancel, strBounds.returnString());
            Dimension dimension2 = Utility.determineTextDimensions(this.ivjButtonOK, strBounds2.returnString());
            int n = dimension.width + insets.left + insets.right;
            int n2 = dimension2.width + insets2.left + insets2.right;
            int n3 = Math.max(n, n2);
            if (n3 < 60) {
                n3 = 60;
            }
            int n4 = dimension.height + insets.top + insets.bottom;
            int n5 = dimension2.height + insets2.top + insets2.bottom;
            Rectangle rectangle = this.getBounds();
            String string = Locale.getDefault().getLanguage();
            int n6 = rectangle.width / 2;
            n6 -= n3;
            n6 -= 30;
            if ((string.equals("ko") || string.equals("zh") || string.equals("ja")) && SysInfo.getOSPlatform().equals("AIX")) {
                this.ivjButtonOK.setBounds(n6, rectangle.height - 65 - 20, n3, n5);
            } else {
                this.ivjButtonOK.setBounds(n6, rectangle.height - 35 - 20, n3, n5);
            }
            n6 += n3;
            n6 += 60;
            if ((string.equals("ko") || string.equals("zh") || string.equals("ja")) && SysInfo.getOSPlatform().equals("AIX")) {
                this.ivjButtonCancel.setBounds(n6, rectangle.height - 65 - 20, n3, n4);
            } else {
                this.ivjButtonCancel.setBounds(n6, rectangle.height - 35 - 20, n3, n4);
            }
            this.ivjButtonCancel.setText(strBounds.returnString());
            this.ivjButtonOK.setText(strBounds2.returnString());
            this.getContentPane().add((Component)this.ivjButtonCancel, this.ivjButtonCancel.getName());
            this.getContentPane().add((Component)this.ivjButtonOK, this.ivjButtonOK.getName());
        }
        catch (Throwable throwable) {
            System.out.println("Problem in ErrorConnect.addButtons()!");
            throwable.printStackTrace();
        }
    }

    private static String copyright() {
        return "\n\nLicensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1999, 2000. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    }

    private void doDataExchange() {
        this.ivjJTextPaneError.setText(this.m_message);
        if (Country.getCountry(CustInfo.getInstance().getAddr().getCountryIdx()).isFaxSupported() == 1) {
            this.ivjCheckboxPrint.setText(Language.rb_241.getString(Integer.toString(2120)));
        }
        this.bgErrorConnectGroup.setSelected(this.ivjCheckboxLater.getModel(), true);
        if (RegCommandLine.getRegisterLater().equalsIgnoreCase("no")) {
            this.ivjCheckboxLater.setVisible(false);
            this.bgErrorConnectGroup.setSelected(this.ivjCheckboxStartISP.getModel(), true);
        }
    }

    public int getUserInput() {
        return this.buttonPressed;
    }

    private void initialize() {
        try {
            int n;
            this.setName("ErrorConnect");
            this.setTitle(SystemProductInfo.title);
            this.getContentPane().setLayout(null);
            this.setResizable(false);
            ((Component)this).setBackground(Color.lightGray);
            this.getContentPane().setBackground(Color.lightGray);
            this.setModal(true);
            try {
                MetalLookAndFeel metalLookAndFeel = new MetalLookAndFeel();
                MetalLookAndFeel.setCurrentTheme(new BlueMetalTheme());
                UIManager.setLookAndFeel(metalLookAndFeel);
                UIManager.put("ToolTip.background", new Color(95, 127, 191));
            }
            catch (Exception exception) {
                System.out.println("Problem setting the look and feel in ErrorConnect!");
                exception.printStackTrace();
            }
            Bounds bounds = (Bounds)Language.rb_24.getObject(Integer.toString(2407));
            Dimension dimension = bounds.returnDimension();
            Point point = bounds.returnPoint();
            ((Component)this).setSize(dimension.width, dimension.height);
            this.getContentPane().setSize(dimension.width, dimension.height);
            this.ivjJTextPaneError = new JTextPane();
            this.ivjJTextPaneError.setName("JTextPaneError");
            this.ivjJTextPaneError.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.ivjJTextPaneError.setEditable(false);
            this.ivjJTextPaneError.setMargin(new Insets(3, 5, 3, 5));
            this.ivjJTextPaneError.setBorder(null);
            this.ivjJTextPaneError.setSelectionColor(SystemColor.control);
            this.ivjJTextPaneError.setBackground(Color.lightGray);
            this.ivjJTextPaneError.setDisabledTextColor(Color.black);
            this.ivjJTextPaneError.setEnabled(false);
            this.ivjJTextPaneMessage = new JTextPane();
            this.ivjJTextPaneMessage.setName("JTextPaneMessage");
            this.ivjJTextPaneMessage.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.ivjJTextPaneMessage.setEditable(false);
            this.ivjJTextPaneMessage.setBorder(BorderFactory.createEmptyBorder(3, 0, 3, 15));
            this.ivjJTextPaneMessage.setSelectionColor(SystemColor.control);
            this.ivjJTextPaneMessage.setBackground(Color.lightGray);
            this.ivjJTextPaneMessage.setDisabledTextColor(Color.black);
            this.ivjJTextPaneMessage.setEnabled(false);
            this.ivjCheckboxLater = new JRadioButton();
            this.ivjCheckboxLater.setName("CheckboxLater");
            this.ivjCheckboxLater.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.ivjCheckboxLater.setBackground(Color.lightGray);
            this.ivjCheckboxStartISP = new JRadioButton();
            this.ivjCheckboxStartISP.setName("CheckboxStartISP");
            this.ivjCheckboxStartISP.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.ivjCheckboxStartISP.setBackground(Color.lightGray);
            this.ivjCheckboxPrint = new JRadioButton();
            this.ivjCheckboxPrint.setName("CheckboxPrint");
            this.ivjCheckboxPrint.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.ivjCheckboxPrint.setBackground(Color.lightGray);
            this.ivjCheckboxPrint.setVerticalAlignment(1);
            StrBounds strBounds = (StrBounds)Language.rb_24.getObject(Integer.toString(2244));
            StrBounds strBounds2 = (StrBounds)Language.rb_24.getObject(Integer.toString(2288));
            StrBounds strBounds3 = (StrBounds)Language.rb_24.getObject(Integer.toString(2245));
            StrBounds strBounds4 = (StrBounds)Language.rb_24.getObject(Integer.toString(2333));
            StrBounds strBounds5 = (StrBounds)Language.rb_24.getObject(Integer.toString(2246));
            if (Locale.getDefault().toString().equals("ru_RU")) {
                int n2 = 0;
                n = 0;
                Locale locale = null;
                FontMetrics fontMetrics = null;
                String string = strBounds2.returnString();
                TextBreaker textBreaker = new TextBreaker(fontMetrics, locale, n);
                String[] stringArray = textBreaker.getTextLines(string, 60);
                n2 = stringArray.length;
                string = "";
                int n3 = 0;
                while (n3 < n2) {
                    string = String.valueOf(string) + stringArray[n3] + "\n";
                    ++n3;
                }
                this.ivjJTextPaneMessage.setText(string);
            } else {
                this.ivjJTextPaneMessage.setText(strBounds2.returnString());
            }
            this.ivjCheckboxLater.setText(strBounds3.returnString());
            this.ivjCheckboxStartISP.setText(strBounds4.returnString());
            this.ivjCheckboxPrint.setText(strBounds5.returnString());
            Point point2 = strBounds.returnPoint();
            Point point3 = strBounds2.returnPoint();
            Point point4 = strBounds3.returnPoint();
            Point point5 = strBounds4.returnPoint();
            Point point6 = strBounds5.returnPoint();
            Dimension dimension2 = strBounds.returnDimension();
            Dimension dimension3 = strBounds2.returnDimension();
            Dimension dimension4 = strBounds3.returnDimension();
            Dimension dimension5 = strBounds4.returnDimension();
            Dimension dimension6 = strBounds5.returnDimension();
            this.ivjJTextPaneError.setBounds(point2.x - point.x, point2.y - (20 + point.y + 10), this.getSize().width - 20, 30);
            this.ivjJTextPaneMessage.setBounds(point3.x - point.x, point3.y - (20 + point.y + 10), dimension3.width, dimension3.height);
            this.ivjCheckboxLater.setBounds(point4.x - point.x, point4.y - (20 + point.y), dimension4.width, dimension4.height);
            this.ivjCheckboxStartISP.setBounds(point5.x - point.x, point5.y - (20 + point.y), dimension5.width, dimension5.height);
            this.ivjCheckboxPrint.setBounds(point6.x - point.x, point6.y - (20 + point.y) + 3, dimension6.width, dimension6.height);
            if (Locale.getDefault().toString().equals("ja_JP")) {
                this.ivjJTextPaneError.setBounds(point2.x - point.x, point2.y - (20 + point.y + 10), dimension2.width + 20, 40);
                this.ivjJTextPaneMessage.setBounds(point3.x - point.x, point3.y - (20 + point.y + 10), dimension3.width + 25, dimension3.height + 10);
            } else if (Locale.getDefault().toString().equals("zh_CN")) {
                this.ivjJTextPaneMessage.setBounds(point3.x - point.x, point3.y - (20 + point.y + 10), dimension3.width + 25, dimension3.height + 10);
            }
            this.bgErrorConnectGroup.add(this.ivjCheckboxLater);
            this.bgErrorConnectGroup.add(this.ivjCheckboxStartISP);
            this.bgErrorConnectGroup.add(this.ivjCheckboxPrint);
            this.getContentPane().add((Component)this.ivjJTextPaneError, this.ivjJTextPaneError.getName());
            this.getContentPane().add((Component)this.ivjJTextPaneMessage, this.ivjJTextPaneMessage.getName());
            this.getContentPane().add((Component)this.ivjCheckboxLater, this.ivjCheckboxLater.getName());
            this.getContentPane().add((Component)this.ivjCheckboxStartISP, this.ivjCheckboxStartISP.getName());
            this.getContentPane().add((Component)this.ivjCheckboxPrint, this.ivjCheckboxPrint.getName());
            this.addButtons();
            this.ivjButtonOK.addActionListener(this);
            this.ivjButtonCancel.addActionListener(this);
            this.ivjCheckboxLater.addActionListener(this);
            this.ivjCheckboxStartISP.addActionListener(this);
            this.ivjCheckboxPrint.addActionListener(this);
            this.getRootPane().setDefaultButton(this.ivjButtonOK);
            Dimension dimension7 = this.getSize();
            Dimension dimension8 = Toolkit.getDefaultToolkit().getScreenSize();
            n = dimension8.height / 2 - dimension7.height / 2;
            int n4 = dimension8.width / 2 - dimension7.width / 2;
            ((Component)this).setLocation(n4, n);
        }
        catch (Throwable throwable) {
            System.out.println("Problem with ErrorConnect.initialize()!");
            throwable.printStackTrace();
        }
    }

    private void onCancel() {
        this.buttonPressed = 2;
        ((Component)this).setVisible(false);
    }

    private void onOK() {
        this.buttonPressed = 0;
        ((Component)this).setVisible(false);
    }

    private void onRADIOPrint() {
        this.m_custInfo.setRadioPrint();
        this.m_regLater = -2;
    }

    private void onRADIORegisterLater() {
        this.m_custInfo.setRadioRegister();
        this.m_regLater = 0;
    }

    private void onRADIOStartISP() {
        this.m_custInfo.setRadioStartISP();
        this.m_regLater = -1;
    }

    public void setMessage(String string) {
        this.ivjJTextPaneError.setText(string);
    }
}

