/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lexington.prt;

import com.ibm.lexington.prt.BlueMetalTheme;
import com.ibm.lexington.prt.CustInfo;
import com.ibm.lexington.prt.Language;
import com.ibm.lexington.prt.RegCommandLine;
import com.ibm.lexington.prt.SysInfo;
import com.ibm.lexington.prt.SystemProductInfo;
import com.ibm.lexington.prt.Utility;
import com.ibm.lexington.prt.res.Bounds;
import com.ibm.lexington.prt.res.StrBounds;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class ExitConfirm
extends JDialog
implements ActionListener {
    private JPanel ivjExitConfirmContentPane;
    private FlowLayout ivjExitConfirmTextPanePanelFlowLayout;
    private JPanel ivjExitConfirmTextPanePanel;
    private JTextPane ivjExitConfirmTextPane;
    private JPanel ivjExitConfirmButtonPanel;
    private FlowLayout ivjExitConfirmButtonPanelFlowLayout;
    private JCheckBox m_exitCheckLaterControl;
    private boolean m_exitCheckLater;
    private JButton ivjExitConfirmButtonYes;
    private JButton ivjExitConfirmButtonNo;
    private int buttonPressed;

    public ExitConfirm(JFrame jFrame) {
        super(jFrame, SystemProductInfo.title, true);
        CustInfo custInfo = CustInfo.getInstance();
        this.m_exitCheckLater = custInfo.getCheckRegisterLater();
        this.initialize();
        this.doDataExchange();
        ((Component)this).setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.ivjExitConfirmButtonYes) {
            this.onYes();
        }
        if (actionEvent.getSource() == this.ivjExitConfirmButtonNo) {
            this.onNo();
        }
    }

    private static String copyright() {
        return "\n\nLicensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1999, 2000. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    }

    private void doDataExchange() {
        if (RegCommandLine.getRegisterLater().equalsIgnoreCase("no")) {
            this.m_exitCheckLaterControl.setVisible(false);
        }
        this.m_exitCheckLaterControl.setSelected(this.m_exitCheckLater);
    }

    public int getUserInput() {
        return this.buttonPressed;
    }

    private void initialize() {
        try {
            try {
                MetalLookAndFeel metalLookAndFeel = new MetalLookAndFeel();
                MetalLookAndFeel.setCurrentTheme(new BlueMetalTheme());
                UIManager.setLookAndFeel(metalLookAndFeel);
                UIManager.put("ToolTip.background", new Color(95, 127, 191));
            }
            catch (Exception exception) {
                System.out.println("Problem setting up the Look and Feel!");
                exception.printStackTrace();
            }
            this.setName("ExitConfirmDialog");
            this.setResizable(false);
            ((Component)this).setBackground(Color.lightGray);
            Bounds bounds = (Bounds)Language.rb_24.getObject(Integer.toString(2406));
            Dimension dimension = bounds.returnDimension();
            int n = Utility.determineTextDimensions((Component)this, (String)SystemProductInfo.title).width + 90;
            if (n > dimension.width) {
                dimension.width = n;
            }
            Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
            int n2 = dimension2.width / 2 - dimension.width / 2;
            int n3 = dimension2.height / 2 - dimension.height / 2;
            ((Component)this).setBounds(n2, n3, dimension.width, dimension.height);
            StrBounds strBounds = (StrBounds)Language.rb_24.getObject(Integer.toString(2243));
            StrBounds strBounds2 = (StrBounds)Language.rb_24.getObject(Integer.toString(2319));
            StrBounds strBounds3 = (StrBounds)Language.rb_24.getObject(Integer.toString(2328));
            StrBounds strBounds4 = (StrBounds)Language.rb_24.getObject(Integer.toString(2329));
            this.ivjExitConfirmTextPane = new JTextPane();
            this.ivjExitConfirmTextPane.setName("ExitConfirmTextPane");
            this.ivjExitConfirmTextPane.setAutoscrolls(false);
            this.ivjExitConfirmTextPane.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.ivjExitConfirmTextPane.setEditable(false);
            this.ivjExitConfirmTextPane.setEnabled(false);
            this.ivjExitConfirmTextPane.setRequestFocusEnabled(false);
            this.ivjExitConfirmTextPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 20));
            this.ivjExitConfirmTextPane.setSelectionColor(SystemColor.control);
            this.ivjExitConfirmTextPane.setBackground(Color.lightGray);
            this.ivjExitConfirmTextPane.setDisabledTextColor(Color.black);
            this.ivjExitConfirmTextPane.setPreferredSize(new Dimension(dimension.width, 64));
            this.ivjExitConfirmTextPanePanelFlowLayout = new FlowLayout();
            this.ivjExitConfirmTextPanePanel = new JPanel();
            this.ivjExitConfirmTextPanePanel.setName("ExitConfirmTextPanePanel");
            this.ivjExitConfirmTextPanePanel.setLayout(this.ivjExitConfirmTextPanePanelFlowLayout);
            this.ivjExitConfirmTextPanePanel.setBackground(Color.lightGray);
            this.ivjExitConfirmTextPanePanel.add((Component)this.ivjExitConfirmTextPane, this.ivjExitConfirmTextPane.getName());
            this.m_exitCheckLaterControl = new JCheckBox(strBounds2.returnString(), true);
            this.m_exitCheckLaterControl.setName("ExitConfirmCheckBox");
            this.m_exitCheckLaterControl.setHorizontalAlignment(0);
            this.m_exitCheckLaterControl.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.m_exitCheckLaterControl.setBackground(Color.lightGray);
            this.m_exitCheckLaterControl.setMargin(new Insets(2, 20, 2, 2));
            this.ivjExitConfirmButtonYes = new JButton(strBounds3.returnString());
            this.ivjExitConfirmButtonYes.setName("ExitConfirmButtonYes");
            this.ivjExitConfirmButtonYes.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.ivjExitConfirmButtonYes.setBackground(Color.lightGray);
            this.ivjExitConfirmButtonNo = new JButton(strBounds4.returnString());
            this.ivjExitConfirmButtonNo.setName("ExitConfirmButtonNo");
            this.ivjExitConfirmButtonNo.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.ivjExitConfirmButtonNo.setBackground(Color.lightGray);
            this.ivjExitConfirmButtonPanelFlowLayout = new FlowLayout();
            this.ivjExitConfirmButtonPanelFlowLayout.setHgap(20);
            this.ivjExitConfirmButtonPanel = new JPanel();
            this.ivjExitConfirmButtonPanel.setName("ExitConfirmButtonPanel");
            this.ivjExitConfirmButtonPanel.setLayout(this.ivjExitConfirmButtonPanelFlowLayout);
            this.ivjExitConfirmButtonPanel.setBackground(Color.lightGray);
            this.ivjExitConfirmButtonPanel.add((Component)this.ivjExitConfirmButtonYes, this.ivjExitConfirmButtonYes.getName());
            this.ivjExitConfirmButtonPanel.add((Component)this.ivjExitConfirmButtonNo, this.ivjExitConfirmButtonNo.getName());
            this.ivjExitConfirmContentPane = new JPanel();
            this.ivjExitConfirmContentPane.setName("ExitConfirmContentPane");
            this.ivjExitConfirmContentPane.setLayout(new BorderLayout());
            this.ivjExitConfirmContentPane.setBackground(Color.lightGray);
            this.ivjExitConfirmContentPane.add((Component)this.ivjExitConfirmTextPanePanel, "North");
            this.ivjExitConfirmContentPane.add((Component)this.m_exitCheckLaterControl, "West");
            this.ivjExitConfirmContentPane.add((Component)this.ivjExitConfirmButtonPanel, "South");
            this.setContentPane(this.ivjExitConfirmContentPane);
            this.ivjExitConfirmTextPane.setText(strBounds.returnString());
            this.ivjExitConfirmButtonYes.addActionListener(this);
            this.ivjExitConfirmButtonNo.addActionListener(this);
            this.getRootPane().setDefaultButton(this.ivjExitConfirmButtonNo);
        }
        catch (Throwable throwable) {
            System.out.println("Problem in ExitConfirm.initialize()!");
            throwable.printStackTrace();
        }
    }

    private void onNo() {
        boolean bl = this.m_exitCheckLaterControl.isSelected();
        CustInfo custInfo = CustInfo.getInstance();
        custInfo.setCheckRegisterLater(bl);
        this.buttonPressed = 1;
        ((Component)this).setVisible(false);
    }

    private void onYes() {
        boolean bl = this.m_exitCheckLaterControl.isSelected();
        if (bl) {
            SysInfo.reschedule(14, 0, 0);
        }
        this.buttonPressed = 0;
        ((Component)this).setVisible(false);
    }
}

