/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lexington.prt;

import com.ibm.lexington.prt.AddInfo;
import com.ibm.lexington.prt.Answer;
import com.ibm.lexington.prt.Brand;
import com.ibm.lexington.prt.CustInfo;
import com.ibm.lexington.prt.QuestionComboBox;
import com.ibm.lexington.prt.Questions;
import com.ibm.lexington.prt.SysInfo;
import java.text.CollationKey;
import java.text.Collator;
import java.util.Locale;
import java.util.Vector;

public class HomeBusinessQuestions
extends Questions {
    Vector[] homeAnswers = new Vector[]{new Vector(), new Vector(), new Vector()};
    Vector[] businessAnswers = new Vector[]{new Vector(), new Vector(), new Vector()};
    private static final String PRTHomeBusinessName = "q18";
    private static final String PRTHomeBusinessToken = "7518";
    private QuestionComboBox[] m_pHomeQuestions;
    private QuestionComboBox[] m_pBusinessQuestions;
    private QuestionComboBox[] m_activeQuestions;
    private int m_hb;
    private int[] m_CurrentQuestions;
    private String m_strHomeBusinessSelection;

    public HomeBusinessQuestions(AddInfo addInfo, int n) {
        super(addInfo);
        this.m_hb = n;
        this.m_activeQuestions = null;
        this.m_strHomeBusinessSelection = "BUSI";
        this.initialize();
        this.doDataExchange();
    }

    private static String copyright() {
        return "\n\nLicensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1999, 2000. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    }

    public void doDataExchange() {
        Brand brand = Brand.getBrand();
        int n = brand.maxNumberOfQuestions();
        CustInfo custInfo = CustInfo.getInstance();
        this.m_strHomeBusinessSelection = custInfo.getQuestionValue(PRTHomeBusinessName);
        if (this.m_strHomeBusinessSelection.length() == 0) {
            this.readRegistry();
        }
        if (this.m_strHomeBusinessSelection.length() == 0) {
            this.m_strHomeBusinessSelection = brand.homeBusinessDefault();
        }
        if (this.m_strHomeBusinessSelection.equalsIgnoreCase("BUSI")) {
            this.addInfo.bgHomeBusinessGroup.setSelected(this.addInfo.rbJRadioButtonBusiness.getModel(), true);
            this.m_hb = 1;
        } else if (this.m_strHomeBusinessSelection.equalsIgnoreCase("HOME")) {
            this.addInfo.bgHomeBusinessGroup.setSelected(this.addInfo.rbJRadioButtonHome.getModel(), true);
            this.m_hb = 0;
        } else if (this.m_strHomeBusinessSelection.equalsIgnoreCase("HOBU")) {
            this.addInfo.bgHomeBusinessGroup.setSelected(this.addInfo.rbJRadioButtonHomeBus.getModel(), true);
            this.m_hb = 3;
        }
        int n2 = 0;
        while (n2 < n) {
            String string = custInfo.getQuestionValue(this.m_pHomeQuestions[n2].getName());
            if (string.length() == 0) {
                this.m_pHomeQuestions[n2].readRegistry();
                this.m_pHomeQuestions[n2].setPreviousAnswer();
            } else {
                this.m_pHomeQuestions[n2].setAnswerText(string);
            }
            string = custInfo.getQuestionValue(this.m_pBusinessQuestions[n2].getName());
            if (string.length() == 0) {
                this.m_pBusinessQuestions[n2].readRegistry();
                this.m_pBusinessQuestions[n2].setPreviousAnswer();
            } else {
                this.m_pBusinessQuestions[n2].setAnswerText(string);
            }
            ++n2;
        }
        this.setHomeBusiness(this.m_hb);
    }

    public String format() {
        Brand brand = Brand.getBrand();
        int n = brand.maxNumberOfQuestions();
        String string = "&q18=" + this.m_strHomeBusinessSelection;
        int n2 = 0;
        while (n2 < n) {
            string = String.valueOf(string) + "&";
            string = String.valueOf(string) + this.m_pHomeQuestions[n2].format(this.m_hb == 0 || this.m_hb == 3);
            string = String.valueOf(string) + "&";
            string = String.valueOf(string) + this.m_pBusinessQuestions[n2].format(this.m_hb == 1);
            ++n2;
        }
        return string;
    }

    public void initialize() {
        Object e;
        Object e2;
        CollationKey collationKey;
        int n;
        int n2;
        CollationKey[] collationKeyArray;
        int n3;
        new Answer(525, "", "", this.homeAnswers[0], 0);
        new Answer(901, "ADV", "1", this.homeAnswers[0], 0);
        new Answer(902, "ART", "2", this.homeAnswers[0], 0);
        new Answer(903, "BRND", "3", this.homeAnswers[0], 0);
        new Answer(904, "FUNC", "4", this.homeAnswers[0], 0);
        new Answer(905, "INFO", "5", this.homeAnswers[0], 0);
        new Answer(906, "MKTG", "6", this.homeAnswers[0], 0);
        new Answer(907, "PRCE", "7", this.homeAnswers[0], 0);
        new Answer(908, "PDEM", "8", this.homeAnswers[0], 0);
        new Answer(909, "RECM", "9", this.homeAnswers[0], 0);
        new Answer(910, "SALE", "10", this.homeAnswers[0], 0);
        new Answer(525, "", "", this.homeAnswers[1], 0);
        new Answer(926, "EMAL", "1", this.homeAnswers[1], 0);
        new Answer(927, "TELE", "2", this.homeAnswers[1], 0);
        new Answer(928, "WEB", "3", this.homeAnswers[1], 0);
        new Answer(929, "CATL", "4", this.homeAnswers[1], 0);
        new Answer(930, "PCOT", "5", this.homeAnswers[1], 0);
        new Answer(931, "RET", "6", this.homeAnswers[1], 0);
        new Answer(525, "", "", this.homeAnswers[2], 0);
        new Answer(951, "COLL", "1", this.homeAnswers[2], 0);
        new Answer(952, "HOME", "2", this.homeAnswers[2], 0);
        new Answer(953, "OPHO", "3", this.homeAnswers[2], 0);
        new Answer(954, "RET", "4", this.homeAnswers[2], 0);
        new Answer(955, "SELF", "5", this.homeAnswers[2], 0);
        new Answer(956, "STDT", "6", this.homeAnswers[2], 0);
        new Answer(957, "WOHO", "7", this.homeAnswers[2], 0);
        Collator collator = Collator.getInstance(Locale.getDefault());
        collator.setStrength(1);
        int n4 = 0;
        while (n4 < 3) {
            n3 = this.homeAnswers[n4].size();
            collationKeyArray = new CollationKey[n3];
            n2 = 0;
            while (n2 < n3) {
                collationKeyArray[n2] = collator.getCollationKey(((Answer)this.homeAnswers[n4].elementAt(n2)).toString());
                ++n2;
            }
            n2 = 0;
            while (n2 < n3 - 1) {
                n = n2 + 1;
                while (n < n3) {
                    if (collationKeyArray[n2].compareTo(collationKeyArray[n]) > 0) {
                        collationKey = collationKeyArray[n2];
                        e2 = this.homeAnswers[n4].elementAt(n2);
                        e = this.homeAnswers[n4].elementAt(n);
                        this.homeAnswers[n4].removeElementAt(n);
                        this.homeAnswers[n4].removeElementAt(n2);
                        collationKeyArray[n2] = collationKeyArray[n];
                        this.homeAnswers[n4].insertElementAt(e, n2);
                        collationKeyArray[n] = collationKey;
                        this.homeAnswers[n4].insertElementAt(e2, n);
                    }
                    ++n;
                }
                ++n2;
            }
            ++n4;
        }
        new Answer(525, "", "", this.businessAnswers[0], 0);
        new Answer(751, "ACCT", "1", this.businessAnswers[0], 0);
        new Answer(752, "ADMI", "2", this.businessAnswers[0], 0);
        new Answer(753, "ANLY", "3", this.businessAnswers[0], 0);
        new Answer(754, "ATTY", "4", this.businessAnswers[0], 0);
        new Answer(755, "CEO", "6", this.businessAnswers[0], 0);
        new Answer(756, "CIO", "7", this.businessAnswers[0], 0);
        new Answer(757, "CONS", "8", this.businessAnswers[0], 0);
        new Answer(758, "DIRE", "9", this.businessAnswers[0], 0);
        new Answer(759, "DOCT", "10", this.businessAnswers[0], 0);
        new Answer(760, "EDUC", "11", this.businessAnswers[0], 0);
        new Answer(761, "ENGI", "12", this.businessAnswers[0], 0);
        new Answer(762, "MANA", "13", this.businessAnswers[0], 0);
        new Answer(763, "NETM", "14", this.businessAnswers[0], 0);
        new Answer(764, "OFFM", "15", this.businessAnswers[0], 0);
        new Answer(765, "PRES", "16", this.businessAnswers[0], 0);
        new Answer(766, "PROG", "17", this.businessAnswers[0], 0);
        new Answer(767, "PROJ", "18", this.businessAnswers[0], 0);
        new Answer(768, "BUYR", "5", this.businessAnswers[0], 0);
        new Answer(769, "SREP", "21", this.businessAnswers[0], 0);
        new Answer(770, "SCNT", "19", this.businessAnswers[0], 0);
        new Answer(771, "SPEC", "20", this.businessAnswers[0], 0);
        new Answer(772, "STAF", "22", this.businessAnswers[0], 0);
        new Answer(773, "STUD", "23", this.businessAnswers[0], 0);
        new Answer(774, "SUPE", "24", this.businessAnswers[0], 0);
        new Answer(775, "SYAD", "25", this.businessAnswers[0], 0);
        new Answer(776, "TREA", "26", this.businessAnswers[0], 0);
        new Answer(777, "VICE", "27", this.businessAnswers[0], 0);
        new Answer(778, "WEBM", "28", this.businessAnswers[0], 0);
        new Answer(525, "", "", this.businessAnswers[1], 0);
        new Answer(801, "AGRC", "1", this.businessAnswers[1], 0);
        new Answer(802, "BANK", "2", this.businessAnswers[1], 0);
        new Answer(803, "CSTR", "5", this.businessAnswers[1], 0);
        new Answer(804, "CONS", "3", this.businessAnswers[1], 0);
        new Answer(805, "CPRD", "4", this.businessAnswers[1], 0);
        new Answer(806, "EDUC", "6", this.businessAnswers[1], 0);
        new Answer(807, "GOVF", "9", this.businessAnswers[1], 0);
        new Answer(808, "FINL", "7", this.businessAnswers[1], 0);
        new Answer(809, "GOIL", "8", this.businessAnswers[1], 0);
        new Answer(810, "GOVT", "10", this.businessAnswers[1], 0);
        new Answer(811, "HCAR", "11", this.businessAnswers[1], 0);
        new Answer(812, "HTEC", "12", this.businessAnswers[1], 0);
        new Answer(813, "INDP", "13", this.businessAnswers[1], 0);
        new Answer(814, "INSU", "14", this.businessAnswers[1], 0);
        new Answer(815, "MANF", "15", this.businessAnswers[1], 0);
        new Answer(816, "MKTG", "16", this.businessAnswers[1], 0);
        new Answer(817, "NONP", "17", this.businessAnswers[1], 0);
        new Answer(818, "PROF", "18", this.businessAnswers[1], 0);
        new Answer(819, "PUBL", "19", this.businessAnswers[1], 0);
        new Answer(820, "REAL", "20", this.businessAnswers[1], 0);
        new Answer(821, "RETL", "21", this.businessAnswers[1], 0);
        new Answer(822, "TELE", "22", this.businessAnswers[1], 0);
        new Answer(823, "TRAN", "23", this.businessAnswers[1], 0);
        new Answer(824, "TRAV", "24", this.businessAnswers[1], 0);
        new Answer(525, "", "", this.businessAnswers[2], 0);
        new Answer(851, "1-9", "1", this.businessAnswers[2], 0);
        new Answer(852, "10-24", "2", this.businessAnswers[2], 0);
        new Answer(853, "25-49", "5", this.businessAnswers[2], 0);
        new Answer(854, "50-99", "10", this.businessAnswers[2], 0);
        new Answer(855, "100-249", "3", this.businessAnswers[2], 0);
        new Answer(856, "250-499", "6", this.businessAnswers[2], 0);
        new Answer(857, "500-999", "11", this.businessAnswers[2], 0);
        new Answer(858, "1K-1999", "4", this.businessAnswers[2], 0);
        new Answer(859, "2K-2999", "7", this.businessAnswers[2], 0);
        new Answer(860, "3K-3999", "8", this.businessAnswers[2], 0);
        new Answer(861, "4K-4999", "9", this.businessAnswers[2], 0);
        new Answer(862, "5000+", "12", this.businessAnswers[2], 0);
        new Answer(863, "UNKN", "13", this.businessAnswers[2], 0);
        n4 = 0;
        while (n4 < 2) {
            n3 = this.businessAnswers[n4].size();
            collationKeyArray = new CollationKey[n3];
            n2 = 0;
            while (n2 < n3) {
                collationKeyArray[n2] = collator.getCollationKey(((Answer)this.businessAnswers[n4].elementAt(n2)).toString());
                ++n2;
            }
            n2 = 0;
            while (n2 < n3 - 1) {
                n = n2 + 1;
                while (n < n3) {
                    if (collationKeyArray[n2].compareTo(collationKeyArray[n]) > 0) {
                        collationKey = collationKeyArray[n2];
                        e2 = this.businessAnswers[n4].elementAt(n2);
                        e = this.businessAnswers[n4].elementAt(n);
                        this.businessAnswers[n4].removeElementAt(n);
                        this.businessAnswers[n4].removeElementAt(n2);
                        collationKeyArray[n2] = collationKeyArray[n];
                        this.businessAnswers[n4].insertElementAt(e, n2);
                        collationKeyArray[n] = collationKey;
                        this.businessAnswers[n4].insertElementAt(e2, n);
                    }
                    ++n;
                }
                ++n2;
            }
            ++n4;
        }
        new Answer(779, "OTHR", "29", this.businessAnswers[0], -1);
        new Answer(825, "OTHR", "25", this.businessAnswers[1], -1);
        Brand brand = Brand.getBrand();
        this.m_pHomeQuestions = new QuestionComboBox[]{new QuestionComboBox(brand.id(0, 0), brand.name(0, 0), brand.token(0, 0), this.homeAnswers[0], true, 2302, 2227, this.addInfo), new QuestionComboBox(brand.id(1, 0), brand.name(1, 0), brand.token(1, 0), this.homeAnswers[1], true, 2274, 2228, this.addInfo), new QuestionComboBox(brand.id(2, 0), brand.name(2, 0), brand.token(2, 0), this.homeAnswers[2], true, 2275, 2229, this.addInfo)};
        this.m_pBusinessQuestions = new QuestionComboBox[]{new QuestionComboBox(brand.id(0, 1), brand.name(0, 1), brand.token(0, 1), this.businessAnswers[0], true, 2302, 2227, this.addInfo), new QuestionComboBox(brand.id(1, 1), brand.name(1, 1), brand.token(1, 1), this.businessAnswers[1], true, 2274, 2228, this.addInfo), new QuestionComboBox(brand.id(2, 1), brand.name(2, 1), brand.token(2, 1), this.businessAnswers[2], false, 2275, 2229, this.addInfo)};
    }

    public void readRegistry() {
        Brand brand = Brand.getBrand();
        this.m_strHomeBusinessSelection = SysInfo.getInstance().readRegistryString(brand.getBrandSection(), PRTHomeBusinessName);
    }

    public void saveInfo() {
        CustInfo custInfo = CustInfo.getInstance();
        Brand brand = Brand.getBrand();
        int n = brand.maxNumberOfQuestions();
        custInfo.setQuestionValue(PRTHomeBusinessName, this.m_strHomeBusinessSelection);
        if (this.m_strHomeBusinessSelection == "HOME") {
            custInfo.setPrintValue(PRTHomeBusinessToken, "1");
        } else if (this.m_strHomeBusinessSelection == "BUSI") {
            custInfo.setPrintValue(PRTHomeBusinessToken, "2");
        } else if (this.m_strHomeBusinessSelection == "HOBU") {
            custInfo.setPrintValue(PRTHomeBusinessToken, "3");
        }
        int n2 = 0;
        while (n2 < n) {
            custInfo.setQuestionValue(this.m_pHomeQuestions[n2].getName(), this.m_pHomeQuestions[n2].getAnswerText());
            custInfo.setQuestionValue(this.m_pBusinessQuestions[n2].getName(), this.m_pBusinessQuestions[n2].getAnswerText());
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            if (this.m_hb == 0 || this.m_hb == 3) {
                custInfo.setPrintValue(this.m_pHomeQuestions[n2].getToken(), this.m_pHomeQuestions[n2].getAnswerPrintedFormValue());
            } else {
                custInfo.setPrintValue(this.m_pHomeQuestions[n2].getToken(), "");
            }
            if (this.m_hb == 1) {
                custInfo.setPrintValue(this.m_pBusinessQuestions[n2].getToken(), this.m_pBusinessQuestions[n2].getAnswerPrintedFormValue());
            } else {
                custInfo.setPrintValue(this.m_pBusinessQuestions[n2].getToken(), "");
            }
            ++n2;
        }
    }

    public void setHomeBusiness(int n) {
        int n2;
        Brand brand = Brand.getBrand();
        int n3 = brand.maxNumberOfQuestions();
        if (this.m_activeQuestions != null) {
            n2 = 0;
            while (n2 < n3) {
                this.m_activeQuestions[n2].deActivate();
                ++n2;
            }
        }
        this.m_hb = n;
        switch (this.m_hb) {
            case 1: {
                this.m_strHomeBusinessSelection = "BUSI";
                break;
            }
            case 0: {
                this.m_strHomeBusinessSelection = "HOME";
                break;
            }
            case 3: {
                this.m_strHomeBusinessSelection = "HOBU";
            }
        }
        switch (n) {
            case 1: {
                this.m_activeQuestions = this.m_pBusinessQuestions;
                break;
            }
            case 0: 
            case 3: {
                this.m_activeQuestions = this.m_pHomeQuestions;
            }
        }
        if (this.m_activeQuestions != null) {
            n2 = 0;
            while (n2 < n3) {
                if (this.m_activeQuestions[n2] != null) {
                    this.m_activeQuestions[n2].activate();
                }
                ++n2;
            }
        }
    }

    public void writeRegistry() {
        Brand brand = Brand.getBrand();
        int n = brand.maxNumberOfQuestions();
        QuestionComboBox[] questionComboBoxArray = null;
        SysInfo.getInstance().writeRegistryString(brand.getBrandSection(), PRTHomeBusinessName, this.m_strHomeBusinessSelection);
        switch (this.m_hb) {
            case 1: {
                questionComboBoxArray = this.m_pBusinessQuestions;
                break;
            }
            case 0: 
            case 3: {
                questionComboBoxArray = this.m_pHomeQuestions;
            }
        }
        if (questionComboBoxArray != null) {
            int n2 = 0;
            while (n2 < n) {
                if (questionComboBoxArray[n2] != null) {
                    questionComboBoxArray[n2].writeRegistry();
                }
                ++n2;
            }
        }
    }
}

