/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lexington.prt;

import com.ibm.lexington.prt.BusyDlg;
import com.ibm.lexington.prt.HttpAIX;
import com.ibm.lexington.prt.HttpLinux;
import com.ibm.lexington.prt.HttpOS2;
import com.ibm.lexington.prt.HttpWindows;
import com.ibm.lexington.prt.Language;
import com.ibm.lexington.prt.RegCommandLine;
import com.ibm.lexington.prt.RegException;
import com.ibm.lexington.prt.SysInfo;
import com.ibm.lexington.prt.URLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Hashtable;
import javax.swing.JFrame;

public abstract class HttpService
extends Thread {
    static boolean canceled = false;
    protected JFrame parent;
    private StringBuffer returnMsg = new StringBuffer();
    private static String strServerName;
    private static String cgiCmd;
    static final int CONNTYPE_DIRECT = 1;
    static final int CONNTYPE_AUTO = 2;
    static final int CONNTYPE_SOCKS = 3;
    static final int CONNTYPE_PROXY = 4;
    protected static int m_iConnType;
    static String m_strProxyType;
    static String m_strProxyAddress;
    static String m_strProxyPort;
    static String m_strSocksAddress;
    static String m_strSocksPort;
    static String m_strAutoConfigURL;
    private String m_postMsg;
    private RegException m_pException = null;
    private Thread m_pConnectionThread;
    private BusyDlg m_BusyDlg;

    static {
        cgiCmd = "/scripts/mwisapi.dll/Service.Gateway.DoGet?";
        m_iConnType = 1;
        m_strProxyType = "";
        m_strProxyAddress = "";
        m_strProxyPort = "";
        m_strSocksAddress = "";
        m_strSocksPort = "";
        m_strAutoConfigURL = "";
    }

    public boolean canceled() {
        if (canceled) {
            System.out.println("User canceled connection");
        }
        return canceled;
    }

    private static String copyright() {
        return "\n\nLicensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1999, 2000. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    }

    protected int getAutoConfigInfo() {
        CharSequence charSequence;
        Object object;
        Object object2;
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 1;
        String string2 = m_strAutoConfigURL;
        string2 = HttpService.stripHttp(string2);
        int n2 = string2.indexOf("/");
        String string3 = "";
        if (n2 != -1) {
            string3 = string2.substring(n2);
            string2 = string2.substring(0, n2);
        }
        if (string3.length() == 0) {
            string3 = "http://" + string2;
        }
        String string4 = "";
        n2 = string2.indexOf(":");
        if (n2 != -1) {
            string4 = string2.substring(n2 + 1);
            string2 = string2.substring(0, n2);
        }
        if (string4.length() == 0) {
            string4 = "80";
        }
        try {
            object2 = null;
            object2 = new Socket(string2, Integer.parseInt(string4));
            PrintWriter printWriter = new PrintWriter(((Socket)object2).getOutputStream());
            object = new BufferedReader(new InputStreamReader(((Socket)object2).getInputStream()));
            String string5 = "GET " + string3;
            printWriter.println(string5);
            printWriter.flush();
            string = ((BufferedReader)object).readLine();
            while (string != null) {
                if (string.length() > 0) {
                    stringBuffer.append(string);
                }
                string = ((BufferedReader)object).readLine();
            }
            ((BufferedReader)object).close();
            printWriter.close();
            ((Socket)object2).close();
        }
        catch (UnknownHostException unknownHostException) {
            System.out.println("Autoproxyserver Host is unknown.");
        }
        catch (IOException iOException) {
            System.out.println("IOException when reading from autoproxy socket");
        }
        object2 = new String("return \"DIRECT\"");
        int n3 = stringBuffer.toString().indexOf((String)object2);
        if (n3 != -1) {
            n = 1;
        }
        object = new String("return \"PROXY");
        n3 = stringBuffer.toString().lastIndexOf((String)object);
        if (n3 != -1) {
            n = 4;
            charSequence = new StringBuffer();
            n3 += 14;
            while (stringBuffer.charAt(n3) != '\"') {
                ((StringBuffer)charSequence).append(stringBuffer.charAt(n3));
                ++n3;
            }
            System.out.println("PROXY: " + charSequence);
            n3 = ((StringBuffer)charSequence).toString().indexOf(":");
            if (n3 != -1) {
                m_strProxyPort = ((StringBuffer)charSequence).toString().substring(n3 + 1);
                m_strProxyAddress = ((StringBuffer)charSequence).toString().substring(0, n3);
            } else {
                m_strProxyAddress = ((StringBuffer)charSequence).toString();
            }
        }
        charSequence = new String("return \"SOCKS");
        n3 = stringBuffer.toString().lastIndexOf((String)charSequence);
        if (n3 != -1) {
            n = 3;
            StringBuffer stringBuffer2 = new StringBuffer();
            n3 += 14;
            while (stringBuffer.charAt(n3) != '\"') {
                stringBuffer2.append(stringBuffer.charAt(n3));
                ++n3;
            }
            System.out.println("SOCKS: " + stringBuffer2);
            n3 = stringBuffer2.toString().indexOf(":");
            if (n3 != -1) {
                m_strSocksPort = stringBuffer2.toString().substring(n3 + 1);
                m_strSocksAddress = stringBuffer2.toString().substring(0, n3);
            } else {
                m_strSocksAddress = stringBuffer2.toString();
            }
        }
        return n;
    }

    public abstract void getFirewallInfo();

    public static HttpService getInstance(JFrame jFrame) {
        canceled = false;
        if (SysInfo.getOSPlatform().equals("AIX")) {
            return new HttpAIX(jFrame);
        }
        if (SysInfo.getOSPlatform().startsWith("WINDOWS")) {
            return new HttpWindows(jFrame);
        }
        if (SysInfo.getOSPlatform().equals("OS/2")) {
            return new HttpOS2(jFrame);
        }
        if (SysInfo.getOSPlatform().equals("LINUX")) {
            return new HttpLinux(jFrame);
        }
        return null;
    }

    public String parsePrefsStrs(String string, String string2) {
        int n = 0;
        String string3 = "";
        string2 = string2.toUpperCase();
        String string4 = string.toUpperCase();
        n = string4.indexOf(string2);
        if (n != -1 && (n = string.indexOf(",", n)) != -1) {
            string3 = string.substring(n);
            string3 = string3.replace(',', ' ');
            string3 = string3.replace('\"', ' ');
            string3 = string3.replace(')', ' ');
            string3 = string3.replace(';', ' ');
            string3 = string3.trim();
            string3 = HttpService.stripHttp(string3);
        }
        return string3;
    }

    public void postTheMsg() throws RegException {
        String string = RegCommandLine.getConnect();
        strServerName = string.equalsIgnoreCase("Direct") ? "http://ibm.registration.globalsupport.com/" : (string.equalsIgnoreCase("DirectIP") ? "http://207.51.66.55/" : "http://" + Language.rb_comall.getString(Integer.toString(307)));
        this.m_BusyDlg = new BusyDlg(this.parent);
        this.m_pConnectionThread = new Thread(this);
        this.m_pConnectionThread.start();
        if (this.m_BusyDlg != null) {
            this.m_BusyDlg.show();
        }
        if (canceled) {
            String string2 = Language.rb_24.getString(Integer.toString(245));
            this.m_pException = new RegException(219, string2);
            throw this.m_pException;
        }
        if (this.returnMsg.toString().toUpperCase().indexOf("RESULT1=SUCCESS") == -1) {
            System.out.println("TRANSMISSION FAILURE");
            String string3 = Language.rb.getString(Integer.toString(1511));
            this.m_pException = new RegException(219, string3);
            throw this.m_pException;
        }
        System.out.println("TRANSMISSION SUCCESS");
    }

    public void run() {
        if (this.canceled()) {
            return;
        }
        this.getFirewallInfo();
        if (this.canceled()) {
            return;
        }
        if (m_iConnType == 2) {
            System.out.println("Connection type: Autoconfig URL");
            System.out.println("Autoconfig URL: " + m_strAutoConfigURL);
            m_iConnType = this.getAutoConfigInfo();
        }
        if (this.canceled()) {
            return;
        }
        if (m_iConnType == 1) {
            System.out.println("Connecting via direct.");
        } else if (m_iConnType == 3) {
            System.out.println("Connecting via socks.");
            System.out.println("Server:" + m_strSocksAddress);
            System.out.println("Port:" + m_strSocksPort);
            this.setSocksProp(m_strSocksAddress, m_strSocksPort);
        } else if (m_iConnType == 4) {
            System.out.println("Connecting via proxy.");
            System.out.println("Server:" + m_strProxyAddress);
            System.out.println("Port:" + m_strProxyPort);
            this.setProxyProp(m_strProxyAddress, m_strProxyPort);
        }
        if (this.canceled()) {
            return;
        }
        String string = String.valueOf(strServerName) + cgiCmd + URLEncoder.encode(this.m_postMsg);
        if (this.canceled()) {
            return;
        }
        try {
            int n;
            System.out.println("strSendString:" + string);
            URL uRL = new URL(string);
            URLConnection uRLConnection = uRL.openConnection();
            BufferedInputStream bufferedInputStream = (BufferedInputStream)uRLConnection.getContent();
            while ((n = bufferedInputStream.read()) > 0) {
                this.returnMsg.append((char)n);
            }
            System.out.println("Returned code: " + ((HttpURLConnection)uRLConnection).getResponseCode());
            System.out.println("Returned Msg:" + this.returnMsg);
        }
        catch (Exception exception) {
            System.out.println("Receive URL:" + exception);
        }
        this.m_BusyDlg.dispose();
    }

    public void setMsgToPost(String string) {
        this.m_postMsg = string;
    }

    public void setProxyProp(String string, String string2) {
        try {
            ((Hashtable)System.getProperties()).put("proxySet", "true");
            ((Hashtable)System.getProperties()).put("proxyHost", string);
            ((Hashtable)System.getProperties()).put("proxyPort", string2);
        }
        catch (Exception exception) {
            System.out.println("Error in setProxyProp() :" + exception);
        }
    }

    public void setSocksProp(String string, String string2) {
        try {
            ((Hashtable)System.getProperties()).put("socksProxySet", "true");
            ((Hashtable)System.getProperties()).put("socksProxyHost", string);
            ((Hashtable)System.getProperties()).put("socksProxyPort", string2);
        }
        catch (Exception exception) {
            System.out.println("Error in setSocksProp:" + exception);
        }
    }

    protected static String stripHttp(String string) {
        int n = string.toUpperCase().indexOf("HTTP:\\\\");
        if (n == -1) {
            n = string.toUpperCase().indexOf("HTTP://");
        }
        if (n != -1) {
            string = string.substring(n + 7);
        }
        return string;
    }
}

