/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lexington.prt;

import com.ibm.lexington.prt.Brand;
import com.ibm.lexington.prt.BrazilianPortuguese;
import com.ibm.lexington.prt.Country;
import com.ibm.lexington.prt.English;
import com.ibm.lexington.prt.French;
import com.ibm.lexington.prt.Japanese;
import java.util.Locale;
import java.util.ResourceBundle;

public class Language {
    static ResourceBundle rb_address;
    static ResourceBundle rb_comall;
    static ResourceBundle rb_combrand;
    static ResourceBundle rb;
    static ResourceBundle rb_24;
    static ResourceBundle rb_241;
    static ResourceBundle rb_brand;
    static ResourceBundle rb_brand_22;
    static ResourceBundle rb_aix;
    protected static final int IT = 0;
    protected static final int EL = 1;
    protected static final int DA = 2;
    protected static final int RU = 3;
    protected static final int JA = 4;
    protected static final int ZH_CN = 5;
    protected static final int KO = 6;
    protected static final int SV = 7;
    protected static final int TH = 8;
    protected static final int FR = 9;
    protected static final int ES = 10;
    protected static final int DE = 11;
    protected static final int ZH_TW = 12;
    protected static final int NL = 13;
    protected static final int NO = 14;
    protected static final int CS = 15;
    protected static final int TR = 16;
    protected static final int PL = 17;
    protected static final int EN = 18;
    protected static final int HU = 19;
    protected static final int FI = 20;
    protected static final int PT = 21;
    protected static final int PT_BR = 22;
    private static final String[] langStrings;
    private static final int PREFIX = 0;
    private static final int FIRSTNAME = 1;
    private static final int INITIAL = 2;
    private static final int LASTNAME = 3;
    private static final int SUFFIX = 4;
    private static final int JOBTITLE = 5;
    private static final int COMPANY = 6;
    private static final int POBOX = 7;
    private static final int STREET = 8;
    private static final int CITY = 9;
    private static final int STATE = 10;
    private static final int ZIP = 11;
    private static final int COUNTRY = 12;
    private static final int PHONE = 13;
    private static final int EXTENSION = 14;
    private static final int EMAIL = 15;
    private static final int FRENCHCHKBK = 16;
    private static final int ALLOWBOLD = 17;
    private static final boolean[][] supportArray;
    private int m_langIndex;
    private static Language m_defaultLanguage;

    static {
        langStrings = new String[]{"it_IT", "el_GR", "da_DK", "ru_RU", "ja_JP", "zh_CN", "ko_KR", "sv_SE", "th_TH", "fr_FR", "es_ES", "de_DE", "zh_TW", "nl_NL", "no_NO", "cs_CZ", "tr_TR", "pl_PL", "en_US", "hu_HU", "fi_FI", "pt_PT", "pt_BR"};
        supportArray = new boolean[][]{{true, true, true, true, true, true, true, false, true, true, true, true, true, true, false, true, false, true, true, true, false, false, false}, {true, true, true, true, true, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true}, {false, true, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, true, false, false, true, true}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true}, {false, false, false, false, true, false, false, false, true, false, false, true, false, false, false, true, false, false, true, true, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true}, {true, true, true, true, true, true, true, true, true, true, false, true, true, true, true, true, true, false, true, true, true, true, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true}, {false, false, false, false, true, false, false, false, false, true, false, false, false, false, false, false, false, false, true, false, false, false, true}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true}, {false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, true, false, false, false, false}, {true, false, true, true, false, false, false, true, false, true, true, true, false, true, true, true, true, true, true, true, true, true, true}};
        m_defaultLanguage = null;
    }

    public Language(int n) {
        this.m_langIndex = n;
        Brand brand = Brand.getBrand();
        Locale locale = Locale.getDefault();
        rb_address = ResourceBundle.getBundle("com.ibm.lexington.prt.res.reg_address", locale);
        rb_comall = ResourceBundle.getBundle("com.ibm.lexington.prt.res.common_all");
        rb_combrand = ResourceBundle.getBundle("com.ibm.lexington.prt.res.common_" + brand.getBrandNameLow());
        rb = ResourceBundle.getBundle("com.ibm.lexington.prt.res.reg_common", locale);
        rb_24 = ResourceBundle.getBundle("com.ibm.lexington.prt.res.reg_common2", locale);
        rb_241 = ResourceBundle.getBundle("com.ibm.lexington.prt.res.reg_common211", locale);
        rb_brand = ResourceBundle.getBundle("com.ibm.lexington.prt.res.reg_" + brand.getBrandNameLow(), locale);
        rb_aix = ResourceBundle.getBundle("com.ibm.lexington.prt.res.reg_prtjava", locale);
        if (locale.equals(Locale.JAPAN)) {
            try {
                Class.forName("com.ibm.lexington.prt.res.reg_common_ja");
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println("Could not load reg_common_ja.  Changing language to English!");
                this.m_langIndex = Language.getIndexFromId("en_US");
            }
        }
    }

    private static String copyright() {
        return "\n\nLicensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1999, 2000. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    }

    public static Language getDefaultLanguage() {
        if (m_defaultLanguage == null) {
            Locale locale = Locale.getDefault();
            System.out.println("getDefaultLanguage: locale = " + locale);
            m_defaultLanguage = Language.getLanguage(locale.toString());
        }
        return m_defaultLanguage;
    }

    public static int getIndexFromId(String string) {
        int n = 0;
        while (n < langStrings.length) {
            if (langStrings[n].equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int getLangIndex() {
        return this.m_langIndex;
    }

    public static Language getLanguage(String string) {
        Language language = null;
        int n = Language.getIndexFromId(string);
        if (n == -1) {
            Locale.setDefault(new Locale("en", "US"));
        } else {
            String string2 = string.substring(0, 2);
            String string3 = string.substring(3);
            Locale.setDefault(new Locale(string2, string3));
        }
        language = n == 18 || n == -1 ? new English() : (n == 9 ? new French() : (n == 4 ? new Japanese() : (n == 22 ? new BrazilianPortuguese() : new Language(n))));
        return language;
    }

    public String getLanguageString() {
        return langStrings[this.m_langIndex];
    }

    public boolean isCitySupported() {
        return supportArray[9][this.m_langIndex];
    }

    public boolean isCompanySupported() {
        return supportArray[6][this.m_langIndex];
    }

    public boolean isCountrySupported() {
        return supportArray[12][this.m_langIndex];
    }

    public boolean isEmailAddressSupported() {
        return supportArray[15][this.m_langIndex];
    }

    public boolean isExtensionSupported() {
        return supportArray[14][this.m_langIndex];
    }

    public boolean isFirstNameSupported() {
        return supportArray[1][this.m_langIndex];
    }

    public boolean isFrenchCheckSupported() {
        return supportArray[16][this.m_langIndex];
    }

    public boolean isJobTitleSupported() {
        return supportArray[5][this.m_langIndex];
    }

    public boolean isLastNameSupported() {
        return supportArray[3][this.m_langIndex];
    }

    public boolean isMiddleInitialSupported() {
        return supportArray[2][this.m_langIndex];
    }

    public boolean isPhoneSupported() {
        return supportArray[13][this.m_langIndex];
    }

    public boolean isPOBoxSupported() {
        return supportArray[7][this.m_langIndex];
    }

    public boolean isPrefixSupported() {
        return supportArray[0][this.m_langIndex];
    }

    public boolean isStateSupported(Country country) {
        return supportArray[10][this.m_langIndex];
    }

    public boolean isStreetAddressSupported() {
        return supportArray[8][this.m_langIndex];
    }

    public boolean isSuffixSupported() {
        return supportArray[4][this.m_langIndex];
    }

    public boolean isZipSupported() {
        return supportArray[11][this.m_langIndex];
    }

    public void setDefaultLanguage() {
        m_defaultLanguage = this;
    }

    public boolean supportsBold() {
        return supportArray[17][this.m_langIndex];
    }
}

