/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lexington.prt;

import com.ibm.lexington.prt.CustInfo;
import com.ibm.lexington.prt.CustName;
import com.ibm.lexington.prt.Language;
import com.ibm.lexington.prt.Name;
import com.ibm.lexington.prt.RegException;
import com.ibm.lexington.prt.SysInfo;
import com.ibm.lexington.prt.SystemProductInfo;
import com.ibm.lexington.prt.Utility;
import com.ibm.lexington.prt.res.Bounds;
import com.ibm.lexington.prt.res.StrBounds;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Locale;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class NameControl
extends Name
implements KeyListener {
    private static final int FirstPrefixString = 500;
    private static final int LastPrefixString = 504;
    private static final int FirstSuffixString = 525;
    private static final int LastSuffixString = 534;
    private JFrame parentFrame;
    private Language m_hLanguage;
    private static JLabel ivjLabelFirstName = null;
    private JTextField m_ContactFirstNameControl;
    private String m_strContactFirstName;
    private static JLabel ivjLabelInitial = null;
    private JTextField m_ContactInitialControl;
    private String m_strContactInitial;
    private static JLabel ivjLabelLastName = null;
    private JTextField m_ContactLastNameControl;
    private String m_strContactLastName;
    private static JLabel ivjLabelPrefix = null;
    private JComboBox m_ContactPrefixControl;
    private JTextField m_ContactPrefixEditControl;
    private String m_strContactPrefix;
    private static JLabel ivjLabelSuffix = null;
    private JComboBox m_ContactSuffixControl;
    private JTextField m_ContactSuffixEditControl;
    private String m_strContactSuffix;

    public NameControl(JFrame jFrame) {
        this.parentFrame = jFrame;
        this.m_hLanguage = Language.getDefaultLanguage();
        CustInfo custInfo = CustInfo.getInstance();
        CustName custName = custInfo.getName();
        this.m_strContactFirstName = custName.getFirstName();
        this.m_strContactInitial = custName.getInitial();
        this.m_strContactLastName = custName.getLastName();
        this.m_strContactSuffix = custName.getSuffix();
        this.m_strContactPrefix = custName.getPrefix();
        this.initialize();
    }

    private static String copyright() {
        return "\n\nLicensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1999, 2000. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    }

    public void doDataExchange() {
        if (this.m_hLanguage.getLangIndex() != 4) {
            this.m_ContactPrefixControl.setSelectedItem(this.m_strContactPrefix);
            this.m_ContactSuffixControl.setSelectedItem(this.m_strContactSuffix);
        } else {
            this.m_ContactPrefixEditControl.setText(this.m_strContactPrefix);
            this.m_ContactPrefixEditControl.setText(this.m_strContactSuffix);
        }
        this.m_ContactFirstNameControl.setText(this.m_strContactFirstName);
        this.m_ContactInitialControl.setText(this.m_strContactInitial);
        this.m_ContactLastNameControl.setText(this.m_strContactLastName);
    }

    public String getFirstName() {
        if (this.m_hLanguage.isFirstNameSupported()) {
            this.m_strContactFirstName = this.m_ContactFirstNameControl.getText();
            return this.m_strContactFirstName;
        }
        return "";
    }

    public Component getFirstNameEditControl() {
        return this.m_ContactFirstNameControl;
    }

    public String getInitial() {
        if (this.m_hLanguage.isMiddleInitialSupported()) {
            this.m_strContactInitial = this.m_ContactInitialControl.getText();
            return this.m_strContactInitial;
        }
        return "";
    }

    public Component getInitialEditControl() {
        return this.m_ContactInitialControl;
    }

    public String getLastName() {
        if (this.m_hLanguage.isLastNameSupported()) {
            this.m_strContactLastName = this.m_ContactLastNameControl.getText();
            return this.m_strContactLastName;
        }
        return "";
    }

    public Component getLastNameEditControl() {
        return this.m_ContactLastNameControl;
    }

    public String getPrefix() {
        if (this.m_hLanguage.isPrefixSupported()) {
            this.m_strContactPrefix = this.m_hLanguage.getLangIndex() != 4 ? (String)this.m_ContactPrefixControl.getSelectedItem() : this.m_ContactPrefixEditControl.getText();
            return this.m_strContactPrefix;
        }
        return "";
    }

    public Component getPrefixControl() {
        if (this.m_hLanguage.isPrefixSupported()) {
            if (this.m_hLanguage.getLangIndex() != 4) {
                return this.m_ContactPrefixControl;
            }
            return this.m_ContactPrefixEditControl;
        }
        return null;
    }

    public String getSuffix() {
        if (this.m_hLanguage.isSuffixSupported()) {
            this.m_strContactSuffix = this.m_hLanguage.getLangIndex() != 4 ? (String)this.m_ContactSuffixControl.getSelectedItem() : this.m_ContactSuffixEditControl.getText();
            return this.m_strContactSuffix;
        }
        return "";
    }

    private void initialize() {
        CustInfo custInfo = CustInfo.getInstance();
        CustName custName = custInfo.getName();
        try {
            ivjLabelPrefix = new JLabel();
            ivjLabelPrefix.setName("PrefixLabel");
            ivjLabelPrefix.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            ivjLabelPrefix.setBackground(Color.lightGray);
            ivjLabelPrefix.setForeground(Color.black);
            this.m_ContactPrefixControl = new JComboBox();
            this.m_ContactPrefixControl.setName("PrefixChoice");
            this.m_ContactPrefixControl.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.m_ContactPrefixControl.setBackground(Color.white);
            this.m_ContactPrefixEditControl = new JTextField();
            this.m_ContactPrefixEditControl.setName("PrefixTextField");
            this.m_ContactPrefixEditControl.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.m_ContactPrefixEditControl.setColumns(50);
            ivjLabelFirstName = new JLabel();
            ivjLabelFirstName.setName("FirstNameLabel");
            ivjLabelFirstName.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            ivjLabelFirstName.setBackground(Color.lightGray);
            ivjLabelFirstName.setForeground(Color.black);
            this.m_ContactFirstNameControl = new JTextField();
            this.m_ContactFirstNameControl.setName("FirstNameTextField");
            this.m_ContactFirstNameControl.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.m_ContactFirstNameControl.setColumns(30);
            ivjLabelInitial = new JLabel();
            ivjLabelInitial.setName("InitialLabel");
            ivjLabelInitial.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            ivjLabelInitial.setBackground(Color.lightGray);
            ivjLabelInitial.setForeground(Color.black);
            this.m_ContactInitialControl = new JTextField();
            this.m_ContactInitialControl.setName("InitialTextField");
            this.m_ContactInitialControl.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.m_ContactInitialControl.setColumns(1);
            ivjLabelLastName = new JLabel();
            ivjLabelLastName.setName("LastNameLabel");
            ivjLabelLastName.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            ivjLabelLastName.setBackground(Color.lightGray);
            ivjLabelLastName.setForeground(Color.black);
            this.m_ContactLastNameControl = new JTextField();
            this.m_ContactLastNameControl.setName("TextLastName");
            this.m_ContactLastNameControl.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.m_ContactLastNameControl.setColumns(30);
            ivjLabelSuffix = new JLabel();
            ivjLabelSuffix.setName("SuffixLabel");
            ivjLabelSuffix.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            ivjLabelSuffix.setBackground(Color.lightGray);
            ivjLabelSuffix.setForeground(Color.black);
            this.m_ContactSuffixControl = new JComboBox();
            this.m_ContactSuffixControl.setName("SuffixChoice");
            this.m_ContactSuffixControl.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.m_ContactSuffixControl.setBackground(Color.white);
            this.m_ContactSuffixEditControl = new JTextField();
            this.m_ContactSuffixEditControl.setName("SuffixTextField");
            this.m_ContactSuffixEditControl.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.m_ContactSuffixEditControl.setColumns(50);
            StrBounds strBounds = (StrBounds)Language.rb.getObject(Integer.toString(2251));
            Bounds bounds = (Bounds)Language.rb.getObject(Integer.toString(2238));
            StrBounds strBounds2 = (StrBounds)Language.rb.getObject(Integer.toString(2252));
            Bounds bounds2 = (Bounds)Language.rb.getObject(Integer.toString(2209));
            StrBounds strBounds3 = (StrBounds)Language.rb.getObject(Integer.toString(2250));
            Bounds bounds3 = (Bounds)Language.rb.getObject(Integer.toString(2208));
            StrBounds strBounds4 = (StrBounds)Language.rb.getObject(Integer.toString(2257));
            Bounds bounds4 = (Bounds)Language.rb.getObject(Integer.toString(2210));
            StrBounds strBounds5 = (StrBounds)Language.rb.getObject(Integer.toString(2253));
            Bounds bounds5 = (Bounds)Language.rb.getObject(Integer.toString(2237));
            ivjLabelPrefix.setText(strBounds.returnString());
            ivjLabelFirstName.setText(strBounds2.returnString());
            ivjLabelInitial.setText(strBounds3.returnString());
            ivjLabelLastName.setText(strBounds4.returnString());
            ivjLabelSuffix.setText(strBounds5.returnString());
            custInfo = CustInfo.getInstance();
            custName = custInfo.getName();
            if (this.m_hLanguage.getLangIndex() != 4) {
                String string;
                this.m_ContactPrefixControl.addItem("");
                int n = 500;
                while (n <= 504) {
                    string = Language.rb.getString(Integer.toString(n));
                    if (string != "" && string != " ") {
                        this.m_ContactPrefixControl.addItem(string);
                    }
                    ++n;
                }
                n = 525;
                while (n <= 534) {
                    string = Language.rb.getString(Integer.toString(n));
                    if (string != "" && string != " " || string == " " && n == 525) {
                        this.m_ContactSuffixControl.addItem(string);
                    }
                    ++n;
                }
                this.m_ContactPrefixControl.setSelectedItem(custName.getPrefix());
                this.m_ContactSuffixControl.setSelectedItem(custName.getSuffix());
            } else {
                this.m_ContactPrefixEditControl.setText(custName.getPrefix());
                this.m_ContactSuffixEditControl.setText(custName.getSuffix());
            }
            Point point = strBounds.returnPoint();
            Point point2 = bounds.returnPoint();
            Point point3 = strBounds2.returnPoint();
            Point point4 = bounds2.returnPoint();
            Point point5 = strBounds3.returnPoint();
            Point point6 = bounds3.returnPoint();
            Point point7 = strBounds4.returnPoint();
            Point point8 = bounds4.returnPoint();
            Point point9 = strBounds5.returnPoint();
            Point point10 = bounds5.returnPoint();
            Dimension dimension = strBounds.returnDimension();
            Dimension dimension2 = bounds.returnDimension();
            Dimension dimension3 = strBounds2.returnDimension();
            Dimension dimension4 = bounds2.returnDimension();
            Dimension dimension5 = strBounds3.returnDimension();
            Dimension dimension6 = bounds3.returnDimension();
            Dimension dimension7 = strBounds4.returnDimension();
            Dimension dimension8 = bounds4.returnDimension();
            Dimension dimension9 = strBounds5.returnDimension();
            Dimension dimension10 = bounds5.returnDimension();
            if (SysInfo.getOSPlatform().equals("AIX") && Locale.getDefault().toString().equals("zh_CN")) {
                ivjLabelPrefix.setBounds(point.x - SystemProductInfo.Contact_xvalue, point.y - (20 + SystemProductInfo.Contact_yvalue + 2), dimension.width, dimension.height + 2);
                this.m_ContactPrefixControl.setBounds(point2.x - SystemProductInfo.Contact_xvalue, point2.y - (20 + SystemProductInfo.Contact_yvalue), dimension2.width, dimension2.height + 5);
                this.m_ContactPrefixEditControl.setBounds(point2.x - SystemProductInfo.Contact_xvalue, point2.y - (20 + SystemProductInfo.Contact_yvalue), dimension2.width, dimension2.height + 5);
                ivjLabelFirstName.setBounds(point3.x - SystemProductInfo.Contact_xvalue, point3.y - (20 + SystemProductInfo.Contact_yvalue + 2), dimension3.width, dimension3.height + 2);
                this.m_ContactFirstNameControl.setBounds(point4.x - SystemProductInfo.Contact_xvalue, point4.y - (20 + SystemProductInfo.Contact_yvalue), dimension4.width, dimension4.height + 5);
                ivjLabelInitial.setBounds(point5.x - SystemProductInfo.Contact_xvalue, point5.y - (20 + SystemProductInfo.Contact_yvalue + 2), dimension5.width + 7, dimension5.height + 2);
                this.m_ContactInitialControl.setBounds(point6.x - SystemProductInfo.Contact_xvalue, point6.y - (20 + SystemProductInfo.Contact_yvalue), dimension6.width + 2, dimension6.height + 5);
                ivjLabelLastName.setBounds(point7.x - SystemProductInfo.Contact_xvalue, point7.y - (20 + SystemProductInfo.Contact_yvalue + 2), dimension7.width, dimension7.height + 2);
                this.m_ContactLastNameControl.setBounds(point8.x - SystemProductInfo.Contact_xvalue, point8.y - (20 + SystemProductInfo.Contact_yvalue), dimension8.width, dimension8.height + 5);
                ivjLabelSuffix.setBounds(point9.x - SystemProductInfo.Contact_xvalue, point9.y - (20 + SystemProductInfo.Contact_yvalue + 2), dimension9.width, dimension9.height + 2);
                this.m_ContactSuffixControl.setBounds(point10.x - SystemProductInfo.Contact_xvalue, point10.y - (20 + SystemProductInfo.Contact_yvalue), dimension10.width, dimension10.height + 5);
                this.m_ContactSuffixEditControl.setBounds(point10.x - SystemProductInfo.Contact_xvalue, point10.y - (20 + SystemProductInfo.Contact_yvalue), dimension10.width, dimension10.height + 5);
            } else {
                ivjLabelPrefix.setBounds(point.x - SystemProductInfo.Contact_xvalue, point.y - (20 + SystemProductInfo.Contact_yvalue), dimension.width, dimension.height);
                this.m_ContactPrefixControl.setBounds(point2.x - SystemProductInfo.Contact_xvalue, point2.y - (20 + SystemProductInfo.Contact_yvalue), dimension2.width, dimension2.height);
                this.m_ContactPrefixEditControl.setBounds(point2.x - SystemProductInfo.Contact_xvalue, point2.y - (20 + SystemProductInfo.Contact_yvalue), dimension2.width, dimension2.height);
                ivjLabelFirstName.setBounds(point3.x - SystemProductInfo.Contact_xvalue, point3.y - (20 + SystemProductInfo.Contact_yvalue), dimension3.width, dimension3.height);
                this.m_ContactFirstNameControl.setBounds(point4.x - SystemProductInfo.Contact_xvalue, point4.y - (20 + SystemProductInfo.Contact_yvalue), dimension4.width, dimension4.height);
                ivjLabelInitial.setBounds(point5.x - SystemProductInfo.Contact_xvalue, point5.y - (20 + SystemProductInfo.Contact_yvalue), dimension5.width + 7, dimension5.height);
                this.m_ContactInitialControl.setBounds(point6.x - SystemProductInfo.Contact_xvalue, point6.y - (20 + SystemProductInfo.Contact_yvalue), dimension6.width + 2, dimension6.height);
                ivjLabelLastName.setBounds(point7.x - SystemProductInfo.Contact_xvalue, point7.y - (20 + SystemProductInfo.Contact_yvalue), dimension7.width, dimension7.height);
                this.m_ContactLastNameControl.setBounds(point8.x - SystemProductInfo.Contact_xvalue, point8.y - (20 + SystemProductInfo.Contact_yvalue), dimension8.width, dimension8.height);
                ivjLabelSuffix.setBounds(point9.x - SystemProductInfo.Contact_xvalue, point9.y - (20 + SystemProductInfo.Contact_yvalue), dimension9.width, dimension9.height);
                this.m_ContactSuffixControl.setBounds(point10.x - SystemProductInfo.Contact_xvalue, point10.y - (20 + SystemProductInfo.Contact_yvalue), dimension10.width, dimension10.height);
                this.m_ContactSuffixEditControl.setBounds(point10.x - SystemProductInfo.Contact_xvalue, point10.y - (20 + SystemProductInfo.Contact_yvalue), dimension10.width, dimension10.height);
            }
            if (this.m_hLanguage.isPrefixSupported()) {
                this.parentFrame.getContentPane().add((Component)ivjLabelPrefix, ivjLabelPrefix.getName());
                if (this.m_hLanguage.getLangIndex() == 4) {
                    this.parentFrame.getContentPane().add((Component)this.m_ContactPrefixEditControl, this.m_ContactPrefixEditControl.getName());
                } else {
                    this.parentFrame.getContentPane().add((Component)this.m_ContactPrefixControl, this.m_ContactPrefixControl.getName());
                }
            }
            if (this.m_hLanguage.isFirstNameSupported()) {
                this.parentFrame.getContentPane().add((Component)ivjLabelFirstName, ivjLabelFirstName.getName());
                this.parentFrame.getContentPane().add((Component)this.m_ContactFirstNameControl, this.m_ContactFirstNameControl.getName());
            }
            if (this.m_hLanguage.isMiddleInitialSupported()) {
                this.parentFrame.getContentPane().add((Component)ivjLabelInitial, ivjLabelInitial.getName());
                this.parentFrame.getContentPane().add((Component)this.m_ContactInitialControl, this.m_ContactInitialControl.getName());
            }
            if (this.m_hLanguage.isLastNameSupported()) {
                this.parentFrame.getContentPane().add((Component)ivjLabelLastName, ivjLabelLastName.getName());
                this.parentFrame.getContentPane().add((Component)this.m_ContactLastNameControl, this.m_ContactLastNameControl.getName());
            }
            if (this.m_hLanguage.isSuffixSupported()) {
                this.parentFrame.getContentPane().add((Component)ivjLabelSuffix, ivjLabelSuffix.getName());
                if (this.m_hLanguage.getLangIndex() == 4) {
                    this.parentFrame.getContentPane().add((Component)this.m_ContactSuffixEditControl, this.m_ContactSuffixEditControl.getName());
                } else {
                    this.parentFrame.getContentPane().add((Component)this.m_ContactSuffixControl, this.m_ContactSuffixControl.getName());
                }
            }
            this.m_ContactFirstNameControl.addKeyListener(this);
            this.m_ContactInitialControl.addKeyListener(this);
            this.m_ContactLastNameControl.addKeyListener(this);
            this.m_ContactPrefixEditControl.addKeyListener(this);
            this.m_ContactSuffixEditControl.addKeyListener(this);
        }
        catch (Throwable throwable) {
            System.out.println("Error in NameControl.initialize() " + throwable);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 16) {
            return;
        }
        if (keyEvent.getSource() == this.m_ContactPrefixEditControl) {
            this.onChangeEDITFuriganaFirst();
        } else if (keyEvent.getSource() == this.m_ContactFirstNameControl) {
            this.onChangeEDITFirstName();
        } else if (keyEvent.getSource() == this.m_ContactInitialControl) {
            this.onChangeEDITInitial();
        } else if (keyEvent.getSource() == this.m_ContactLastNameControl) {
            this.onChangeEDITLastName();
        } else if (keyEvent.getSource() == this.m_ContactSuffixEditControl) {
            this.onChangeEDITFuriganaLast();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void onChangeEDITFirstName() {
        RegException regException;
        String string = this.m_ContactFirstNameControl.getText();
        if (Utility.validateString(string) != -1) {
            regException = new RegException(217);
            regException.showMessage();
            if (this.m_ContactFirstNameControl.isVisible()) {
                this.m_ContactFirstNameControl.requestFocus();
            }
        }
        if (Utility.validateNoNumericsString(string) != -1) {
            regException = new RegException(221);
            regException.showMessage();
            if (this.m_ContactFirstNameControl.isVisible()) {
                this.m_ContactFirstNameControl.requestFocus();
            }
        }
    }

    public void onChangeEDITFuriganaFirst() {
        RegException regException;
        String string = this.m_ContactPrefixEditControl.getText();
        if (Utility.validateString(string) != -1) {
            regException = new RegException(217);
            regException.showMessage();
            if (this.m_ContactPrefixEditControl.isVisible()) {
                this.m_ContactPrefixEditControl.requestFocus();
            }
        }
        if (Utility.validateNoNumericsString(string) != -1) {
            regException = new RegException(221);
            regException.showMessage();
            if (this.m_ContactPrefixEditControl.isVisible()) {
                this.m_ContactPrefixEditControl.requestFocus();
            }
        }
    }

    public void onChangeEDITFuriganaLast() {
        RegException regException;
        String string = this.m_ContactSuffixEditControl.getText();
        if (Utility.validateString(string) != -1) {
            regException = new RegException(217);
            regException.showMessage();
            if (this.m_ContactSuffixEditControl.isVisible()) {
                this.m_ContactSuffixEditControl.requestFocus();
            }
        }
        if (Utility.validateNoNumericsString(string) != -1) {
            regException = new RegException(221);
            regException.showMessage();
            if (this.m_ContactSuffixEditControl.isVisible()) {
                this.m_ContactSuffixEditControl.requestFocus();
            }
        }
    }

    public void onChangeEDITInitial() {
        String string = this.m_ContactInitialControl.getText();
        if (Utility.validateString(string) != -1) {
            RegException regException = new RegException(217);
            regException.showMessage();
            if (this.m_ContactInitialControl.isVisible()) {
                this.m_ContactInitialControl.requestFocus();
            }
        }
    }

    public void onChangeEDITLastName() {
        RegException regException;
        String string = this.m_ContactLastNameControl.getText();
        if (Utility.validateString(string) != -1) {
            regException = new RegException(217);
            regException.showMessage();
            if (this.m_ContactLastNameControl.isVisible()) {
                this.m_ContactLastNameControl.requestFocus();
            }
        }
        if (Utility.validateNoNumericsString(string) != -1) {
            regException = new RegException(221);
            regException.showMessage();
            if (this.m_ContactLastNameControl.isVisible()) {
                this.m_ContactLastNameControl.requestFocus();
            }
        }
    }

    public void saveInfo() {
        CustInfo custInfo = CustInfo.getInstance();
        CustName custName = custInfo.getName();
        custName.setFirstName(this.m_ContactFirstNameControl.getText());
        custName.setInitial(this.m_ContactInitialControl.getText());
        custName.setLastName(this.m_ContactLastNameControl.getText());
        if (this.m_hLanguage.getLangIndex() != 4) {
            int n = this.m_ContactSuffixControl.getSelectedIndex();
            String string = (String)this.m_ContactSuffixControl.getSelectedItem();
            custName.setSuffixIdx(string, n);
            int n2 = this.m_ContactPrefixControl.getSelectedIndex();
            String string2 = (String)this.m_ContactPrefixControl.getSelectedItem();
            custName.setPrefixIdx(string2, n2);
        } else {
            String string = this.m_ContactSuffixEditControl.getText();
            custName.setSuffixIdx(string, 0);
            String string3 = this.m_ContactPrefixEditControl.getText();
            custName.setPrefixIdx(string3, 0);
        }
    }

    public boolean setFieldFocus(int n, int n2) {
        boolean bl = false;
        switch (n) {
            case 1519: {
                if (this.m_hLanguage.getLangIndex() != 4) {
                    if (!this.m_ContactPrefixControl.isVisible()) break;
                    this.m_ContactPrefixControl.requestFocus();
                    break;
                }
                if (!this.m_ContactPrefixEditControl.isVisible()) break;
                this.m_ContactPrefixEditControl.requestFocus();
                break;
            }
            case 201: {
                if (!this.m_ContactFirstNameControl.isVisible()) break;
                this.m_ContactFirstNameControl.requestFocus();
                break;
            }
            case 202: {
                if (!this.m_ContactLastNameControl.isVisible()) break;
                this.m_ContactLastNameControl.requestFocus();
                break;
            }
            case 1520: {
                if (this.m_hLanguage.getLangIndex() != 4) {
                    if (!this.m_ContactSuffixControl.isVisible()) break;
                    this.m_ContactSuffixControl.requestFocus();
                    break;
                }
                if (!this.m_ContactSuffixEditControl.isVisible()) break;
                this.m_ContactSuffixEditControl.requestFocus();
            }
        }
        return bl;
    }

    public void setFirstName(String string) {
        this.m_strContactFirstName = string;
        this.m_ContactFirstNameControl.setText(this.m_strContactFirstName);
    }

    public void setInitial(String string) {
        this.m_strContactInitial = string;
        this.m_ContactInitialControl.setText(this.m_strContactInitial);
    }

    public void setLastName(String string) {
        this.m_strContactLastName = string;
        this.m_ContactLastNameControl.setText(this.m_strContactLastName);
    }

    public void setPrefix(String string) {
        this.m_strContactPrefix = string;
        if (this.m_hLanguage.getLangIndex() != 4) {
            this.m_ContactPrefixControl.setSelectedItem(this.m_strContactPrefix);
        } else {
            this.m_ContactPrefixEditControl.setText(this.m_strContactPrefix);
        }
    }

    public void setPrefixIdx(String string, int n) {
    }

    public void setSuffix(String string) {
        this.m_strContactSuffix = string;
        if (this.m_hLanguage.getLangIndex() != 4) {
            this.m_ContactSuffixControl.setSelectedItem(this.m_strContactSuffix);
        } else {
            this.m_ContactSuffixEditControl.setText(this.m_strContactSuffix);
        }
    }

    public void setSuffixIdx(String string, int n) {
    }
}

