/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lexington.prt;

import com.ibm.lexington.prt.Country;
import com.ibm.lexington.prt.CustInfo;
import com.ibm.lexington.prt.CustPhone;
import com.ibm.lexington.prt.Language;
import com.ibm.lexington.prt.Phone;
import com.ibm.lexington.prt.RegException;
import com.ibm.lexington.prt.SysInfo;
import com.ibm.lexington.prt.SystemProductInfo;
import com.ibm.lexington.prt.Utility;
import com.ibm.lexington.prt.res.Bounds;
import com.ibm.lexington.prt.res.StrBounds;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Locale;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class PhoneControl
extends Phone
implements KeyListener {
    private JFrame parentFrame;
    private Language m_hLanguage;
    private boolean PhoneValidationIsOK;
    private JLabel ivjLabelPhone;
    private JTextField m_ContactPhoneControl;
    private String m_strContactPhone;
    private JLabel ivjLabelExt;
    private JTextField m_ContactExtControl;
    private String m_strContactExt;

    public PhoneControl(JFrame jFrame) {
        this.parentFrame = jFrame;
        this.m_hLanguage = Language.getDefaultLanguage();
        CustInfo custInfo = CustInfo.getInstance();
        CustPhone custPhone = custInfo.getPhone();
        this.m_strContactPhone = custPhone.getPhone();
        this.m_strContactExt = custPhone.getExt();
        this.initialize();
    }

    private static String copyright() {
        return "\n\nLicensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1999, 2000. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    }

    public void doDataExchange() {
        this.m_ContactPhoneControl.setText(this.m_strContactPhone);
        this.m_ContactExtControl.setText(this.m_strContactExt);
    }

    public String getExt() {
        this.m_strContactExt = this.m_ContactExtControl.getText();
        return this.m_strContactExt;
    }

    public Component getExtControl() {
        return this.m_ContactExtControl;
    }

    public String getPhone() {
        this.m_strContactPhone = this.m_ContactPhoneControl.getText();
        return this.m_strContactPhone;
    }

    public Component getPhoneControl() {
        return this.m_ContactPhoneControl;
    }

    public boolean getPhoneValidationIsOK() {
        return this.PhoneValidationIsOK;
    }

    private void initialize() {
        try {
            this.ivjLabelPhone = new JLabel();
            this.ivjLabelPhone.setName("PhoneLabel");
            this.ivjLabelPhone.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.ivjLabelPhone.setBackground(Color.lightGray);
            this.ivjLabelPhone.setForeground(Color.black);
            this.ivjLabelExt = new JLabel();
            this.ivjLabelExt.setName("ExtLabel");
            this.ivjLabelExt.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.ivjLabelExt.setBackground(Color.lightGray);
            this.ivjLabelExt.setForeground(Color.black);
            this.m_ContactPhoneControl = new JTextField();
            this.m_ContactPhoneControl.setName("PhoneTextfield");
            this.m_ContactPhoneControl.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.m_ContactPhoneControl.setColumns(20);
            this.m_ContactExtControl = new JTextField();
            this.m_ContactExtControl.setName("ExtensionTextfield");
            this.m_ContactExtControl.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.m_ContactExtControl.setColumns(5);
            StrBounds strBounds = (StrBounds)Language.rb.getObject(Integer.toString(2268));
            StrBounds strBounds2 = (StrBounds)Language.rb.getObject(Integer.toString(2269));
            Bounds bounds = (Bounds)Language.rb.getObject(Integer.toString(2213));
            Bounds bounds2 = (Bounds)Language.rb.getObject(Integer.toString(2212));
            this.ivjLabelPhone.setText(strBounds.returnString());
            this.ivjLabelExt.setText(strBounds2.returnString());
            Point point = strBounds.returnPoint();
            Point point2 = strBounds2.returnPoint();
            Point point3 = bounds.returnPoint();
            Point point4 = bounds2.returnPoint();
            Dimension dimension = strBounds.returnDimension();
            Dimension dimension2 = strBounds2.returnDimension();
            Dimension dimension3 = bounds.returnDimension();
            Dimension dimension4 = bounds2.returnDimension();
            if (SysInfo.getOSPlatform().equals("AIX") && Locale.getDefault().toString().equals("zh_CN")) {
                this.ivjLabelPhone.setBounds(point.x - SystemProductInfo.Contact_xvalue, point.y - (20 + SystemProductInfo.Contact_yvalue + 2), dimension.width, dimension.height + 2);
                this.ivjLabelExt.setBounds(point2.x - SystemProductInfo.Contact_xvalue, point2.y - (20 + SystemProductInfo.Contact_yvalue + 2), dimension2.width, dimension2.height + 2);
                this.m_ContactPhoneControl.setBounds(point3.x - SystemProductInfo.Contact_xvalue, point3.y - (20 + SystemProductInfo.Contact_yvalue), dimension3.width, dimension3.height + 5);
                this.m_ContactExtControl.setBounds(point4.x - SystemProductInfo.Contact_xvalue, point4.y - (20 + SystemProductInfo.Contact_yvalue), dimension4.width, dimension4.height + 5);
            } else {
                this.ivjLabelPhone.setBounds(point.x - SystemProductInfo.Contact_xvalue, point.y - (20 + SystemProductInfo.Contact_yvalue), dimension.width, dimension.height);
                this.ivjLabelExt.setBounds(point2.x - SystemProductInfo.Contact_xvalue, point2.y - (20 + SystemProductInfo.Contact_yvalue), dimension2.width, dimension2.height);
                this.m_ContactPhoneControl.setBounds(point3.x - SystemProductInfo.Contact_xvalue, point3.y - (20 + SystemProductInfo.Contact_yvalue), dimension3.width, dimension3.height);
                this.m_ContactExtControl.setBounds(point4.x - SystemProductInfo.Contact_xvalue, point4.y - (20 + SystemProductInfo.Contact_yvalue), dimension4.width, dimension4.height);
            }
            if (this.m_hLanguage.isPhoneSupported()) {
                this.parentFrame.getContentPane().add((Component)this.ivjLabelPhone, this.ivjLabelPhone.getName());
                this.parentFrame.getContentPane().add((Component)this.m_ContactPhoneControl, this.m_ContactPhoneControl.getName());
            }
            if (this.m_hLanguage.isExtensionSupported()) {
                this.parentFrame.getContentPane().add((Component)this.ivjLabelExt, this.ivjLabelExt.getName());
                this.parentFrame.getContentPane().add((Component)this.m_ContactExtControl, this.m_ContactExtControl.getName());
            }
            this.m_ContactPhoneControl.addKeyListener(this);
            this.m_ContactExtControl.addKeyListener(this);
        }
        catch (Throwable throwable) {
            System.out.println("Error in PhoneControl.initialize()!" + throwable);
            throwable.printStackTrace();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 16) {
            return;
        }
        if (keyEvent.getSource() == this.m_ContactPhoneControl) {
            this.onChangeEDITPhone();
        } else if (keyEvent.getSource() == this.m_ContactExtControl) {
            this.onChangeEDITExt();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void onChangeEDITExt() {
        block4: {
            String string = this.m_ContactExtControl.getText();
            if (Utility.validateString(string) != -1) {
                RegException regException = new RegException(217);
                regException.showMessage();
                if (this.m_ContactExtControl.isVisible()) {
                    this.m_ContactExtControl.requestFocus();
                }
            }
            try {
                Country.getDefaultCountry().validatePhoneExtField(this);
            }
            catch (RegException regException) {
                if (regException.getMessageID() != 246) break block4;
                regException.showMessage();
                if (!this.m_ContactExtControl.isVisible()) break block4;
                this.m_ContactExtControl.requestFocus();
            }
        }
    }

    public void onChangeEDITPhone() {
        block4: {
            String string = this.m_ContactPhoneControl.getText();
            if (Utility.validateString(string) != -1) {
                RegException regException = new RegException(217);
                regException.showMessage();
                if (this.m_ContactPhoneControl.isVisible()) {
                    this.m_ContactPhoneControl.requestFocus();
                }
            }
            this.PhoneValidationIsOK = false;
            try {
                Country.getDefaultCountry().validatePhoneField(this);
            }
            catch (RegException regException) {
                if (regException.getMessageID() != 246) break block4;
                regException.showMessage();
                if (!this.m_ContactPhoneControl.isVisible()) break block4;
                this.m_ContactPhoneControl.requestFocus();
            }
        }
    }

    public void saveInfo() {
        CustInfo custInfo = CustInfo.getInstance();
        CustPhone custPhone = custInfo.getPhone();
        custPhone.setPhone(this.m_ContactPhoneControl.getText());
        custPhone.setExt(this.m_ContactExtControl.getText());
    }

    public void setExt(String string) {
        this.m_strContactExt = string;
        this.m_ContactExtControl.setText(this.m_strContactExt);
    }

    public boolean setFieldFocus(int n, int n2) {
        boolean bl = false;
        switch (n) {
            case 208: {
                if (!this.m_ContactPhoneControl.isVisible()) break;
                this.m_ContactPhoneControl.requestFocus();
                break;
            }
            case 223: {
                if (n2 == 0) {
                    if (!this.m_ContactPhoneControl.isVisible()) break;
                    this.m_ContactPhoneControl.requestFocus();
                    break;
                }
                bl = true;
                break;
            }
            case 1515: {
                if (n2 == 1) {
                    this.PhoneValidationIsOK = true;
                    bl = true;
                    break;
                }
                if (!this.m_ContactPhoneControl.isVisible()) break;
                this.m_ContactPhoneControl.requestFocus();
            }
        }
        return bl;
    }

    public void setPhone(String string) {
        this.m_strContactPhone = string;
        this.m_ContactPhoneControl.setText(this.m_strContactPhone);
    }
}

