/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lexington.prt;

import com.ibm.lexington.prt.Brand;
import com.ibm.lexington.prt.SysInfo;
import com.ibm.lexington.prt.URLEncoder;
import java.awt.Component;
import javax.swing.JLabel;

public abstract class Question {
    protected int m_captionId;
    protected String m_name;
    protected String m_token;
    protected String m_answerText;
    protected String m_answerValue;
    protected String m_answerPrintedFormValue;
    protected Component m_visualControl;
    protected JLabel m_captionControl;

    private static String copyright() {
        return "\n\nLicensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1999, 2000. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    }

    public String format(boolean bl) {
        String string = String.valueOf(this.getName()) + "=";
        String string2 = bl ? this.getAnswerValue() : " ";
        URLEncoder.encode(string2);
        string = String.valueOf(string) + string2;
        return string;
    }

    public abstract String getAnswerPrintedFormValue();

    public abstract String getAnswerText();

    public abstract String getAnswerValue();

    public int getCaptionId() {
        return this.m_captionId;
    }

    public String getName() {
        return this.m_name;
    }

    public String getToken() {
        return this.m_token;
    }

    public void readRegistry() {
        Brand brand = Brand.getBrand();
        this.m_answerText = SysInfo.getInstance().readRegistryString(brand.getBrandSection(), this.getName());
    }

    public void setAnswerText(String string) {
        this.m_answerText = string;
    }

    public void setCaptionControl(JLabel jLabel) {
        this.m_captionControl = jLabel;
    }

    public void setVisualControl(Component component) {
        this.m_visualControl = component;
    }

    public void writeRegistry() {
        Brand brand = Brand.getBrand();
        SysInfo.getInstance().writeRegistryString(brand.getBrandSection(), this.getName(), this.getAnswerText());
    }
}

