/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lexington.prt;

import com.ibm.lexington.prt.AddInfo;
import com.ibm.lexington.prt.Answer;
import com.ibm.lexington.prt.Language;
import com.ibm.lexington.prt.Question;
import com.ibm.lexington.prt.SysInfo;
import com.ibm.lexington.prt.SystemProductInfo;
import com.ibm.lexington.prt.res.Bounds;
import com.ibm.lexington.prt.res.StrBounds;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class QuestionComboBox
extends Question {
    private AddInfo addInfo;
    private JLabel questionLabel;
    private StrBounds sbndQuestionLabel;
    private JComboBox questionComboBox;
    private Bounds bndQuestionComboBox;
    private Vector m_answers;
    private boolean m_sorted;
    private boolean m_active = false;

    public QuestionComboBox(int n, String string, String string2, Vector vector, boolean bl, int n2, int n3, AddInfo addInfo) {
        this.m_answers = vector;
        this.m_captionId = n;
        this.m_name = string;
        this.m_token = string2;
        this.m_sorted = bl;
        this.addInfo = addInfo;
        this.sbndQuestionLabel = (StrBounds)Language.rb_24.getObject(Integer.toString(n2));
        this.bndQuestionComboBox = (Bounds)Language.rb_24.getObject(Integer.toString(n3));
        this.initialize();
    }

    public boolean activate() {
        this.questionLabel.setVisible(true);
        this.questionComboBox.setVisible(true);
        this.m_active = true;
        return true;
    }

    private static String copyright() {
        return "\n\nLicensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1999, 2000. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    }

    public boolean deActivate() {
        this.questionLabel.setVisible(false);
        this.questionComboBox.setVisible(false);
        this.m_active = false;
        return true;
    }

    public String getAnswerPrintedFormValue() {
        if (this.m_active) {
            this.m_answerPrintedFormValue = "";
            if (this.questionComboBox.getSelectedIndex() != -1) {
                this.m_answerPrintedFormValue = ((Answer)this.questionComboBox.getSelectedItem()).getPrintedFormValue();
            }
        }
        return this.m_answerPrintedFormValue;
    }

    public String getAnswerText() {
        int n;
        if (this.m_active && (n = this.questionComboBox.getSelectedIndex()) != -1 && n != 0) {
            this.m_answerText = this.questionComboBox.getSelectedItem().toString();
        }
        return this.m_answerText;
    }

    public String getAnswerValue() {
        if (this.m_active) {
            this.m_answerValue = " ";
            if (this.questionComboBox.getSelectedIndex() != -1) {
                this.m_answerValue = ((Answer)this.questionComboBox.getSelectedItem()).getValue();
            }
        }
        return this.m_answerValue;
    }

    public void initialize() {
        try {
            this.questionLabel = new JLabel();
            this.questionLabel.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.questionLabel.setBackground(Color.lightGray);
            this.questionLabel.setForeground(Color.black);
            this.questionLabel.setVisible(false);
            this.questionComboBox = new JComboBox(this.m_answers);
            this.questionComboBox.setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.questionComboBox.setBackground(Color.white);
            this.questionComboBox.setVisible(false);
            Point point = this.sbndQuestionLabel.returnPoint();
            Point point2 = this.bndQuestionComboBox.returnPoint();
            Dimension dimension = this.sbndQuestionLabel.returnDimension();
            Dimension dimension2 = this.bndQuestionComboBox.returnDimension();
            this.questionLabel.setBounds(point.x - SystemProductInfo.AddInfo_xvalue, point.y - (20 + SystemProductInfo.AddInfo_yvalue), dimension.width + 20, dimension.height);
            this.questionComboBox.setBounds(point2.x - SystemProductInfo.AddInfo_xvalue, point2.y - (20 + SystemProductInfo.AddInfo_yvalue), dimension2.width, dimension2.height);
            if (SysInfo.getOSPlatform().equals("AIX")) {
                if (Locale.getDefault().toString().equals("ko_KR")) {
                    this.questionLabel.setBounds(point.x - SystemProductInfo.AddInfo_xvalue, point.y - (20 + SystemProductInfo.AddInfo_yvalue), dimension.width + 50, dimension.height);
                    this.questionComboBox.setBounds(point2.x - SystemProductInfo.AddInfo_xvalue, point2.y - (20 + SystemProductInfo.AddInfo_yvalue), dimension2.width + 70, dimension2.height);
                } else if (Locale.getDefault().toString().equals("zh_CN")) {
                    this.questionLabel.setBounds(point.x - SystemProductInfo.AddInfo_xvalue, point.y - (20 + SystemProductInfo.AddInfo_yvalue + 2), dimension.width + 20, dimension.height + 2);
                    this.questionComboBox.setBounds(point2.x - SystemProductInfo.AddInfo_xvalue, point2.y - (20 + SystemProductInfo.AddInfo_yvalue), dimension2.width, dimension2.height + 5);
                }
            }
            try {
                this.questionLabel.setText(Language.rb.getString(Integer.toString(this.m_captionId)));
            }
            catch (MissingResourceException missingResourceException) {
                try {
                    this.questionLabel.setText(Language.rb_24.getString(Integer.toString(this.m_captionId)));
                }
                catch (MissingResourceException missingResourceException2) {
                    this.questionLabel.setText(Language.rb_brand.getString(Integer.toString(this.m_captionId)));
                }
            }
            this.addInfo.getContentPane().add((Component)this.questionLabel, this.questionLabel.getName());
            this.addInfo.getContentPane().add((Component)this.questionComboBox, this.questionComboBox.getName());
        }
        catch (Throwable throwable) {
            System.out.println("Problem in QuestionComboBox.initialize()!");
            throwable.printStackTrace();
        }
    }

    public void setPreviousAnswer() {
        String string = this.getAnswerText();
        int n = this.questionComboBox.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            String string2 = ((Answer)this.questionComboBox.getItemAt(n2)).toString();
            if (string.equals(string2)) {
                this.questionComboBox.setSelectedIndex(n2);
                break;
            }
            ++n2;
        }
    }
}

