/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lexington.prt;

import com.ibm.lexington.prt.Contact;
import com.ibm.lexington.prt.Language;
import com.ibm.lexington.prt.RegCommandLine;
import com.ibm.lexington.prt.Scheduler;
import com.ibm.lexington.prt.Splash;
import com.ibm.lexington.prt.SysInfo;
import com.ibm.lexington.prt.SystemProductInfo;
import com.ibm.lexington.prt.Utility;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;

public class RegApp {
    static final int IBM = 0;
    static final int LOTUS = 1;
    static final int TIVOLI = 2;
    static final int CRAYOLA = 3;
    static final int BRAINQUEST = 4;
    static final int BRAND = 1;
    static final String strResPath = "/com/ibm/lexington/prt/res/";
    static final String GLOBE_GIF = "globe.gif";
    static final String BRAND_GIF = "brand.gif";
    private static long startTime;
    private static long stopTime;

    private static String copyright() {
        return "\n\nLicensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1999, 2000. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    }

    public static void main(String[] stringArray) {
        Object object;
        RegCommandLine.parseParam(stringArray);
        Scheduler.getInstance().cleanUp();
        if (RegCommandLine.getCleanRegistry().equalsIgnoreCase("retry")) {
            System.exit(0);
        }
        String string = RegCommandLine.getLanguage();
        String string2 = RegCommandLine.getCountry();
        String string3 = RegCommandLine.getLang();
        if (!string3.equalsIgnoreCase("NotSpecified")) {
            object = Language.getLanguage(Utility.convertLocale(string3));
            if (object != null) {
                ((Language)object).setDefaultLanguage();
            } else {
                Language.getDefaultLanguage();
            }
        } else if (string != null) {
            object = Language.getLanguage(Utility.checkLocale(string, string2));
            if (object != null) {
                ((Language)object).setDefaultLanguage();
            } else {
                Language.getDefaultLanguage();
            }
        } else {
            Language.getDefaultLanguage();
        }
        try {
            Object object2;
            if (SysInfo.getOSPlatform().equals("AIX") && (Locale.getDefault().toString().equals("ja_JP") || Locale.getDefault().toString().equals("ko_KR") || Locale.getDefault().toString().equals("zh_CN") || Locale.getDefault().toString().equals("zh_TW"))) {
                SystemProductInfo.type = "serif";
                SystemProductInfo.size = 13;
            }
            if (SysInfo.getOSPlatform().equals("OS2")) {
                System.out.println("Getting file encoding...");
                object = ResourceBundle.getBundle("com.ibm.lexington.prt.res.reg_encoding");
                System.out.println("Got file encoding...");
                ((Hashtable)System.getProperties()).put("file.encoding", (String)((ResourceBundle)object).getObject(Locale.getDefault().toString()));
            }
            try {
                SystemProductInfo.title = Language.rb_brand.getString(Integer.toString(313));
            }
            catch (Exception exception) {
                System.out.println("Problem with title " + exception);
            }
            if (SysInfo.getOSPlatform().equals("AIX") || SysInfo.getOSPlatform().equals("LINUX")) {
                object = Runtime.getRuntime().exec("env");
                ((Process)object).waitFor();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(((Process)object).getInputStream()));
                int n = -1;
                while (bufferedReader.ready()) {
                    object2 = new String(bufferedReader.readLine());
                    if (!((String)object2).startsWith("DISPLAY=") || ((String)object2).endsWith("DISPLAY=")) continue;
                    n = 1;
                }
                if (n == -1) {
                    System.out.println("DISPLAY environment variable not set; PRT cannot continue. Exiting...");
                    System.exit(1);
                }
            }
            object = RegCommandLine.getSplashDelay();
            int n = Integer.parseInt((String)object);
            n *= 1000;
            Splash splash = new Splash();
            stopTime = startTime = System.currentTimeMillis();
            object2 = new Contact();
            while (stopTime - startTime < (long)n) {
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                stopTime = System.currentTimeMillis();
            }
            splash.dispose();
            ((Component)object2).setVisible(true);
        }
        catch (Exception exception) {
            System.out.println("Exception occurred in RegApp.main()");
            exception.printStackTrace();
        }
    }
}

