/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lexington.prt;

import com.ibm.lexington.prt.SchedulerAIX;
import com.ibm.lexington.prt.SchedulerLinux;
import com.ibm.lexington.prt.SchedulerOS2;
import com.ibm.lexington.prt.SchedulerWindows;
import com.ibm.lexington.prt.SysInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public abstract class Scheduler {
    protected static final String EXEC_DATE = "EXEC_DATE";
    protected static final String EXEC_TIME = "EXEC_TIME";
    protected static final String EXEC_CMD = "EXEC_CMD";
    protected static final String AT_ID = "AT_ID";
    private static Scheduler scheduler;
    public static boolean setReminder;
    public static int delay;
    protected Properties prtPropFile = new Properties();
    protected String prtCmd;
    protected String prtDir = System.getProperty("user.dir");
    protected static String jreDir;

    static {
        setReminder = true;
        delay = 14;
    }

    public abstract void cleanUp();

    private static String copyright() {
        return "\n\nLicensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1999, 2000. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    }

    public abstract void createReminder(int var1);

    public static Scheduler getInstance() {
        if (scheduler == null) {
            if (SysInfo.getOSPlatform().equals("OS/2")) {
                scheduler = new SchedulerOS2();
            }
            if (SysInfo.getOSPlatform().equals("AIX")) {
                scheduler = new SchedulerAIX();
            }
            if (SysInfo.getOSPlatform().equals("LINUX")) {
                scheduler = new SchedulerLinux();
            }
            if (SysInfo.getOSPlatform().startsWith("WINDOWS")) {
                scheduler = new SchedulerWindows();
            }
        }
        return scheduler;
    }

    protected String getJREPath(String string) {
        if (jreDir == null) {
            String string2 = System.getProperty("user.dir");
            System.out.println("Current directory: " + string2);
            string2 = string2.substring(0, string2.lastIndexOf(File.separator.charAt(0)));
            jreDir = String.valueOf(string2) + File.separator + string;
        }
        return jreDir;
    }

    public String getProducts() {
        return "";
    }

    protected String getPrtCmd(String string) {
        if (this.prtCmd == null) {
            String string2 = new String(File.separator);
            File file = new File(this.prtDir);
            String[] stringArray = file.list();
            String string3 = new String();
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].toLowerCase().endsWith("jar")) {
                    string3 = String.valueOf(string3) + this.prtDir + string2 + stringArray[n] + string;
                }
                ++n;
            }
            this.prtCmd = new String(String.valueOf(jreDir) + string2 + "bin" + string2 + "jre -nojit -cp " + string3 + this.prtDir + string2 + " com.ibm.lexington.prt.RegApp " + this.getProducts() + "/connect=yes /prtdir=" + this.prtDir + " /jredir=" + jreDir + " > " + this.prtDir + string2 + "out.txt");
        }
        return this.prtCmd;
    }

    protected void loadProperties() {
        try {
            FileInputStream fileInputStream = new FileInputStream(String.valueOf(System.getProperty("user.dir")) + File.separator + "prt.prp");
            this.prtPropFile.load(fileInputStream);
            fileInputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("load exception: " + iOException);
        }
    }

    protected void saveProperties() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(String.valueOf(System.getProperty("user.dir")) + File.separator + "prt.prp");
            this.prtPropFile.save(fileOutputStream, "IBM PRT Properties");
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("save error: " + iOException);
        }
    }

    public static void setJREDir(String string) throws Exception {
        File file = new File(String.valueOf(string) + File.separator + "bin");
        if (!file.isDirectory()) {
            throw new Exception(String.valueOf(file.toString()) + " does not exist.");
        }
        jreDir = string;
    }
}

