/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lexington.prt;

import com.ibm.lexington.prt.Scheduler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.StringTokenizer;

public final class SchedulerLinux
extends Scheduler {
    private File atTxtFile;
    private String prtCmd;
    private String atCmd;

    public SchedulerLinux() {
        this.getJREPath("linux118");
    }

    public void cleanUp() {
        if (Scheduler.setReminder) {
            if (this.getAtTxt().exists()) {
                System.out.println("Deleted " + this.getAtTxt().toString());
                this.getAtTxt().delete();
            }
            this.killAtCmd();
        }
    }

    private static String copyright() {
        return "\n\nLicensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1999, 2000. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    }

    public void createAtFile() {
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new FileOutputStream(this.getAtTxt()));
        }
        catch (IOException iOException) {
            System.out.println("File not opened properly\n" + iOException.toString());
        }
        printWriter.println(this.getPrtCmd(":"));
        printWriter.flush();
        printWriter.close();
        System.out.println("Wrote to: " + this.getAtTxt().toString());
        try {
            String string = new String("chmod 777 " + this.getAtTxt().toString());
            System.out.println("Executing: " + string);
            Process process = Runtime.getRuntime().exec(string);
            process.waitFor();
        }
        catch (Exception exception) {
            System.out.println("Runtime.exec Exception: " + exception);
        }
    }

    public void createReminder(int n) {
        if (Scheduler.setReminder) {
            this.loadProperties();
            Scheduler.delay = n;
            this.createAtFile();
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            String string = new String(" + " + Scheduler.delay + " days ");
            String string2 = new String(String.valueOf(Integer.toString(gregorianCalendar.get(11))) + ":" + Integer.toString(gregorianCalendar.get(12)));
            this.atCmd = new String("at -f " + this.getAtTxt().toString() + " " + string2 + string);
            System.out.println("Spawned: " + this.atCmd);
            try {
                Process process = Runtime.getRuntime().exec(this.atCmd);
                process.waitFor();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                StringBuffer stringBuffer = new StringBuffer();
                String string3 = bufferedReader.readLine();
                while (string3 != null) {
                    stringBuffer.append(String.valueOf(string3) + " \n");
                    string3 = bufferedReader.readLine();
                }
                System.out.println("at cmd returned: " + stringBuffer.toString());
                StringTokenizer stringTokenizer = new StringTokenizer(stringBuffer.toString());
                String string4 = new String();
                while (stringTokenizer.hasMoreTokens() && !string4.equals("job")) {
                    string4 = stringTokenizer.nextToken();
                }
                String string5 = new String();
                if (stringTokenizer.hasMoreTokens()) {
                    string5 = stringTokenizer.nextToken();
                }
                System.out.println("job id: " + string5);
                ((Hashtable)this.prtPropFile).put("AT_ID", string5);
                this.saveProperties();
            }
            catch (Exception exception) {
                System.out.println("Runtime.exec Exception: " + exception);
            }
        }
    }

    private File getAtTxt() {
        if (this.atTxtFile == null) {
            this.atTxtFile = new File(String.valueOf(this.prtDir) + File.separator + "at.txt");
        }
        return this.atTxtFile;
    }

    public void killAtCmd() {
        try {
            this.loadProperties();
            String string = new String();
            string = (String)((Hashtable)this.prtPropFile).get("AT_ID");
            if (string != null) {
                Process process = Runtime.getRuntime().exec("atrm " + string);
                process.waitFor();
                System.out.println("Executed atrm " + string);
                ((Hashtable)this.prtPropFile).remove("AT_ID");
            }
            this.saveProperties();
        }
        catch (Exception exception) {
            System.out.println("killAtCmd Exception: " + exception);
        }
    }
}

