/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lexington.prt;

import com.ibm.lexington.prt.Scheduler;
import com.ibm.lexington.prt.SysInfo;
import com.ibm.lexington.prt.Utility;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.util.GregorianCalendar;
import java.util.Hashtable;

public final class SchedulerOS2
extends Scheduler {
    private File configSysFile;
    private File configTmpFile;
    private File remindCmdFile;
    private String runCmd;
    private String prtCmd;

    public SchedulerOS2() {
        this.getJREPath("os2118");
    }

    public void checkSchedule() {
        this.loadProperties();
        String string = (String)((Hashtable)this.prtPropFile).get("EXEC_DATE");
        String string2 = (String)((Hashtable)this.prtPropFile).get("EXEC_CMD");
        System.out.println("day:" + string);
        System.out.println("command:" + string2);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        int n = gregorianCalendar.get(6);
        int n2 = 0;
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Exception: " + numberFormatException);
        }
        if (Math.abs(n - n2) >= Scheduler.delay) {
            Runtime runtime = Runtime.getRuntime();
            try {
                System.out.println("Spawning: cmd.exe /c " + string2);
                runtime.exec("cmd.exe /c " + string2);
            }
            catch (Exception exception) {
                System.out.println("Runtime.exec Exception: " + exception);
            }
        } else {
            System.out.println("Diff: " + Math.abs(n - n2));
            System.out.println("Delay: " + Scheduler.delay);
        }
        System.exit(0);
    }

    public void checkSchedule(String string) {
        this.loadProperties();
        String string2 = (String)((Hashtable)this.prtPropFile).get("EXEC_DATE");
        String string3 = (String)((Hashtable)this.prtPropFile).get("EXEC_CMD");
        System.out.println("day:" + string2);
        System.out.println("command:" + string3);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        int n = gregorianCalendar.get(6);
        int n2 = 0;
        try {
            n2 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Exception: " + numberFormatException);
        }
        if (Math.abs(n - n2) >= Scheduler.delay) {
            Runtime runtime = Runtime.getRuntime();
            try {
                System.out.println("Spawning: cmd.exe /c " + string3);
                runtime.exec("cmd.exe /c " + string3);
            }
            catch (Exception exception) {
                System.out.println("Runtime.exec Exception: " + exception);
            }
        } else {
            System.out.println("Diff: " + Math.abs(n - n2));
            System.out.println("Delay: " + Scheduler.delay);
        }
        System.exit(0);
    }

    public void cleanUp() {
        if (Scheduler.setReminder) {
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new FileReader(this.getConfigSys()));
            }
            catch (Exception exception) {
                System.out.println("Exception: " + exception);
            }
            PrintWriter printWriter = null;
            try {
                printWriter = new PrintWriter(new FileOutputStream(this.getConfigTmp()));
            }
            catch (IOException iOException) {
                System.out.println("File not opened properly\n" + iOException.toString());
            }
            try {
                String string = new String();
                string = bufferedReader.readLine();
                while (string != null) {
                    if (string.toUpperCase().startsWith("RUN") && string.toLowerCase().indexOf("remind.cmd") != -1) {
                        System.out.println("Removed Run Command: " + string);
                        string = new String();
                    }
                    if (string.length() != 0) {
                        printWriter.print(String.valueOf(string) + "\r\n");
                    }
                    string = bufferedReader.readLine();
                }
                printWriter.flush();
                printWriter.close();
                bufferedReader.close();
                Process process = Runtime.getRuntime().exec("cmd.exe /c copy " + this.getConfigTmp().toString() + " " + this.getConfigSys().toString());
                process.waitFor();
                if (this.getConfigTmp().exists()) {
                    System.out.println("Deleted " + this.getConfigTmp().toString());
                    this.getConfigTmp().delete();
                }
                if (this.getRemindCmd().exists()) {
                    System.out.println("Deleted " + this.getRemindCmd().toString());
                    this.getRemindCmd().delete();
                }
            }
            catch (Exception exception) {
                System.out.println("Exception: " + exception);
            }
        }
    }

    private static String copyright() {
        return "\n\nLicensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1999, 2000. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    }

    public void createReminder(int n) {
        if (Scheduler.setReminder) {
            this.loadProperties();
            Scheduler.delay = n;
            this.updateConfigSys();
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            String string = new String(String.valueOf(Integer.toString(gregorianCalendar.get(11))) + ":" + Integer.toString(gregorianCalendar.get(12)));
            String string2 = new String(Integer.toString(gregorianCalendar.get(6)));
            ((Hashtable)this.prtPropFile).put("EXEC_DATE", string2);
            ((Hashtable)this.prtPropFile).put("EXEC_TIME", string);
            ((Hashtable)this.prtPropFile).put("EXEC_CMD", this.getPrtCmd(";"));
            this.createRemindFile();
            this.saveProperties();
        }
    }

    public void createRemindFile() {
        File file = new File(this.prtDir);
        String[] stringArray = file.list();
        String string = new String();
        String string2 = File.separator;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].toLowerCase().endsWith("jar")) {
                string = String.valueOf(string) + this.prtDir + string2 + stringArray[n] + ";";
            }
            ++n;
        }
        String string3 = new String(String.valueOf(Scheduler.jreDir) + string2 + "bin" + string2 + "jre -nojit -cp " + string + this.prtDir + string2 + " com.ibm.lexington.prt.SchedulerOS2 " + "/prtdir=" + this.prtDir);
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new FileOutputStream(this.getRemindCmd()));
        }
        catch (IOException iOException) {
            System.out.println("File not opened properly\n" + iOException.toString());
        }
        printWriter.println(string3);
        printWriter.flush();
        printWriter.close();
        System.out.println("Wrote to: " + this.getRemindCmd().toString());
    }

    public File getConfigSys() {
        if (this.configSysFile == null) {
            this.configSysFile = new File(String.valueOf(SysInfo.getInstance().getRoot()) + "config.sys");
        }
        return this.configSysFile;
    }

    public File getConfigTmp() {
        if (this.configTmpFile == null) {
            this.configTmpFile = new File(String.valueOf(this.prtDir) + File.separator + "config.tmp");
        }
        return this.configTmpFile;
    }

    public File getRemindCmd() {
        if (this.remindCmdFile == null) {
            this.remindCmdFile = new File(String.valueOf(this.prtDir) + File.separator + "remind.cmd");
        }
        return this.remindCmdFile;
    }

    public String getRunCmd() {
        if (this.runCmd == null) {
            this.runCmd = new String("RUN=" + SysInfo.getInstance().getRoot() + "OS2" + File.separator + "CMD.EXE /C " + this.prtDir + File.separator + "remind.cmd");
        }
        return this.runCmd;
    }

    public static void main(String[] stringArray) {
        int n = Array.getLength(stringArray);
        String string = null;
        try {
            if (n > 0) {
                int n2 = 0;
                while (n2 < n) {
                    int n3;
                    if (stringArray[n2].charAt(0) == '/' && (n3 = stringArray[n2].indexOf(61)) > 0) {
                        String string2 = stringArray[n2].substring(1, n3);
                        String string3 = stringArray[n2].substring(n3 + 1);
                        if (string2.toLowerCase().equals("prtdir")) {
                            try {
                                String string4 = Utility.chgDir(string3.trim());
                                ((Hashtable)System.getProperties()).put("user.dir", string4);
                            }
                            catch (Exception exception) {
                                System.out.println("Error setting prtdir: " + exception);
                            }
                        }
                        if (string2.toLowerCase().equals("delay")) {
                            try {
                                Scheduler.delay = Integer.parseInt(string3);
                            }
                            catch (NumberFormatException numberFormatException) {
                                Scheduler.delay = 14;
                            }
                        }
                    }
                    ++n2;
                }
            }
            SchedulerOS2 schedulerOS2 = new SchedulerOS2();
            if (string == null) {
                string = ".\\";
            }
            schedulerOS2.checkSchedule();
        }
        catch (Throwable throwable) {
            System.out.println("Exception : " + throwable);
        }
    }

    public void updateConfigSys() {
        boolean bl = false;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(this.getConfigSys()));
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception);
        }
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new FileOutputStream(this.getConfigTmp()));
        }
        catch (IOException iOException) {
            System.out.println("File not opened properly\n" + iOException.toString());
        }
        try {
            String string = new String();
            string = bufferedReader.readLine();
            while (string != null) {
                if (string.toUpperCase().startsWith("RUN") && string.toLowerCase().indexOf("remind.cmd") != -1) {
                    bl = true;
                    System.out.println("Found Run Command: " + string);
                }
                if (string.trim().length() != 0) {
                    printWriter.print(String.valueOf(string) + "\r\n");
                }
                string = bufferedReader.readLine();
            }
            if (!bl) {
                System.out.println("Added Run Command to Config.sys: " + this.getRunCmd());
                printWriter.print(String.valueOf(this.getRunCmd()) + "\r\n");
            }
            printWriter.flush();
            printWriter.close();
            bufferedReader.close();
            if (!bl) {
                String string2 = new String("cmd.exe /c copy " + this.getConfigTmp().toString() + " " + this.getConfigSys().toString());
                Process process = Runtime.getRuntime().exec(string2);
                process.waitFor();
                System.out.println("Executed: " + string2);
            }
            if (this.getConfigTmp().exists()) {
                System.out.println("Deleted " + this.getConfigTmp().toString());
                this.getConfigTmp().delete();
            }
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception);
        }
    }
}

