/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lexington.prt;

import com.ibm.lexington.prt.Brand;
import com.ibm.lexington.prt.CustInfo;
import com.ibm.lexington.prt.EmbeddedPartFile;
import com.ibm.lexington.prt.Language;
import com.ibm.lexington.prt.SystemProductInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;

public class Splash
extends JWindow {
    private JPanel ivjJWindowContentPane = null;
    private JLabel ivjSplashLabel = null;
    private static final String m_defaultNumProds = "1";
    private static final String m_defaultPartName = "prod1";
    private static final String m_defaultPartValue = "IBMLexNone";
    private static final String m_defaultProdValue = "Unknown";

    public Splash() {
        this.getPartInfo();
        this.initialize();
        ((Component)this).setVisible(true);
    }

    private static String copyright() {
        return "\n\n(c) Copyright IBM Corporation 1999, 2000.\n\n";
    }

    private void getPartInfo() {
        SystemProductInfo systemProductInfo = SystemProductInfo.getInstance();
        if (EmbeddedPartFile.getInstance() != null) {
            if (EmbeddedPartFile.getInstance().productType().equalsIgnoreCase("SUITE")) {
                systemProductInfo.setProductName(EmbeddedPartFile.getInstance().productName());
                systemProductInfo.readCommandLine();
            }
            if (systemProductInfo.getNumProducts() == null) {
                systemProductInfo.readFile();
            }
        }
        if (systemProductInfo.getNumProducts() == null) {
            systemProductInfo.setNumProducts(m_defaultNumProds);
            systemProductInfo.setProduct(m_defaultPartName, m_defaultPartValue);
            systemProductInfo.setProductName(m_defaultProdValue);
        }
    }

    private void initialize() {
        CustInfo.getInstance().readRegistry();
        try {
            Brand brand = Brand.getBrand();
            String string = brand.getBrandStringLow();
            this.setName("Splash");
            String string2 = Language.getDefaultLanguage().getLanguageString();
            if (!(string2.equals("zh_CN") || string2.equals("zh_TW") || string2.equals("pt_BR"))) {
                string2 = string2.substring(0, 2);
            }
            String string3 = String.valueOf(string) + string2 + ".gif";
            ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/com/ibm/lexington/prt/res/" + string3));
            this.ivjJWindowContentPane = new JPanel();
            this.ivjJWindowContentPane.setName("JWindowContentPane");
            this.ivjJWindowContentPane.setLayout(new BorderLayout());
            this.ivjSplashLabel = new JLabel();
            this.ivjSplashLabel.setName("JLabel1");
            this.ivjSplashLabel.setIcon(imageIcon);
            this.ivjJWindowContentPane.add((Component)this.ivjSplashLabel, "Center");
            this.setContentPane(this.ivjJWindowContentPane);
            ((Component)this).setSize(imageIcon.getIconWidth(), imageIcon.getIconHeight());
            Dimension dimension = this.getSize();
            Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
            int n = dimension2.height / 2 - dimension.height / 2;
            int n2 = dimension2.width / 2 - dimension.width / 2;
            ((Component)this).setLocation(n2, n);
        }
        catch (Throwable throwable) {
            System.err.println("Exception occurred in Splash.initialize()" + throwable);
            throwable.printStackTrace(System.out);
        }
    }
}

