/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lexington.prt;

import com.ibm.lexington.prt.RegCommandLine;
import com.ibm.lexington.prt.Scheduler;
import com.ibm.lexington.prt.SysInfoAIX;
import com.ibm.lexington.prt.SysInfoLinux;
import com.ibm.lexington.prt.SysInfoOS2;
import com.ibm.lexington.prt.SysInfoWindows;

public abstract class SysInfo {
    public static final String GeneralSection = "General";
    public static final String registryKey = "Software\\IBM\\Product Registration";
    private static String m_strNetscapePath = "";
    public static SysInfo sysInfo = null;

    public static boolean addBookmark(String string, String string2) {
        System.out.println("Adding bookmark");
        if (SysInfo.getOSPlatform().equals("OS/2")) {
            return SysInfoOS2.addBookmark(string, string2);
        }
        if (SysInfo.getOSPlatform().equals("LINUX")) {
            return SysInfoLinux.addBookmark(string, string2);
        }
        if (SysInfo.getOSPlatform().equals("WINDOWS NT")) {
            return SysInfoWindows.addBookmark(string, string2);
        }
        return false;
    }

    private static String copyright() {
        return "\n\nLicensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1999, 2000. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    }

    public static String findPathToNSFile(String string) {
        return null;
    }

    public static SysInfo getInstance() {
        if (sysInfo == null) {
            if (SysInfo.getOSPlatform().startsWith("WINDOWS")) {
                sysInfo = new SysInfoWindows();
            } else if (SysInfo.getOSPlatform().equals("OS/2")) {
                sysInfo = new SysInfoOS2();
            } else if (SysInfo.getOSPlatform().equals("AIX")) {
                sysInfo = new SysInfoAIX();
            } else if (SysInfo.getOSPlatform().equals("LINUX")) {
                sysInfo = new SysInfoLinux();
            }
        }
        return sysInfo;
    }

    public static String getOSPlatform() {
        return System.getProperty("os.name").toUpperCase();
    }

    public static String getOSVersion() {
        return System.getProperty("os.version");
    }

    public abstract String getRoot();

    public static void main(String[] stringArray) {
    }

    public abstract int readRegistryInt(String var1, String var2);

    public abstract String readRegistryString(String var1, String var2);

    public static boolean removeStartupKey() {
        return false;
    }

    public static void reschedule(int n, int n2, int n3) {
        if (RegCommandLine.getRegisterLater().equalsIgnoreCase("no")) {
            return;
        }
        Scheduler scheduler = Scheduler.getInstance();
        scheduler.createReminder(n);
    }

    public void saveRegistryKeys() {
    }

    public abstract boolean writeRegistryInt(String var1, String var2, int var3);

    public abstract boolean writeRegistryString(String var1, String var2, String var3);
}

