/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lexington.prt;

import com.ibm.lexington.prt.SysInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;

public final class SysInfoAIX
extends SysInfo {
    private File dbFile = null;
    private Properties registry = null;
    private boolean saveRegistry = false;

    public SysInfoAIX() {
        this.load();
    }

    private static String copyright() {
        return "\n\nLicensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1999, 2000. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    }

    public void finalize() {
        try {
            if (this.saveRegistry) {
                this.saveRegistryKeys();
            }
            super.finalize();
        }
        catch (Throwable throwable) {
            System.out.println("Failed to save Registry:" + throwable);
        }
    }

    private File getDBFile() {
        if (this.dbFile == null) {
            this.dbFile = new File("/usr/bin/ibmprt.db");
        }
        return this.dbFile;
    }

    private Properties getRegistry() {
        if (this.registry == null) {
            this.registry = new Properties();
        }
        return this.registry;
    }

    public String getRoot() {
        return "/";
    }

    private void load() {
        try {
            FileInputStream fileInputStream = new FileInputStream(this.getDBFile());
            this.getRegistry().load(fileInputStream);
            fileInputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("load exception: " + iOException);
        }
    }

    public int readRegistryInt(String string, String string2) {
        String string3 = this.readRegistryString(string, string2);
        if (string3.length() == 0) {
            return -1;
        }
        return Integer.parseInt(string3);
    }

    public String readRegistryString(String string, String string2) {
        String string3 = new String("Software/IBM/Product_registration/" + string + "/" + string2);
        String string4 = this.getRegistry().getProperty(string3);
        if (string4 != null) {
            return string4.toString();
        }
        return "";
    }

    public void saveRegistryKeys() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.getDBFile());
            this.getRegistry().save(fileOutputStream, "IBM Product Registration");
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("sava error: " + iOException);
        }
    }

    public boolean writeRegistryInt(String string, String string2, int n) {
        this.writeRegistryString(string, string2, new Integer(n).toString());
        return true;
    }

    public boolean writeRegistryString(String string, String string2, String string3) {
        this.saveRegistry = true;
        String string4 = new String("Software/IBM/Product_registration/" + string + "/" + string2);
        ((Hashtable)this.getRegistry()).put(string4, string3);
        return true;
    }
}

