/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lexington.prt;

import com.ibm.lexington.prt.FileFilter;
import com.ibm.lexington.prt.SysInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Hashtable;
import java.util.Properties;

public final class SysInfoLinux
extends SysInfo {
    private File dbFile = null;
    private Properties registry = null;
    private boolean saveRegistry = false;

    public SysInfoLinux() {
        this.load();
    }

    public static boolean addBookmark(String string, String string2) {
        String string3 = SysInfoLinux.findPathToNSFile("bookmarks.html");
        if (string3.length() == 0) {
            return false;
        }
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(String.valueOf(string3) + "bookmarks.html", "rw");
            randomAccessFile.seek(randomAccessFile.length());
            String string4 = new String("<DT><A HREF=\"");
            string4 = String.valueOf(string4) + string2;
            string4 = String.valueOf(string4) + "\" ADD_DATE=\"910212194\" LAST_VISIT=\"0\" LAST_MODIFIED=\"0\">";
            string4 = String.valueOf(string4) + string;
            string4 = String.valueOf(string4) + "</A>\n";
            randomAccessFile.writeBytes(string4);
            randomAccessFile.close();
        }
        catch (Exception exception) {
            System.out.println("Error adding bookmarks!");
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    private static String copyright() {
        return "\n\nLicensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1999, 2000. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    }

    public void finalize() {
        try {
            if (this.saveRegistry) {
                this.saveRegistryKeys();
            }
            super.finalize();
        }
        catch (Throwable throwable) {
            System.out.println("Failed to save Registry:" + throwable);
        }
    }

    public static String findPathToNSFile(String string) {
        FileFilter fileFilter;
        String[] stringArray;
        String string2 = "";
        new String();
        File file = new File(SysInfoLinux.getNetscapePath());
        if (file.isDirectory() && (stringArray = file.list(fileFilter = new FileFilter(string))).length == 1) {
            string2 = file.toString();
        }
        System.out.println("File " + string + " path : " + string2);
        return string2;
    }

    private File getDBFile() {
        if (this.dbFile == null) {
            this.dbFile = new File("/usr/bin/ibmprt.db");
        }
        return this.dbFile;
    }

    private static String getNetscapePath() {
        return "/root/.netscape/";
    }

    private Properties getRegistry() {
        if (this.registry == null) {
            this.registry = new Properties();
        }
        return this.registry;
    }

    public String getRoot() {
        return "/";
    }

    private void load() {
        try {
            FileInputStream fileInputStream = new FileInputStream(this.getDBFile());
            this.getRegistry().load(fileInputStream);
            fileInputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("load exception: " + iOException);
        }
    }

    public int readRegistryInt(String string, String string2) {
        String string3 = this.readRegistryString(string, string2);
        if (string3.length() == 0) {
            return -1;
        }
        return Integer.parseInt(string3);
    }

    public String readRegistryString(String string, String string2) {
        String string3 = new String("Software/IBM/Product_registration/" + string + "/" + string2);
        String string4 = this.getRegistry().getProperty(string3);
        if (string4 != null) {
            return string4.toString();
        }
        return "";
    }

    public void saveRegistryKeys() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.getDBFile());
            this.getRegistry().save(fileOutputStream, "IBM Product Registration");
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("sava error: " + iOException);
        }
    }

    public boolean writeRegistryInt(String string, String string2, int n) {
        this.writeRegistryString(string, string2, new Integer(n).toString());
        return true;
    }

    public boolean writeRegistryString(String string, String string2, String string3) {
        this.saveRegistry = true;
        String string4 = new String("Software/IBM/Product_registration/" + string + "/" + string2);
        ((Hashtable)this.getRegistry()).put(string4, string3);
        return true;
    }
}

