/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lexington.prt;

import com.ibm.lexington.prt.Brand;
import com.ibm.lexington.prt.EmbeddedPartFile;
import com.ibm.lexington.prt.Language;
import com.ibm.lexington.prt.RegCommandLine;
import com.ibm.lexington.prt.URLEncoder;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class SystemProductInfo {
    public static final int offset = 20;
    public static int Contact_xvalue = 0;
    public static int Contact_yvalue = 0;
    public static int BiosInfo_xvalue = 0;
    public static int BiosInfo_yvalue = 0;
    public static int AddInfo_xvalue = 0;
    public static int AddInfo_yvalue = 0;
    public static String type = "sanserif";
    public static int size = 11;
    public static String title;
    private static final String NumProducts = "numOfProds";
    private static final String OSPlatform = "q2";
    private static final String OSVersion = "q3";
    static final String Product = "prod";
    private static final String ProdName = "prodName";
    private static final String biosProdName = "q16";
    private static final String biosManuf = "q15";
    private static final String biosSerialNum = "q17";
    private static SystemProductInfo m_instance;
    private String m_message;
    private Hashtable m_hash = new Hashtable();
    private Hashtable m_biosHash = new Hashtable();
    private boolean m_biosSend = true;

    static {
        m_instance = null;
    }

    protected SystemProductInfo() {
    }

    private static String copyright() {
        return "\n\nLicensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1999, 2000. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    }

    public boolean doBiosProcessing() {
        this.m_biosHash.put(biosManuf, "");
        this.m_biosHash.put(biosProdName, "");
        this.m_biosHash.put(biosSerialNum, "");
        return false;
    }

    public String format() {
        String string;
        String string2;
        Enumeration enumeration = this.m_hash.keys();
        Enumeration enumeration2 = this.m_hash.elements();
        boolean bl = true;
        this.m_message = "";
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            string = (String)enumeration2.nextElement();
            if (!bl) {
                this.m_message = String.valueOf(this.m_message) + "&";
            } else {
                bl = false;
            }
            this.m_message = String.valueOf(this.m_message) + string2;
            this.m_message = String.valueOf(this.m_message) + "=";
            if (string == "") {
                string = " ";
            }
            URLEncoder.encode(string);
            this.m_message = String.valueOf(this.m_message) + string;
        }
        if (this.m_biosSend) {
            enumeration = this.m_biosHash.keys();
            enumeration2 = this.m_biosHash.elements();
            bl = true;
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                string = (String)enumeration2.nextElement();
                if (!bl) {
                    this.m_message = String.valueOf(this.m_message) + "&";
                } else {
                    if (this.m_message.length() > 0) {
                        this.m_message = String.valueOf(this.m_message) + "&";
                    }
                    bl = false;
                }
                this.m_message = String.valueOf(this.m_message) + string2;
                this.m_message = String.valueOf(this.m_message) + "=";
                if (string == "") {
                    string = " ";
                }
                URLEncoder.encode(string);
                this.m_message = String.valueOf(this.m_message) + string;
            }
        }
        return this.m_message;
    }

    public void getBiosInfo(String string, String string2, String string3) {
        string = (String)this.m_biosHash.get(biosManuf);
        string2 = (String)this.m_biosHash.get(biosProdName);
        string3 = (String)this.m_biosHash.get(biosSerialNum);
    }

    public boolean getBiosSend() {
        return this.m_biosSend;
    }

    public String getFormattedProducts() {
        String string = this.getNumProducts();
        int n = Integer.parseInt(string);
        String string2 = "";
        String string3 = Product;
        int n2 = 1;
        while (n2 < n + 1) {
            string2 = String.valueOf(string2) + " " + this.getProduct(String.valueOf(string3) + Integer.toString(n2));
            ++n2;
        }
        string2.trim();
        return string2;
    }

    public static SystemProductInfo getInstance() {
        if (m_instance == null) {
            m_instance = new SystemProductInfo();
        }
        return m_instance;
    }

    public String getNumProducts() {
        return (String)this.m_hash.get(NumProducts);
    }

    public String getOSPlatform() {
        return (String)this.m_hash.get(OSPlatform);
    }

    public String getOSVersion() {
        return (String)this.m_hash.get(OSVersion);
    }

    public String getProduct(String string) {
        return (String)this.m_hash.get(string);
    }

    public String getProductName() {
        return (String)this.m_hash.get(ProdName);
    }

    public String getSRTVersion() {
        String string = Language.rb_comall.getString(Integer.toString(1059));
        String string2 = "RENAMED.JAR";
        StringTokenizer stringTokenizer = new StringTokenizer(System.getProperty("java.class.path"), String.valueOf(File.separator) + File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().toLowerCase();
            if (!string3.endsWith(".jar") || string3.startsWith("swing")) continue;
            string2 = string3;
            break;
        }
        return String.valueOf(string) + Brand.getBrand().getBrandName() + " " + string2;
    }

    public void readCommandLine() {
        Vector vector = RegCommandLine.getParts();
        String string = Product;
        if (!vector.isEmpty()) {
            int n = vector.size();
            if (n > 0) {
                this.setNumProducts(Integer.toString(n));
                int n2 = 1;
                while (n2 <= n) {
                    this.setProduct(String.valueOf(string) + Integer.toString(n2), (String)vector.elementAt(n2 - 1));
                    ++n2;
                }
            } else {
                this.setNumProducts("0");
            }
        } else {
            this.setNumProducts("0");
        }
    }

    public void readFile() {
        Language language = Language.getDefaultLanguage();
        int n = language.getLangIndex();
        EmbeddedPartFile embeddedPartFile = EmbeddedPartFile.getInstance();
        this.setProductName(embeddedPartFile.productName());
        int n2 = embeddedPartFile.numParts(n);
        String string = Integer.toString(n2);
        if (n2 > 0) {
            this.setNumProducts(string);
            int n3 = 0;
            while (n3 < n2) {
                String string2 = Product + Integer.toString(n3 + 1);
                String string3 = embeddedPartFile.partNumber(n, n3);
                this.setProduct(string2, string3);
                ++n3;
            }
        } else {
            String string4 = embeddedPartFile.defaultPartNumber();
            if ((string4 = string4.trim()) != "") {
                this.setNumProducts("1");
                this.setProduct("prod1", embeddedPartFile.defaultPartNumber());
            }
        }
    }

    public void setBiosSend(boolean bl) {
        this.m_biosSend = bl;
    }

    public void setNumProducts(String string) {
        this.m_hash.put(NumProducts, string);
    }

    public void setOSPlatform(String string) {
        this.m_hash.put(OSPlatform, string);
    }

    public void setOSVersion(String string) {
        this.m_hash.put(OSVersion, string);
    }

    public void setProduct(String string, String string2) {
        this.m_hash.put(string, string2);
    }

    public void setProductName(String string) {
        this.m_hash.put(ProdName, string);
    }
}

