/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lexington.prt;

import com.ibm.lexington.prt.Brand;
import com.ibm.lexington.prt.CustInfo;
import com.ibm.lexington.prt.Language;
import com.ibm.lexington.prt.RegException;
import com.ibm.lexington.prt.SysInfo;
import com.ibm.lexington.prt.SystemProductInfo;
import com.ibm.lexington.prt.res.StrBounds;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.util.Locale;
import javax.swing.JCheckBox;
import javax.swing.JFrame;

public class URLs {
    private JFrame m_parent;
    private JCheckBox[] m_pCheckBoxes;
    private int m_hb;
    private int m_NumberOfDisplayedURLs;

    public URLs(JFrame jFrame, int n) {
        this.m_parent = jFrame;
        this.m_hb = n;
        this.initialize();
        this.doDataExchange();
    }

    public void addBookmarks() {
        if (SysInfo.getOSPlatform().equals("AIX")) {
            return;
        }
        CustInfo custInfo = CustInfo.getInstance();
        boolean bl = true;
        boolean bl2 = false;
        Brand brand = Brand.getBrand();
        int n = brand.numberOfURLs();
        int n2 = 0;
        while (n2 < n && bl) {
            switch (n2) {
                case 0: {
                    bl2 = custInfo.getCheckURL1();
                    break;
                }
                case 1: {
                    bl2 = custInfo.getCheckURL2();
                    break;
                }
                case 2: {
                    bl2 = custInfo.getCheckURL3();
                }
            }
            if (bl2) {
                int n3 = brand.getURLCheckTextId(n2);
                int n4 = brand.getURLString(n2);
                String string = Language.rb_brand.getString(Integer.toString(n3));
                String string2 = Language.rb_combrand.getString(Integer.toString(n4));
                bl = SysInfo.addBookmark(string, string2);
            }
            ++n2;
        }
        if (!bl) {
            RegException regException = new RegException(215);
            regException.showMessage();
        }
    }

    private static String copyright() {
        return "\n\nLicensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1999, 2000. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    }

    public void doDataExchange() {
        if (SysInfo.getOSPlatform().equals("AIX")) {
            return;
        }
        this.setHomeBusiness(this.m_hb);
    }

    private void initialize() {
        if (SysInfo.getOSPlatform().equals("AIX")) {
            return;
        }
        try {
            Brand brand = Brand.getBrand();
            int n = brand.numberOfURLCheckBoxes();
            this.m_pCheckBoxes = new JCheckBox[n];
            this.m_pCheckBoxes[0] = new JCheckBox();
            this.m_pCheckBoxes[0].setName("CheckboxURL1");
            this.m_pCheckBoxes[0].setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.m_pCheckBoxes[0].setBackground(Color.lightGray);
            this.m_pCheckBoxes[1] = new JCheckBox();
            this.m_pCheckBoxes[1].setName("CheckboxURL2");
            this.m_pCheckBoxes[1].setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.m_pCheckBoxes[1].setBackground(Color.lightGray);
            this.m_pCheckBoxes[2] = new JCheckBox();
            this.m_pCheckBoxes[2].setName("CheckboxURL3");
            this.m_pCheckBoxes[2].setFont(new Font(SystemProductInfo.type, 0, SystemProductInfo.size));
            this.m_pCheckBoxes[2].setBackground(Color.lightGray);
            StrBounds strBounds = (StrBounds)Language.rb_24.getObject(Integer.toString(2221));
            StrBounds strBounds2 = (StrBounds)Language.rb_24.getObject(Integer.toString(2205));
            StrBounds strBounds3 = (StrBounds)Language.rb_24.getObject(Integer.toString(2204));
            this.m_pCheckBoxes[0].setText(Language.rb_brand.getString(Integer.toString(300)));
            this.m_pCheckBoxes[1].setText(Language.rb_brand.getString(Integer.toString(302)));
            this.m_pCheckBoxes[2].setText(Language.rb_brand.getString(Integer.toString(304)));
            Point point = strBounds.returnPoint();
            Point point2 = strBounds2.returnPoint();
            Point point3 = strBounds3.returnPoint();
            Dimension dimension = strBounds.returnDimension();
            Dimension dimension2 = strBounds2.returnDimension();
            Dimension dimension3 = strBounds3.returnDimension();
            this.m_pCheckBoxes[0].setBounds(point.x - SystemProductInfo.AddInfo_xvalue, point.y - (20 + SystemProductInfo.AddInfo_yvalue), dimension.width, dimension.height);
            this.m_pCheckBoxes[1].setBounds(point2.x - SystemProductInfo.AddInfo_xvalue, point2.y - (20 + SystemProductInfo.AddInfo_yvalue), dimension2.width + 30, dimension2.height);
            this.m_pCheckBoxes[2].setBounds(point3.x - SystemProductInfo.AddInfo_xvalue, point3.y - (20 + SystemProductInfo.AddInfo_yvalue), dimension3.width, dimension3.height);
            if (SysInfo.getOSPlatform().equals("lotus") || Locale.getDefault().toString().equals("pl_PL")) {
                this.m_pCheckBoxes[2].setBounds(point3.x - SystemProductInfo.AddInfo_xvalue, point3.y - (20 + SystemProductInfo.AddInfo_yvalue), dimension3.width + 50, dimension3.height);
            }
            this.m_parent.getContentPane().add((Component)this.m_pCheckBoxes[0], this.m_pCheckBoxes[0].getName());
            this.m_parent.getContentPane().add((Component)this.m_pCheckBoxes[1], this.m_pCheckBoxes[1].getName());
            this.m_parent.getContentPane().add((Component)this.m_pCheckBoxes[2], this.m_pCheckBoxes[2].getName());
        }
        catch (Throwable throwable) {
            System.out.println("Problem in URLs.initialize()!");
            throwable.printStackTrace();
        }
    }

    public void saveInfo() {
        if (SysInfo.getOSPlatform().equals("AIX")) {
            return;
        }
        Brand brand = Brand.getBrand();
        int n = brand.numberOfURLs();
        CustInfo custInfo = CustInfo.getInstance();
        int n2 = 0;
        while (n2 < n) {
            boolean bl = this.m_pCheckBoxes[n2].isSelected();
            switch (n2) {
                case 0: {
                    custInfo.setCheckURL1(bl);
                    break;
                }
                case 1: {
                    custInfo.setCheckURL2(bl);
                    break;
                }
                case 2: {
                    custInfo.setCheckURL3(bl);
                }
            }
            ++n2;
        }
    }

    public void setHomeBusiness(int n) {
        this.m_hb = n;
        Brand brand = Brand.getBrand();
        int n2 = brand.numberOfURLCheckBoxes();
        int n3 = 0;
        while (n3 < n2) {
            if (brand.isURLSupported(n3, n)) {
                this.m_pCheckBoxes[n3].setVisible(true);
            } else {
                this.m_pCheckBoxes[n3].setVisible(false);
            }
            ++n3;
        }
    }
}

