/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lexington.prt;

import com.ibm.lexington.prt.Language;
import com.ibm.lexington.prt.SysInfo;
import com.ibm.lexington.prt.TextBreaker;
import com.ibm.lexington.prt.res.StrBounds;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.io.File;
import java.util.Locale;
import java.util.Random;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class Utility {
    public static String checkLocale(String string, String string2) {
        String string3 = null;
        if (SysInfo.getOSPlatform().equals("AIX")) {
            if (string.equals("en") && string2 == null) {
                System.out.println("Locale: " + string + " (CPOSIX)");
                string3 = "en_US";
            } else if (string.equals("en") && string2.equals("US") || string.equals("pt") && string2.equals("BR") || string.equals("es") && string2.equals("ES") || string.equals("fr") && string2.equals("FR") || string.equals("de") && string2.equals("DE") || string.equals("it") && string2.equals("IT") || string.equals("ja") && string2.equals("JP") || string.equals("ko") && string2.equals("KR") || string.equals("zh") && string2.equals("TW") || string.equals("zh") && string2.equals("CN") || string.equals("nl") && string2.equals("NL")) {
                System.out.println("Locale: " + string + "_" + string2 + " is valid.");
                string3 = String.valueOf(string) + "_" + string2;
            } else {
                System.out.println("Unsupported Locale: " + string + "_" + string2 + "!  Defaulting to en_US.");
                string3 = "en_US";
            }
        } else if (SysInfo.getOSPlatform().equals("OS/2")) {
            if (string.equals("th") && string2.equals("TH")) {
                System.out.println("Unsupported Locale: " + string + "_" + string2 + "!  Defaulting to en_US.");
                string3 = "en_US";
            } else if (string.equals("el") && string2.equals("GR")) {
                System.out.println("Unsupported Locale: " + string + "_" + string2 + "!  Defaulting to en_US.");
                string3 = "en_US";
            } else {
                System.out.println("Locale: " + string + "_" + string2 + " is valid.");
                string3 = String.valueOf(string) + "_" + string2;
            }
        }
        return string3;
    }

    public static String chgDir(String string) throws Exception {
        String string2 = new String();
        String string3 = System.getProperty("user.dir");
        if (string.endsWith(File.separator)) {
            string = string.substring(0, string.lastIndexOf(File.separator));
        }
        if (string.startsWith(".")) {
            string = string.replace(File.separator.charAt(0), '/');
            string3 = string3.replace(File.separator.charAt(0), '/');
            if (string.startsWith("./")) {
                string = string.substring(2);
            }
            int n = 0;
            while (string.startsWith("../")) {
                string = string.substring(3);
                ++n;
            }
            if (string3.endsWith("/")) {
                string3.substring(0, string3.lastIndexOf("/"));
            }
            while (n > 0 && string3.indexOf("/") >= 0) {
                string3 = string3.substring(0, string3.lastIndexOf("/"));
                --n;
            }
            string2 = new String(String.valueOf(string3) + "/" + string);
            File file = new File(string2 = string2.replace('/', File.separator.charAt(0)));
            if (!file.isDirectory()) {
                throw new Exception("Invalid relative path");
            }
        } else {
            File file = new File(string);
            if (!file.isDirectory()) {
                throw new Exception("Invalid absolute path");
            }
            string2 = string;
        }
        return string2;
    }

    public static String convertLocale(String string) {
        System.out.println(SysInfo.getOSPlatform());
        if (SysInfo.getOSPlatform().equals("LINUX")) {
            return "en_US";
        }
        if (string.equalsIgnoreCase("enu")) {
            return "en_US";
        }
        if (string.equalsIgnoreCase("fra")) {
            return "fr_FR";
        }
        if (string.equalsIgnoreCase("deu")) {
            return "de_DE";
        }
        if (string.equalsIgnoreCase("ita")) {
            return "it_IT";
        }
        if (string.equalsIgnoreCase("esp")) {
            return "es_ES";
        }
        if (string.equalsIgnoreCase("ptb")) {
            return "pt_BR";
        }
        if (string.equalsIgnoreCase("jpn")) {
            return "ja_JP";
        }
        if (string.equalsIgnoreCase("chs")) {
            return "zh_CN";
        }
        if (string.equalsIgnoreCase("cht")) {
            return "zh_TW";
        }
        if (string.equalsIgnoreCase("kor")) {
            return "ko_KR";
        }
        if (SysInfo.getOSPlatform().equals("OS/2") || SysInfo.getOSPlatform().startsWith("WINDOWS")) {
            if (string.equalsIgnoreCase("nld")) {
                return "nl_NL";
            }
            if (string.equalsIgnoreCase("sve")) {
                return "sv_SE";
            }
            if (string.equalsIgnoreCase("dan")) {
                return "da_DK";
            }
            if (string.equalsIgnoreCase("fin")) {
                return "fi_FI";
            }
            if (string.equalsIgnoreCase("nor")) {
                return "no_NO";
            }
            if (string.equalsIgnoreCase("ptg")) {
                return "pt_PT";
            }
            if (string.equalsIgnoreCase("ell")) {
                return "en_US";
            }
            if (string.equalsIgnoreCase("trk")) {
                return "tr_TR";
            }
            if (string.equalsIgnoreCase("plk")) {
                return "pl_PL";
            }
            if (string.equalsIgnoreCase("rus")) {
                return "ru_RU";
            }
            if (string.equalsIgnoreCase("csy")) {
                return "cs_CZ";
            }
            if (string.equalsIgnoreCase("hun")) {
                return "hu_HU";
            }
            if (string.equalsIgnoreCase("tha")) {
                return "en_US";
            }
        }
        return "en_US";
    }

    public static String convertLocale2(String string) {
        if (string.equalsIgnoreCase("enu")) {
            return "en_US";
        }
        if (string.equalsIgnoreCase("fra")) {
            return "fr_FR";
        }
        if (string.equalsIgnoreCase("deu")) {
            return "de_DE";
        }
        if (string.equalsIgnoreCase("ita")) {
            return "it_IT";
        }
        if (string.equalsIgnoreCase("esp")) {
            return "es_ES";
        }
        if (string.equalsIgnoreCase("ptb")) {
            return "pt_BR";
        }
        if (string.equalsIgnoreCase("jpn")) {
            return "ja_JP";
        }
        if (string.equalsIgnoreCase("chs")) {
            return "zh_CN";
        }
        if (string.equalsIgnoreCase("cht")) {
            return "zh_TW";
        }
        if (string.equalsIgnoreCase("kor")) {
            return "ko_KR";
        }
        if (string.equalsIgnoreCase("nld")) {
            return "nl_NL";
        }
        if (string.equalsIgnoreCase("sve")) {
            return "sv_SE";
        }
        if (string.equalsIgnoreCase("dan")) {
            return "da_DK";
        }
        if (string.equalsIgnoreCase("fin")) {
            return "fi_FI";
        }
        if (string.equalsIgnoreCase("nor")) {
            return "no_NO";
        }
        if (string.equalsIgnoreCase("ptg")) {
            return "pt_PT";
        }
        if (string.equalsIgnoreCase("ell")) {
            return "el_GR";
        }
        if (string.equalsIgnoreCase("trk")) {
            return "tr_TR";
        }
        if (string.equalsIgnoreCase("plk")) {
            return "pl_PL";
        }
        if (string.equalsIgnoreCase("rus")) {
            return "ru_RU";
        }
        if (string.equalsIgnoreCase("csy")) {
            return "cs_CZ";
        }
        if (string.equalsIgnoreCase("hun")) {
            return "hu_HU";
        }
        if (string.equalsIgnoreCase("tha")) {
            return "th_TH";
        }
        return "";
    }

    private static String copyright() {
        return "\n\nLicensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1999, 2000. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    }

    public static Dimension determineTextDimensions(Component component, String string) {
        Font font = component.getFont();
        if (font == null) {
            return null;
        }
        FontMetrics fontMetrics = component.getFontMetrics(font);
        if (fontMetrics == null) {
            return null;
        }
        return new Dimension(fontMetrics.stringWidth(string), fontMetrics.getHeight());
    }

    public static int displayOKDialog(JFrame jFrame, Object object, String string) {
        Locale locale = null;
        Font font = jFrame.getFont();
        FontMetrics fontMetrics = jFrame.getFontMetrics(font);
        Dimension dimension = jFrame.getSize();
        int n = dimension.width - 100;
        locale = Locale.getDefault();
        TextBreaker textBreaker = new TextBreaker(fontMetrics, locale, n);
        StringBuffer stringBuffer = new StringBuffer(object.toString());
        if (stringBuffer.length() < string.length()) {
            int n2 = string.length() - stringBuffer.length();
            int n3 = 0;
            while (n3 < n2) {
                stringBuffer.append(" ");
                ++n3;
            }
        }
        String[] stringArray = locale.toString().equals("pt_PT") ? textBreaker.getTextLines(stringBuffer.toString(), 70) : textBreaker.getTextLines(stringBuffer.toString());
        int cfr_ignored_0 = stringArray.length;
        JOptionPane.showMessageDialog(jFrame, stringArray, string, 2);
        return 0;
    }

    public static int displayYesNoDialog(JFrame jFrame, Object object, String string) {
        String string2;
        Object[] objectArray = new Object[2];
        Locale locale = null;
        Font font = jFrame.getFont();
        FontMetrics fontMetrics = jFrame.getFontMetrics(font);
        Dimension dimension = jFrame.getSize();
        int n = dimension.width - 100;
        locale = Locale.getDefault();
        TextBreaker textBreaker = new TextBreaker(fontMetrics, locale, n);
        String[] stringArray = locale.toString().equals("ja_JP") ? textBreaker.getTextLines(object.toString(), 30) : textBreaker.getTextLines(object.toString());
        int cfr_ignored_0 = stringArray.length;
        String[] stringArray2 = stringArray;
        objectArray[0] = ((StrBounds)Language.rb_24.getObject(Integer.toString(2328))).returnString();
        objectArray[1] = ((StrBounds)Language.rb_24.getObject(Integer.toString(2329))).returnString();
        JOptionPane jOptionPane = new JOptionPane(stringArray2, 2, -1, null, objectArray, objectArray[0]);
        JDialog jDialog = jOptionPane.createDialog(jFrame, string);
        jDialog.setModal(true);
        jDialog.show();
        if (jOptionPane.getValue() != null && (string2 = jOptionPane.getValue().toString()).equals(objectArray[1].toString())) {
            return 1;
        }
        return 0;
    }

    public static String generateRegistrationCode(String string, String string2) {
        int n = 0;
        int n2 = 0;
        char[] cArray = new char[15];
        byte[] byArray = new byte[240];
        try {
            Random random = new Random();
            random.nextBytes(byArray);
        }
        catch (Error error) {
            System.out.println("Secure Random Prob " + error);
        }
        int n3 = 0;
        while (n3 < 240) {
            n2 = Math.abs(byArray[n3]);
            if (n2 > 47 && n2 < 91 && (n2 < 58 || n2 > 64)) {
                cArray[n] = (char)n2;
                if (++n > 12) break;
            }
            ++n3;
        }
        return new String(cArray);
    }

    public static String getThreeCharISOCode(String string) {
        if (string.equals("en_US")) {
            return "ENU";
        }
        if (string.equals("fr_FR")) {
            return "FRA";
        }
        if (string.equals("de_DE")) {
            return "DEU";
        }
        if (string.equals("it_IT")) {
            return "ITA";
        }
        if (string.equals("es_ES")) {
            return "ESP";
        }
        if (string.equals("pt_BR")) {
            return "PTB";
        }
        if (string.equals("ja_JP")) {
            return "JPN";
        }
        if (string.equals("ko_KR")) {
            return "KOR";
        }
        if (string.equals("zh_CN")) {
            return "CHS";
        }
        if (string.equals("zh_TW")) {
            return "CHT";
        }
        if (string.equals("nl_NL")) {
            return "NLD";
        }
        if (string.equals("sv_SE")) {
            return "SVE";
        }
        if (string.equals("da_DK")) {
            return "DAN";
        }
        if (string.equals("fi_FI")) {
            return "FIN";
        }
        if (string.equals("no_NO")) {
            return "NOR";
        }
        if (string.equals("pt_PT")) {
            return "PTG";
        }
        if (string.equals("el_GR")) {
            return "ELL";
        }
        if (string.equals("tr_TR")) {
            return "TRK";
        }
        if (string.equals("pl_PL")) {
            return "PLK";
        }
        if (string.equals("ru_RU")) {
            return "RUS";
        }
        if (string.equals("cs_CZ")) {
            return "CSY";
        }
        if (string.equals("hu_HU")) {
            return "HUN";
        }
        if (string.equals("th_TH")) {
            return "THA";
        }
        return string;
    }

    public static boolean validateEmailString(String string) {
        if (string.length() > 0) {
            if (string.indexOf("@") == -1) {
                return false;
            }
            if (string.indexOf(".") == -1) {
                return false;
            }
            if (string.indexOf(" ") != -1) {
                return false;
            }
        }
        return true;
    }

    public static boolean validateHasCharsString(String string) {
        if (string.length() > 0) {
            int n = 0;
            while (n < string.length()) {
                if (Character.isLetter(string.charAt(n))) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public static int validateIsWhiteSpace(String string) {
        int n = 1;
        int n2 = 0;
        while (n2 < string.length()) {
            if (!Character.isWhitespace(string.charAt(n2))) {
                n = -1;
            }
            ++n2;
        }
        return n;
    }

    public static int validateNoNumericsString(String string) {
        if (string.length() > 0) {
            int n = 0;
            while (n < string.length()) {
                if (Character.isDigit(string.charAt(n))) {
                    return n + 1;
                }
                ++n;
            }
        }
        return -1;
    }

    public static int validateString(String string) {
        int n = string.length();
        if (n > 0) {
            int n2 = 0;
            while (n2 < n) {
                char c = string.charAt(n2);
                if (c == '|' || c == '\\') {
                    return n2;
                }
                ++n2;
            }
        }
        return -1;
    }
}

