/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.colorchooser;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import javax.swing.JPanel;
import javax.swing.UIManager;

class DefaultPreviewPanel
extends JPanel {
    private int squareSize = 25;
    private int squareGap = 5;
    private int innerGap = 5;
    private int textGap = 5;
    private Font font = new Font("Dialog", 0, 12);
    private String sampleText = UIManager.getString("ColorChooser.sampleText");
    private int swatchWidth = 50;
    private Color oldColor = null;

    DefaultPreviewPanel() {
    }

    public Dimension getPreferredSize() {
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.getFont());
        int n = fontMetrics.getAscent();
        int n2 = fontMetrics.getHeight();
        int n3 = fontMetrics.stringWidth(this.sampleText);
        int n4 = n2 * 3 + this.textGap * 3;
        int n5 = this.squareSize * 3 + this.squareGap * 4 + this.swatchWidth + n3;
        return new Dimension(n5, n4);
    }

    public void paintComponent(Graphics graphics) {
        if (this.oldColor == null) {
            this.oldColor = this.getForeground();
        }
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        int n = this.paintSquares(graphics);
        int n2 = this.paintText(graphics, n);
        this.paintSwatch(graphics, n + n2);
    }

    private int paintSquares(Graphics graphics) {
        Color color = this.getForeground();
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.squareSize, this.squareSize);
        graphics.setColor(color);
        graphics.fillRect(this.innerGap, this.innerGap, this.squareSize - this.innerGap * 2, this.squareSize - this.innerGap * 2);
        graphics.setColor(Color.white);
        graphics.fillRect(this.innerGap * 2, this.innerGap * 2, this.squareSize - this.innerGap * 4, this.squareSize - this.innerGap * 4);
        graphics.setColor(color);
        graphics.fillRect(0, this.squareSize + this.squareGap, this.squareSize, this.squareSize);
        graphics.translate(this.squareSize + this.squareGap, 0);
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, this.squareSize, this.squareSize);
        graphics.setColor(color);
        graphics.fillRect(this.innerGap, this.innerGap, this.squareSize - this.innerGap * 2, this.squareSize - this.innerGap * 2);
        graphics.setColor(Color.white);
        graphics.fillRect(this.innerGap * 2, this.innerGap * 2, this.squareSize - this.innerGap * 4, this.squareSize - this.innerGap * 4);
        graphics.translate(-(this.squareSize + this.squareGap), 0);
        graphics.translate(this.squareSize + this.squareGap, this.squareSize + this.squareGap);
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.squareSize, this.squareSize);
        graphics.setColor(color);
        graphics.fillRect(this.innerGap, this.innerGap, this.squareSize - this.innerGap * 2, this.squareSize - this.innerGap * 2);
        graphics.translate(-(this.squareSize + this.squareGap), -(this.squareSize + this.squareGap));
        graphics.translate((this.squareSize + this.squareGap) * 2, 0);
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.squareSize, this.squareSize);
        graphics.setColor(color);
        graphics.fillRect(this.innerGap, this.innerGap, this.squareSize - this.innerGap * 2, this.squareSize - this.innerGap * 2);
        graphics.setColor(Color.black);
        graphics.fillRect(this.innerGap * 2, this.innerGap * 2, this.squareSize - this.innerGap * 4, this.squareSize - this.innerGap * 4);
        graphics.translate(-((this.squareSize + this.squareGap) * 2), 0);
        graphics.translate((this.squareSize + this.squareGap) * 2, this.squareSize + this.squareGap);
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, this.squareSize, this.squareSize);
        graphics.setColor(color);
        graphics.fillRect(this.innerGap, this.innerGap, this.squareSize - this.innerGap * 2, this.squareSize - this.innerGap * 2);
        graphics.translate(-((this.squareSize + this.squareGap) * 2), -(this.squareSize + this.squareGap));
        return (this.squareSize + this.squareGap) * 3;
    }

    private void paintSwatch(Graphics graphics, int n) {
        int n2 = n + this.squareGap;
        graphics.setColor(this.oldColor);
        graphics.fillRect(n2, 0, this.swatchWidth, this.squareSize + this.squareGap / 2);
        graphics.setColor(this.getForeground());
        graphics.fillRect(n2, this.squareSize + this.squareGap / 2, this.swatchWidth, this.squareSize + this.squareGap / 2);
    }

    private int paintText(Graphics graphics, int n) {
        graphics.setFont(this.getFont());
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = fontMetrics.getAscent();
        int n3 = fontMetrics.getHeight();
        int n4 = fontMetrics.stringWidth(this.sampleText);
        int n5 = n + this.textGap;
        Color color = this.getForeground();
        graphics.setColor(color);
        graphics.drawString(this.sampleText, n5, n2 + 2);
        graphics.fillRect(n5, n3 + this.textGap, n4 + this.textGap, n3 + 2);
        graphics.setColor(Color.black);
        graphics.drawString(this.sampleText, n5 + this.textGap / 2, n3 + n2 + this.textGap + 2);
        graphics.setColor(Color.white);
        graphics.fillRect(n5, (n3 + this.textGap) * 2, n4 + this.textGap, n3 + 2);
        graphics.setColor(color);
        graphics.drawString(this.sampleText, n5 + this.textGap / 2, (n3 + this.textGap) * 2 + n2 + 2);
        return n4 + this.textGap + 4;
    }
}

