/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.TextUI;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.StateInvariantError;

public class DefaultCaret
extends Rectangle
implements Caret,
FocusListener,
MouseListener,
MouseMotionListener {
    protected EventListenerList listenerList = new EventListenerList();
    protected transient ChangeEvent changeEvent = null;
    JTextComponent component;
    boolean async = false;
    boolean visible;
    int dot;
    int mark;
    Object selectionTag;
    Timer flasher;
    Point magicCaretPosition;
    transient Position.Bias dotBias;
    transient Position.Bias markBias;
    boolean dotLTR;
    boolean markLTR;
    transient UpdateHandler updateHandler = new UpdateHandler();
    private transient int[] flagXPoints = new int[3];
    private transient int[] flagYPoints = new int[3];
    private transient FocusListener focusListener;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(class$javax$swing$event$ChangeListener != null ? class$javax$swing$event$ChangeListener : (class$javax$swing$event$ChangeListener = DefaultCaret.class$("javax.swing.event.ChangeListener")), changeListener);
    }

    protected void adjustVisibility(Rectangle rectangle) {
        SwingUtilities.invokeLater(new SafeScroller(rectangle));
    }

    void changeCaretPosition(int n, Position.Bias bias) {
        this.repaint();
        if (this.flasher != null && this.flasher.isRunning()) {
            this.visible = true;
            this.flasher.restart();
        }
        this.dot = n;
        this.dotBias = bias;
        this.dotLTR = this.isPositionLTR(n, bias);
        this.fireStateChanged();
        Runnable runnable = new Runnable(){

            public void run() {
                DefaultCaret.this.repaintNewCaret();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected synchronized void damage(Rectangle rectangle) {
        if (rectangle != null) {
            int n = this.component.getBounds().width;
            if (rectangle.x > n) {
                this.x = n - 3;
            } else {
                this.x = rectangle.x - 4;
                if (this.x < 0) {
                    this.x = 2;
                }
            }
            this.y = rectangle.y;
            this.width = 10;
            this.height = rectangle.height;
            this.repaint();
        }
    }

    public void deinstall(JTextComponent jTextComponent) {
        jTextComponent.removeMouseListener(this);
        jTextComponent.removeMouseMotionListener(this);
        if (this.focusListener != null) {
            jTextComponent.removeFocusListener(this.focusListener);
            this.focusListener = null;
        }
        jTextComponent.removePropertyChangeListener(this.updateHandler);
        Document document = jTextComponent.getDocument();
        if (document != null) {
            document.removeDocumentListener(this.updateHandler);
        }
        DefaultCaret defaultCaret = this;
        synchronized (defaultCaret) {
            this.component = null;
        }
        if (this.flasher != null) {
            this.flasher.stop();
        }
    }

    public boolean equals(Object object) {
        return this == object;
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$ChangeListener != null ? class$javax$swing$event$ChangeListener : DefaultCaret.class$("javax.swing.event.ChangeListener"))) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((ChangeListener)objectArray[n + 1]).stateChanged(this.changeEvent);
            }
            n -= 2;
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this.component.isEditable()) {
            this.setVisible(true);
            this.setSelectionVisible(true);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        this.setVisible(false);
        this.setSelectionVisible(false);
    }

    boolean getAsynchronousMovement() {
        return this.async;
    }

    public int getBlinkRate() {
        return this.flasher == null ? 0 : this.flasher.getDelay();
    }

    protected final JTextComponent getComponent() {
        return this.component;
    }

    public int getDot() {
        return this.dot;
    }

    Position.Bias getDotBias() {
        return this.dotBias;
    }

    public Point getMagicCaretPosition() {
        return this.magicCaretPosition;
    }

    public int getMark() {
        return this.mark;
    }

    Position.Bias getMarkBias() {
        return this.markBias;
    }

    protected Highlighter.HighlightPainter getSelectionPainter() {
        return DefaultHighlighter.DefaultPainter;
    }

    Position.Bias guessBiasForOffset(int n, Position.Bias bias, boolean bl) {
        block6: {
            if (bl != this.isPositionLTR(n, bias)) {
                bias = Position.Bias.Backward;
            } else if (bias != Position.Bias.Backward && bl != this.isPositionLTR(n, Position.Bias.Backward)) {
                bias = Position.Bias.Backward;
            }
            if (bias != Position.Bias.Backward || n <= 0) break block6;
            try {
                String string = this.component.getDocument().getText(n - 1, 1);
                if (string.length() > 0 && string.charAt(0) == '\n') {
                    bias = Position.Bias.Forward;
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        return bias;
    }

    public void install(JTextComponent jTextComponent) {
        this.component = jTextComponent;
        Document document = jTextComponent.getDocument();
        this.mark = 0;
        this.dot = 0;
        this.markLTR = true;
        this.dotLTR = true;
        this.dotBias = this.markBias = Position.Bias.Forward;
        if (document != null) {
            document.addDocumentListener(this.updateHandler);
        }
        jTextComponent.addPropertyChangeListener(this.updateHandler);
        this.focusListener = new FocusHandler(this);
        jTextComponent.addFocusListener(this.focusListener);
        jTextComponent.addMouseListener(this);
        jTextComponent.addMouseMotionListener(this);
        if (this.component.hasFocus()) {
            this.focusGained(null);
        }
    }

    boolean isDotLeftToRight() {
        return this.dotLTR;
    }

    boolean isMarkLeftToRight() {
        return this.markLTR;
    }

    boolean isPositionLTR(int n, Position.Bias bias) {
        Document document = this.component.getDocument();
        if (document instanceof AbstractDocument) {
            if (bias == Position.Bias.Backward && --n < 0) {
                n = 0;
            }
            return ((AbstractDocument)document).isLeftToRight(n, n);
        }
        return true;
    }

    public boolean isSelectionVisible() {
        return this.selectionTag != null;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 0x10) != 0) {
            if (mouseEvent.getClickCount() == 2) {
                DefaultEditorKit.SelectWordAction selectWordAction = new DefaultEditorKit.SelectWordAction();
                selectWordAction.actionPerformed(null);
            } else if (mouseEvent.getClickCount() == 3) {
                DefaultEditorKit.SelectLineAction selectLineAction = new DefaultEditorKit.SelectLineAction();
                selectLineAction.actionPerformed(null);
            }
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.moveCaret(mouseEvent);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.positionCaret(mouseEvent);
            if (this.component != null && this.component.isEnabled()) {
                this.component.requestFocus();
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    protected void moveCaret(MouseEvent mouseEvent) {
        Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
        Position.Bias[] biasArray = new Position.Bias[1];
        int n = this.component.getUI().viewToModel(this.component, point, biasArray);
        if (biasArray[0] == null) {
            biasArray[0] = Position.Bias.Forward;
        }
        if (n >= 0) {
            this.moveDot(n, biasArray[0]);
        }
    }

    public void moveDot(int n) {
        this.moveDot(n, Position.Bias.Forward);
    }

    void moveDot(int n, Position.Bias bias) {
        if (!this.component.isEnabled()) {
            this.setDot(n, bias);
            return;
        }
        if (n != this.dot) {
            this.changeCaretPosition(n, bias);
            Highlighter highlighter = this.component.getHighlighter();
            if (highlighter != null) {
                int n2 = Math.min(n, this.mark);
                int n3 = Math.max(n, this.mark);
                try {
                    if (this.selectionTag != null) {
                        highlighter.changeHighlight(this.selectionTag, n2, n3);
                    } else {
                        Highlighter.HighlightPainter highlightPainter = this.getSelectionPainter();
                        this.selectionTag = highlighter.addHighlight(n2, n3, highlightPainter);
                    }
                }
                catch (BadLocationException badLocationException) {
                    throw new StateInvariantError("Bad caret position");
                }
            }
        }
    }

    public void paint(Graphics graphics) {
        block3: {
            if (!this.isVisible()) break block3;
            try {
                Element element;
                TextUI textUI = this.component.getUI();
                Rectangle rectangle = textUI.modelToView(this.component, this.dot, this.dotBias);
                graphics.setColor(this.component.getCaretColor());
                graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height - 1);
                Document document = this.component.getDocument();
                if (document instanceof AbstractDocument && (element = ((AbstractDocument)document).getBidiRootElement()) != null && element.getElementCount() > 1) {
                    this.flagXPoints[0] = rectangle.x;
                    this.flagYPoints[0] = rectangle.y;
                    this.flagXPoints[1] = rectangle.x;
                    this.flagYPoints[1] = rectangle.y + 4;
                    this.flagYPoints[2] = rectangle.y;
                    this.flagXPoints[2] = this.dotLTR ? rectangle.x + 5 : rectangle.x - 4;
                    graphics.fillPolygon(this.flagXPoints, this.flagYPoints, 3);
                }
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    protected void positionCaret(MouseEvent mouseEvent) {
        Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
        Position.Bias[] biasArray = new Position.Bias[1];
        int n = this.component.getUI().viewToModel(this.component, point, biasArray);
        if (biasArray[0] == null) {
            biasArray[0] = Position.Bias.Forward;
        }
        if (n >= 0) {
            this.setDot(n, biasArray[0]);
            this.setMagicCaretPosition(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.updateHandler = new UpdateHandler();
        this.dotBias = !objectInputStream.readBoolean() ? Position.Bias.Forward : Position.Bias.Backward;
        this.markBias = !objectInputStream.readBoolean() ? Position.Bias.Forward : Position.Bias.Backward;
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(class$javax$swing$event$ChangeListener != null ? class$javax$swing$event$ChangeListener : (class$javax$swing$event$ChangeListener = DefaultCaret.class$("javax.swing.event.ChangeListener")), changeListener);
    }

    protected final synchronized void repaint() {
        if (this.component != null) {
            this.component.repaint(this.x, this.y, this.width, this.height);
        }
    }

    void repaintNewCaret() {
        if (this.component != null) {
            TextUI textUI = this.component.getUI();
            Document document = this.component.getDocument();
            if (textUI != null && document != null) {
                Rectangle rectangle;
                try {
                    rectangle = textUI.modelToView(this.component, this.dot, this.dotBias);
                }
                catch (BadLocationException badLocationException) {
                    rectangle = null;
                }
                if (rectangle != null) {
                    this.adjustVisibility(rectangle);
                }
                this.damage(rectangle);
            }
        }
    }

    void setAsynchronousMovement(boolean bl) {
        this.async = bl;
    }

    public void setBlinkRate(int n) {
        if (n != 0) {
            if (this.flasher == null) {
                this.flasher = new Timer(n, this.updateHandler);
            }
            this.flasher.setDelay(n);
        } else if (this.flasher != null) {
            this.flasher.stop();
            this.flasher.removeActionListener(this.updateHandler);
            this.flasher = null;
        }
    }

    public void setDot(int n) {
        this.setDot(n, Position.Bias.Forward);
    }

    void setDot(int n, Position.Bias bias) {
        Document document = this.component.getDocument();
        if (document != null) {
            n = Math.min(n, document.getLength());
        }
        if ((n = Math.max(n, 0)) == 0) {
            bias = Position.Bias.Forward;
        }
        this.mark = n;
        if (this.dot != n || this.dotBias != bias || this.selectionTag != null) {
            this.changeCaretPosition(n, bias);
        }
        this.markBias = this.dotBias;
        this.markLTR = this.dotLTR;
        Highlighter highlighter = this.component.getHighlighter();
        if (highlighter != null && this.selectionTag != null) {
            highlighter.removeHighlight(this.selectionTag);
            this.selectionTag = null;
        }
    }

    public void setMagicCaretPosition(Point point) {
        this.magicCaretPosition = point;
    }

    public void setSelectionVisible(boolean bl) {
        if (bl) {
            Highlighter highlighter = this.component.getHighlighter();
            if (this.dot != this.mark && highlighter != null && this.selectionTag == null) {
                int n = Math.min(this.dot, this.mark);
                int n2 = Math.max(this.dot, this.mark);
                Highlighter.HighlightPainter highlightPainter = this.getSelectionPainter();
                try {
                    this.selectionTag = highlighter.addHighlight(n, n2, highlightPainter);
                }
                catch (BadLocationException badLocationException) {
                    this.selectionTag = null;
                }
            }
        } else if (this.selectionTag != null) {
            Highlighter highlighter = this.component.getHighlighter();
            highlighter.removeHighlight(this.selectionTag);
            this.selectionTag = null;
        }
    }

    public void setVisible(boolean bl) {
        if (this.component != null) {
            if (this.visible != bl) {
                try {
                    Rectangle rectangle = this.component.modelToView(this.dot);
                    this.damage(rectangle);
                }
                catch (BadLocationException badLocationException) {}
            }
            this.visible = bl;
        }
        if (this.flasher != null) {
            if (this.visible) {
                this.flasher.start();
            } else {
                this.flasher.stop();
            }
        }
    }

    public String toString() {
        String string = "Dot=(" + this.dot + ", " + this.dotBias + ")";
        string = String.valueOf(string) + " Mark=(" + this.mark + ", " + this.markBias + ")";
        return string;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeBoolean(this.dotBias == Position.Bias.Backward);
        objectOutputStream.writeBoolean(this.markBias == Position.Bias.Backward);
    }

    class SafeScroller
    implements Runnable {
        Rectangle r;

        SafeScroller(Rectangle rectangle) {
            this.r = rectangle;
        }

        public void run() {
            if (DefaultCaret.this.component != null) {
                DefaultCaret.this.component.scrollRectToVisible(this.r);
            }
        }
    }

    private static class FocusHandler
    implements FocusListener {
        private transient FocusListener fl;

        FocusHandler(FocusListener focusListener) {
            this.fl = focusListener;
        }

        public void focusGained(FocusEvent focusEvent) {
            this.fl.focusGained(focusEvent);
        }

        public void focusLost(FocusEvent focusEvent) {
            this.fl.focusLost(focusEvent);
        }
    }

    class UpdateHandler
    implements PropertyChangeListener,
    DocumentListener,
    ActionListener {
        UpdateHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!(DefaultCaret.this.visible || DefaultCaret.this.width != 0 && DefaultCaret.this.height != 0)) {
                DefaultCaret.this.setVisible(true);
            } else {
                DefaultCaret.this.visible ^= true;
                DefaultCaret.this.repaint();
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            if (DefaultCaret.this.async || SwingUtilities.isEventDispatchThread()) {
                int n = 0;
                int n2 = documentEvent.getOffset();
                int n3 = documentEvent.getLength();
                if (DefaultCaret.this.dot >= n2) {
                    n = n3;
                }
                if (DefaultCaret.this.mark >= n2) {
                    DefaultCaret.this.mark += n3;
                }
                if (n != 0) {
                    if (DefaultCaret.this.dot == n2) {
                        boolean bl;
                        Document document = DefaultCaret.this.component.getDocument();
                        int n4 = DefaultCaret.this.dot + n;
                        try {
                            bl = document.getText(n4 - 1, 1).equals("\n");
                        }
                        catch (BadLocationException badLocationException) {
                            bl = false;
                        }
                        if (bl) {
                            DefaultCaret.this.changeCaretPosition(n4, Position.Bias.Forward);
                        } else {
                            DefaultCaret.this.changeCaretPosition(n4, Position.Bias.Backward);
                        }
                    } else {
                        DefaultCaret.this.changeCaretPosition(DefaultCaret.this.dot + n, DefaultCaret.this.dotBias);
                    }
                }
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getOldValue();
            Object object2 = propertyChangeEvent.getNewValue();
            if (object instanceof Document || object2 instanceof Document) {
                DefaultCaret.this.setDot(0);
                if (object != null) {
                    ((Document)object).removeDocumentListener(this);
                }
                if (object2 != null) {
                    ((Document)object2).addDocumentListener(this);
                }
            }
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            if (DefaultCaret.this.async || SwingUtilities.isEventDispatchThread()) {
                int n = 0;
                int n2 = documentEvent.getOffset();
                int n3 = n2 + documentEvent.getLength();
                boolean bl = false;
                if (DefaultCaret.this.dot >= n3) {
                    n = n3 - n2;
                    if (DefaultCaret.this.dot == n3) {
                        bl = true;
                    }
                } else if (DefaultCaret.this.dot >= n2) {
                    n = DefaultCaret.this.dot - n2;
                    bl = true;
                }
                boolean bl2 = false;
                if (DefaultCaret.this.mark >= n3) {
                    DefaultCaret.this.mark -= n3 - n2;
                    if (DefaultCaret.this.mark == n3) {
                        bl2 = true;
                    }
                } else if (DefaultCaret.this.mark >= n2) {
                    DefaultCaret.this.mark = n2;
                    bl2 = true;
                }
                if (DefaultCaret.this.mark == DefaultCaret.this.dot - n) {
                    DefaultCaret.this.setDot(DefaultCaret.this.dot - n, DefaultCaret.this.guessBiasForOffset(DefaultCaret.this.dot - n, DefaultCaret.this.dotBias, DefaultCaret.this.dotLTR));
                } else {
                    if (bl) {
                        DefaultCaret.this.dotBias = DefaultCaret.this.guessBiasForOffset(DefaultCaret.this.dot - n, DefaultCaret.this.dotBias, DefaultCaret.this.dotLTR);
                    }
                    if (bl2) {
                        DefaultCaret.this.markBias = DefaultCaret.this.guessBiasForOffset(DefaultCaret.this.mark, DefaultCaret.this.markBias, DefaultCaret.this.markLTR);
                    }
                    DefaultCaret.this.changeCaretPosition(DefaultCaret.this.dot - n, DefaultCaret.this.dotBias);
                    DefaultCaret.this.markLTR = DefaultCaret.this.isPositionLTR(DefaultCaret.this.mark, DefaultCaret.this.markBias);
                }
            }
        }
    }
}

