/*
 * Decompiled with CFR 0.152.
 */
package stardiv;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import stardiv.ImageCanvas;
import stardiv.messbox.OMessageBox;
import stardiv.rvi.OColor;
import stardiv.rvi.OImageLoader;
import stardiv.sclient_updversion;

public class OAboutDialog
extends Dialog {
    private _WindowListener m_WindowListener;
    private _MouseListener m_MouseListener;
    private _KeyListener m_KeyListener;
    private Image aboutImage;
    private Image logoImage;
    private Button okBtn;
    private TextArea textArea;
    private Panel textPanel;
    private Panel panel;
    private Frame frame;

    public OAboutDialog(Frame frame) {
        super(frame);
        this.setTitle("About StarOffice");
        this.m_WindowListener = new _WindowListener();
        this.addWindowListener(this.m_WindowListener);
        this.m_KeyListener = new _KeyListener();
        this.addKeyListener(this.m_KeyListener);
        Insets insets = this.getInsets();
        this.setLayout(new BorderLayout());
        this.setTitle("About StarOffice");
        this.setModal(true);
        this.aboutImage = OImageLoader.loadImage((String)"/images/about.gif");
        this.logoImage = OImageLoader.loadImage((String)"/images/logo.gif");
        ImageCanvas imageCanvas = new ImageCanvas(this.aboutImage);
        Dimension dimension = imageCanvas.getSize();
        ImageCanvas imageCanvas2 = new ImageCanvas(this.logoImage);
        Dimension dimension2 = imageCanvas2.getSize();
        imageCanvas2.setLocation(dimension.width, dimension.height - dimension2.height + insets.top);
        int n = dimension.width + dimension2.width;
        int n2 = dimension.height;
        this.okBtn = new Button();
        this.okBtn.setActionCommand("ok");
        this.okBtn.setLabel("Ok");
        this.okBtn.setBackground(new Color(0xC0C0C0));
        this.okBtn.setBounds(n - 85, 40 + insets.top, 70, 25);
        this.m_MouseListener = new _MouseListener();
        this.okBtn.addMouseListener(this.m_MouseListener);
        this.okBtn.addKeyListener(this.m_KeyListener);
        GridLayout gridLayout = new GridLayout(15, 1);
        this.textPanel = new Panel(gridLayout);
        this.textPanel.setBounds(dimension.width + 10, 30 + insets.top, n - dimension.width - 100, dimension.height - dimension2.height - 35);
        this.textPanel.setBackground(Color.white);
        Label label = new Label(" StarOffice 5.1", 0);
        label.setFont(new Font("Dialog", 1, 14));
        this.textPanel.add(label);
        this.textPanel.add(new Label(""));
        label = new Label(" Version 1.0", 0);
        this.textPanel.add(label);
        label = new Label(" Copyright (C) 1993-99", 0);
        this.textPanel.add(label);
        label = new Label(" Alle Rechte vorbehalten.", 0);
        this.textPanel.add(label);
        this.panel = new Panel(null);
        ((Component)this).setSize(n + insets.left + insets.right, n2 + insets.top + insets.bottom);
        this.center();
        this.panel.setSize(n + insets.left + insets.right, n2 + insets.top + insets.bottom);
        this.panel.setBackground((Color)OColor.white);
        this.add((Component)this.panel, "Center");
        this.panel.add(imageCanvas);
        this.panel.add(imageCanvas2);
        this.panel.add(this.okBtn);
        this.panel.add(this.textPanel);
        this.okBtn.requestFocus();
        this.pack();
        this.setResizable(false);
        ((Component)this).setVisible(true);
    }

    public void dispose() {
        this.removeWindowListener(this.m_WindowListener);
        this.okBtn.removeKeyListener(this.m_KeyListener);
        this.removeKeyListener(this.m_KeyListener);
        this.okBtn.removeMouseListener(this.m_MouseListener);
    }

    public void center() {
        Rectangle rectangle = this.getBounds();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = dimension.width / 2 - rectangle.width / 2;
        int n2 = dimension.height / 2 - rectangle.height / 2;
        ((Component)this).setLocation(n, n2);
    }

    class _MouseListener
    extends MouseAdapter {
        public void mouseClicked(MouseEvent mouseEvent) {
            ((Component)OAboutDialog.this).setVisible(false);
            OAboutDialog.this.dispose();
        }

        _MouseListener() {
            OAboutDialog.this = OAboutDialog.this;
        }
    }

    class _KeyListener
    extends KeyAdapter {
        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 86 && keyEvent.isControlDown()) {
                Frame frame = new Frame();
                OMessageBox oMessageBox = new OMessageBox(frame, "StarOffice Version", sclient_updversion.Version, "information.gif", true);
                oMessageBox.setFont(new Font("helvetica", 1, 12));
                oMessageBox.show();
                return;
            }
            if (keyEvent.getKeyCode() == 10) {
                ((Component)OAboutDialog.this).setVisible(false);
                OAboutDialog.this.dispose();
            }
        }

        _KeyListener() {
            OAboutDialog.this = OAboutDialog.this;
        }
    }

    class _WindowListener
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            ((Component)OAboutDialog.this).setVisible(false);
            OAboutDialog.this.dispose();
        }

        _WindowListener() {
            OAboutDialog.this = OAboutDialog.this;
        }
    }
}

