/*
 * Decompiled with CFR 0.152.
 */
package stardiv;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import stardiv.OAboutDialog;
import stardiv.OLoginPanel;
import stardiv.OptionsDlg;
import stardiv.daemons.sofficed.ResultOfLogin;
import stardiv.messbox.OMessageBox;
import stardiv.remote.XRmStarOffice;
import stardiv.remote.XRmStatus;
import stardiv.rvi.Connection;
import stardiv.rvi.ConnectionEvent;
import stardiv.rvi.ConnectionListener;
import stardiv.rvi.Cryptor;
import stardiv.rvi.OClientFactory;
import stardiv.rvi.remoteversion;
import stardiv.uno.OUnoSystemException;
import stardiv.uno.Uik;
import stardiv.uno.XFactory;
import stardiv.uno.XInterface;

public class StarOffice
extends Applet
implements MouseListener,
KeyListener,
ComponentListener,
WindowListener,
ConnectionListener {
    public static String VERSION = "StarOffice 5.0";
    private OLoginPanel m_loginPanel;
    private Panel m_officePanel;
    private Connection m_connection;
    private Dimension m_initSize;
    private boolean m_isApplet = true;
    private boolean m_status = true;
    private boolean m_noLogin = false;
    private OClientFactory m_clientFactory;
    private OptionsDlg m_optionsDlg;
    private String propertiesFilename = "remote.ini";
    private static boolean m_hasCommandLineParams;
    private static Hashtable m_paramTable;
    private static Frame m_frame;

    public static void main(String[] stringArray) {
        m_paramTable = new Hashtable(20);
        if (!System.getProperty("os.name").equals("JavaOS")) {
            m_hasCommandLineParams = StarOffice.scanCommandLineParameter(stringArray, m_paramTable);
        }
        StarOffice starOffice = new StarOffice();
        starOffice.m_isApplet = false;
        starOffice.init();
        starOffice.start();
        m_frame = new Frame("StarOffice for Java");
        m_frame.add("Center", starOffice);
        Dimension dimension = new Dimension(350, 170);
        m_frame.pack();
        ((Component)m_frame).setSize(dimension);
        starOffice.center();
        ((Component)m_frame).setVisible(true);
    }

    protected static boolean scanCommandLineParameter(String[] stringArray, Hashtable hashtable) {
        String string = null;
        String string2 = null;
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length) {
            StringTokenizer stringTokenizer = new StringTokenizer(stringArray[n], "=");
            string = stringTokenizer.nextToken();
            if (string.equals("/help") || string.equals("-help") || string.equals("--help")) {
                StarOffice.displayUsage();
                System.exit(1);
            }
            try {
                string2 = stringTokenizer.nextToken();
            }
            catch (NoSuchElementException noSuchElementException) {
                StarOffice.displayUsage();
                System.exit(1);
            }
            hashtable.put(string, string2);
            bl = true;
            ++n;
        }
        return bl;
    }

    private static void displayUsage() {
        System.out.println();
        System.out.println("StarOffice for Java, (C) 1999 by StarDivision GmbH");
        System.out.println();
        System.out.println("Usage: java stardiv.StarOffice [server1=name] ... [server99=name] [fileServer=name] [printServer=name]");
        System.out.println();
        System.out.println("Example:");
        System.out.println("========");
        System.out.println();
        System.out.println("java stardiv.StarOffice server1=AppServer server2=ExtraServer:8126 fileServer=gold printServer=172.55.23.12");
        System.out.println();
    }

    protected boolean hasCommandLineProperties() {
        try {
            return System.getProperty("server1") != null || System.getProperty("fileServer") != null || System.getProperty("printServer") != null;
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
            return false;
        }
    }

    public void connectionStatus(ConnectionEvent connectionEvent) {
        if (connectionEvent.getCode() == 1) {
            this.restart();
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        System.exit(0);
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public Window getMainWindow() {
        Container container = this.getParent();
        while (container != null && !(container instanceof Frame)) {
            container = container.getParent();
        }
        return (Window)container;
    }

    public void center() {
        Window window = this.getMainWindow();
        if (window == null) {
            return;
        }
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle rectangle = window.getBounds();
        ((Component)window).setLocation((dimension.width - rectangle.width) / 2, (dimension.height - rectangle.height) / 2);
    }

    public void init() {
        TextField textField;
        super.init();
        String string = null;
        String string2 = null;
        this.addComponentListener(this);
        this.setLayout(new BorderLayout());
        this.m_loginPanel = new OLoginPanel();
        Frame frame = new Frame();
        this.m_optionsDlg = new OptionsDlg(frame, true);
        if (this.m_isApplet) {
            string = this.getParameter("fileServer");
            string2 = this.getParameter("printServer");
            String string3 = null;
            string3 = this.getParameter("noLogin");
            if (string3 != null && string3.equals("true")) {
                this.m_noLogin = true;
            }
            if (string == null) {
                string = "";
            }
            if (string2 == null) {
                string2 = "";
            }
            String string4 = this.getParameter("Browser");
            this.m_loginPanel.showInFrameCB.setState(Boolean.valueOf(string4) == false);
            Vector<String> vector = new Vector<String>(10, 5);
            String string5 = this.getParameter("useChoice");
            if (string5 == null || !string5.equals("yes")) {
                this.m_optionsDlg.hasChoice = false;
                this.m_optionsDlg.initControls();
                URL uRL = this.getCodeBase();
                String string6 = uRL.getHost();
                if (!string6.equals("")) {
                    this.m_optionsDlg.appServerText = string6;
                    ((TextComponent)this.m_optionsDlg.serverEdit).setText(string6);
                } else {
                    String string7 = this.getParameter("server1");
                    if (string7 != null) {
                        this.m_optionsDlg.appServerText = string7;
                        ((TextComponent)this.m_optionsDlg.serverEdit).setText(string7);
                    } else {
                        this.m_optionsDlg.appServerText = "127.0.0.1";
                        ((TextComponent)this.m_optionsDlg.serverEdit).setText(this.m_optionsDlg.appServerText);
                    }
                }
            } else {
                this.m_optionsDlg.hasChoice = true;
                this.m_optionsDlg.initControls();
                String string8 = this.getParameter("server1");
                if (string8 != null) {
                    int n = 2;
                    while (string8 != null) {
                        vector.addElement(string8);
                        string8 = this.getParameter("server" + n);
                        ++n;
                    }
                }
                this.m_optionsDlg.initServerChoice(vector);
            }
            this.m_optionsDlg.fileServer = string;
            ((TextComponent)this.m_optionsDlg.fileserverEdit).setText(string);
            this.m_optionsDlg.printerServer = string2;
            ((TextComponent)this.m_optionsDlg.printerserverEdit).setText(string2);
            textField = this.m_loginPanel.userEdit;
        } else {
            if (m_hasCommandLineParams) {
                int n = this.countServerParams();
                if (n > 1) {
                    this.m_optionsDlg.hasChoice = true;
                }
                this.m_optionsDlg.initControls();
                this.initViaCommandLine();
            } else if (this.hasCommandLineProperties()) {
                int n = this.countServerProperties();
                if (n > 1) {
                    this.m_optionsDlg.hasChoice = true;
                }
                this.m_optionsDlg.initControls();
                this.initViaProperties();
            } else if (this.existsRemoteIni()) {
                this.m_optionsDlg.hasChoice = true;
                this.m_optionsDlg.initControls();
                this.initViaPropertyFile();
            } else {
                String string9 = "127.0.0.1";
                this.m_optionsDlg.hasChoice = false;
                this.m_optionsDlg.initControls();
                this.m_optionsDlg.appServerText = string9;
                ((TextComponent)this.m_optionsDlg.serverEdit).setText(string9);
            }
            textField = this.m_loginPanel.userEdit;
        }
        this.m_loginPanel.connectBtn.addMouseListener(this);
        this.m_loginPanel.cancelBtn.addMouseListener(this);
        this.m_loginPanel.aboutBtn.addMouseListener(this);
        this.m_loginPanel.detailsBtn.addMouseListener(this);
        this.m_loginPanel.userEdit.addKeyListener(this);
        this.m_loginPanel.passwordEdit.addKeyListener(this);
        this.m_loginPanel.connectBtn.addKeyListener(this);
        this.m_loginPanel.cancelBtn.addKeyListener(this);
        this.m_loginPanel.aboutBtn.addKeyListener(this);
        this.m_loginPanel.detailsBtn.addKeyListener(this);
        this.add((Component)this.m_loginPanel, "Center");
        this.m_loginPanel.invalidate();
        this.m_loginPanel.doLayout();
        this.m_loginPanel.validate();
        this.setEnabledAll(true);
        textField.requestFocus();
        this.invalidate();
        this.doLayout();
        this.validate();
    }

    protected int countServerParams() {
        int n = 0;
        String string = null;
        do {
            if ((string = (String)m_paramTable.get("server" + (n + 1))) == null) continue;
            ++n;
        } while (string != null);
        return n;
    }

    protected int countServerProperties() {
        int n = 0;
        try {
            String string = null;
            do {
                if ((string = System.getProperty("server" + (n + 1))) == null) continue;
                ++n;
            } while (string != null);
        }
        catch (SecurityException securityException) {
            System.out.println("Could not retrieve server-properties.");
            securityException.printStackTrace();
            return 0;
        }
        return n;
    }

    protected void initViaCommandLine() {
        String string = null;
        String string2 = null;
        String string3 = null;
        Vector<String> vector = null;
        String string4 = null;
        string4 = (String)m_paramTable.get("noLogin");
        if (string4 != null && string4.equals("true")) {
            this.m_noLogin = true;
        }
        vector = new Vector<String>(10, 5);
        string3 = (String)m_paramTable.get("server1");
        if (this.m_optionsDlg.hasChoice) {
            int n = 2;
            while (string3 != null) {
                vector.addElement(string3);
                string3 = (String)m_paramTable.get("server" + n);
                ++n;
            }
            this.m_optionsDlg.initServerChoice(vector);
        } else {
            string3 = (String)m_paramTable.get("server1");
            if (string3 == null) {
                string3 = "127.0.0.1";
            }
            this.m_optionsDlg.appServerText = string3;
            ((TextComponent)this.m_optionsDlg.serverEdit).setText(string3);
        }
        string = (String)m_paramTable.get("fileServer");
        if (string == null) {
            string = "";
        }
        this.m_optionsDlg.fileServer = string;
        ((TextComponent)this.m_optionsDlg.fileserverEdit).setText(this.m_optionsDlg.fileServer);
        string2 = (String)m_paramTable.get("printServer");
        if (string2 == null) {
            string2 = "";
        }
        this.m_optionsDlg.printerServer = string2;
        ((TextComponent)this.m_optionsDlg.printerserverEdit).setText(this.m_optionsDlg.printerServer);
    }

    protected void initViaProperties() {
        String string = null;
        String string2 = null;
        String string3 = null;
        Vector<String> vector = null;
        try {
            vector = new Vector<String>(10, 5);
            string3 = System.getProperty("server1");
            if (this.m_optionsDlg.hasChoice) {
                int n = 2;
                while (string3 != null) {
                    vector.addElement(string3);
                    string3 = System.getProperty("server" + n);
                    ++n;
                }
                this.m_optionsDlg.initServerChoice(vector);
            } else {
                string3 = System.getProperty("server1");
                if (string3 == null) {
                    string3 = "127.0.0.1";
                }
                ((TextComponent)this.m_optionsDlg.serverEdit).setText(string3);
                this.m_optionsDlg.appServerText = string3;
            }
            string = System.getProperty("fileServer");
            if (string == null) {
                string = "";
            }
            this.m_optionsDlg.fileServer = string;
            ((TextComponent)this.m_optionsDlg.fileserverEdit).setText(this.m_optionsDlg.fileServer);
            string2 = System.getProperty("printServer");
            if (string2 == null) {
                string2 = "";
            }
            this.m_optionsDlg.printerServer = string2;
            ((TextComponent)this.m_optionsDlg.printerserverEdit).setText(this.m_optionsDlg.printerServer);
            return;
        }
        catch (SecurityException securityException) {
            System.out.println("Could not retrieve server-properties.");
            securityException.printStackTrace();
            return;
        }
    }

    public boolean existsRemoteIni() {
        boolean bl = false;
        File file = null;
        String string = null;
        String string2 = null;
        try {
            string = System.getProperty("java.class.path");
        }
        catch (SecurityException securityException) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        int n = stringTokenizer.countTokens();
        int n2 = 0;
        while (n2 < n) {
            string2 = stringTokenizer.nextToken();
            file = new File(string2, this.propertiesFilename);
            try {
                if (file.exists()) {
                    bl = true;
                }
            }
            catch (SecurityException securityException) {
                return false;
            }
            ++n2;
        }
        return bl;
    }

    protected void initViaPropertyFile() {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        File file = null;
        string = System.getProperty("java.class.path");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        int n = stringTokenizer.countTokens();
        int n2 = 0;
        while (n2 < n) {
            string2 = stringTokenizer.nextToken();
            file = new File(string2, this.propertiesFilename);
            if (file.exists()) break;
            ++n2;
        }
        if (file != null && file.exists()) {
            String string5 = null;
            Vector<String> vector = null;
            try {
                Properties properties = new Properties();
                properties.load(new FileInputStream(file));
                vector = new Vector<String>(10, 5);
                string5 = properties.getProperty("server1");
                int n3 = 2;
                while (string5 != null) {
                    vector.addElement(string5);
                    string5 = properties.getProperty("server" + n3);
                    ++n3;
                }
                this.m_optionsDlg.initServerChoice(vector);
                string3 = properties.getProperty("fileServer");
                if (string3 == null) {
                    string3 = "";
                }
                this.m_optionsDlg.fileServer = string3;
                ((TextComponent)this.m_optionsDlg.fileserverEdit).setText(this.m_optionsDlg.fileServer);
                string4 = properties.getProperty("printServer");
                if (string4 == null) {
                    string4 = "";
                }
                this.m_optionsDlg.printerServer = string4;
                ((TextComponent)this.m_optionsDlg.printerserverEdit).setText(this.m_optionsDlg.printerServer);
                return;
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
                return;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return;
            }
        }
        System.err.println();
        System.err.println("Could not find remote.ini.");
        System.err.println("Please place it somewhere in the classpath.");
        System.exit(1);
    }

    public void start() {
        Container container = this.getParent();
        if (container != null) {
            Dimension dimension = container.getSize();
            this.setSize(dimension);
        }
    }

    public void restart() {
        if (!this.m_loginPanel.showInFrameCB.getState()) {
            this.add("Center", this.m_loginPanel);
        }
        ((TextComponent)this.m_loginPanel.passwordEdit).setText("");
        this.setEnabledAll(true);
        this.m_loginPanel.setVisible(true);
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            if (keyEvent.getSource() == this.m_loginPanel.cancelBtn) {
                this.cancel();
            } else if (keyEvent.getSource() == this.m_loginPanel.aboutBtn) {
                this.about();
            }
            if (keyEvent.getSource() == this.m_loginPanel.detailsBtn) {
                this.details();
                return;
            }
            this.connect();
        }
    }

    public void cancel() {
        System.exit(0);
    }

    public void details() {
        this.m_optionsDlg.center();
        this.m_optionsDlg.show(true);
        this.toFront();
    }

    public void connect() {
        Object object;
        ResultOfLogin resultOfLogin;
        block11: {
            resultOfLogin = ResultOfLogin.OK;
            String string = this.m_loginPanel.passwordEdit.getText();
            String string2 = "";
            Cryptor cryptor = new Cryptor();
            cryptor.encryptString(string, "U^gZ~@s2");
            string2 = "1" + cryptor.getResult();
            this.setEnabledAll(false);
            this.getSize();
            this.m_connection = new Connection();
            if (this.m_connection.connect(this.m_optionsDlg.getAppServer())) {
                this.m_connection.addConnectionListener((ConnectionListener)this);
                if (!this.m_noLogin) {
                    resultOfLogin = this.m_connection.login(this.m_loginPanel.userEdit.getText(), string2, "");
                }
                if (resultOfLogin == ResultOfLogin.OK) {
                    object = this.m_connection.createObject("StarOffice.stardiv.de", XRmStarOffice.UIK);
                    if (object != null) {
                        this.m_clientFactory = new OClientFactory((Container)this, this.m_loginPanel.showInFrameCB.getState(), (XRmStatus)new ORmStatus());
                        try {
                            ((XRmStarOffice)object).Start((XFactory)this.m_clientFactory, "uno://:" + 8125 + "/OfficeWindow", this.m_loginPanel.userEdit.getText(), string2, this.m_optionsDlg.fileserverEdit.getText(), "java", "StarOffice", "", 0, remoteversion.VERSION);
                        }
                        catch (OUnoSystemException oUnoSystemException) {
                            if (this.m_status) {
                                resultOfLogin = ResultOfLogin.UNKNOWN_ERROR;
                                break block11;
                            }
                            resultOfLogin = ResultOfLogin.UNKNOWN_ERROR;
                        }
                    } else {
                        resultOfLogin = ResultOfLogin.UNKNOWN_ERROR;
                    }
                }
            } else {
                resultOfLogin = ResultOfLogin.UNKNOWN_ERROR;
            }
        }
        if (resultOfLogin != ResultOfLogin.OK) {
            object = new Frame();
            OMessageBox oMessageBox = new OMessageBox((Frame)object, "StarOffice for Java Error", resultOfLogin, "stop.gif", true);
            oMessageBox.show();
            this.m_connection.disconnect();
            this.m_connection = null;
            this.restart();
            return;
        }
        if (!this.m_loginPanel.showInFrameCB.getState()) {
            this.remove(this.m_loginPanel);
        }
    }

    public void about() {
        Frame frame = new Frame();
        new OAboutDialog(frame);
        this.toFront();
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.m_loginPanel.connectBtn) {
            this.connect();
            return;
        }
        if (mouseEvent.getSource() == this.m_loginPanel.cancelBtn) {
            this.cancel();
            return;
        }
        if (mouseEvent.getSource() == this.m_loginPanel.aboutBtn) {
            this.about();
            return;
        }
        if (mouseEvent.getSource() == this.m_loginPanel.detailsBtn) {
            this.details();
        }
    }

    public void toFront() {
        Container container = this.getParent();
        while (container != null && !(container instanceof Window)) {
            container = container.getParent();
        }
        if (container instanceof Window) {
            ((Window)container).toFront();
        }
        this.requestFocus();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void setEnabledAll(boolean bl) {
        this.m_loginPanel.userEdit.setEnabled(bl);
        this.m_loginPanel.passwordEdit.setEnabled(bl);
        this.m_loginPanel.connectBtn.setEnabled(bl);
        this.m_loginPanel.detailsBtn.setEnabled(bl);
        if (this.m_isApplet) {
            this.m_loginPanel.showInFrameCB.setEnabled(bl);
            this.m_loginPanel.cancelBtn.setEnabled(false);
        } else {
            this.m_loginPanel.showInFrameCB.setEnabled(false);
            this.m_loginPanel.cancelBtn.setEnabled(bl);
        }
        this.m_loginPanel.aboutBtn.setEnabled(bl);
    }

    static /* synthetic */ boolean access$0(StarOffice starOffice) {
        return starOffice.m_status;
    }

    static {
        m_paramTable = null;
    }

    public class ORmStatus
    implements XRmStatus {
        public XInterface queryInterface(Uik uik) {
            if (uik.isEqual(XRmStatus.UIK) || uik.isEqual(XInterface.UIK)) {
                return this;
            }
            return null;
        }

        public void acquire() {
        }

        public void release() {
        }

        public ORmStatus() {
            StarOffice.this = StarOffice.this;
        }

        public int GetRemoteVersion() {
            return remoteversion.VERSION;
        }

        public int GetSystemType() {
            return 0x2000000;
        }

        public int GetSystemCharSet() {
            return 0;
        }

        public void ShowError(String string, short s) {
            StarOffice.this.m_status = false;
        }

        public void ShowWarning(String string, short s) {
        }

        public void ShowWarning(String string, ResultOfLogin resultOfLogin) {
            System.err.println("Warning: " + string + " Code: " + resultOfLogin);
            Frame frame = new Frame();
            OMessageBox oMessageBox = new OMessageBox(frame, "StarCafe Warning", resultOfLogin, "exclamation.gif", true);
            oMessageBox.show();
        }

        public void ShowInfo(String string, short s) {
        }

        public void ShowInfo(String string, ResultOfLogin resultOfLogin) {
            System.err.println("Info: " + string + " Code: " + resultOfLogin);
            Frame frame = new Frame();
            OMessageBox oMessageBox = new OMessageBox(frame, "StarCafe Info", resultOfLogin, "information.gif", true);
            oMessageBox.show();
        }

        public void Quit() {
            System.out.println("Status : quit");
        }
    }
}

