/*
 * Decompiled with CFR 0.152.
 */
package stardiv.admin.usersetup;

import com.sun.java.swing.DefaultListModel;
import java.util.Enumeration;
import java.util.Vector;
import stardiv.admin.usersetup.ExtUserConfiguration;
import stardiv.admin.usersetup.IUserObserver;
import stardiv.daemons.sofficed.Language;
import stardiv.daemons.sofficed.UserConfiguration;

public class UserModel
implements Cloneable {
    protected Vector m_users = new Vector(10, 5);
    protected Vector m_userObservers = new Vector(5, 5);
    protected DefaultListModel m_profileList = new DefaultListModel();
    protected DefaultListModel m_languageList = new DefaultListModel();
    protected String m_sLastError = "";

    public DefaultListModel getProfiles() {
        return this.m_profileList;
    }

    public DefaultListModel getLanguages() {
        return this.m_languageList;
    }

    public void setLanguages(Language[] languageArray) {
        int n = 0;
        while (n < languageArray.length) {
            this.m_languageList.addElement((Object)new String(this.langToString(languageArray[n])));
            ++n;
        }
    }

    public void setProfiles(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            this.m_profileList.addElement((Object)new String(stringArray[n]));
            ++n;
        }
    }

    public int getNoOfUsers() {
        return this.m_users.size();
    }

    public String getID(int n) {
        return ((UserConfiguration)this.m_users.elementAt((int)n)).sUserID;
    }

    public String getUserName(int n) {
        return ((UserConfiguration)this.m_users.elementAt((int)n)).sUserName;
    }

    public String getOfficeDir(int n) {
        return ((UserConfiguration)this.m_users.elementAt((int)n)).sOfficeDir;
    }

    public String getProfile(int n) {
        return ((UserConfiguration)this.m_users.elementAt((int)n)).sProfile;
    }

    public String getLanguage(int n) {
        Language language = ((UserConfiguration)this.m_users.elementAt((int)n)).eLanguage;
        return this.langToString(language);
    }

    protected String langToString(Language language) {
        if (language.equals(Language.ENGLISH)) {
            return "English";
        }
        if (language.equals(Language.GERMAN)) {
            return "German";
        }
        if (language.equals(Language.DEFAULT)) {
            return "Default";
        }
        return "Unknown";
    }

    public Language getLanguageId(int n) {
        return ((UserConfiguration)this.m_users.elementAt((int)n)).eLanguage;
    }

    public ExtUserConfiguration getUserById(String string) {
        int n = this.m_users.size();
        boolean bl = false;
        ExtUserConfiguration extUserConfiguration = null;
        int n2 = 0;
        while (n2 < n && !bl) {
            extUserConfiguration = (ExtUserConfiguration)this.m_users.elementAt(n2);
            if (extUserConfiguration.sUserID.equals(string)) {
                bl = true;
            }
            ++n2;
        }
        if (bl) {
            return extUserConfiguration;
        }
        return null;
    }

    public ExtUserConfiguration getUserByIndex(int n) {
        return (ExtUserConfiguration)this.m_users.elementAt(n);
    }

    public void setID(int n, String string) {
        UserConfiguration userConfiguration = (UserConfiguration)this.m_users.elementAt(n);
        if (!userConfiguration.sUserID.equals(string)) {
            this.setModified(n, true);
            userConfiguration.sUserID = string;
        }
    }

    public void setUserName(int n, String string) {
        UserConfiguration userConfiguration = (UserConfiguration)this.m_users.elementAt(n);
        if (!userConfiguration.sUserName.equals(string)) {
            this.setModified(n, true);
            userConfiguration.sUserName = string;
        }
    }

    public void setOfficeDir(int n, String string) {
        UserConfiguration userConfiguration = (UserConfiguration)this.m_users.elementAt(n);
        if (!userConfiguration.sOfficeDir.equals(string)) {
            this.setModified(n, true);
            userConfiguration.sOfficeDir = string;
        }
    }

    public void setProfile(int n, String string) {
        UserConfiguration userConfiguration = (UserConfiguration)this.m_users.elementAt(n);
        if (!userConfiguration.sProfile.equals(string)) {
            this.setModified(n, true);
            userConfiguration.sProfile = string;
        }
    }

    public void setLanguage(int n, Language language) {
        UserConfiguration userConfiguration = (UserConfiguration)this.m_users.elementAt(n);
        if (!userConfiguration.eLanguage.equals(language)) {
            this.setModified(n, true);
            userConfiguration.eLanguage = language;
        }
    }

    public void setModified(int n, boolean bl) {
        ((ExtUserConfiguration)this.m_users.elementAt(n)).setModified(bl);
        if (this.m_userObservers != null) {
            Enumeration enumeration = this.m_userObservers.elements();
            int n2 = 0;
            while (enumeration.hasMoreElements()) {
                IUserObserver iUserObserver = (IUserObserver)enumeration.nextElement();
                iUserObserver.userChanged();
                ++n2;
            }
        }
    }

    public void setNew(int n, boolean bl) {
        ((ExtUserConfiguration)this.m_users.elementAt(n)).setNew(bl);
        if (this.m_userObservers != null) {
            Enumeration enumeration = this.m_userObservers.elements();
            int n2 = 0;
            while (enumeration.hasMoreElements()) {
                IUserObserver iUserObserver = (IUserObserver)enumeration.nextElement();
                iUserObserver.userChanged();
                ++n2;
            }
        }
    }

    public void setRemoved(String string, boolean bl) {
        ExtUserConfiguration extUserConfiguration = this.getUserById(string);
        if (extUserConfiguration != null) {
            extUserConfiguration.setRemoved(true);
        }
    }

    public void toggleRemoved(String string) {
        ExtUserConfiguration extUserConfiguration = this.getUserById(string);
        if (extUserConfiguration != null) {
            extUserConfiguration.setRemoved(!extUserConfiguration.isRemoved());
        }
        if (this.m_userObservers != null) {
            Enumeration enumeration = this.m_userObservers.elements();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                IUserObserver iUserObserver = (IUserObserver)enumeration.nextElement();
                iUserObserver.userChanged();
                ++n;
            }
        }
    }

    public void toggleRemovedByIndex(int n) {
        ExtUserConfiguration extUserConfiguration = this.getUserByIndex(n);
        if (extUserConfiguration != null) {
            extUserConfiguration.setRemoved(!extUserConfiguration.isRemoved());
        }
        if (this.m_userObservers != null) {
            Enumeration enumeration = this.m_userObservers.elements();
            int n2 = 0;
            while (enumeration.hasMoreElements()) {
                IUserObserver iUserObserver = (IUserObserver)enumeration.nextElement();
                iUserObserver.userChanged();
                ++n2;
            }
        }
    }

    public boolean setLanguage(int n, String string) {
        if (string.equals("English")) {
            this.setLanguage(n, Language.ENGLISH);
        } else if (string.equals("German")) {
            this.setLanguage(n, Language.GERMAN);
        } else {
            return false;
        }
        return true;
    }

    public boolean isUserModified(int n) {
        return ((ExtUserConfiguration)this.m_users.elementAt(n)).isModified();
    }

    public boolean isUserNew(int n) {
        return ((ExtUserConfiguration)this.m_users.elementAt(n)).isNew();
    }

    public boolean isUserRemoved(int n) {
        return ((ExtUserConfiguration)this.m_users.elementAt(n)).isRemoved();
    }

    public void addUser(String string) {
        ExtUserConfiguration extUserConfiguration = new ExtUserConfiguration(string, "", "", "Standard", Language.DEFAULT);
        extUserConfiguration.setNew(true);
        this.m_users.addElement(extUserConfiguration);
        if (this.m_userObservers != null) {
            Enumeration enumeration = this.m_userObservers.elements();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                IUserObserver iUserObserver = (IUserObserver)enumeration.nextElement();
                iUserObserver.userAdded();
                ++n;
            }
        }
    }

    public void addUser(String string, String string2, String string3, String string4, Language language) {
        ExtUserConfiguration extUserConfiguration = new ExtUserConfiguration(string, string2, string3, string4, language);
        extUserConfiguration.setNew(true);
        this.m_users.addElement(extUserConfiguration);
        if (this.m_userObservers != null) {
            Enumeration enumeration = this.m_userObservers.elements();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                IUserObserver iUserObserver = (IUserObserver)enumeration.nextElement();
                iUserObserver.userAdded();
                ++n;
            }
        }
    }

    public void addUser(ExtUserConfiguration extUserConfiguration) {
        this.m_users.addElement(extUserConfiguration);
        if (this.m_userObservers != null) {
            Enumeration enumeration = this.m_userObservers.elements();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                IUserObserver iUserObserver = (IUserObserver)enumeration.nextElement();
                iUserObserver.userAdded();
                ++n;
            }
        }
    }

    public boolean removeUser(String string) {
        Object object;
        int n = -1;
        int n2 = this.m_users.size();
        int n3 = 0;
        while (n3 < n2 && n == -1) {
            object = (UserConfiguration)this.m_users.elementAt(n3);
            if (((UserConfiguration)object).sUserID.equals(string)) {
                n = n3;
            }
            ++n3;
        }
        this.m_users.removeElementAt(n);
        if (this.m_userObservers != null) {
            object = this.m_userObservers.elements();
            int n4 = 0;
            while (object.hasMoreElements()) {
                IUserObserver iUserObserver = (IUserObserver)object.nextElement();
                iUserObserver.userChanged();
                ++n4;
            }
        }
        return n != -1;
    }

    public boolean removeUserByIndex(int n) {
        this.m_users.removeElementAt(n);
        if (this.m_userObservers != null) {
            Enumeration enumeration = this.m_userObservers.elements();
            int n2 = 0;
            while (enumeration.hasMoreElements()) {
                IUserObserver iUserObserver = (IUserObserver)enumeration.nextElement();
                iUserObserver.userChanged();
                ++n2;
            }
        }
        return n != -1;
    }

    public boolean removeUser(ExtUserConfiguration extUserConfiguration) {
        return this.removeUser(extUserConfiguration.sUserID);
    }

    public ExtUserConfiguration[] getUserConfigs() {
        Object[] objectArray = new ExtUserConfiguration[this.m_users.size()];
        this.m_users.copyInto(objectArray);
        return objectArray;
    }

    public synchronized void addObserver(IUserObserver iUserObserver) {
        this.m_userObservers.addElement(iUserObserver);
    }

    public synchronized boolean removeObserver(IUserObserver iUserObserver) {
        boolean bl = false;
        bl = this.m_userObservers.removeElement(iUserObserver);
        return bl;
    }

    public boolean checkModel() {
        this.resetError();
        return this.checkIDs() && this.checkDirs();
    }

    private boolean checkIDs() {
        boolean bl = false;
        boolean bl2 = false;
        int n = this.getNoOfUsers();
        int n2 = 0;
        while (n2 < n && !bl && !bl2) {
            String string = ((ExtUserConfiguration)this.m_users.elementAt((int)n2)).sUserID;
            if (string.equals("")) {
                bl2 = true;
                this.appendError("checkIDs(): found an emtpty id field");
            }
            int n3 = n2 + 1;
            while (n3 < n && !bl) {
                String string2 = ((ExtUserConfiguration)this.m_users.elementAt((int)n3)).sUserID;
                if (string.equals(string2)) {
                    bl = true;
                    this.appendError("checkIDs(): found identical ids: " + string + "," + string2);
                }
                ++n3;
            }
            ++n2;
        }
        return !bl && !bl2;
    }

    private boolean checkDirs() {
        boolean bl = false;
        boolean bl2 = false;
        int n = this.getNoOfUsers();
        int n2 = 0;
        while (n2 < n && !bl && !bl2) {
            String string = ((ExtUserConfiguration)this.m_users.elementAt((int)n2)).sOfficeDir;
            if (string.equals("")) {
                bl2 = true;
                this.appendError("checkDirs(): found empty directory field");
            }
            int n3 = n2 + 1;
            while (n3 < n && !bl) {
                String string2 = ((ExtUserConfiguration)this.m_users.elementAt((int)n3)).sOfficeDir;
                if (string.equals(string2)) {
                    bl = true;
                    this.appendError("checkDirs(): found identical directories: " + string + "," + string2);
                }
                ++n3;
            }
            ++n2;
        }
        return !bl && !bl2;
    }

    protected void appendError(String string) {
        this.m_sLastError = String.valueOf(this.m_sLastError) + "UserModel: " + string + "\n";
    }

    protected void resetError() {
        this.m_sLastError = "";
    }

    protected String getLastErrorString() {
        return this.m_sLastError;
    }
}

