/*
 * Decompiled with CFR 0.152.
 */
package stardiv.admin.usersetup;

import com.sun.java.swing.JApplet;
import com.sun.java.swing.JPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import stardiv.admin.usersetup.ExtUserConfiguration;
import stardiv.admin.usersetup.UserController;
import stardiv.admin.usersetup.UserModel;
import stardiv.admin.usersetup.UserTableView;
import stardiv.admin.usersetup.UserTableViewModel;
import stardiv.connect.SetupConnection;
import stardiv.daemons.sofficed.Language;
import stardiv.daemons.sofficed.ResultOfInstallation;
import stardiv.daemons.sofficed.UserConfiguration;
import stardiv.daemons.sofficed.XUserInstaller;
import stardiv.uno.OUnoSystemException;

public class UserSetup
extends JApplet {
    SetupConnection m_connection;
    XUserInstaller m_userInstaller;
    UserTableView m_userView;
    UserTableViewModel m_userViewModel;
    UserModel m_userModel;
    JPanel m_mainPanel;
    UserController m_userController;
    public static final boolean DEBUG = false;
    protected String m_sLastError = "";

    public void init() {
        super.init();
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        this.getContentPane().add((Component)new Label("Loading, please wait ..."), gridBagConstraints);
    }

    public void connectAndLogin(String string, String string2, String string3) {
        boolean bl = false;
        this.resetError();
        System.out.println("UserSetup: connectAndLogin called: " + string + "," + string3);
        try {
            bl = this.getConnection().connectAndLogin(string, string2, string3);
        }
        catch (OUnoSystemException oUnoSystemException) {
            this.resetError();
            this.appendError("connectAndLogin: caught OUnoSystemException ");
            this.appendError("user: " + string);
            this.appendError("host: " + string3);
            return;
        }
        catch (NullPointerException nullPointerException) {
            this.appendError("connectAndLogin: caught NullPointerException ");
            this.appendError("user: " + string);
            this.appendError("host: " + string3);
            return;
        }
        if (bl) {
            this.resetError();
            this.initModel();
            this.initView();
        } else {
            this.appendError("connectAndLogin() failed: ");
            this.appendError(this.getConnection().getLastErrorString());
        }
        System.out.println(this.getLastErrorString());
    }

    protected void initModel() {
        this.m_userModel = new UserModel();
        Language[] languageArray = null;
        String[] stringArray = null;
        this.resetError();
        try {
            languageArray = this.getUserInstaller().getLanguages();
            if (languageArray != null) {
                this.m_userModel.setLanguages(languageArray);
            } else {
                this.appendError("initModel(): Could not get languages from server");
                this.m_userModel.setLanguages(new Language[0]);
            }
            stringArray = this.getUserInstaller().getProfiles();
            if (stringArray != null) {
                this.m_userModel.setProfiles(stringArray);
            } else {
                this.m_userModel.setProfiles(new String[0]);
                this.appendError("initModel(): Could not get profiles from server");
            }
            UserConfiguration[] userConfigurationArray = this.getUserInstaller().getUsers();
            if (userConfigurationArray != null) {
                int n = 0;
                while (n < userConfigurationArray.length) {
                    this.m_userModel.addUser(new ExtUserConfiguration(userConfigurationArray[n]));
                    ++n;
                }
            }
            this.m_userController = new UserController(this.m_userModel, this);
            return;
        }
        catch (OUnoSystemException oUnoSystemException) {
            this.appendError("initModel: caught OUnoSystemException ");
            return;
        }
    }

    protected void initView() {
        this.m_userView = new UserTableView(this.m_userModel, this.m_userController);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().removeAll();
        this.getContentPane().add((Component)this.m_userView.getTable(), "Center");
        this.getContentPane().validate();
        this.getContentPane().repaint();
        ((Container)((Object)this)).invalidate();
        ((Container)((Object)this)).doLayout();
        ((Container)((Object)this)).validate();
    }

    protected SetupConnection getConnection() {
        if (this.m_connection != null) {
            return this.m_connection;
        }
        this.m_connection = new SetupConnection();
        return this.m_connection;
    }

    protected XUserInstaller getUserInstaller() {
        if (this.m_userInstaller != null) {
            return this.m_userInstaller;
        }
        this.m_userInstaller = this.getConnection().getUserInstaller();
        return this.m_userInstaller;
    }

    public boolean installUser(String string, String string2) {
        String string3 = "";
        String string4 = "";
        ResultOfInstallation resultOfInstallation = ResultOfInstallation.UNKNOWN_ERROR;
        boolean bl = false;
        UserConfiguration userConfiguration = new UserConfiguration(string, string3, string2, string4, Language.DEFAULT);
        try {
            if (this.m_connection.isConnected()) {
                resultOfInstallation = this.getUserInstaller().addUser(userConfiguration, bl);
            }
        }
        catch (OUnoSystemException oUnoSystemException) {
            this.appendError("installUser: caught OUnoSystemException ");
        }
        return resultOfInstallation == ResultOfInstallation.OK;
    }

    public boolean installUser(UserConfiguration userConfiguration, boolean bl) {
        ResultOfInstallation resultOfInstallation = ResultOfInstallation.OK;
        if (this.m_connection.isConnected()) {
            resultOfInstallation = this.getUserInstaller().addUser(userConfiguration, bl);
        }
        return resultOfInstallation == ResultOfInstallation.OK;
    }

    public void addUser() {
        this.resetError();
        this.m_userController.addUser();
    }

    public void removeUser() {
        this.resetError();
        this.m_userController.removeUser();
    }

    public void apply() {
        this.resetError();
        try {
            if (!this.m_userController.applyChanges()) {
                this.appendError(this.m_userController.getLastErrorString());
                return;
            }
        }
        catch (OUnoSystemException oUnoSystemException) {
            this.appendError("apply: caught OUnoSystemException ");
            return;
        }
    }

    public void addFromFile() {
        this.appendError("'Add from file' is not implemented yet...");
    }

    public void destroy() {
        this.getConnection().disconnect();
    }

    protected void appendError(String string) {
        this.m_sLastError = String.valueOf(this.m_sLastError) + "UserSetup: " + string + "\n";
    }

    public void resetError() {
        this.m_sLastError = "";
    }

    public String getLastErrorString() {
        return this.m_sLastError;
    }
}

