/*
 * Decompiled with CFR 0.152.
 */
package stardiv.admin.usersetup;

import com.sun.java.swing.DefaultCellEditor;
import com.sun.java.swing.JComboBox;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JTable;
import com.sun.java.swing.JTextField;
import com.sun.java.swing.event.ListSelectionListener;
import com.sun.java.swing.event.TableModelEvent;
import com.sun.java.swing.event.TableModelListener;
import com.sun.java.swing.table.DefaultTableCellRenderer;
import com.sun.java.swing.table.TableCellEditor;
import com.sun.java.swing.table.TableCellRenderer;
import com.sun.java.swing.table.TableColumn;
import com.sun.java.swing.table.TableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import stardiv.admin.usersetup.IUserObserver;
import stardiv.admin.usersetup.MarkModifiedCellRenderer;
import stardiv.admin.usersetup.StringCellEditor;
import stardiv.admin.usersetup.UserController;
import stardiv.admin.usersetup.UserModel;
import stardiv.admin.usersetup.UserTableViewModel;
import stardiv.util.TableSorter;

public class UserTableView
extends JPanel
implements IUserObserver {
    protected JScrollPane m_scrollpane;
    protected TableSorter m_sortedUsers;
    protected UserModel m_unsortedUsers;
    protected UserController m_controller;
    protected final short ID_CELL_WIDTH = (short)50;
    protected final short NAME_CELL_WIDTH = (short)150;
    protected final short OFFICEDIR_CELL_WIDTH = (short)150;
    protected final short PROFILE_CELL_WIDTH = (short)100;
    protected final short LANG_CELL_WIDTH = (short)100;
    protected final boolean DEBUG = false;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$sun$java$swing$JComboBox;

    public UserTableView(UserModel userModel, UserController userController) {
        JTable jTable = null;
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this.m_unsortedUsers = userModel;
        this.m_unsortedUsers.addObserver(this);
        this.m_controller = userController;
        UserTableViewModel userTableViewModel = new UserTableViewModel(userModel);
        this.m_sortedUsers = new TableSorter((TableModel)userTableViewModel);
        jTable = new JTable((TableModel)this.m_sortedUsers);
        jTable.setAutoResizeMode(0);
        int[] nArray = new int[]{50, 150, 150, 100, 100};
        this.setColumnWidths(jTable, nArray);
        jTable.setSelectionMode(2);
        userTableViewModel.addTableModelListener((TableModelListener)jTable);
        jTable.getSelectionModel().addListSelectionListener((ListSelectionListener)userController);
        TableColumn tableColumn = jTable.getColumnModel().getColumn(2);
        tableColumn.setCellEditor((TableCellEditor)new DefaultCellEditor((JTextField)new StringCellEditor()));
        this.setupProfileAndLanguageColumns(jTable);
        this.setupMarkModifiedCellRenderer(jTable);
        this.m_scrollpane = new JScrollPane((Component)jTable);
        ((Container)((Object)this)).add((Component)this.m_scrollpane);
        ((Container)((Object)this)).setLayout(new FlowLayout(1, 5, 5));
        ((Component)((Object)this)).setSize(20, 40);
    }

    public JScrollPane getTable() {
        return this.m_scrollpane;
    }

    public TableSorter getSortedUsers() {
        return this.m_sortedUsers;
    }

    protected void setColumnWidths(JTable jTable, int[] nArray) {
        TableColumn tableColumn = null;
        int n = jTable.getColumnCount();
        if (nArray.length == n) {
            int n2 = 0;
            while (n2 < n) {
                tableColumn = jTable.getColumnModel().getColumn(n2);
                tableColumn.setWidth(nArray[n2]);
                ++n2;
            }
        }
    }

    private void setupProfileAndLanguageColumns(JTable jTable) {
        TableColumn tableColumn = jTable.getColumnModel().getColumn(3);
        TableColumn tableColumn2 = jTable.getColumnModel().getColumn(4);
        JComboBox jComboBox = new JComboBox(this.m_unsortedUsers.getProfiles().toArray());
        tableColumn.setCellEditor((TableCellEditor)new DefaultCellEditor(jComboBox));
        JComboBox jComboBox2 = new JComboBox(this.m_unsortedUsers.getLanguages().toArray());
        tableColumn2.setCellEditor((TableCellEditor)new DefaultCellEditor(jComboBox2));
    }

    private void setupToolTips(JTable jTable) {
        TableColumn tableColumn = jTable.getColumnModel().getColumn(3);
        jTable.getColumnModel().getColumn(4);
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        defaultTableCellRenderer.setToolTipText("Click to change Profile");
        tableColumn.setCellRenderer((TableCellRenderer)defaultTableCellRenderer);
        defaultTableCellRenderer = new DefaultTableCellRenderer();
        defaultTableCellRenderer.setToolTipText("Click to change Language");
        tableColumn.setCellRenderer((TableCellRenderer)defaultTableCellRenderer);
    }

    private void setupMarkModifiedCellRenderer(JTable jTable) {
        jTable.setDefaultRenderer(class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = UserTableView.class$("java.lang.String")), (TableCellRenderer)new MarkModifiedCellRenderer(this.m_unsortedUsers));
        jTable.setDefaultRenderer(class$com$sun$java$swing$JComboBox != null ? class$com$sun$java$swing$JComboBox : (class$com$sun$java$swing$JComboBox = UserTableView.class$("com.sun.java.swing.JComboBox")), (TableCellRenderer)new MarkModifiedCellRenderer(this.m_unsortedUsers));
    }

    public void userAdded() {
        this.m_sortedUsers.tableChanged(new TableModelEvent((TableModel)this.m_sortedUsers));
    }

    public void userRemoved() {
        this.m_sortedUsers.tableChanged(new TableModelEvent((TableModel)this.m_sortedUsers));
    }

    public void userChanged() {
        this.m_sortedUsers.tableChanged(new TableModelEvent((TableModel)this.m_sortedUsers));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

