/*
 * Decompiled with CFR 0.152.
 */
package stardiv.uno;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import stardiv.uno.FactoryServerPair;
import stardiv.uno.IExitListener;
import stardiv.uno.OServer;
import stardiv.uno.OXInterfaceHolder;
import stardiv.uno.Uik;
import stardiv.uno.XFactory;
import stardiv.uno.holder.OObjectHolder;
import stardiv.uno.sys.IConnection;
import stardiv.uno.sys.OSemaphore;
import stardiv.uno.sys.server.OServerProxy;
import stardiv.uno.sys.server.OServerStub;

public class OEnvironment {
    public static final int ENV_NO_FLAG = 0;
    public static final int ENV_DISPATCH_FLAG_ALL = 1;
    protected IExitListener m_exitListener;
    protected static final int ServerTypeModule = 1;
    protected static final int ServerTypeRemote = 2;
    protected int m_flags;
    protected Hashtable m_serverMap;
    protected Hashtable m_factoryMap;
    protected OServerStub m_selfServer;
    protected OSemaphore m_requestSem;

    public OEnvironment(int n) {
        this.m_flags = n;
        this.m_requestSem = new OSemaphore(Integer.MAX_VALUE);
        this.m_serverMap = new Hashtable();
        this.m_factoryMap = new Hashtable();
    }

    public OEnvironment(OEnvironment oEnvironment, IConnection iConnection) {
        Object object;
        Enumeration enumeration;
        Hashtable hashtable;
        this.m_requestSem = new OSemaphore(Integer.MAX_VALUE);
        this.m_serverMap = new Hashtable();
        this.m_factoryMap = new Hashtable();
        if (oEnvironment.m_selfServer != null) {
            this.registerSelfAsServer();
            hashtable = oEnvironment.m_factoryMap;
            synchronized (hashtable) {
                enumeration = oEnvironment.m_factoryMap.elements();
                object = null;
                while (enumeration.hasMoreElements()) {
                    FactoryServerPair factoryServerPair = (FactoryServerPair)enumeration.nextElement();
                    if (factoryServerPair.m_server != oEnvironment.m_selfServer) continue;
                    object = (XFactory)factoryServerPair.m_factory.queryInterface(XFactory.UIK);
                    this.m_factoryMap.put(factoryServerPair.m_objectName, new FactoryServerPair(factoryServerPair.m_objectName, (XFactory)object, this.m_selfServer));
                }
            }
        }
        hashtable = oEnvironment.m_serverMap;
        synchronized (hashtable) {
            enumeration = oEnvironment.m_serverMap.elements();
            object = null;
            while (enumeration.hasMoreElements()) {
                object = (OServer)enumeration.nextElement();
                if (((OServer)object).isSelf()) continue;
                this.registerServer(((OServer)object).getUrl());
            }
        }
        if (this.m_selfServer != null) {
            this.m_selfServer.acceptConnection(iConnection);
        }
    }

    public void destroy() {
        if (this.m_selfServer != null) {
            this.disconnectServer(this.m_selfServer);
            this.m_selfServer = null;
        }
        this.disconnectServers();
        Hashtable hashtable = this.m_serverMap;
        synchronized (hashtable) {
            Enumeration enumeration = this.m_serverMap.elements();
            while (enumeration.hasMoreElements()) {
                this.deregisterServer((OServer)enumeration.nextElement());
            }
            return;
        }
    }

    public void setExitListener(IExitListener iExitListener) {
        this.m_exitListener = iExitListener;
    }

    public IExitListener getExitListener() {
        return this.m_exitListener;
    }

    public OServer registerSelfAsServer() {
        Hashtable hashtable = this.m_serverMap;
        synchronized (hashtable) {
            if (this.m_selfServer == null) {
                this.m_selfServer = new OServerStub(this, this.m_requestSem);
                this.m_serverMap.put(this.m_selfServer.getUrl(), this.m_selfServer);
                OServerStub oServerStub = this.m_selfServer;
                Object var3_4 = null;
                return oServerStub;
            }
            OServer oServer = null;
            Object var3_5 = null;
            return oServer;
        }
    }

    public OServer registerServer(String string) {
        OServer oServer = null;
        Hashtable hashtable = this.m_serverMap;
        synchronized (hashtable) {
            if (!this.m_serverMap.containsKey(string)) {
                switch (this.queryServerType(string)) {
                    case 2: {
                        oServer = new OServerProxy(string, this, this.m_requestSem);
                        break;
                    }
                }
                this.m_serverMap.put(oServer.getUrl(), oServer);
                if (oServer.connect()) {
                    if (oServer.isDisconnectAble()) {
                        this.disconnectServer(oServer);
                    }
                } else {
                    this.deregisterServer(oServer);
                    oServer = null;
                }
            }
        }
        return oServer;
    }

    public boolean deregisterServer(OServer oServer) {
        boolean bl = false;
        this.disconnectServer(oServer);
        Hashtable hashtable = this.m_serverMap;
        synchronized (hashtable) {
            bl = this.m_serverMap.remove(oServer.getUrl()) != null;
        }
        return bl;
    }

    public void disconnectServers() {
        Hashtable hashtable = this.m_serverMap;
        synchronized (hashtable) {
            Enumeration enumeration = this.m_serverMap.elements();
            while (enumeration.hasMoreElements()) {
                OServer oServer = (OServer)enumeration.nextElement();
                if (!oServer.isDisconnectAble()) continue;
                oServer.disconnect();
            }
            return;
        }
    }

    public boolean registerFactory(String string, XFactory xFactory, OServer oServer) {
        Hashtable hashtable = this.m_factoryMap;
        synchronized (hashtable) {
            FactoryServerPair factoryServerPair = (FactoryServerPair)this.m_factoryMap.get(string);
            if (oServer == null) {
                oServer = this.m_selfServer;
            }
            if (factoryServerPair == null) {
                this.m_factoryMap.put(string, new FactoryServerPair(string, xFactory, oServer));
            } else {
                factoryServerPair.m_factory = xFactory;
            }
        }
        if (oServer != null) {
            oServer.registerFactory(string, xFactory);
        }
        return true;
    }

    public boolean deregisterFactory(String string, OServer oServer) {
        FactoryServerPair factoryServerPair;
        Hashtable hashtable = this.m_factoryMap;
        synchronized (hashtable) {
            factoryServerPair = (FactoryServerPair)this.m_factoryMap.remove(string);
        }
        if (oServer != null && factoryServerPair != null) {
            oServer.deregisterFactory(string, factoryServerPair.m_factory);
        }
        return factoryServerPair != null;
    }

    public boolean createInstance(String string, OServer oServer, Uik uik, OObjectHolder oObjectHolder) {
        Object[] objectArray;
        if (oServer != null) {
            return oServer.createInstance(string, uik, oObjectHolder);
        }
        Serializable serializable = this.m_factoryMap;
        synchronized (serializable) {
            objectArray = (Object[])this.m_factoryMap.get(string);
            if (objectArray != null) {
                if (objectArray.m_factory == null) {
                    objectArray.m_server.connect();
                }
                boolean bl = objectArray.m_factory.instancedObject(string, null, uik, (OXInterfaceHolder)oObjectHolder);
                Object var7_9 = null;
                return bl;
            }
        }
        Method method = null;
        try {
            serializable = Class.forName("stardiv.uno.sys.ORepository");
            Class[] classArray = new Class[2];
            objectArray = new Object[2];
            classArray[0] = Class.forName("stardiv.uno.OEnvironment");
            classArray[1] = Class.forName("java.lang.String");
            objectArray[0] = this;
            objectArray[1] = string;
            method = ((Class)serializable).getMethod("registerServerForObject", classArray);
            Object object = method.invoke(null, objectArray);
            if (object != null && object instanceof OServer) {
                return ((OServer)object).createInstance(string, uik, oObjectHolder);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        return false;
    }

    public boolean dispatch(int n) {
        boolean bl;
        block8: {
            bl = false;
            try {
                if (!this.isAnyServerConnected()) break block8;
                if (n == 0) {
                    bl = this.m_requestSem.tryToAcquire();
                } else {
                    this.m_requestSem.acquire();
                    bl = true;
                }
                if (!bl) break block8;
                Hashtable hashtable = this.m_serverMap;
                synchronized (hashtable) {
                    Enumeration enumeration = this.m_serverMap.elements();
                    while (enumeration.hasMoreElements()) {
                        OServer oServer = (OServer)enumeration.nextElement();
                        if (!oServer.isRequestPending()) continue;
                        bl = oServer.isSelf() || (this.m_flags & 1) == 0 ? oServer.dispatch(n) : oServer.dispatchAll(n);
                    }
                }
            }
            catch (NullPointerException nullPointerException) {
                System.err.println("NullPointerException in OEnvironment.dispatch");
                if (this.m_exitListener == null) break block8;
                this.m_exitListener.exit(0);
            }
        }
        return bl;
    }

    public boolean waitForPendingRequest(int n) {
        if (!this.isAnyServerConnected()) {
            return false;
        }
        if (n == 0) {
            if (this.m_requestSem.tryToAcquire()) {
                this.m_requestSem.release();
                return true;
            }
            return false;
        }
        this.m_requestSem.acquire();
        this.m_requestSem.release();
        return true;
    }

    public boolean isRequestPending() {
        if (this.m_requestSem.tryToAcquire()) {
            this.m_requestSem.release();
            return true;
        }
        return false;
    }

    public String getLocalHostName() {
        Hashtable hashtable = this.m_serverMap;
        synchronized (hashtable) {
            Enumeration enumeration = this.m_serverMap.elements();
            while (enumeration.hasMoreElements()) {
                OServer oServer = (OServer)enumeration.nextElement();
                if (!oServer.isConnected()) continue;
                String string = oServer.getLocalHostName();
                Object var3_5 = null;
                return string;
            }
        }
        return null;
    }

    public void enterBlockMode(int n) {
        Hashtable hashtable = this.m_serverMap;
        synchronized (hashtable) {
            Enumeration enumeration = this.m_serverMap.elements();
            while (enumeration.hasMoreElements()) {
                OServer oServer = (OServer)enumeration.nextElement();
                oServer.enterBlockMode(n);
            }
            return;
        }
    }

    public void leaveBlockMode() {
        Hashtable hashtable = this.m_serverMap;
        synchronized (hashtable) {
            Enumeration enumeration = this.m_serverMap.elements();
            while (enumeration.hasMoreElements()) {
                OServer oServer = (OServer)enumeration.nextElement();
                oServer.leaveBlockMode();
            }
            return;
        }
    }

    public void flushBlock() {
        Hashtable hashtable = this.m_serverMap;
        synchronized (hashtable) {
            Enumeration enumeration = this.m_serverMap.elements();
            while (enumeration.hasMoreElements()) {
                OServer oServer = (OServer)enumeration.nextElement();
                oServer.flushBlock();
            }
            return;
        }
    }

    public boolean isAnyServerConnected() {
        Hashtable hashtable = this.m_serverMap;
        synchronized (hashtable) {
            Enumeration enumeration = this.m_serverMap.elements();
            while (enumeration.hasMoreElements()) {
                OServer oServer = (OServer)enumeration.nextElement();
                if (!oServer.isConnected()) continue;
                boolean bl = true;
                Object var3_5 = null;
                return bl;
            }
        }
        return false;
    }

    protected void disconnectServer(OServer oServer) {
        Hashtable hashtable = this.m_factoryMap;
        synchronized (hashtable) {
            Enumeration enumeration = this.m_factoryMap.elements();
            while (enumeration.hasMoreElements()) {
                FactoryServerPair factoryServerPair = (FactoryServerPair)enumeration.nextElement();
                if (factoryServerPair.m_server != oServer) continue;
                factoryServerPair.m_factory = null;
            }
        }
        oServer.disconnect();
    }

    protected int queryServerType(String string) {
        return 2;
    }
}

