/*
 * Decompiled with CFR 0.152.
 */
package stardiv.uno.sys;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import stardiv.uno.OServer;
import stardiv.uno.OUnoSystemException;
import stardiv.uno.sys.BlockingInputStream;
import stardiv.uno.sys.IConnection;
import stardiv.uno.sys.IConnectionCallback;
import stardiv.uno.sys.IProtocol;
import stardiv.uno.sys.ITransport;
import stardiv.uno.sys.ORequest;
import stardiv.uno.sys.ORequestBroker;
import stardiv.uno.sys.OTransportException;
import stardiv.uno.sys.OUrl;
import stardiv.uno.sys.connection.ONativeConnection;
import stardiv.uno.sys.connection.OTcpConnection;
import stardiv.uno.sys.marshal.OBuffer;
import stardiv.uno.sys.marshal.OBufferHeap;
import stardiv.uno.sys.marshal.OCdrDecoder;
import stardiv.uno.sys.marshal.OCdrEncoder;
import stardiv.uno.sys.marshal.ODecodeException;
import stardiv.uno.sys.marshal.OEncodeException;
import stardiv.uno.sys.marshal.OPacket;
import stardiv.uno.sys.protocol.OUnoProtocol;
import stardiv.uno.sys.transport.OStreamTransport;

public class OChannel {
    protected final byte UNO_PROTOCOL_VERSION = (byte)2;
    protected IConnection m_connection;
    protected IProtocol m_protocol;
    protected ITransport m_transport;
    protected OCdrDecoder m_decoder;
    protected OCdrEncoder m_encoder;
    protected boolean m_isConnected;
    protected OPacket m_recvPacket;
    protected OServer m_server;
    protected boolean m_bIsRecvEnabled;
    public OBufferHeap m_bufferHeap;
    protected static final int HEADMAGIC = 89449712;
    protected static final short HEADLEN = 12;

    public OChannel(OServer oServer) {
        this.m_server = oServer;
        this.m_bufferHeap = new OBufferHeap();
        this.m_recvPacket = new OPacket(0);
    }

    public OChannel(OServer oServer, IConnection iConnection) {
        this.m_server = oServer;
        this.m_connection = iConnection;
        this.m_bufferHeap = new OBufferHeap();
        this.m_recvPacket = new OPacket(0);
        if (this.m_connection.getStatus() == 2) {
            this.m_encoder = new OCdrEncoder(this.m_server);
            this.m_decoder = new OCdrDecoder(this.m_server);
            this.m_transport = new OStreamTransport(this.m_connection, null, this.m_encoder, this.m_decoder, this.m_bufferHeap);
            this.m_protocol = new OUnoProtocol(this.m_transport, this.m_encoder, this.m_decoder);
            this.m_isConnected = true;
            return;
        }
        try {
            OBuffer oBuffer = this.m_bufferHeap.getBuffer(12);
            this.m_encoder = new OCdrEncoder(this.m_server);
            this.m_decoder = new OCdrDecoder(this.m_server);
            OutputStream outputStream = this.m_connection.getOutputStream();
            BlockingInputStream blockingInputStream = new BlockingInputStream(this.m_connection.getInputStream());
            blockingInputStream.read(oBuffer.getData(), oBuffer.getSize());
            int n = this.m_decoder.decodeULong(oBuffer);
            byte by = this.m_decoder.decodeByte(oBuffer);
            byte by2 = this.m_decoder.decodeByte(oBuffer);
            short s = this.m_decoder.decodeUShort(oBuffer);
            if (n == 89449712) {
                oBuffer = this.m_bufferHeap.getBuffer(12);
                by2 = 2;
                this.m_encoder.encodeULong(oBuffer, n);
                this.m_encoder.encodeByte(oBuffer, by);
                this.m_encoder.encodeByte(oBuffer, by2);
                this.m_encoder.encodeUShort(oBuffer, s);
                oBuffer.setSize(oBuffer.getWritePos());
                outputStream.write(oBuffer.getData(), 0, oBuffer.getSize());
                this.m_transport = new OStreamTransport(this.m_connection, null, this.m_encoder, this.m_decoder, this.m_bufferHeap);
                this.m_protocol = new OUnoProtocol(this.m_transport, this.m_encoder, this.m_decoder);
                this.m_isConnected = true;
                this.m_bufferHeap.putBuffer(oBuffer);
                return;
            }
            this.m_connection.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    protected boolean doClientConnect(OutputStream outputStream, InputStream inputStream) {
        boolean bl = false;
        BlockingInputStream blockingInputStream = new BlockingInputStream(inputStream);
        OBuffer oBuffer = this.m_bufferHeap.getBuffer(12);
        try {
            try {
                int n = 89449712;
                byte by = 1;
                byte by2 = 2;
                short s = 127;
                this.m_encoder.encodeULong(oBuffer, n);
                this.m_encoder.encodeByte(oBuffer, by);
                this.m_encoder.encodeByte(oBuffer, by2);
                this.m_encoder.encodeUShort(oBuffer, s);
                oBuffer.setSize(oBuffer.getWritePos());
                outputStream.write(oBuffer.getData(), 0, oBuffer.getSize());
                oBuffer.reset();
                blockingInputStream.read(oBuffer.getData(), oBuffer.getSize());
                n = this.m_decoder.decodeULong(oBuffer);
                by = this.m_decoder.decodeByte(oBuffer);
                by2 = this.m_decoder.decodeByte(oBuffer);
                s = this.m_decoder.decodeUShort(oBuffer);
                if (n == 89449712 && by2 != 1 && by2 >= 2 && by2 == 2) {
                    bl = true;
                }
            }
            catch (IOException iOException) {
            }
            catch (OUnoSystemException oUnoSystemException) {
            }
            catch (ODecodeException oDecodeException) {
            }
            catch (OEncodeException oEncodeException) {
            }
            Object var7_10 = null;
            this.m_bufferHeap.putBuffer(oBuffer);
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            this.m_bufferHeap.putBuffer(oBuffer);
            throw throwable;
        }
        return bl;
    }

    public boolean connect(OUrl oUrl, IConnectionCallback iConnectionCallback) {
        block20: {
            this.m_isConnected = false;
            this.m_encoder = new OCdrEncoder(this.m_server);
            this.m_decoder = new OCdrDecoder(this.m_server);
            if (oUrl.getProtocol().equals("uno")) {
                Socket socket = null;
                try {
                    try {
                        InetAddress inetAddress = InetAddress.getByName(oUrl.getNode());
                        int n = Integer.parseInt(oUrl.getPort());
                        socket = new Socket(inetAddress, n);
                    }
                    catch (SecurityException securityException) {
                        try {
                            Class<?> clazz = Class.forName("netscape.security.PrivilegeManager");
                            if (clazz != null) {
                                Class[] classArray = new Class[]{Class.forName("java.lang.String")};
                                Method method = clazz.getMethod("enablePrivilege", classArray);
                                if (method != null) {
                                    Object[] objectArray = new Object[]{new String("UniversalConnect")};
                                    method.invoke(null, objectArray);
                                    InetAddress inetAddress = InetAddress.getByName(oUrl.getNode());
                                    int n = Integer.parseInt(oUrl.getPort());
                                    socket = new Socket(inetAddress, n);
                                }
                            }
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                        }
                        catch (SecurityException securityException2) {
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                        }
                        catch (IllegalAccessException illegalAccessException) {
                        }
                        catch (InvocationTargetException invocationTargetException) {
                        }
                        catch (IllegalArgumentException illegalArgumentException) {}
                    }
                    if (socket == null) break block20;
                    this.m_isConnected = this.doClientConnect(socket.getOutputStream(), socket.getInputStream());
                    if (!this.m_isConnected) {
                        socket.close();
                        break block20;
                    }
                    this.m_connection = new OTcpConnection(socket, 2);
                    this.m_transport = new OStreamTransport(this.m_connection, null, this.m_encoder, this.m_decoder, this.m_bufferHeap);
                    this.m_protocol = new OUnoProtocol(this.m_transport, this.m_encoder, this.m_decoder);
                }
                catch (UnknownHostException unknownHostException) {
                }
                catch (IOException iOException) {}
            } else if (oUrl.getProtocol().equals("native")) {
                ONativeConnection oNativeConnection = new ONativeConnection();
                this.m_transport = new OStreamTransport(oNativeConnection, null, this.m_encoder, this.m_decoder, this.m_bufferHeap);
                this.m_protocol = new OUnoProtocol(this.m_transport, this.m_encoder, this.m_decoder);
                this.m_isConnected = true;
                this.m_isConnected = oNativeConnection.open(oUrl.getNode(), iConnectionCallback);
                if (!this.m_isConnected) {
                    this.m_transport = null;
                    this.m_protocol = null;
                }
            }
        }
        return this.m_isConnected;
    }

    public synchronized void disconnect() {
        this.terminateTransport();
        if (this.m_protocol != null) {
            this.m_protocol = null;
        }
        if (this.m_transport != null) {
            this.m_transport = null;
        }
        if (this.m_encoder != null) {
            this.m_encoder = null;
        }
        if (this.m_decoder != null) {
            this.m_decoder = null;
        }
        if (this.m_connection != null) {
            this.m_connection.close();
            this.m_connection = null;
        }
    }

    public void putRequest(ORequest oRequest) {
        if (this.m_isConnected) {
            OPacket oPacket = new OPacket(0);
            oPacket.pushBack(oRequest.m_head);
            oPacket.pushBack(oRequest.m_data);
            try {
                this.m_protocol.sendPacket(oPacket);
                if (oRequest.isSync()) {
                    this.m_transport.flushBlock();
                    return;
                }
            }
            catch (OTransportException oTransportException) {
                this.disconnect();
                return;
            }
        }
    }

    public ORequest getRequest(ORequestBroker oRequestBroker, int n) {
        ORequest oRequest = null;
        if (this.m_isConnected) {
            if (this.m_recvPacket.isEmpty() && this.m_protocol != null) {
                try {
                    this.m_protocol.recvPacket(this.m_recvPacket);
                }
                catch (OTransportException oTransportException) {
                    this.disconnect();
                }
            }
            if (this.m_encoder != null && this.m_decoder != null && !this.m_recvPacket.isEmpty()) {
                oRequest = new ORequest(this.m_recvPacket.popFront(), oRequestBroker, this.m_encoder, this.m_decoder);
            }
        }
        return oRequest;
    }

    public void terminateTransport() {
        this.m_isConnected = false;
        if (this.m_transport != null) {
            this.m_transport.terminateTransport();
        }
    }

    public final OCdrEncoder getEncoder() {
        return this.m_encoder;
    }

    public final OCdrDecoder getDecoder() {
        return this.m_decoder;
    }

    public final void enterBlockMode(int n) {
        if (this.isConnected()) {
            this.m_protocol.enterBlockMode(n);
        }
    }

    public final void leaveBlockMode() {
        if (this.isConnected()) {
            this.m_protocol.leaveBlockMode();
        }
    }

    public final void flushBlock() {
        if (this.isConnected()) {
            this.m_protocol.flushBlock();
        }
    }

    public final boolean isConnected() {
        return this.m_isConnected;
    }

    public String getLocalHostName() {
        return this.m_connection.getLocalUrl().getNode();
    }
}

