/*
 * Decompiled with CFR 0.152.
 */
package stardiv.uno.sys;

import stardiv.uno.sys.OCondition;
import stardiv.uno.sys.ORequest;
import stardiv.uno.sys.ORequestBroker;

class OQueueThread
extends Thread {
    protected ORequestBroker m_broker;
    protected OCondition m_recvCond;

    public OQueueThread(ORequestBroker oRequestBroker) {
        this.m_broker = oRequestBroker;
        this.m_recvCond = new OCondition(true);
    }

    public boolean isRecvEnabled() {
        return this.m_recvCond.test();
    }

    public void enableRecv(boolean bl) {
        if (bl) {
            this.m_recvCond.set();
            return;
        }
        this.m_recvCond.reset();
    }

    public void run() {
        while (this.m_broker.isConnected()) {
            this.m_recvCond.waitFor();
            ORequest oRequest = this.m_broker.m_channel.getRequest(this.m_broker, -1);
            if (oRequest == null) {
                this.m_broker.connectionHasTerminated();
                continue;
            }
            if (!oRequest.isReply() && oRequest.isSysRequest()) {
                oRequest.execute();
                continue;
            }
            this.m_broker.addRequest(oRequest);
        }
    }
}

