/*
 * Decompiled with CFR 0.152.
 */
package stardiv.uno.sys;

import java.util.Enumeration;
import java.util.Hashtable;
import stardiv.uno.IExitListener;
import stardiv.uno.OServer;
import stardiv.uno.OUnoSystemException;
import stardiv.uno.sys.IConnectionCallback;
import stardiv.uno.sys.OCachedRequestQueue;
import stardiv.uno.sys.OChannel;
import stardiv.uno.sys.OQueueThread;
import stardiv.uno.sys.ORequest;
import stardiv.uno.sys.OSemaphore;
import stardiv.uno.sys.OThreadCallContext;

public class ORequestBroker {
    public OChannel m_channel;
    IConnectionCallback m_callback;
    protected OQueueThread m_queueThread;
    protected OServer m_server;
    protected OSemaphore m_superSem;
    protected int m_ridCount;
    protected boolean m_directX;
    protected Hashtable m_Thread2RequestMap;
    protected OCachedRequestQueue m_defaultRequestQueue;

    public ORequestBroker getThis() {
        return this;
    }

    public IConnectionCallback getConnectionCallback() {
        return this.m_callback;
    }

    public ORequestBroker(OServer oServer, OChannel oChannel, OSemaphore oSemaphore, boolean bl) {
        this.m_superSem = oSemaphore;
        this.m_server = oServer;
        this.m_channel = oChannel;
        this.m_Thread2RequestMap = new Hashtable();
        this.m_directX = bl;
        this.m_defaultRequestQueue = new OCachedRequestQueue(this.m_channel.m_bufferHeap, this);
        this.m_queueThread = new OQueueThread(this);
        if (this.m_directX) {
            this.m_callback = new OConnectionCallback();
            return;
        }
        this.m_queueThread.start();
    }

    public void destroy() {
        try {
            block6: {
                try {
                    this.m_channel.terminateTransport();
                    try {
                        this.m_queueThread.stop();
                    }
                    catch (SecurityException securityException) {
                        System.err.println("SecurityException while stoping RequestBroker thread");
                    }
                }
                catch (OUnoSystemException oUnoSystemException) {
                    IExitListener iExitListener = this.m_server.getEnvironment().getExitListener();
                    if (iExitListener == null) break block6;
                    iExitListener.exit(0);
                }
            }
            Object var2_2 = null;
            this.emptyRequestQueue();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.emptyRequestQueue();
            this.m_superSem.release();
            throw throwable;
        }
        this.m_superSem.release();
    }

    protected boolean emptyRequestQueue() {
        ORequest oRequest = null;
        boolean bl = false;
        if (this.m_defaultRequestQueue != null) {
            while (!this.m_defaultRequestQueue.isEmpty()) {
                oRequest = this.m_defaultRequestQueue.pop(false);
                if (oRequest == null || oRequest.isSync()) continue;
                oRequest.execute();
                bl = true;
            }
        }
        return bl;
    }

    public boolean dispatch(int n) {
        ORequest oRequest = null;
        if (this.isConnected() && this.m_defaultRequestQueue != null) {
            oRequest = n == 0 ? this.m_defaultRequestQueue.pop(false) : this.m_defaultRequestQueue.pop(true);
            oRequest.execute();
        }
        return true;
    }

    public boolean dispatchAll(int n) {
        ORequest oRequest = null;
        boolean bl = false;
        if (this.isConnected() && this.m_defaultRequestQueue != null) {
            this.m_queueThread.enableRecv(false);
            if (n == 0) {
                bl = true;
                do {
                    if ((oRequest = this.m_defaultRequestQueue.pop(false)) == null) continue;
                    this.m_superSem.tryToAcquire();
                    oRequest.execute();
                } while (oRequest != null);
                this.m_queueThread.enableRecv(true);
            } else {
                oRequest = this.m_defaultRequestQueue.pop(true);
                bl = true;
                while (oRequest != null) {
                    oRequest.execute();
                    oRequest = this.m_defaultRequestQueue.pop(false);
                    if (oRequest == null) continue;
                    this.m_superSem.tryToAcquire();
                }
            }
            this.m_queueThread.enableRecv(true);
        }
        return bl;
    }

    public boolean isRequestPending() {
        return this.m_defaultRequestQueue != null && !this.m_defaultRequestQueue.isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean putRequest(ORequest oRequest, int n) {
        Object object;
        boolean bl = false;
        if (!this.isConnected()) return bl;
        OCachedRequestQueue oCachedRequestQueue = null;
        if (oRequest.isSync() && !oRequest.isReply()) {
            object = this.m_Thread2RequestMap;
            synchronized (object) {
                if (!this.m_Thread2RequestMap.containsKey(oRequest.getThreadCallContext())) {
                    oCachedRequestQueue = new OCachedRequestQueue(this.m_channel.m_bufferHeap, this);
                    this.m_Thread2RequestMap.put(oRequest.getThreadCallContext(), oCachedRequestQueue);
                } else {
                    oCachedRequestQueue = (OCachedRequestQueue)this.m_Thread2RequestMap.get(oRequest.getThreadCallContext());
                }
                oCachedRequestQueue.m_ridStack.push(new Integer(oRequest.getRid()));
            }
        }
        this.m_channel.putRequest(oRequest);
        if (oCachedRequestQueue == null) return true;
        object = null;
        while (object == null && this.isConnected()) {
            this.m_queueThread.enableRecv(true);
            object = oCachedRequestQueue.pop(true);
            if ((object == null || ((ORequest)object).isReply()) && ((ORequest)object).getRid() == oRequest.getRid()) continue;
            ((ORequest)object).setThreadCallContext(oRequest.getThreadCallContext());
            ((ORequest)object).execute();
            object = null;
        }
        oCachedRequestQueue.m_ridStack.pop();
        if (oCachedRequestQueue.m_ridStack.empty()) {
            Hashtable hashtable = this.m_Thread2RequestMap;
            synchronized (hashtable) {
                this.m_Thread2RequestMap.remove(oRequest.getThreadCallContext());
            }
        }
        if (object != null) {
            oRequest.putReply((ORequest)object);
            return true;
        }
        OUnoSystemException oUnoSystemException = new OUnoSystemException("connection lost while waiting for reply");
        throw oUnoSystemException;
    }

    public int createRid() {
        return this.m_ridCount++;
    }

    public OServer getServer() {
        return this.m_server;
    }

    public boolean isConnected() {
        return this.m_channel.isConnected();
    }

    protected boolean addRequest(ORequest oRequest) {
        OThreadCallContext oThreadCallContext = oRequest.getThreadCallContext();
        boolean bl = false;
        if (this.m_directX && !oRequest.isReply()) {
            oRequest.execute();
            bl = true;
        } else {
            Hashtable hashtable = this.m_Thread2RequestMap;
            synchronized (hashtable) {
                Object object;
                if (this.m_Thread2RequestMap.containsKey(oThreadCallContext) && (object = (OCachedRequestQueue)this.m_Thread2RequestMap.get(oThreadCallContext)) != null && !((OCachedRequestQueue)object).m_ridStack.empty()) {
                    ((OCachedRequestQueue)object).push(oRequest);
                    bl = true;
                }
                if (!bl && oRequest.isReply()) {
                    object = this.m_Thread2RequestMap.elements();
                    OCachedRequestQueue oCachedRequestQueue = null;
                    while (!bl && object.hasMoreElements()) {
                        oCachedRequestQueue = (OCachedRequestQueue)object.nextElement();
                        if (oCachedRequestQueue.m_ridStack.empty() || !oCachedRequestQueue.m_ridStack.peek().equals(new Integer(oRequest.getRid()))) continue;
                        oCachedRequestQueue.push(oRequest);
                        bl = true;
                    }
                }
            }
            if (!bl) {
                this.m_defaultRequestQueue.push(oRequest);
                this.m_superSem.release();
                bl = true;
            }
        }
        return bl;
    }

    protected void connectionHasTerminated() {
        if (this.m_defaultRequestQueue != null) {
            this.m_defaultRequestQueue.push(null);
        }
        Hashtable hashtable = this.m_Thread2RequestMap;
        synchronized (hashtable) {
            Enumeration enumeration = this.m_Thread2RequestMap.elements();
            OCachedRequestQueue oCachedRequestQueue = null;
            while (enumeration.hasMoreElements()) {
                oCachedRequestQueue = (OCachedRequestQueue)enumeration.nextElement();
                oCachedRequestQueue.push(null);
            }
        }
        this.m_superSem.release();
    }

    protected class OConnectionCallback
    implements IConnectionCallback {
        public void dataRecieved(int n) {
            if (n > 0) {
                ORequest oRequest = ORequestBroker.this.m_channel.getRequest(ORequestBroker.this.getThis(), -1);
                if (oRequest == null) {
                    ORequestBroker.this.connectionHasTerminated();
                    return;
                }
                if (!oRequest.isReply() && oRequest.isSysRequest()) {
                    oRequest.execute();
                    return;
                }
                ORequestBroker.this.addRequest(oRequest);
            }
        }

        protected OConnectionCallback() {
            ORequestBroker.this = ORequestBroker.this;
        }
    }
}

