/*
 * Decompiled with CFR 0.152.
 */
package stardiv.uno.sys.connection;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import stardiv.uno.sys.IConnection;
import stardiv.uno.sys.IConnectionCallback;
import stardiv.uno.sys.OUrl;

public class OTcpConnection
implements IConnection {
    Socket m_socket;
    int m_status;
    OUrl m_localUrl;
    OUrl m_remoteUrl;

    public OTcpConnection(Socket socket, int n) {
        this.m_socket = socket;
        this.m_status = n;
        try {
            this.m_localUrl = new OUrl(this.m_socket.getLocalAddress().getHostName(), Integer.toString(this.m_socket.getLocalPort()), "uno://", "");
            this.m_remoteUrl = new OUrl(this.m_socket.getInetAddress().getHostName(), Integer.toString(this.m_socket.getLocalPort()), "uno://", "");
            this.m_socket.setTcpNoDelay(true);
            return;
        }
        catch (IOException iOException) {
            this.m_localUrl = new OUrl("localhost", "8125", "uno://", "");
            this.m_remoteUrl = new OUrl("localhost", "8125", "uno://", "");
            return;
        }
        catch (SecurityException securityException) {
            this.m_localUrl = new OUrl("localhost", "8125", "uno://", "");
            this.m_remoteUrl = new OUrl("localhost", "8125", "uno://", "");
            return;
        }
    }

    public void close() {
        try {
            this.m_socket.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public int getStatus() {
        return this.m_status;
    }

    public void setStatus(int n) {
        this.m_status = n;
    }

    public OUrl getLocalUrl() {
        return this.m_localUrl;
    }

    public OUrl getRemoteUrl() {
        return this.m_remoteUrl;
    }

    public boolean registerCallback(IConnectionCallback iConnectionCallback) {
        return false;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.m_socket.getOutputStream();
    }

    public InputStream getInputStream() throws IOException {
        return this.m_socket.getInputStream();
    }
}

