/*
 * Decompiled with CFR 0.152.
 */
package stardiv.uno.sys.marshal;

import stardiv.uno.OServer;
import stardiv.uno.sys.OCid;
import stardiv.uno.sys.marshal.OBuffer;
import stardiv.uno.sys.marshal.ODecodeException;

public class OCdrDecoder {
    protected byte m_byteOrder;
    protected OServer m_server;

    public OCdrDecoder(OServer oServer) {
        this.m_server = oServer;
        this.m_byteOrder = 1;
    }

    public OCdrDecoder(OServer oServer, byte by) {
        this.m_server = oServer;
        this.m_byteOrder = by;
    }

    public short decodeShort(OBuffer oBuffer) {
        if (oBuffer.read() == 7) {
            return (short)(oBuffer.read() << 8 | oBuffer.read());
        }
        throw new ODecodeException();
    }

    public int decodeLong(OBuffer oBuffer) {
        if (oBuffer.read() == 9) {
            return oBuffer.read() << 24 | oBuffer.read() << 16 | oBuffer.read() << 8 | oBuffer.read();
        }
        throw new ODecodeException();
    }

    public long decodeHyper(OBuffer oBuffer) {
        if (oBuffer.read() == 11) {
            return (long)oBuffer.read() << 56 | (long)oBuffer.read() << 48 | (long)oBuffer.read() << 40 | (long)oBuffer.read() << 32 | (long)oBuffer.read() << 24 | (long)oBuffer.read() << 16 | (long)oBuffer.read() << 8 | (long)oBuffer.read();
        }
        throw new ODecodeException();
    }

    public short decodeUShort(OBuffer oBuffer) {
        if (oBuffer.read() == 8) {
            return (short)(oBuffer.read() << 8 | oBuffer.read());
        }
        throw new ODecodeException();
    }

    public int decodeULong(OBuffer oBuffer) {
        if (oBuffer.read() == 10) {
            return oBuffer.read() << 24 | oBuffer.read() << 16 | oBuffer.read() << 8 | oBuffer.read();
        }
        throw new ODecodeException();
    }

    public long decodeUHyper(OBuffer oBuffer) {
        if (oBuffer.read() == 12) {
            return (long)oBuffer.read() << 56 | (long)oBuffer.read() << 48 | (long)oBuffer.read() << 40 | (long)oBuffer.read() << 32 | (long)oBuffer.read() << 24 | (long)oBuffer.read() << 16 | (long)oBuffer.read() << 8 | (long)oBuffer.read();
        }
        throw new ODecodeException();
    }

    public float decodeFloat(OBuffer oBuffer) {
        if (oBuffer.read() == 13) {
            int n = oBuffer.read() << 24 | oBuffer.read() << 16 | oBuffer.read() << 8 | oBuffer.read();
            return Float.intBitsToFloat(n);
        }
        throw new ODecodeException();
    }

    public double decodeDouble(OBuffer oBuffer) {
        if (oBuffer.read() == 14) {
            long l = (long)oBuffer.read() << 56 | (long)oBuffer.read() << 48 | (long)oBuffer.read() << 40 | (long)oBuffer.read() << 32 | (long)oBuffer.read() << 24 | (long)oBuffer.read() << 16 | (long)oBuffer.read() << 8 | (long)oBuffer.read();
            return Double.longBitsToDouble(l);
        }
        throw new ODecodeException();
    }

    public char decodeChar(OBuffer oBuffer) {
        if (oBuffer.read() == 4) {
            return (char)oBuffer.read();
        }
        throw new ODecodeException();
    }

    public byte decodeByte(OBuffer oBuffer) {
        if (oBuffer.read() == 3) {
            return (byte)oBuffer.read();
        }
        throw new ODecodeException();
    }

    public String decodeString(OBuffer oBuffer) {
        if (oBuffer.read() == 18) {
            short s = (short)(oBuffer.read() << 8 | oBuffer.read());
            char[] cArray = new char[s];
            short s2 = 0;
            while (s2 < s) {
                cArray[s2] = (char)(oBuffer.read() << 8 | oBuffer.read());
                s2 = (short)(s2 + 1);
            }
            return new String(cArray);
        }
        throw new ODecodeException();
    }

    public boolean decodeBoolean(OBuffer oBuffer) {
        if (oBuffer.read() == 15) {
            byte by = (byte)oBuffer.read();
            return by != 0;
        }
        throw new ODecodeException();
    }

    public int decodeEnum(OBuffer oBuffer) {
        if (oBuffer.read() == 16) {
            return oBuffer.read() << 8 | oBuffer.read();
        }
        throw new ODecodeException();
    }

    public byte decodeOctet(OBuffer oBuffer) {
        if (oBuffer.read() == 2) {
            return (byte)oBuffer.read();
        }
        throw new ODecodeException();
    }

    public OCid decodeCid(OBuffer oBuffer) {
        OCid oCid = null;
        if (oBuffer.read() == 21) {
            int n = this.decodeULong(oBuffer);
            byte by = this.decodeByte(oBuffer);
            if (by == 1) {
                int n2 = this.decodeULong(oBuffer);
                oCid = n <= 0 ? OCid.invalidCid : new OCid(n, this.m_server.mapIncomingServerId(n2));
            } else {
                int[] nArray = new int[by];
                this.decodeULongArray(oBuffer, nArray);
                oCid = n <= 0 ? OCid.invalidCid : new OCid(n, nArray);
            }
        } else {
            throw new ODecodeException();
        }
        return oCid;
    }

    public void decodeShortArray(OBuffer oBuffer, short[] sArray) {
        int n = this.decodeEnum(oBuffer);
        if (n == 134) {
            int n2 = this.decodeULong(oBuffer);
            int n3 = 0;
            while (n3 < n2) {
                sArray[n3] = (short)(oBuffer.read() << 8 | oBuffer.read());
                ++n3;
            }
            return;
        }
        throw new ODecodeException();
    }

    public void decodeLongArray(OBuffer oBuffer, int[] nArray) {
        int n = this.decodeEnum(oBuffer);
        if (n == 136) {
            int n2 = this.decodeULong(oBuffer);
            int n3 = 0;
            while (n3 < n2) {
                nArray[n3] = oBuffer.read() << 24 | oBuffer.read() << 16 | oBuffer.read() << 8 | oBuffer.read();
                ++n3;
            }
            return;
        }
        throw new ODecodeException();
    }

    public void decodeHyperArray(OBuffer oBuffer, long[] lArray) {
        int n = this.decodeEnum(oBuffer);
        if (n == 138) {
            int n2 = this.decodeULong(oBuffer);
            int n3 = 0;
            while (n3 < n2) {
                lArray[n3] = (long)oBuffer.read() << 56 | (long)oBuffer.read() << 48 | (long)oBuffer.read() << 40 | (long)oBuffer.read() << 32 | (long)oBuffer.read() << 24 | (long)oBuffer.read() << 16 | (long)oBuffer.read() << 8 | (long)oBuffer.read();
                ++n3;
            }
            return;
        }
        throw new ODecodeException();
    }

    public void decodeUShortArray(OBuffer oBuffer, short[] sArray) {
        int n = this.decodeEnum(oBuffer);
        if (n == 135) {
            int n2 = this.decodeULong(oBuffer);
            int n3 = 0;
            while (n3 < n2) {
                sArray[n3] = (short)(oBuffer.read() << 8 | oBuffer.read());
                ++n3;
            }
            return;
        }
        throw new ODecodeException();
    }

    public void decodeULongArray(OBuffer oBuffer, int[] nArray) {
        int n = this.decodeEnum(oBuffer);
        if (n == 137) {
            int n2 = this.decodeULong(oBuffer);
            int n3 = 0;
            while (n3 < n2) {
                nArray[n3] = oBuffer.read() << 24 | oBuffer.read() << 16 | oBuffer.read() << 8 | oBuffer.read();
                ++n3;
            }
            return;
        }
        throw new ODecodeException();
    }

    public void decodeUHyperArray(OBuffer oBuffer, long[] lArray) {
        int n = this.decodeEnum(oBuffer);
        if (n == 139) {
            int n2 = this.decodeULong(oBuffer);
            int n3 = 0;
            while (n3 < n2) {
                lArray[n3] = (long)oBuffer.read() << 56 | (long)oBuffer.read() << 48 | (long)oBuffer.read() << 40 | (long)oBuffer.read() << 32 | (long)oBuffer.read() << 24 | (long)oBuffer.read() << 16 | (long)oBuffer.read() << 8 | (long)oBuffer.read();
                ++n3;
            }
            return;
        }
        throw new ODecodeException();
    }

    public void decodeFloatArray(OBuffer oBuffer, float[] fArray) {
        int n = this.decodeEnum(oBuffer);
        if (n == 140) {
            int n2 = this.decodeULong(oBuffer);
            int n3 = 0;
            while (n3 < n2) {
                int n4 = oBuffer.read() << 24 | oBuffer.read() << 16 | oBuffer.read() << 8 | oBuffer.read();
                fArray[n3] = Float.intBitsToFloat(n4);
                ++n3;
            }
            return;
        }
        throw new ODecodeException();
    }

    public void decodeDoubleArray(OBuffer oBuffer, double[] dArray) {
        int n = this.decodeEnum(oBuffer);
        if (n == 141) {
            int n2 = this.decodeULong(oBuffer);
            int n3 = 0;
            while (n3 < n2) {
                long l = (long)oBuffer.read() << 56 | (long)oBuffer.read() << 48 | (long)oBuffer.read() << 40 | (long)oBuffer.read() << 32 | (long)oBuffer.read() << 24 | (long)oBuffer.read() << 16 | (long)oBuffer.read() << 8 | (long)oBuffer.read();
                dArray[n3] = Double.longBitsToDouble(l);
                ++n3;
            }
            return;
        }
        throw new ODecodeException();
    }

    public void decodeCharArray(OBuffer oBuffer, byte[] byArray) {
        int n = this.decodeEnum(oBuffer);
        if (n == 131) {
            int n2 = this.decodeULong(oBuffer);
            System.arraycopy(oBuffer.getData(), oBuffer.getReadPos(), byArray, 0, n2);
            oBuffer.incReadPos(n2);
            return;
        }
        throw new ODecodeException();
    }

    public void decodeByteArray(OBuffer oBuffer, byte[] byArray) {
        int n = this.decodeEnum(oBuffer);
        if (n == 130) {
            int n2 = this.decodeULong(oBuffer);
            System.arraycopy(oBuffer.getData(), oBuffer.getReadPos(), byArray, 0, n2);
            oBuffer.incReadPos(n2);
            return;
        }
        throw new ODecodeException();
    }

    public void decodeStringArray(OBuffer oBuffer, String[] stringArray) {
        int n = this.decodeEnum(oBuffer);
        if (n == 145) {
            int n2 = this.decodeULong(oBuffer);
            int n3 = 0;
            while (n3 < n2) {
                short s = (short)(oBuffer.read() << 8 | oBuffer.read());
                char[] cArray = new char[s];
                short s2 = 0;
                while (s2 < s) {
                    cArray[s2] = (char)(oBuffer.read() << 8 | oBuffer.read());
                    s2 = (short)(s2 + 1);
                }
                stringArray[n3] = new String(cArray);
                ++n3;
            }
            return;
        }
        throw new ODecodeException();
    }

    public void decodeBooleanArray(OBuffer oBuffer, boolean[] blArray) {
        int n = this.decodeEnum(oBuffer);
        if (n == 142) {
            int n2 = this.decodeULong(oBuffer);
            int n3 = 0;
            while (n3 < n2) {
                byte by = (byte)oBuffer.read();
                blArray[n3] = by != 0;
                ++n3;
            }
            return;
        }
        throw new ODecodeException();
    }

    public void decodeEnumArray(OBuffer oBuffer, int[] nArray) {
        int n = this.decodeEnum(oBuffer);
        if (n == 143) {
            int n2 = this.decodeULong(oBuffer);
            int n3 = 0;
            while (n3 < n2) {
                nArray[n3] = oBuffer.read() << 8 | oBuffer.read();
                ++n3;
            }
            return;
        }
        throw new ODecodeException();
    }

    public void decodeOctetArray(OBuffer oBuffer, byte[] byArray) {
        int n = this.decodeEnum(oBuffer);
        if (n == 129) {
            int n2 = this.decodeULong(oBuffer);
            int n3 = 0;
            while (n3 < n2) {
                byArray[n3] = (byte)oBuffer.read();
                ++n3;
            }
            return;
        }
        throw new ODecodeException();
    }

    protected void finalize() {
    }
}

