/*
 * Decompiled with CFR 0.152.
 */
package stardiv.uno.sys.server;

import java.util.Hashtable;
import stardiv.uno.IExitListener;
import stardiv.uno.OEnvironment;
import stardiv.uno.OServer;
import stardiv.uno.OUnoSystemException;
import stardiv.uno.Uik;
import stardiv.uno.XFactory;
import stardiv.uno.holder.OIntHolder;
import stardiv.uno.holder.OObjectHolder;
import stardiv.uno.sys.IConnection;
import stardiv.uno.sys.OChannel;
import stardiv.uno.sys.OContext;
import stardiv.uno.sys.OMarshalType;
import stardiv.uno.sys.ORequest;
import stardiv.uno.sys.ORequestBroker;
import stardiv.uno.sys.OSemaphore;

public class OServerStub
extends OServer {
    protected OSemaphore m_requestSem;
    protected OChannel m_channel;
    protected ORequestBroker m_broker;
    protected OEnvironment m_environ;
    protected int m_myServerId;
    protected Hashtable m_incomingMap;
    protected Hashtable m_outgoingMap;
    public static final OMarshalType[] queryServerIdTypes = new OMarshalType[]{new OMarshalType(10, 2, null)};

    public OServerStub(OEnvironment oEnvironment, OSemaphore oSemaphore) {
        super("self", oEnvironment);
        this.m_requestSem = oSemaphore;
        this.m_environ = oEnvironment;
        this.m_myServerId = 0;
        this.m_incomingMap = new Hashtable();
        this.m_outgoingMap = new Hashtable();
    }

    public boolean isDisconnectAble() {
        return false;
    }

    public boolean isConnected() {
        if (this.m_broker == null) {
            return false;
        }
        return this.m_broker.isConnected();
    }

    public boolean connect() {
        return true;
    }

    public boolean disconnect() {
        block5: {
            try {
                if (this.m_broker != null) {
                    OContext.invalidateContexts(this.m_broker);
                }
                if (this.m_channel != null) {
                    this.m_channel.disconnect();
                    this.m_channel = null;
                }
                if (this.m_broker != null) {
                    this.m_broker.destroy();
                    this.m_broker = null;
                }
            }
            catch (OUnoSystemException oUnoSystemException) {
                IExitListener iExitListener = this.m_environ.getExitListener();
                if (iExitListener == null) break block5;
                iExitListener.exit(0);
            }
        }
        return true;
    }

    public void enterBlockMode(int n) {
    }

    public void leaveBlockMode() {
    }

    public void flushBlock() {
    }

    public boolean dispatch(int n) {
        if (this.m_broker == null) {
            return false;
        }
        return this.m_broker.dispatch(n);
    }

    public boolean isRequestPending() {
        if (this.m_broker == null) {
            return false;
        }
        return this.m_broker.isRequestPending();
    }

    public boolean sendRequest(ORequest oRequest, int n) {
        if (this.m_broker == null) {
            return false;
        }
        return this.m_broker.putRequest(oRequest, n);
    }

    public String getLocalHostName() {
        if (this.m_channel == null) {
            return null;
        }
        return this.m_channel.getLocalHostName();
    }

    public boolean registerFactory(String string, XFactory xFactory) {
        return false;
    }

    public boolean deregisterFactory(String string, XFactory xFactory) {
        return false;
    }

    public boolean createInstance(String string, Uik uik, OObjectHolder oObjectHolder) {
        return this.m_environ.createInstance(string, null, uik, oObjectHolder);
    }

    public boolean acceptConnection(IConnection iConnection) {
        if (this.m_channel == null) {
            this.m_channel = new OChannel(this, iConnection);
            if (iConnection.getLocalUrl().getProtocol().equals("java")) {
                this.m_broker = new ORequestBroker(this, this.m_channel, this.m_requestSem, true);
                iConnection.registerCallback(this.m_broker.getConnectionCallback());
            } else {
                this.m_broker = new ORequestBroker(this, this.m_channel, this.m_requestSem, false);
            }
            OIntHolder oIntHolder = new OIntHolder();
            Object[] objectArray = new Object[]{oIntHolder};
            ORequest oRequest = new ORequest(this.m_broker, 2, 0);
            oRequest.execute();
            oRequest.unmarshalArguments(queryServerIdTypes, objectArray, 2);
            this.m_myServerId = oIntHolder.value;
            this.addToServerIdMap(this.m_myServerId, 1);
            return true;
        }
        return false;
    }

    public boolean killConnection() {
        if (this.m_channel == null) {
            return false;
        }
        this.m_channel.disconnect();
        this.m_channel = null;
        if (this.m_broker == null) {
            return false;
        }
        this.m_broker = null;
        return true;
    }

    public int getServerId() {
        return this.m_myServerId;
    }

    public void addToServerIdMap(int n, int n2) {
        this.m_incomingMap.put(new Integer(n), new Integer(n2));
        this.m_outgoingMap.put(new Integer(n2), new Integer(n));
    }

    public int mapOutgoingServerId(int n) {
        Integer n2 = (Integer)this.m_outgoingMap.get(new Integer(n));
        if (n2 == null) {
            return 0;
        }
        return n2;
    }

    public int mapIncomingServerId(int n) {
        if (n == 0) {
            return 0;
        }
        Integer n2 = (Integer)this.m_incomingMap.get(new Integer(n));
        if (n2 != null) {
            return n2;
        }
        int n3 = OContext.getNewServerId();
        this.m_incomingMap.put(new Integer(n), new Integer(n3));
        this.m_outgoingMap.put(new Integer(n3), new Integer(n));
        return n3;
    }
}

