/*
 * Decompiled with CFR 0.152.
 */
package stardiv.util.messbox;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.io.File;
import java.io.FileNotFoundException;
import stardiv.util.messbox.OImageLoader;
import stardiv.util.messbox.OPanel;

public class OImagePanel
extends OPanel {
    protected Image m_Image;
    protected int m_Offset = 5;

    public OImagePanel(String string, int n) throws FileNotFoundException {
        new File(string);
        MediaTracker mediaTracker = new MediaTracker(this);
        try {
            this.m_Image = OImageLoader.loadImage(string);
            mediaTracker.addImage(this.m_Image, 0);
            try {
                mediaTracker.waitForAll();
            }
            catch (InterruptedException interruptedException) {}
            this.m_Offset = n;
            this.sizeSelf();
            this.setLayout(null);
            return;
        }
        catch (NullPointerException nullPointerException) {
            System.err.println("Can't load image " + string);
            return;
        }
    }

    public OImagePanel(String string) throws FileNotFoundException {
        this(string, 5);
    }

    public void addNotify() {
        super.addNotify();
        this.sizeSelf();
    }

    public void sizeSelf() {
        if (this.m_Image == null) {
            return;
        }
        int n = this.m_Offset * 2;
        int n2 = this.m_Image.getWidth(this) + n;
        int n3 = this.m_Image.getHeight(this) + n;
        this.setSize(n2, n3);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.getSize().width < 1) {
            this.sizeSelf();
        }
        if (this.m_Image == null) {
            return;
        }
        int n = this.m_Image.getWidth(this);
        int n2 = this.m_Image.getHeight(this);
        graphics.drawImage(this.m_Image, this.m_Thickness + this.m_Offset, this.m_Thickness + this.m_Offset, n, n2, this);
    }
}

