/*
 * Decompiled with CFR 0.152.
 */
package stardiv.util.messbox;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ComponentEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.StringTokenizer;
import stardiv.util.messbox.IEffects;

public class OPanel
extends Panel
implements IEffects {
    _MouseListener mouseListener;
    public static final int TAB_KEY = 9;
    public static final int TEXT_OFFSET = 5;
    protected int m_TextStyle = 0;
    protected int m_TextPlacement = 0;
    protected int m_Style = 0;
    protected int m_Thickness = 2;
    protected int m_Width;
    protected int m_Height;
    protected String m_Text;
    protected boolean m_SkipLeft = false;
    protected boolean m_SkipTop = false;
    protected boolean m_SkipBottom = false;
    protected boolean m_SkipRight = false;
    protected int m_CurrentPos;

    public OPanel() {
        this(0);
    }

    public OPanel(int n) {
        this.setBounds(0, 0, 1, 1);
        this.setSize(0, 0);
        this.m_Style = n;
        this.mouseListener = new _MouseListener();
        this.addMouseListener(this.mouseListener);
        this.enableEvents(1L);
    }

    public OPanel(String string) {
        this(0, string);
    }

    public OPanel(int n, String string) {
        this(n);
        this.setText(string, 0, 0);
    }

    public OPanel(int n, int n2, int n3, String string) {
        this(n);
        this.m_Width = n2;
        this.m_Height = n3;
        this.setSize(n2, n3);
        this.setText(string, 0, 0);
    }

    public OPanel(int n, int n2, int n3) {
        this(n, n2, n3, null);
    }

    public void addNotify() {
        super.addNotify();
        this.getMetrics();
    }

    public Insets getInsets() {
        FontMetrics fontMetrics;
        int n;
        int n2 = n = this.m_Thickness + 1;
        if (this.isStyleSet(64) && (fontMetrics = this.getFontMetrics(this.getFont())) != null) {
            n2 += fontMetrics.getHeight() / 2 + 1;
        }
        return new Insets(n2, n, n, n);
    }

    public void getMetrics() {
        if (this.m_Text != null && this.m_Width == 0 && this.m_Height == 0) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            if (fontMetrics == null) {
                return;
            }
            int n = this.m_Thickness * 2 + 10;
            this.m_Height = fontMetrics.getHeight() + n;
            this.m_Width = fontMetrics.stringWidth(this.m_Text) + n;
            this.setSize(this.m_Width + this.m_Thickness * 2, this.m_Height + this.m_Thickness * 2);
        }
    }

    public Dimension getMinimumSize() {
        if (this.m_Width != 0 && this.m_Height != 0) {
            int n = this.m_Width + this.m_Thickness * 2;
            int n2 = this.m_Height + this.m_Thickness * 2;
            return new Dimension(n, n2);
        }
        return super.getMinimumSize();
    }

    public Dimension getPreferredSize() {
        if (this.m_Width != 0 && this.m_Height != 0) {
            return this.getMinimumSize();
        }
        return super.getPreferredSize();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.repaint();
    }

    public void setStyle(int n) {
        this.m_Style = n;
        this.repaint();
    }

    public void setText(String string, int n, int n2) {
        this.m_Text = string;
        this.setTextStyle(n);
        this.setTextPlacement(n2);
        this.repaint();
    }

    public void setText(String string) {
        this.m_Text = string;
        this.setTextStyle(0);
        this.setTextPlacement(1);
        this.repaint();
    }

    public void setTextStyle(int n) {
        this.m_TextStyle = n;
        this.repaint();
    }

    public void setTextPlacement(int n) {
        this.m_TextPlacement = n;
        this.repaint();
    }

    public void setThickness(int n) {
        this.m_Thickness = n;
        this.repaint();
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.getSize().width < 1) {
            this.getMetrics();
        }
        if (this.m_Style != 0) {
            this.drawFrame(graphics);
            if (this.m_Text != null && this.m_Text != "") {
                this.drawText(graphics);
            }
        }
    }

    public void drawFrame(Graphics graphics) {
        int n = 0;
        int n2 = 0;
        Dimension dimension = this.getSize();
        if (this.isStyleSet(64)) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            n = fontMetrics.getHeight() / 2;
        }
        int n3 = 0;
        int n4 = 1;
        while (n3 < this.m_Thickness) {
            if (n3 != 0) {
                n2 = 0;
            } else if (this.isStyleSet(8)) {
                n2 = 1;
            }
            if (this.isStyleSet(16) || this.isStyleSet(32) && n4 < this.m_Thickness || this.isStyleSet(2) && n4 > this.m_Thickness) {
                graphics.setColor(Color.white);
            } else {
                graphics.setColor(Color.gray);
            }
            if (!this.m_SkipTop) {
                graphics.fillRect(n3 + n2, n3 + n, dimension.width - 2 * (n3 + n2), 1);
            }
            if (!this.m_SkipLeft) {
                graphics.fillRect(n3, n3 + n2 + n, 1, dimension.height - (2 * n3 + 1 + n2) - n);
            }
            if (this.isStyleSet(16) || this.isStyleSet(1) || this.isStyleSet(32) && n4 < this.m_Thickness || this.isStyleSet(2) && n4 > this.m_Thickness) {
                graphics.setColor(Color.gray);
            } else {
                graphics.setColor(Color.white);
            }
            if (!this.m_SkipBottom) {
                graphics.fillRect(n3 + n2, dimension.height - (n3 + 1), dimension.width - 2 * (n3 + n2), 1);
            }
            if (!this.m_SkipRight) {
                graphics.fillRect(dimension.width - (n3 + 1), n3 + n2 + n, 1, dimension.height - (2 * n3 + 1 + n2) - n);
            }
            ++n3;
            n4 += 2;
        }
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    public void drawText(Graphics var1_1) {
        var2_2 = var1_1.getColor();
        var3_3 = 0;
        var4_4 = 0;
        var5_5 = var1_1.getFontMetrics();
        var6_6 = this.getSize();
        if (this.isStyleSet(64)) ** GOTO lbl20
        switch (this.m_TextPlacement) {
            case 0: {
                var3_3 = var6_6.width / 2 - var5_5.stringWidth(this.m_Text) / 2;
                var4_4 = var6_6.height / 2 - var5_5.getHeight() / 2;
                break;
            }
            case 1: {
                var3_3 = this.m_Thickness + 5;
                var4_4 = var6_6.height / 2 - var5_5.getHeight() / 2;
                break;
            }
            case 2: {
                var3_3 = var6_6.width - this.m_Thickness - 5 - var5_5.stringWidth(this.m_Text);
                var4_4 = var6_6.height / 2 - var5_5.getHeight() / 2;
                break;
            }
lbl20:
            // 1 sources

            var7_7 = var5_5.charWidth('i');
            var3_3 = this.m_Thickness + 5 + var7_7;
            var4_4 = 0;
            var1_1.setColor(this.getBackground());
            var1_1.fillRect(var3_3, var4_4, var5_5.stringWidth(this.m_Text) + var7_7 * 2, var5_5.getHeight());
            var3_3 += var7_7;
            break;
        }
        var4_4 += var5_5.getHeight() - var5_5.getDescent() - 1;
        if (this.m_TextStyle == 1) {
            var1_1.setColor(Color.white);
            var1_1.drawString(this.m_Text, var3_3 + 1, var4_4 + 1);
        }
        if (this.m_TextStyle == 2) {
            var1_1.setColor(Color.white);
            var1_1.drawString(this.m_Text, var3_3 - 1, var4_4 - 1);
        }
        if (this.m_TextStyle == 3) {
            var1_1.setColor(Color.gray);
            var1_1.drawString(this.m_Text, var3_3 + 1, var4_4 + 1);
        }
        var1_1.setColor(Color.black);
        var1_1.drawString(this.m_Text, var3_3, var4_4);
        var1_1.setColor(var2_2);
    }

    public boolean isStyleSet(int n) {
        return (this.m_Style & n) != 0;
    }

    public synchronized void focusForward() {
        this.m_CurrentPos = this.findNextComponent(this.m_CurrentPos);
        this.getComponent(this.m_CurrentPos).requestFocus();
        if (this.getComponent(this.m_CurrentPos) instanceof TextComponent) {
            ((TextComponent)this.getComponent(this.m_CurrentPos)).selectAll();
        }
    }

    public synchronized void focusBackward() {
        this.m_CurrentPos = this.findPreviousComponent(this.m_CurrentPos);
        this.getComponent(this.m_CurrentPos).requestFocus();
        if (this.getComponent(this.m_CurrentPos) instanceof TextComponent) {
            ((TextComponent)this.getComponent(this.m_CurrentPos)).selectAll();
        }
    }

    protected int findNextComponent(int n) {
        int n2 = n + 1;
        do {
            Component component;
            if (n2 >= this.getComponentCount()) {
                n2 = 0;
            }
            if ((component = this.getComponent(n2)) instanceof Label || !component.isEnabled()) continue;
            return n2;
        } while (++n2 != n);
        return 0;
    }

    protected int findPreviousComponent(int n) {
        int n2 = n - 1;
        do {
            Component component;
            if (n2 < 0) {
                n2 = this.getComponentCount() - 1;
            }
            if ((component = this.getComponent(n2)) instanceof Label || !component.isEnabled()) continue;
            return n2;
        } while (--n2 != n);
        return 0;
    }

    public void setFocus(Component component) {
        int n = 0;
        while (n < this.getComponentCount()) {
            Component component2 = this.getComponent(n);
            if (component == component2) {
                if (!component2.isEnabled()) {
                    return;
                }
                if (n == this.m_CurrentPos) {
                    return;
                }
                this.getComponent(n).requestFocus();
                this.m_CurrentPos = n;
                if (this.getComponent(n) instanceof TextField) {
                    ((TextField)this.getComponent(n)).selectAll();
                }
                return;
            }
            ++n;
        }
    }

    protected void processComponentEvent(ComponentEvent componentEvent) {
        int n = componentEvent.getID();
        if (n == 1004 || componentEvent instanceof InputEvent) {
            this.setFocus(componentEvent.getComponent());
        }
        if (componentEvent instanceof KeyEvent) {
            KeyEvent keyEvent = (KeyEvent)componentEvent;
            if (n == 401 && keyEvent.getKeyCode() == 9) {
                if (!keyEvent.isShiftDown()) {
                    this.focusForward();
                    return;
                }
                this.focusBackward();
            }
        }
    }

    public void setSkip(String string, boolean bl) {
        if (string.equalsIgnoreCase("North")) {
            this.m_SkipTop = bl;
            return;
        }
        if (string.equalsIgnoreCase("South")) {
            this.m_SkipBottom = bl;
            return;
        }
        if (string.equalsIgnoreCase("East")) {
            this.m_SkipRight = bl;
            return;
        }
        if (string.equalsIgnoreCase("West")) {
            this.m_SkipLeft = bl;
            return;
        }
        if (string.equalsIgnoreCase("All")) {
            this.m_SkipTop = bl;
            this.m_SkipBottom = bl;
            this.m_SkipRight = bl;
            this.m_SkipLeft = bl;
        }
    }

    public void addWithConstraints(Component component, String string) {
        this.add(component);
        if (this.getLayout() instanceof GridBagLayout) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "=");
                String string3 = stringTokenizer2.nextToken();
                String string4 = stringTokenizer2.nextToken();
                if (string3.equalsIgnoreCase("x") || string3.equalsIgnoreCase("gridx")) {
                    gridBagConstraints.gridx = Integer.parseInt(string4);
                    continue;
                }
                if (string3.equalsIgnoreCase("y") || string3.equalsIgnoreCase("gridy")) {
                    gridBagConstraints.gridy = Integer.parseInt(string4);
                    continue;
                }
                if (string3.equalsIgnoreCase("width") || string3.equalsIgnoreCase("gridwidth")) {
                    gridBagConstraints.gridwidth = Integer.parseInt(string4);
                    continue;
                }
                if (string3.equalsIgnoreCase("height") || string3.equalsIgnoreCase("gridheight")) {
                    gridBagConstraints.gridheight = Integer.parseInt(string4);
                    continue;
                }
                if (string3.equalsIgnoreCase("fill")) {
                    if (string4.equalsIgnoreCase("HORIZONTAL")) {
                        gridBagConstraints.fill = 2;
                        continue;
                    }
                    if (string4.equalsIgnoreCase("VERTICAL")) {
                        gridBagConstraints.fill = 3;
                        continue;
                    }
                    if (string4.equalsIgnoreCase("BOTH")) {
                        gridBagConstraints.fill = 1;
                        continue;
                    }
                    gridBagConstraints.fill = 0;
                    continue;
                }
                if (!string3.equalsIgnoreCase("anchor")) continue;
                if (string4.equalsIgnoreCase("NORTH")) {
                    gridBagConstraints.anchor = 11;
                    continue;
                }
                if (string4.equalsIgnoreCase("NORTHEAST")) {
                    gridBagConstraints.anchor = 12;
                    continue;
                }
                if (string4.equalsIgnoreCase("NORTHWEST")) {
                    gridBagConstraints.anchor = 18;
                    continue;
                }
                if (string4.equalsIgnoreCase("SOUTH")) {
                    gridBagConstraints.anchor = 15;
                    continue;
                }
                if (string4.equalsIgnoreCase("SOUTHWEST")) {
                    gridBagConstraints.anchor = 16;
                    continue;
                }
                if (string4.equalsIgnoreCase("SOUTHEAST")) {
                    gridBagConstraints.anchor = 14;
                    continue;
                }
                if (string4.equalsIgnoreCase("EAST")) {
                    gridBagConstraints.anchor = 13;
                    continue;
                }
                if (!string4.equalsIgnoreCase("WEST")) continue;
                gridBagConstraints.anchor = 17;
            }
            ((GridBagLayout)this.getLayout()).setConstraints(component, gridBagConstraints);
        }
    }

    class _MouseListener
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            Component component = OPanel.this.getComponentAt(mouseEvent.getX(), mouseEvent.getY());
            if (component != null) {
                OPanel.this.setFocus(component);
            }
        }

        _MouseListener() {
            OPanel.this = OPanel.this;
        }
    }
}

