/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing;

import com.sun.java.swing.JComponent;
import com.sun.java.swing.Timer;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

class Autoscroller
extends MouseAdapter
implements Serializable {
    transient MouseEvent event;
    transient Timer timer;
    JComponent component;

    Autoscroller(JComponent jComponent) {
        if (jComponent == null) {
            throw new IllegalArgumentException("component must be non null");
        }
        this.component = jComponent;
        this.timer = new Timer(100, new AutoScrollTimerAction());
        this.component.addMouseListener(this);
    }

    void stop() {
        this.timer.stop();
        this.event = null;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.stop();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Rectangle rectangle = this.component.getVisibleRect();
        boolean bl = rectangle.contains(mouseEvent.getX(), mouseEvent.getY());
        if (bl) {
            if (this.timer.isRunning()) {
                this.stop();
                return;
            }
        } else {
            Point point = this.component.getLocationOnScreen();
            this.event = new MouseEvent(this.component, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX() + point.x, mouseEvent.getY() + point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
            if (!this.timer.isRunning()) {
                this.timer.start();
            }
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.timer = new Timer(100, new AutoScrollTimerAction());
    }

    class AutoScrollTimerAction
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (!Autoscroller.this.component.isShowing() || Autoscroller.this.event == null) {
                Autoscroller.this.stop();
                return;
            }
            Point point = Autoscroller.this.component.getLocationOnScreen();
            MouseEvent mouseEvent = new MouseEvent(Autoscroller.this.component, Autoscroller.this.event.getID(), Autoscroller.this.event.getWhen(), Autoscroller.this.event.getModifiers(), Autoscroller.this.event.getX() - point.x, Autoscroller.this.event.getY() - point.y, Autoscroller.this.event.getClickCount(), Autoscroller.this.event.isPopupTrigger());
            Autoscroller.this.component.superProcessMouseMotionEvent(mouseEvent);
        }

        AutoScrollTimerAction() {
            Autoscroller.this = Autoscroller.this;
        }
    }
}

