/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing;

import com.sun.java.accessibility.Accessible;
import com.sun.java.accessibility.AccessibleContext;
import com.sun.java.accessibility.AccessibleState;
import com.sun.java.accessibility.AccessibleStateSet;
import com.sun.java.swing.AbstractListModel;
import com.sun.java.swing.ComboBoxEditor;
import com.sun.java.swing.ComboBoxModel;
import com.sun.java.swing.JComboBox;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.ListCellRenderer;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.event.AncestorEvent;
import com.sun.java.swing.event.AncestorListener;
import com.sun.java.swing.event.ListDataEvent;
import com.sun.java.swing.event.ListDataListener;
import com.sun.java.swing.plaf.ComboBoxUI;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import java.util.Vector;

public class JComboBox
extends JComponent
implements ItemSelectable,
ListDataListener,
ActionListener,
Accessible {
    protected ComboBoxModel dataModel;
    protected ListCellRenderer renderer;
    protected ComboBoxEditor editor;
    protected int maximumRowCount = 8;
    protected boolean isEditable = false;
    protected Object selectedItemReminder;
    protected KeySelectionManager keySelectionManager;
    protected String actionCommand = "comboBoxChanged";
    protected boolean lightWeightPopupEnabled = true;
    static /* synthetic */ Class class$java$awt$event$ItemListener;
    static /* synthetic */ Class class$java$awt$event$ActionListener;

    public JComboBox(ComboBoxModel comboBoxModel) {
        this.setModel(comboBoxModel);
        this.installAncestorListener();
        this.updateUI();
    }

    public JComboBox(Object[] objectArray) {
        this.setModel(new DefaultComboBoxModel(objectArray));
        this.installAncestorListener();
        this.updateUI();
    }

    public JComboBox(Vector vector) {
        this.setModel(new DefaultComboBoxModel(vector));
        this.installAncestorListener();
        this.updateUI();
    }

    public JComboBox() {
        this.setModel(new DefaultComboBoxModel());
        this.installAncestorListener();
        this.updateUI();
    }

    protected void installAncestorListener() {
        this.addAncestorListener(new 1());
    }

    public void setUI(ComboBoxUI comboBoxUI) {
        super.setUI(comboBoxUI);
    }

    public void updateUI() {
        this.setUI((ComboBoxUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return "ComboBoxUI";
    }

    public ComboBoxUI getUI() {
        return (ComboBoxUI)this.ui;
    }

    public void setModel(ComboBoxModel comboBoxModel) {
        ComboBoxModel comboBoxModel2 = this.dataModel;
        if (this.dataModel != null) {
            this.dataModel.removeListDataListener(this);
        }
        this.dataModel = comboBoxModel;
        this.firePropertyChange("model", comboBoxModel2, this.dataModel);
        this.dataModel.addListDataListener(this);
        this.invalidate();
    }

    public ComboBoxModel getModel() {
        return this.dataModel;
    }

    public void setLightWeightPopupEnabled(boolean bl) {
        this.lightWeightPopupEnabled = bl;
    }

    public boolean isLightWeightPopupEnabled() {
        return this.lightWeightPopupEnabled;
    }

    public void setEditable(boolean bl) {
        boolean bl2 = bl != this.isEditable;
        this.isEditable = bl;
        if (bl2) {
            this.firePropertyChange("editable", !this.isEditable, this.isEditable);
        }
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public void setMaximumRowCount(int n) {
        int n2 = this.maximumRowCount;
        this.maximumRowCount = n;
        this.firePropertyChange("maximumRowCount", n2, this.maximumRowCount);
    }

    public int getMaximumRowCount() {
        return this.maximumRowCount;
    }

    public void setRenderer(ListCellRenderer listCellRenderer) {
        ListCellRenderer listCellRenderer2 = this.renderer;
        this.renderer = listCellRenderer;
        this.firePropertyChange("renderer", listCellRenderer2, this.renderer);
        this.invalidate();
    }

    public ListCellRenderer getRenderer() {
        return this.renderer;
    }

    public void setEditor(ComboBoxEditor comboBoxEditor) {
        ComboBoxEditor comboBoxEditor2 = this.editor;
        if (this.editor != null) {
            this.editor.removeActionListener(this);
        }
        this.editor = comboBoxEditor;
        if (this.editor != null) {
            this.editor.addActionListener(this);
        }
        this.firePropertyChange("editor", comboBoxEditor2, this.editor);
    }

    public ComboBoxEditor getEditor() {
        return this.editor;
    }

    public void setSelectedItem(Object object) {
        this.dataModel.setSelectedItem(object);
    }

    public Object getSelectedItem() {
        return this.dataModel.getSelectedItem();
    }

    public void setSelectedIndex(int n) {
        int n2 = this.dataModel.getSize();
        if (n < 0 || n >= n2) {
            throw new IllegalArgumentException("setSelectedIndex: " + n + " out of bounds");
        }
        this.setSelectedItem(this.dataModel.getElementAt(n));
    }

    public int getSelectedIndex() {
        Object object = this.dataModel.getSelectedItem();
        int n = 0;
        int n2 = this.dataModel.getSize();
        while (n < n2) {
            Object object2 = this.dataModel.getElementAt(n);
            if (object2.equals(object)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void addItem(Object object) {
        this.checkDefaultComboBoxModel();
        ((DefaultComboBoxModel)this.dataModel).addObject(object);
    }

    public void insertItemAt(Object object, int n) {
        this.checkDefaultComboBoxModel();
        ((DefaultComboBoxModel)this.dataModel).insertObjectAt(object, n);
    }

    public void removeItem(Object object) {
        this.checkDefaultComboBoxModel();
        int n = ((DefaultComboBoxModel)this.dataModel).getIndexOf(object);
        ((DefaultComboBoxModel)this.dataModel).removeObject(object);
        if (!this.isEditable() && this.dataModel.getSize() > 0 && n < this.dataModel.getSize()) {
            this.setSelectedIndex(n);
        }
    }

    public void removeItemAt(int n) {
        this.checkDefaultComboBoxModel();
        ((DefaultComboBoxModel)this.dataModel).removeObjectAt(n);
    }

    public void removeAllItems() {
        this.checkDefaultComboBoxModel();
        ((DefaultComboBoxModel)this.dataModel).removeAllObjects();
        if (!this.isEditable()) {
            this.setSelectedItem(null);
        }
    }

    void checkDefaultComboBoxModel() {
        if (!(this.dataModel instanceof DefaultComboBoxModel)) {
            throw new InternalError("Cannot use this method with a custom data model.");
        }
    }

    public void showPopup() {
        this.getUI().showPopup();
    }

    public void hidePopup() {
        this.getUI().hidePopup();
    }

    public void addItemListener(ItemListener itemListener) {
        this.listenerList.add(class$java$awt$event$ItemListener != null ? class$java$awt$event$ItemListener : (class$java$awt$event$ItemListener = JComponent.class$("java.awt.event.ItemListener")), itemListener);
    }

    public void removeItemListener(ItemListener itemListener) {
        this.listenerList.remove(class$java$awt$event$ItemListener != null ? class$java$awt$event$ItemListener : (class$java$awt$event$ItemListener = JComponent.class$("java.awt.event.ItemListener")), itemListener);
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(class$java$awt$event$ActionListener != null ? class$java$awt$event$ActionListener : (class$java$awt$event$ActionListener = JComponent.class$("java.awt.event.ActionListener")), actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(class$java$awt$event$ActionListener != null ? class$java$awt$event$ActionListener : (class$java$awt$event$ActionListener = JComponent.class$("java.awt.event.ActionListener")), actionListener);
    }

    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    protected void fireItemStateChanged(ItemEvent itemEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$java$awt$event$ItemListener != null ? class$java$awt$event$ItemListener : JComponent.class$("java.awt.event.ItemListener"))) {
                ((ItemListener)objectArray[n + 1]).itemStateChanged(itemEvent);
            }
            n -= 2;
        }
    }

    protected void fireActionEvent() {
        ActionEvent actionEvent = null;
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$java$awt$event$ActionListener != null ? class$java$awt$event$ActionListener : JComponent.class$("java.awt.event.ActionListener"))) {
                if (actionEvent == null) {
                    actionEvent = new ActionEvent(this, 1001, this.getActionCommand());
                }
                ((ActionListener)objectArray[n + 1]).actionPerformed(actionEvent);
            }
            n -= 2;
        }
    }

    protected void selectedItemChanged() {
        if (this.selectedItemReminder != null) {
            this.fireItemStateChanged(new ItemEvent(this, 701, this.selectedItemReminder, 2));
        }
        this.selectedItemReminder = this.getModel().getSelectedItem();
        if (this.selectedItemReminder != null) {
            this.fireItemStateChanged(new ItemEvent(this, 701, this.selectedItemReminder, 1));
        }
        this.fireActionEvent();
    }

    public Object[] getSelectedObjects() {
        Object object = this.getSelectedItem();
        if (object == null) {
            return new Object[0];
        }
        Object[] objectArray = new Object[]{object};
        return objectArray;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = this.getEditor().getItem();
        this.getModel().setSelectedItem(object);
        this.getUI().hidePopup();
    }

    public void contentsChanged(ListDataEvent listDataEvent) {
        ComboBoxModel comboBoxModel = this.getModel();
        Object object = comboBoxModel.getSelectedItem();
        if (!this.isEditable() && comboBoxModel instanceof DefaultComboBoxModel && object == null && this.getModel().getSize() > 0) {
            this.setSelectedIndex(0);
        } else if (this.selectedItemReminder == null) {
            if (object != null) {
                this.selectedItemChanged();
            }
        } else if (!this.selectedItemReminder.equals(object)) {
            this.selectedItemChanged();
        }
        if (!this.isEditable() && object != null) {
            boolean bl = true;
            Object object2 = comboBoxModel.getSelectedItem();
            int n = 0;
            int n2 = comboBoxModel.getSize();
            while (n < n2) {
                Object object3 = comboBoxModel.getElementAt(n);
                if (object3.equals(object2)) {
                    bl = false;
                    break;
                }
                ++n;
            }
            if (bl) {
                if (comboBoxModel.getSize() > 0) {
                    this.setSelectedIndex(0);
                    return;
                }
                this.setSelectedItem(null);
            }
        }
    }

    public boolean selectWithKeyChar(char c) {
        int n;
        if (this.keySelectionManager == null) {
            this.keySelectionManager = this.createDefaultKeySelectionManager();
        }
        if ((n = this.keySelectionManager.selectionForKey(c, this.getModel())) != -1) {
            this.setSelectedIndex(n);
            return true;
        }
        return false;
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
        this.contentsChanged(listDataEvent);
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.contentsChanged(listDataEvent);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.firePropertyChange("enabled", !this.isEnabled(), this.isEnabled());
    }

    public void configureEditor(ComboBoxEditor comboBoxEditor, Object object) {
        comboBoxEditor.setItem(object);
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 9) {
            this.hidePopup();
        }
        super.processKeyEvent(keyEvent);
    }

    public boolean isFocusTraversable() {
        return this.getUI().isFocusTraversable();
    }

    public void setKeySelectionManager(KeySelectionManager keySelectionManager) {
        this.keySelectionManager = keySelectionManager;
    }

    public KeySelectionManager getKeySelectionManager() {
        return this.keySelectionManager;
    }

    public int getItemCount() {
        return this.dataModel.getSize();
    }

    public Object getItemAt(int n) {
        return this.dataModel.getElementAt(n);
    }

    protected KeySelectionManager createDefaultKeySelectionManager() {
        return new DefaultKeySelectionManager(this);
    }

    public boolean isOpaque() {
        return true;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJComboBox();
        }
        return this.accessibleContext;
    }

    private final class 1
    implements AncestorListener {
        public void ancestorAdded(AncestorEvent ancestorEvent) {
            JComboBox.this.hidePopup();
        }

        public void ancestorRemoved(AncestorEvent ancestorEvent) {
            JComboBox.this.hidePopup();
        }

        public void ancestorMoved(AncestorEvent ancestorEvent) {
            JComboBox.this.hidePopup();
        }

        /* synthetic */ 1() {
        }
    }

    class DefaultComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    Serializable {
        Vector objects = new Vector();
        Object selectedObject;

        public DefaultComboBoxModel() {
            JComboBox.this = JComboBox.this;
        }

        public DefaultComboBoxModel(Object[] objectArray) {
            JComboBox.this = JComboBox.this;
            int n = 0;
            int n2 = objectArray.length;
            while (n < n2) {
                this.objects.addElement(objectArray[n]);
                ++n;
            }
        }

        public DefaultComboBoxModel(Vector vector) {
            JComboBox.this = JComboBox.this;
            int n = 0;
            int n2 = vector.size();
            while (n < n2) {
                this.objects.addElement(vector.elementAt(n));
                ++n;
            }
        }

        public void setSelectedItem(Object object) {
            this.selectedObject = object;
            this.fireContentsChanged(this, -1, -1);
        }

        public Object getSelectedItem() {
            return this.selectedObject;
        }

        public int getSize() {
            return this.objects.size();
        }

        public Object getElementAt(int n) {
            if (n >= 0 && n < this.objects.size()) {
                return this.objects.elementAt(n);
            }
            return null;
        }

        public int getIndexOf(Object object) {
            return this.objects.indexOf(object);
        }

        void addObject(Object object) {
            this.objects.addElement(object);
            this.fireIntervalAdded(this, this.objects.size() - 1, this.objects.size() - 1);
        }

        void insertObjectAt(Object object, int n) {
            this.objects.insertElementAt(object, n);
            this.fireIntervalAdded(this, n, n);
        }

        void removeObjectAt(int n) {
            this.objects.removeElementAt(n);
            this.fireIntervalRemoved(this, n, n);
        }

        void removeObject(Object object) {
            int n = this.objects.indexOf(object);
            if (n != -1) {
                this.removeObjectAt(n);
            }
        }

        void removeAllObjects() {
            int n = 0;
            int n2 = this.objects.size() - 1;
            this.objects.removeAllElements();
            this.fireIntervalRemoved(this, n, n2);
        }
    }

    public interface KeySelectionManager {
        public int selectionForKey(char var1, ComboBoxModel var2);
    }

    protected class AccessibleJComboBox
    extends JComponent.AccessibleJComponent {
        public int getAccessibleChildrenCount() {
            if (JComboBox.this.isEditable() && JComboBox.this.getEditor().getEditorComponent() instanceof Accessible) {
                return 2;
            }
            return 1;
        }

        public Accessible getAccessibleChild(int n) {
            Object object;
            JComboBox.this.getUI().getPreferredSize(JComboBox.this);
            Object object2 = null;
            if (n == 0) {
                object2 = new AccessibleJComboBoxList(this, JComboBox.this);
            } else if (n == 1 && JComboBox.this.isEditable() && (object = JComboBox.this.getEditor().getEditorComponent()) instanceof Accessible) {
                object2 = (Accessible)object;
            }
            if (object2 != null && (object = object2.getAccessibleContext()) != null) {
                ((AccessibleContext)object).setAccessibleParent(JComboBox.this);
            }
            return object2;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (JComboBox.this.isEditable()) {
                accessibleStateSet.add(AccessibleState.EDITABLE);
            }
            return accessibleStateSet;
        }

        public Accessible getAccessibleAt(Point point) {
            Accessible accessible = this.getAccessibleChild(1);
            if (accessible != null) {
                return accessible;
            }
            return this.getAccessibleChild(0);
        }

        AccessibleJComboBox() {
            super(JComboBox.this);
            JComboBox.this = JComboBox.this;
        }
    }
}

