/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing;

import com.sun.java.accessibility.Accessible;
import com.sun.java.accessibility.AccessibleContext;
import com.sun.java.accessibility.AccessibleRole;
import com.sun.java.accessibility.AccessibleSelection;
import com.sun.java.accessibility.AccessibleState;
import com.sun.java.accessibility.AccessibleStateSet;
import com.sun.java.swing.AbstractListModel;
import com.sun.java.swing.DefaultListSelectionModel;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JList;
import com.sun.java.swing.ListCellRenderer;
import com.sun.java.swing.ListModel;
import com.sun.java.swing.ListSelectionModel;
import com.sun.java.swing.Scrollable;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.event.ListDataEvent;
import com.sun.java.swing.event.ListDataListener;
import com.sun.java.swing.event.ListSelectionEvent;
import com.sun.java.swing.event.ListSelectionListener;
import com.sun.java.swing.plaf.ListUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;

public class JList
extends JComponent
implements Scrollable,
Accessible {
    private int fixedCellWidth = -1;
    private int fixedCellHeight = -1;
    private Object prototypeCellValue;
    private int visibleRowCount = 8;
    private Color selectionForeground;
    private Color selectionBackground;
    private ListSelectionModel selectionModel;
    private ListModel dataModel;
    private ListCellRenderer cellRenderer;
    private ListSelectionListener selectionListener;
    static /* synthetic */ Class class$com$sun$java$swing$event$ListSelectionListener;

    public JList(ListModel listModel) {
        if (listModel == null) {
            throw new IllegalArgumentException("dataModel must be non null");
        }
        this.dataModel = listModel;
        this.selectionModel = this.createSelectionModel();
        this.setAutoscrolls(true);
        this.updateUI();
    }

    public JList(Object[] objectArray) {
        this((ListModel)new 1(objectArray));
    }

    public JList(Vector vector) {
        this((ListModel)new 2(vector));
    }

    public JList() {
        this(new 3());
    }

    public ListUI getUI() {
        return (ListUI)this.ui;
    }

    public void setUI(ListUI listUI) {
        super.setUI(listUI);
    }

    public void updateUI() {
        this.setUI((ListUI)UIManager.getUI(this));
        this.invalidate();
    }

    public String getUIClassID() {
        return "ListUI";
    }

    public boolean isOpaque() {
        return true;
    }

    private void updateFixedCellSize() {
        ListCellRenderer listCellRenderer = this.getCellRenderer();
        Object object = this.getPrototypeCellValue();
        if (listCellRenderer != null && object != null) {
            Component component = listCellRenderer.getListCellRendererComponent(this, object, 0, false, false);
            Font font = component.getFont();
            component.setFont(this.getFont());
            Dimension dimension = component.getPreferredSize();
            this.fixedCellWidth = dimension.width;
            this.fixedCellHeight = dimension.height;
            component.setFont(font);
        }
    }

    public Object getPrototypeCellValue() {
        return this.prototypeCellValue;
    }

    public void setPrototypeCellValue(Object object) {
        Object object2 = this.prototypeCellValue;
        this.prototypeCellValue = object;
        if (object != null && !object.equals(object2)) {
            this.updateFixedCellSize();
        }
        this.firePropertyChange("prototypeCellValue", object2, object);
    }

    public int getFixedCellWidth() {
        return this.fixedCellWidth;
    }

    public void setFixedCellWidth(int n) {
        int n2 = this.fixedCellWidth;
        this.fixedCellWidth = n;
        this.firePropertyChange("fixedCellWidth", n2, this.fixedCellWidth);
    }

    public int getFixedCellHeight() {
        return this.fixedCellHeight;
    }

    public void setFixedCellHeight(int n) {
        int n2 = this.fixedCellHeight;
        this.fixedCellHeight = n;
        this.firePropertyChange("fixedCellHeight", n2, this.fixedCellHeight);
    }

    public ListCellRenderer getCellRenderer() {
        return this.cellRenderer;
    }

    public void setCellRenderer(ListCellRenderer listCellRenderer) {
        ListCellRenderer listCellRenderer2 = this.cellRenderer;
        this.cellRenderer = listCellRenderer;
        if (listCellRenderer != null && !listCellRenderer.equals(listCellRenderer2)) {
            this.updateFixedCellSize();
        }
        this.firePropertyChange("cellRenderer", listCellRenderer2, listCellRenderer);
    }

    public Color getSelectionForeground() {
        return this.selectionForeground;
    }

    public void setSelectionForeground(Color color) {
        Color color2 = this.selectionForeground;
        this.selectionForeground = color;
        this.firePropertyChange("selectionForeground", color2, color);
    }

    public Color getSelectionBackground() {
        return this.selectionBackground;
    }

    public void setSelectionBackground(Color color) {
        Color color2 = this.selectionBackground;
        this.selectionBackground = color;
        this.firePropertyChange("selectionBackground", color2, color);
    }

    public int getVisibleRowCount() {
        return this.visibleRowCount;
    }

    public void setVisibleRowCount(int n) {
        int n2 = this.visibleRowCount;
        this.visibleRowCount = Math.max(0, n);
        this.firePropertyChange("visibleRowCount", n2, n);
    }

    public int getFirstVisibleIndex() {
        Point point = this.getVisibleRect().getLocation();
        return this.locationToIndex(point);
    }

    public int getLastVisibleIndex() {
        Rectangle rectangle = this.getVisibleRect();
        Point point = new Point(rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        return this.locationToIndex(point);
    }

    public void ensureIndexIsVisible(int n) {
        Rectangle rectangle = this.getCellBounds(n, n);
        if (rectangle != null) {
            this.scrollRectToVisible(rectangle);
        }
    }

    public int locationToIndex(Point point) {
        ListUI listUI = this.getUI();
        if (listUI != null) {
            return listUI.locationToIndex(this, point);
        }
        return -1;
    }

    public Point indexToLocation(int n) {
        ListUI listUI = this.getUI();
        if (listUI != null) {
            return listUI.indexToLocation(this, n);
        }
        return null;
    }

    public Rectangle getCellBounds(int n, int n2) {
        ListUI listUI = this.getUI();
        if (listUI != null) {
            return listUI.getCellBounds(this, n, n2);
        }
        return null;
    }

    public ListModel getModel() {
        return this.dataModel;
    }

    public void setModel(ListModel listModel) {
        ListModel listModel2 = this.dataModel;
        this.dataModel = listModel;
        this.firePropertyChange("model", listModel2, this.dataModel);
        this.clearSelection();
    }

    public void setListData(Object[] objectArray) {
        this.setModel((ListModel)new 4(objectArray));
    }

    public void setListData(Vector vector) {
        this.setModel((ListModel)new 5(vector));
    }

    protected ListSelectionModel createSelectionModel() {
        return new DefaultListSelectionModel();
    }

    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    protected void fireSelectionValueChanged(int n, int n2, boolean bl) {
        Object[] objectArray = this.listenerList.getListenerList();
        ListSelectionEvent listSelectionEvent = null;
        int n3 = objectArray.length - 2;
        while (n3 >= 0) {
            if (objectArray[n3] == (class$com$sun$java$swing$event$ListSelectionListener != null ? class$com$sun$java$swing$event$ListSelectionListener : JComponent.class$("com.sun.java.swing.event.ListSelectionListener"))) {
                if (listSelectionEvent == null) {
                    listSelectionEvent = new ListSelectionEvent(this, n, n2, bl);
                }
                ((ListSelectionListener)objectArray[n3 + 1]).valueChanged(listSelectionEvent);
            }
            n3 -= 2;
        }
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        if (this.selectionListener == null) {
            this.selectionListener = new 6();
            this.getSelectionModel().addListSelectionListener(this.selectionListener);
        }
        this.listenerList.add(class$com$sun$java$swing$event$ListSelectionListener != null ? class$com$sun$java$swing$event$ListSelectionListener : (class$com$sun$java$swing$event$ListSelectionListener = JComponent.class$("com.sun.java.swing.event.ListSelectionListener")), listSelectionListener);
    }

    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.listenerList.remove(class$com$sun$java$swing$event$ListSelectionListener != null ? class$com$sun$java$swing$event$ListSelectionListener : (class$com$sun$java$swing$event$ListSelectionListener = JComponent.class$("com.sun.java.swing.event.ListSelectionListener")), listSelectionListener);
    }

    public void setSelectionModel(ListSelectionModel listSelectionModel) {
        if (listSelectionModel == null) {
            throw new IllegalArgumentException("selectionModel must be non null");
        }
        if (this.selectionListener != null) {
            this.selectionModel.removeListSelectionListener(this.selectionListener);
            listSelectionModel.addListSelectionListener(this.selectionListener);
        }
        ListSelectionModel listSelectionModel2 = this.selectionModel;
        this.selectionModel = listSelectionModel;
        this.firePropertyChange("selectionModel", listSelectionModel2, listSelectionModel);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleSelection", new Boolean(false), new Boolean(true));
        }
    }

    public void setSelectionMode(int n) {
        this.getSelectionModel().setSelectionMode(n);
    }

    public int getSelectionMode() {
        return this.getSelectionModel().getSelectionMode();
    }

    public int getAnchorSelectionIndex() {
        return this.getSelectionModel().getAnchorSelectionIndex();
    }

    public int getLeadSelectionIndex() {
        return this.getSelectionModel().getLeadSelectionIndex();
    }

    public int getMinSelectionIndex() {
        return this.getSelectionModel().getMinSelectionIndex();
    }

    public int getMaxSelectionIndex() {
        return this.getSelectionModel().getMaxSelectionIndex();
    }

    public boolean isSelectedIndex(int n) {
        return this.getSelectionModel().isSelectedIndex(n);
    }

    public boolean isSelectionEmpty() {
        return this.getSelectionModel().isSelectionEmpty();
    }

    public void clearSelection() {
        this.getSelectionModel().clearSelection();
    }

    public void setSelectionInterval(int n, int n2) {
        this.getSelectionModel().setSelectionInterval(n, n2);
    }

    public void addSelectionInterval(int n, int n2) {
        this.getSelectionModel().addSelectionInterval(n, n2);
    }

    public void removeSelectionInterval(int n, int n2) {
        this.getSelectionModel().removeSelectionInterval(n, n2);
    }

    public void setValueIsAdjusting(boolean bl) {
        this.getSelectionModel().setValueIsAdjusting(bl);
    }

    public boolean getValueIsAdjusting() {
        return this.getSelectionModel().getValueIsAdjusting();
    }

    public int[] getSelectedIndices() {
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        int n = listSelectionModel.getMinSelectionIndex();
        int n2 = listSelectionModel.getMaxSelectionIndex();
        if (n < 0 || n2 < 0) {
            return new int[0];
        }
        int[] nArray = new int[1 + (n2 - n)];
        int n3 = 0;
        int n4 = n;
        while (n4 <= n2) {
            if (listSelectionModel.isSelectedIndex(n4)) {
                nArray[n3++] = n4;
            }
            ++n4;
        }
        int[] nArray2 = new int[n3];
        System.arraycopy(nArray, 0, nArray2, 0, n3);
        return nArray2;
    }

    public void setSelectedIndex(int n) {
        this.getSelectionModel().setSelectionInterval(n, n);
    }

    public void setSelectedIndices(int[] nArray) {
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        listSelectionModel.clearSelection();
        int n = 0;
        while (n < nArray.length) {
            listSelectionModel.addSelectionInterval(nArray[n], nArray[n]);
            ++n;
        }
    }

    public Object[] getSelectedValues() {
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        ListModel listModel = this.getModel();
        int n = listSelectionModel.getMinSelectionIndex();
        int n2 = listSelectionModel.getMaxSelectionIndex();
        if (n < 0 || n2 < 0) {
            return new Object[0];
        }
        Object[] objectArray = new Object[1 + (n2 - n)];
        int n3 = 0;
        int n4 = n;
        while (n4 <= n2) {
            if (listSelectionModel.isSelectedIndex(n4)) {
                objectArray[n3++] = listModel.getElementAt(n4);
            }
            ++n4;
        }
        Object[] objectArray2 = new Object[n3];
        System.arraycopy(objectArray, 0, objectArray2, 0, n3);
        return objectArray2;
    }

    public int getSelectedIndex() {
        return this.getMinSelectionIndex();
    }

    public Object getSelectedValue() {
        int n = this.getMinSelectionIndex();
        if (n == -1) {
            return null;
        }
        return this.getModel().getElementAt(n);
    }

    public void setSelectedValue(Object object, boolean bl) {
        if (object == null) {
            this.setSelectedIndex(-1);
        } else if (!object.equals(this.getSelectedValue())) {
            ListModel listModel = this.getModel();
            int n = 0;
            int n2 = listModel.getSize();
            while (n < n2) {
                if (object.equals(listModel.getElementAt(n))) {
                    this.setSelectedIndex(n);
                    if (bl) {
                        this.ensureIndexIsVisible(n);
                    }
                    this.repaint();
                    return;
                }
                ++n;
            }
            this.setSelectedIndex(-1);
        }
        this.repaint();
    }

    public Dimension getPreferredScrollableViewportSize() {
        Insets insets = this.getInsets();
        int n = insets.left + insets.right;
        int n2 = insets.top + insets.bottom;
        int n3 = this.getVisibleRowCount();
        int n4 = this.getFixedCellWidth();
        int n5 = this.getFixedCellHeight();
        if (n4 > 0 && n5 > 0) {
            int n6 = n4 + n;
            int n7 = n3 * n5 + n2;
            return new Dimension(n6, n7);
        }
        if (this.getModel().getSize() > 0) {
            int n8 = this.getPreferredSize().width;
            Rectangle rectangle = this.getCellBounds(0, 0);
            int n9 = n3 * rectangle.height + n2;
            return new Dimension(n8, n9);
        }
        n4 = n4 > 0 ? n4 : 256;
        n5 = n5 > 0 ? n5 : 16;
        return new Dimension(n4, n5 * n3);
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 0) {
            return 1;
        }
        int n3 = this.getFirstVisibleIndex();
        if (n3 == -1) {
            return 0;
        }
        if (n2 > 0) {
            Rectangle rectangle2 = this.getCellBounds(n3, n3);
            if (rectangle2 == null) {
                return 0;
            }
            return rectangle2.height - (rectangle.y - rectangle2.y);
        }
        Rectangle rectangle3 = this.getCellBounds(n3, n3);
        if (rectangle3.y == rectangle.y && n3 == 0) {
            return 0;
        }
        if (rectangle3.y == rectangle.y) {
            Rectangle rectangle4 = this.getCellBounds(n3 - 1, n3 - 1);
            if (rectangle4 == null) {
                return 0;
            }
            return rectangle4.height;
        }
        return rectangle.y - rectangle3.y;
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 1) {
            return rectangle.height;
        }
        return rectangle.width;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJList();
        }
        return this.accessibleContext;
    }

    private final class 3
    extends AbstractListModel {
        public int getSize() {
            return 0;
        }

        public Object getElementAt(int n) {
            return "No Data Model";
        }

        /* synthetic */ 3() {
        }
    }

    private final class 6
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            JList.this.fireSelectionValueChanged(listSelectionEvent.getFirstIndex(), listSelectionEvent.getLastIndex(), listSelectionEvent.getValueIsAdjusting());
        }

        /* synthetic */ 6() {
        }
    }

    protected class AccessibleJList
    extends JComponent.AccessibleJComponent
    implements AccessibleSelection,
    ListSelectionListener,
    ListDataListener {
        AccessibleJList() {
            super(JList.this);
            JList.this = JList.this;
            JList.this.getSelectionModel().addListSelectionListener(this);
            JList.this.getModel().addListDataListener(this);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.firePropertyChange("AccessibleVisibleData", new Boolean(false), new Boolean(true));
            this.firePropertyChange("AccessibleSelection", new Boolean(false), new Boolean(true));
            AccessibleStateSet accessibleStateSet = this.getAccessibleStateSet();
            ListSelectionModel listSelectionModel = JList.this.getSelectionModel();
            if (listSelectionModel.getSelectionMode() != 0) {
                if (!accessibleStateSet.contains(AccessibleState.MULTISELECTABLE)) {
                    accessibleStateSet.add(AccessibleState.MULTISELECTABLE);
                    this.firePropertyChange("AccessibleState", null, AccessibleState.MULTISELECTABLE);
                    return;
                }
            } else if (accessibleStateSet.contains(AccessibleState.MULTISELECTABLE)) {
                accessibleStateSet.remove(AccessibleState.MULTISELECTABLE);
                this.firePropertyChange("AccessibleState", AccessibleState.MULTISELECTABLE, null);
            }
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            this.firePropertyChange("AccessibleVisibleData", new Boolean(false), new Boolean(true));
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            this.firePropertyChange("AccessibleVisibleData", new Boolean(false), new Boolean(true));
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            this.firePropertyChange("AccessibleVisibleData", new Boolean(false), new Boolean(true));
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (JList.this.selectionModel.getSelectionMode() != 0) {
                accessibleStateSet.add(AccessibleState.MULTISELECTABLE);
            }
            return accessibleStateSet;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LIST;
        }

        public Accessible getAccessibleAt(Point point) {
            int n = JList.this.locationToIndex(point);
            if (n >= 0) {
                return new AccessibleJListChild(this, JList.this, n);
            }
            return null;
        }

        public int getAccessibleChildrenCount() {
            return JList.this.getModel().getSize();
        }

        public Accessible getAccessibleChild(int n) {
            if (n >= JList.this.getModel().getSize()) {
                return null;
            }
            return new AccessibleJListChild(this, JList.this, n);
        }

        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        public int getAccessibleSelectionCount() {
            return JList.this.getSelectedIndices().length;
        }

        public Accessible getAccessibleSelection(int n) {
            int n2 = this.getAccessibleSelectionCount();
            if (n < 0 || n >= n2) {
                return null;
            }
            return this.getAccessibleChild(JList.this.getSelectedIndices()[n]);
        }

        public boolean isAccessibleChildSelected(int n) {
            return JList.this.isSelectedIndex(n);
        }

        public void addAccessibleSelection(int n) {
            JList.this.addSelectionInterval(n, n);
        }

        public void removeAccessibleSelection(int n) {
            JList.this.removeSelectionInterval(n, n);
        }

        public void clearAccessibleSelection() {
            JList.this.clearSelection();
        }

        public void selectAllAccessibleSelection() {
            JList.this.addSelectionInterval(0, this.getAccessibleChildrenCount() - 1);
        }

        static /* synthetic */ JList access$0(AccessibleJList accessibleJList) {
            return accessibleJList.JList.this;
        }
    }
}

